(* Copyright (C) 1989, Digital Equipment Corporation           *)
(* All rights reserved.                                        *)
(* See the file COPYRIGHT for a full description.              *)

(* File: M3toC.i3                                              *)
(* Last modified on Thu Mar 05 14:55:33 PST 1992 by muller         *)
(*      modified on Thu Jan 30 10:14:38 PST 1992 by kalsow         *)
(*      modified on Tue Apr 24 16:38:45 1990 by jerome         *)



UNSAFE INTERFACE M3toC;

IMPORT Ctypes;

(* The C null string "" *)
VAR
    nullString:  ADDRESS;

PROCEDURE TtoS (t: TEXT): Ctypes.CharStar;
(* Return a null-terminated C string with the same contents as t.  This
   may or may not copy.  The result should be passed to FreeS after
   it is irrelevant and before t is collected.  *)

PROCEDURE CopyTtoS (t: TEXT): Ctypes.CharStar;
(* Return a null-terminated C string with the same contents as t.  This
   copies t.  The result should be passed to FreeS after it is
   irrelevant.  *)

PROCEDURE FreeS (s: Ctypes.CharStar);
(* If s was copied from a text by TtoS or CopyTtoS, this frees the
   storage for s; if s was shared with a text by TtoS, this is a no-op.
   *)

PROCEDURE StoT (s: Ctypes.CharStar): TEXT;
(* Return a text with the same contents as the null-terminated 
   C string s. This may or may not copy.  The result may be
   invalid after s is freed. *)

PROCEDURE CopyStoT (s: Ctypes.CharStar): TEXT;
(* Return a text with the same contents as the null-terminated 
   C string s. This copies s. *)

PROCEDURE ItoP (t: INTEGER): ADDRESS;
(* Loophole a Modula3 INTEGER into a C Pointer *)

PROCEDURE RtoP (t: REAL): ADDRESS;
(* Loophole a Modula3 REAL into a C Pointer *)

PROCEDURE UtoP (t: Ctypes.UnsignedLong): ADDRESS;
(* Loophole a Ctypes.UnsignedLong into a C Pointer *)

PROCEDURE PtoI (t: ADDRESS): INTEGER;
(* Loophole a C Pointer into a Modula3 INTEGER *)

PROCEDURE PtoR (t: ADDRESS): REAL;
(* Loophole a C Pointer into a Modula3 REAL *)

PROCEDURE PtoFS (t: ADDRESS): Ctypes.FloatStar;
(* Loophole a C Pointer into a Modula3 FloatStar *)

PROCEDURE PtoDS (t: ADDRESS): Ctypes.DoubleStar;
(* Loophole a C Pointer into a Modula3 DoubleStar *)

TYPE
  Argv       = UNTRACED REF ARRAY [0..255] OF Ctypes.CharStar;

<*OBSOLETE*> (* please use the Params or ParseParams interface instead. *)
VAR
  argc:      INTEGER;
  adr_argc:  ADDRESS;
  argv:      Argv;

VAR
  null:      ADDRESS;

END M3toC.


