(* Copyright (C) 1992, Digital Equipment Corporation                         *)
(* All rights reserved.                                                      *)
(* See the file COPYRIGHT for a full description.                            *)
(*                                                                           *)
(*  Last modified on Wed Nov 18 12:58:54 MET 1992 by preschern               *)

MODULE DOSTextRd;

IMPORT Rd, RdClass, Thread;

CONST
  BUFFSIZE = 4096;
  Ctrl_Z   = 16_1A;         (* Ctrl Z means DOS text file EOF *)

REVEAL
  T = Rd.T BRANDED "DOSTextRd.T" OBJECT
        rd        : Rd.T;
      OVERRIDES
        seek   := Seek;
        close  := Close;
      END;

PROCEDURE New (rd: Rd.T): T =
  VAR buf: REF ARRAY OF CHAR;
  BEGIN
    buf := NEW (REF ARRAY OF CHAR, BUFFSIZE);
    RETURN (NEW (T, st:= 0, lo := 0, cur := 0, hi := 0, buff := buf,
                    closed := FALSE, seekable := TRUE, intermittent := FALSE,
                    rd := rd)); 
  END New;

PROCEDURE Seek (rd: T; dontBlock: BOOLEAN): RdClass.SeekResult
  RAISES {Rd.Failure, Thread.Alerted} =
  VAR i: INTEGER := 0;
      ch, next: CHAR;
      res: RdClass.SeekResult;
  BEGIN
    res := rd.rd.seek (dontBlock);
    IF (res # RdClass.SeekResult.Ready) THEN RETURN res END (* if *);

    LOOP
      IF Rd.EOF (rd.rd) OR (i >= BUFFSIZE - 2) THEN EXIT END (* if *);
      ch := Rd.GetChar (rd.rd);
      IF (ch = '\r') THEN
        TRY
          next := Rd.GetChar (rd.rd);
          IF (next # '\n') THEN rd.buff [i] := ch; INC (i); END (* if *);
          ch := (*Rd.GetChar(rd.rd)*)  next;
        EXCEPT Rd.EndOfFile => 
        END (* try *);
      END (* if *); 
      IF (ORD(ch) = Ctrl_Z) AND Rd.EOF (rd.rd) THEN EXIT END (* if *);
      rd.buff [i] := ch; INC (i);
    END (* loop *); 
      
    IF (i = 0) THEN RETURN RdClass.SeekResult.Eof END (* if *);
    rd.lo := rd.cur;
    rd.hi := rd.cur + i;
    RETURN RdClass.SeekResult.Ready;
  END Seek;

PROCEDURE Close (rd: T) RAISES {Rd.Failure, Thread.Alerted} =
  BEGIN
    rd.buff   := NIL;
    rd.closed := TRUE;
    Rd.Close (rd.rd);
  END Close;

BEGIN
END DOSTextRd.


