(* Copyright (C) 1989, Digital Equipment Corporation           *)
(* All rights reserved.                                        *)
(* See the file COPYRIGHT for a full description.              *)

(* Last modified on Sat Jun 27 15:30:43 PDT 1992 by muller         *)
(*      modified on Thu Sep 26 22:36:00 1991 by kalsow         *)


UNSAFE MODULE Cast;

(************* UNSAFE *********************************
PROCEDURE IntToReal (i: INTEGER): REAL  RAISES {} =
  BEGIN
    IF (Word.And (i, Word.Shift (255, 7)) = 0) THEN
      (* VAX F floating point restriction *)
      i := 0;
    END;
    RETURN LOOPHOLE (i, REAL);
  END IntToReal;
******************************************************)

PROCEDURE RealToInt (r: REAL): INTEGER  RAISES {} =
  BEGIN
    RETURN LOOPHOLE (r, INTEGER);
  END RealToInt;

TYPE IntPair = ARRAY [0..1] OF INTEGER;

(************* UNSAFE *********************************
PROCEDURE IntToLongreal (i, j: INTEGER): LONGREAL  RAISES {} =
  VAR x: IntPair;
  BEGIN
    IF (Word.And (i, Word.Shift (255, 7)) = 0) THEN
      (* VAX F floating point restriction *)
      i := 0;
      j := 0;
    END;
    x[0] := i;
    x[1] := j;
    RETURN LOOPHOLE (x, LONGREAL);
  END IntToLongreal;
******************************************************)

PROCEDURE LongrealToInt (l: LONGREAL): IntPair  RAISES {} =
  VAR x: IntPair;
  BEGIN
    LOOPHOLE (x, LONGREAL) := l;
    RETURN x;
  END LongrealToInt;

(************* UNSAFE *********************************
PROCEDURE IntToExtended (i, j: INTEGER): EXTENDED  RAISES {} =
  VAR x: IntPair;
  BEGIN
    IF (Word.And (i, Word.Shift (255, 7)) = 0) THEN
      (* VAX F floating point restriction *)
      i := 0;
      j := 0;
    END;
    x[0] := i;
    x[1] := j;
    RETURN LOOPHOLE (x, EXTENDED);
  END IntToExtended;
******************************************************)

PROCEDURE ExtendedToInt (e: EXTENDED): IntPair  RAISES {} =
  VAR x: IntPair;
  BEGIN
    LOOPHOLE (x, EXTENDED) := e;
    RETURN x;
  END ExtendedToInt;

PROCEDURE RefToInt (r: REFANY): INTEGER  RAISES {} =
  BEGIN
    RETURN LOOPHOLE (r, INTEGER);
  END RefToInt;

PROCEDURE AddressToInt (a: ADDRESS): INTEGER  RAISES {} =
  BEGIN
    RETURN LOOPHOLE (a, INTEGER);
  END AddressToInt;

BEGIN
END Cast.
