(* Copyright (C) 1989, Digital Equipment Corporation           *)
(* All rights reserved.                                        *)
(* See the file COPYRIGHT for a full description.              *)

(* Last modified on Thu Nov  2 21:55:22 1989 by muller         *)
(*      modified on Fri Sep 29 15:51:46 1989 by kalsow         *)
(*      modified on Sun May  7 15:46:59 1989 by stolfi         *)

UNSAFE MODULE Root;

PROCEDURE New (value: T): REF T =
  VAR r: REF T;
  BEGIN
    r := NEW (REF T);
    r^ := value;
    RETURN r;
  END New;

PROCEDURE NewArray (size: CARDINAL;  value: T := NIL): REF ARRAY OF T =
  VAR arr: REF ARRAY OF T;
  BEGIN
    arr := NEW (REF ARRAY OF T, size);
    (* Assumes the allocator initializes to NIL automatically: *)
    IF value # NIL THEN
      FOR i := 0 TO size - 1 DO arr[i] := value END
    END;
    RETURN arr
  END NewArray;

PROCEDURE Compare (a, b: T): INTEGER =
  BEGIN
    RETURN LOOPHOLE (a, INTEGER) - LOOPHOLE (b, INTEGER);
  END Compare;

PROCEDURE Lt (a, b: T): BOOLEAN =
  BEGIN
    RETURN (LOOPHOLE (a, INTEGER) < LOOPHOLE (b, INTEGER));
  END Lt;

PROCEDURE Eq (a, b: T): BOOLEAN =
  BEGIN
    RETURN (a = b);
  END Eq;

PROCEDURE Hash (a: T): INTEGER =
  BEGIN
    RETURN LOOPHOLE (a, INTEGER);
  END Hash;

BEGIN
END Root.

