#!/usr/bin/perl
#

use strict;
use warnings;

use FindBin;
use File::Spec;
use Cwd;
use File::Basename;
use lib (glob(File::Spec->catfile(${FindBin::RealBin},'..','..','libs','*','')));
use Tree_Query::Common;
use Treex::PML::Factory;
use Carp;

use Getopt::Long;
Getopt::Long::Configure ("bundling");
my %opts;
GetOptions(\%opts,
   'input-file|f=s',
   'output-file|o=s',
   'stdout',
);

BEGIN {
  Treex::PML::AddResourcePath( File::Spec->catfile(${FindBin::RealBin},'..','..','resources') );
}

$opts{stdout}=1 unless $opts{'output-file'};
my $query = shift;

my @files = glob(File::Spec->catfile(getcwd,$opts{'input-file'}));

die "Input files not specified or don't exist\n" if ($opts{'input-file'} && !@files);

unless ($query || $opts{'input-file'})
{
   local $/;
   undef $/;
   $query = <STDIN>;
}

my $doc = Treex::PML::Factory->createDocument('query.pml');
$doc->changeBackend('Treex::PML::Backend::PML');
$doc->changeEncoding('utf-8');
$doc->changeSchemaURL('tree_query_schema.xml');
$doc->changeMetaData('schema', Tree_Query::Common::Schema);
$doc->changeMetaData('pml_root', Treex::PML::Factory->createStructure);

if (@files)
{
   for my $file (@files)
   {
      local $/;
      undef $/;
      
      open my $fh, '<:utf8', $file or die "Can't open file: '$file'\n";
      my $string = <$fh>;
      my $result = Tree_Query::Common::parse_query($string);
      
      if ($result)
      {
         $file=basename($file);
         $file=~s/\.\w+$//; 
         $result->set_attr('id', $file);
         $doc->append_tree($result);
      } else {
         croak "Parsing query in file '$file' failed";
      }
   }
} else {
   my $result = Tree_Query::Common::parse_query($query);
   
   if ($result)
   {
      $result->set_attr('id', 'set-id');
      $doc->append_tree($result);
   } else {
      croak "Parsing query failed";
   }

}

$doc->writeTo(\*STDOUT) if $opts{stdout};
$doc->writeFile($opts{'output-file'}) if $opts{'output-file'};

__END__

=head1 NAME

query2pml.pl

=head1 SYNOPSIS



=head1 DESCRIPTION

Stub documentation for query2pml.pl, 
created by Padre::Tepmlate.

It looks like the author of this script was negligent 
enough to leave the stub unedited.

=head1 AUTHOR

Michal Sedlák

=head1 COPYRIGHT AND LICENSE

This program is free software; you can redistribute it and/or modify
it under the same terms as Perl itself, either Perl version 5.8.2 or,
at your option, any later version of Perl 5 you may have available.

=cut