package WebService::Mattermost::V4::API::Resource::Email;

# ABSTRACT: Wrapped API methods for the email API endpoints.

use Moo;

extends 'WebService::Mattermost::V4::API::Resource';

################################################################################

sub send_test {
    my $self = shift;
    my $args = shift;

    return $self->_single_view_post({
        endpoint => 'test',
        view     => 'Status',
    });
}

################################################################################

1;

__END__

=pod

=encoding UTF-8

=head1 NAME

WebService::Mattermost::V4::API::Resource::Email - Wrapped API methods for the email API endpoints.

=head1 VERSION

version 0.26

=head1 DESCRIPTION

=head2 USAGE

    use WebService::Mattermost;

    my $mm = WebService::Mattermost->new({
        authenticate => 1,
        username     => 'me@somewhere.com',
        password     => 'hunter2',
        base_url     => 'https://my.mattermost.server.com/api/v4/',
    });

    my $resource = $mm->api->email;

=head2 METHODS

=over 4

=item C<send_test()>

L<Send a test email|https://api.mattermost.com/#tag/system%2Fpaths%2F~1database~1recycle%2Fpost>

There are many available parameters for this API call which may require reading
of the API documentation.

Providing no parameters will use the ones set on your Mattermost server.

    my $response = $resource->send_test({
        # Optional parameters:
        ServiceSettings      => {},
        TeamSettings         => {},
        SqlSettings          => {},
        LogSettings          => {},
        PasswordSettings     => {},
        FileSettings         => {},
        EmailSettings        => {},
        RateLimitSettings    => {},
        PrivacySettings      => {},
        SupportSettings      => {},
        GitLabSettings       => {},
        GoogleSettings       => {},
        Office365Settings    => {},
        LdapSettings         => {},
        ComplianceSettings   => {},
        LocalizationSettings => {},
        SamlSettings         => {},
        NativeAppSettings    => {},
        ClusterSettings      => {},
        MetricsSettings      => {},
        AnalyticsSettings    => {},
        WebrtcSettings       => {},
    });

=back

=head1 AUTHOR

Mike Jones <mike@netsplit.org.uk>

=head1 COPYRIGHT AND LICENSE

This software is Copyright (c) 2020 by Mike Jones.

This is free software, licensed under:

  The MIT (X11) License

=cut
