/*
 * Decompiled with CFR 0.152.
 */
package opennlp.grok.util;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Constructor;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import opennlp.grok.util.GroupMap;
import opennlp.grok.util.ModuleListener;

public class Module {
    private static ArrayList listeners = new ArrayList();
    private static Map CHOICES = new GroupMap();
    private static Properties CURRENT;

    public static void addListener(ModuleListener l) {
        listeners.add(l);
    }

    public static void Init(String file, String current) {
        try {
            Module.Init(new FileInputStream(file), new FileInputStream(current));
        }
        catch (Exception E) {
            System.out.println("Unable to load module file: " + E);
        }
    }

    public static void Init(InputStream file, InputStream current) {
        Properties DEFAULTS = new Properties();
        CURRENT = new Properties(DEFAULTS);
        try {
            CURRENT.load(current);
        }
        catch (Exception E) {
            System.out.println("Unable to load module file: " + current);
        }
        BufferedReader br = new BufferedReader(new InputStreamReader(file));
        try {
            String line = br.readLine();
            while (line != null) {
                if (!(line = line.trim()).equals("")) {
                    StringTokenizer st = new StringTokenizer(line);
                    String module = st.nextToken().trim();
                    String def = st.nextToken().trim();
                    DEFAULTS.setProperty(module, def);
                    CHOICES.put(module, def);
                    while (st.hasMoreTokens()) {
                        CHOICES.put(module, st.nextToken().trim());
                    }
                }
                line = br.readLine();
            }
        }
        catch (IOException IO) {
            IO.printStackTrace();
        }
    }

    public static void Save(String file) {
        try {
            CURRENT.store(new FileOutputStream(file), "Current user modules for Grok");
        }
        catch (Exception E) {
            System.out.println(E);
        }
    }

    private static Constructor getConstructor(Class modClass, Class[] types) {
        Constructor<?>[] constrs = modClass.getDeclaredConstructors();
        int c = 0;
        while (c < constrs.length) {
            Class<?>[] constrParamTypes = constrs[c].getParameterTypes();
            if (constrParamTypes.length == types.length) {
                boolean found = true;
                int t = 0;
                while (t < types.length) {
                    if (!constrParamTypes[t].isAssignableFrom(types[t])) {
                        found = false;
                        break;
                    }
                    ++t;
                }
                if (found) {
                    return constrs[c];
                }
            }
            ++c;
        }
        return null;
    }

    private static Object New(String module, Object[] params, Class[] paramTypes) {
        Object modInst;
        try {
            Class<?> modClass = Class.forName(Module.getDefault(module));
            Constructor constr = Module.getConstructor(modClass, paramTypes);
            modInst = constr.newInstance(params);
        }
        catch (Exception E) {
            System.out.println(module + " " + Module.getDefault(module));
            E.printStackTrace();
            return null;
        }
        return modInst;
    }

    private static Object New(String module, Object[] params) {
        Class[] paramTypes = new Class[params.length];
        int i = 0;
        while (i < paramTypes.length) {
            paramTypes[i] = params[i].getClass();
            ++i;
        }
        return Module.New(module, params, paramTypes);
    }

    public static Object New(Class c, Object[] params) {
        return Module.New(c.getName(), params);
    }

    public static Object New(Class c) {
        Object[] params = new Object[]{};
        return Module.New(c.getName(), params);
    }

    public static Object New(Class c, Object p1) {
        Object[] params = new Object[]{p1};
        return Module.New(c.getName(), params);
    }

    public static Object New(Class c, Object p1, Object p2) {
        Object[] params = new Object[]{p1, p2};
        return Module.New(c.getName(), params);
    }

    public static Object New(Class c, Object p1, Object p2, Object p3) {
        Object[] params = new Object[]{p1, p2, p3};
        return Module.New(c.getName(), params);
    }

    public static Iterator getModules() {
        return CHOICES.keySet().iterator();
    }

    public static String getDefault(String module) {
        return CURRENT.getProperty(module);
    }

    public static void setDefault(String module, String def) {
        CURRENT.setProperty(module, def);
        Iterator i = ((AbstractList)listeners).iterator();
        while (i.hasNext()) {
            ((ModuleListener)i.next()).ModuleChanged(module, def);
        }
    }

    public static Iterator getInstancesIterator(String module) {
        return ((Collection)CHOICES.get(module)).iterator();
    }

    public static Collection getInstances(String module) {
        return (Collection)CHOICES.get(module);
    }
}

