# -*- cperl -*-
# ABSTRACT: LaTeX element object


package SpeL::Object::Element;

use SpeL::Object::VerbatimEnvironment;
use SpeL::Object::Environment;
use SpeL::Object::Group;
use SpeL::Object::MathInline;
use SpeL::Object::MathEnvironment;
use SpeL::Object::Item;
use SpeL::Object::Command;
use SpeL::Object::TokenSequence;
use SpeL::Object::Variable;
use SpeL::Object::Realnumber;

;
use parent 'Exporter';
use Carp;

use Data::Dumper;




sub read {
  my $self = shift;
  my ( $level ) = @_;

  exists $self->{sup} and return '^';
  exists $self->{sub} and return '_';
  exists $self->{smallspace} and return ' ';
  exists $self->{percent} and return $SpeL::I18n::lh->maketext( '%' );
  exists $self->{eol} and return "\n";
  if ( exists $self->{Docstrip} ) {
    $self->{Docstrip} =~ s/\./ dot /g;
    $self->{Docstrip} =~ s/::/ double colon /g;
    $self->{Docstrip} =~ s/:/ colon /g;
    $self->{Docstrip} =~ s/;/ semicolon /g;
    return $self->{Docstrip};
  }
    
  return "Error when reading Element|" . $self->{''} . "|";
}

1;

__END__

=pod

=encoding UTF-8

=head1 NAME

SpeL::Object::Element - LaTeX element object

=head1 VERSION

version 20240616.1333

=head1 METHODS

=head2 new()

We keep the default method, as the object is generated by the parser.

=head2 read( level )

returns a string with the spoken version of the node

=over 4

=item level: parsing level

=back

=head1 SYNOPSYS

Represents a LaTeX element

=head1 AUTHOR

Walter Daems <wdaems@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is Copyright (c) 2024 by Walter Daems.

This is free software, licensed under:

  The GNU General Public License, Version 3, June 2007

=head1 CONTRIBUTOR

=for stopwords Paul Levrie

Paul Levrie

=cut
