# -*- cperl -*-
# ABSTRACT: LaTeX operator object


package SpeL::Object::Unop;


use parent 'Exporter';
use Carp;

use Data::Dumper;



sub read {
  my $self = shift;
  my ( $level ) = @_;

  # say STDERR Data::Dumper->Dump( [ $self ], [ 'self' ] );
  $self->{Op} =~ /^\\overline$/ and
    return
    $SpeL::I18n::lh->maketext( 'Overline',
				       $self->{Arg}->read( $level + 1 ) );

  return 'Error: Unary operator not implemented yet';
}

1;

__END__

=pod

=encoding UTF-8

=head1 NAME

SpeL::Object::Unop - LaTeX operator object

=head1 VERSION

version 20240616.1333

=head1 METHODS

=head2 new()

We keep the default method, as the object is generated by the parser.

=head2 read( level )

returns a string with the spoken version of the node

=over 4

=item level: parsing level

=back

=head1 SYNOPSYS

Represents a LaTeX operator

=head1 AUTHOR

Walter Daems <wdaems@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is Copyright (c) 2024 by Walter Daems.

This is free software, licensed under:

  The GNU General Public License, Version 3, June 2007

=head1 CONTRIBUTOR

=for stopwords Paul Levrie

Paul Levrie

=cut
