# Generated by default/object.tt
package Paws::SecurityHub::Page;
  use Moose;
  has LineRange => (is => 'ro', isa => 'Paws::SecurityHub::Range');
  has OffsetRange => (is => 'ro', isa => 'Paws::SecurityHub::Range');
  has PageNumber => (is => 'ro', isa => 'Int');

1;

### main pod documentation begin ###

=head1 NAME

Paws::SecurityHub::Page

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::SecurityHub::Page object:

  $service_obj->Method(Att1 => { LineRange => $value, ..., PageNumber => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::SecurityHub::Page object:

  $result = $service_obj->Method(...);
  $result->Att1->LineRange

=head1 DESCRIPTION

An occurrence of sensitive data in an Adobe Portable Document Format
(PDF) file.

=head1 ATTRIBUTES


=head2 LineRange => L<Paws::SecurityHub::Range>

An occurrence of sensitive data detected in a non-binary text file or a
Microsoft Word file. Non-binary text files include files such as HTML,
XML, JSON, and TXT files.


=head2 OffsetRange => L<Paws::SecurityHub::Range>

An occurrence of sensitive data detected in a binary text file.


=head2 PageNumber => Int

The page number of the page that contains the sensitive data.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::SecurityHub>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

