## -*- Mode: CPerl -*-
##
## File: DTA::CAB::Analyzer::EqPho::FST.pm
## Author: Bryan Jurish <moocow@cpan.org>
## Description: phonetic equivalence class expansion via Gfsm::Automaton

##==============================================================================
## Package: Analyzer::Morph
##==============================================================================
package DTA::CAB::Analyzer::EqPho::FST;
use DTA::CAB::Analyzer::Automaton::Gfsm;
use Carp;
use strict;
our @ISA = qw(DTA::CAB::Analyzer::Automaton::Gfsm);

## $obj = CLASS_OR_OBJ->new(%args)
##  + object structure: see DTA::CAB::Analyzer::Automaton::Gfsm, DTA::CAB::Analyzer::Automaton
sub new {
  my $that = shift;
  my $aut = $that->SUPER::new(
			      ##-- overrides
			      #tolower => 0,
			      #check_symbols => 0,

			      ##-- analysis selection
			      label => 'eqpho',
			      analyzeGet     => '$_[0]{lts} ? (map {$_->{hi}} @{$_[0]{lts}}) : qw()',
			      attInput       => 1,
			      wantAnalysisLo => 1,
			      allowTextRegex => '^(?:(?:[[:alpha:]\-\@]*[[:alpha:]]+)|(?:[[:alpha:]]+[[:alpha:]\-\@]+))(?:\'s)?$',
			      #allowWordRegex => '.',

			      ##-- type expansion
			      #typeKeys => [qw(eqpho)],

			      ##-- user args
			      @_
			     );
  return $aut;
}

##==============================================================================
## Analysis Formatting
##==============================================================================


1; ##-- be happy

__END__

##========================================================================
## POD DOCUMENTATION, auto-generated by podextract.perl, edited
=pod

=cut

##========================================================================
## NAME
=pod

=head1 NAME

DTA::CAB::Analyzer::EqPho::FST - FST-based phonetic form expander

=cut

##========================================================================
## SYNOPSIS
=pod

=head1 SYNOPSIS

 use DTA::CAB::Analyzer::EqPho::FST;
 
 $eqp = DTA::CAB::Analyzer::EqPho::FST->new(%args);
 $eqp->analyze($tok);

=cut

##========================================================================
## DESCRIPTION
=pod

=head1 DESCRIPTION

B<WORK IN PROGRESS>

L<Gfsm::Automaton|Gfsm::Automaton>-based phonetic equivalence-class expander.
Composite analyzers should also include an 'lts' phonetic analyzer.

DTA::CAB::Analyzer::EqPho::FST
is a just a simplified wrapper for
L<DTA::CAB::Analyzer::Automaton::Gfsm|DTA::CAB::Analyzer::Automaton::Gfsm>
which sets the following default options:

 analyzeSrc     => 'lts',    ##-- analysis input property
 analyzeDst     => 'eqpho',  ##-- analysis output property
 attInput       => 1,        ##-- respect AT&T-lextools escapes in input strings
 wantAnalysisLo => 1,        ##-- include lower label paths in output
 allowTextRegex => '(?:^[[:alpha:]\-]*[[:alpha:]]+$)|(?:^[[:alpha:]]+[[:alpha:]\-]+$)',
                             ##-- analyze only "alphabetic" tokens

=cut

##========================================================================
## END POD DOCUMENTATION, auto-generated by podextract.perl

##======================================================================
## Footer
##======================================================================

=pod

=head1 AUTHOR

Bryan Jurish E<lt>moocow@cpan.orgE<gt>

=head1 COPYRIGHT AND LICENSE

Copyright (C) 2009-2019 by Bryan Jurish

This package is free software; you can redistribute it and/or modify
it under the same terms as Perl itself, either Perl version 5.24.1 or,
at your option, any later version of Perl 5 you may have available.

=cut


=cut
