# This Makefile.PL for Git-Hooks was generated by
# Dist::Zilla::Plugin::MakeMaker::Awesome 0.49.
# Don't edit it but the dist.ini and plugins used to construct it.

use strict;
use warnings;

use ExtUtils::MakeMaker;

 # see http://wiki.cpantesters.org/wiki/CPANAuthorNotes
 if ($^O eq 'MSWin32') {
     warn "I do not support Windows yet. Sorry.\n";
     exit 0;
 }

 sub git {
     my ($args) = @_;
     my $output = `git $args`;
     if ($? == -1) {
         warn "Failed to execute 'git $args': $!\n";
         exit 0;
     } elsif ($? != 0) {
         warn "Command 'git $args' died with exit code=$?\n";
         exit 0;
     }
     return $output;
 }

 # Check if we have a proper git
 chomp(my $git_version = git('version'));
 if (my ($major, $minor, $patch) = ($git_version =~ /(\d+)\.(\d+)\.(\d+)/)) {
     if ($major < 2 || $major == 2 && ($minor < 25 || $minor == 25 && $patch < 1)) {
 	warn "Don't support gits older than 2.25.1. Your version is $git_version.\n";
 	exit 0;
     }
 } else {
     warn "Couldn't parse git version: '$git_version'\n";
     exit 0;
 }

my %WriteMakefileArgs = (
  "ABSTRACT" => "Framework for implementing Git (and Gerrit) hooks",
  "AUTHOR" => "Gustavo L. de M. Chaves <gnustavo\@cpan.org>",
  "CONFIGURE_REQUIRES" => {
    "ExtUtils::MakeMaker" => 0
  },
  "DISTNAME" => "Git-Hooks",
  "EXE_FILES" => [
    "scripts/find-secret-leakage-in-git-diff.pl",
    "scripts/githooks-docker.sh",
    "scripts/githooks.pl"
  ],
  "LICENSE" => "perl",
  "NAME" => "Git::Hooks",
  "PREREQ_PM" => {
    "Carp" => 0,
    "Email::Sender::Simple" => 0,
    "Email::Simple" => 0,
    "Encode" => 0,
    "Exporter" => 0,
    "Git::Repository" => 0,
    "Git::Repository::Log" => 0,
    "Git::Repository::Plugin" => 0,
    "IO::Interactive" => 0,
    "List::MoreUtils" => 0,
    "Log::Any" => 0,
    "Path::Tiny" => "0.060",
    "Test::More" => 0,
    "Text::Glob" => 0,
    "URI::Escape" => 0,
    "parent" => 0,
    "strict" => 0,
    "utf8" => 0,
    "warnings" => 0
  },
  "TEST_REQUIRES" => {
    "Config" => 0,
    "Email::Sender::Transport::Mbox" => 0,
    "ExtUtils::MakeMaker" => 0,
    "File::Spec" => 0,
    "Path::Tiny" => "0.060",
    "Test::More" => 0,
    "Test::Requires::Git" => 0,
    "lib" => 0
  },
  "VERSION" => "4.0.0",
  "test" => {
    "TESTS" => "t/*.t"
  }
);

my %FallbackPrereqs = (
  "Carp" => 0,
  "Config" => 0,
  "Email::Sender::Simple" => 0,
  "Email::Sender::Transport::Mbox" => 0,
  "Email::Simple" => 0,
  "Encode" => 0,
  "Exporter" => 0,
  "ExtUtils::MakeMaker" => 0,
  "File::Spec" => 0,
  "Git::Repository" => 0,
  "Git::Repository::Log" => 0,
  "Git::Repository::Plugin" => 0,
  "IO::Interactive" => 0,
  "List::MoreUtils" => 0,
  "Log::Any" => 0,
  "Path::Tiny" => "0.060",
  "Test::More" => 0,
  "Test::Requires::Git" => 0,
  "Text::Glob" => 0,
  "URI::Escape" => 0,
  "lib" => 0,
  "parent" => 0,
  "strict" => 0,
  "utf8" => 0,
  "warnings" => 0
);

unless ( eval { ExtUtils::MakeMaker->VERSION('6.63_03') } ) {
  delete $WriteMakefileArgs{TEST_REQUIRES};
  delete $WriteMakefileArgs{BUILD_REQUIRES};
  $WriteMakefileArgs{PREREQ_PM} = \%FallbackPrereqs;
}

delete $WriteMakefileArgs{CONFIGURE_REQUIRES}
  unless eval { ExtUtils::MakeMaker->VERSION(6.52) };

WriteMakefile(%WriteMakefileArgs);
