package # hide from PAUSE
    DateTime::Locale::Conflicts;

use strict;
use warnings;

# this module was generated with Dist::Zilla::Plugin::Conflicts 0.20

use Dist::CheckConflicts
    -dist      => 'DateTime::Locale',
    -conflicts => {
        'DateTime::Format::Strptime' => '1.1000',
    },
    -also => [ qw(
        Carp
        Dist::CheckConflicts
        Exporter
        File::ShareDir
        File::Spec
        List::Util
        Params::ValidationCompiler
        Specio::Declare
        Specio::Library::String
        Storable
        namespace::autoclean
        strict
        warnings
    ) ],

;

1;

# ABSTRACT: Check for conflicts between DateTime::Locale and installed packages
# Dist::Zilla: -PodWeaver

__END__

=pod

=for Pod::Coverage *EVERYTHING*

=head1 NAME

DateTime::Locale::Conflicts - Check for conflicts between DateTime::Locale and installed packages

=head1 DESCRIPTION

This module contains information about conflicts between this distribution and
other CPAN distributions. It does not have any user-facing parts.

This module was generated by Dist::Zilla::Plugin::Conflicts 0.20.

=cut
