package Dependency::Resolver::Node;
$Dependency::Resolver::Node::VERSION = '0.01';
use utf8;
use Moose;


has name => (
               isa      => "Str",
               is       => "rw",
);


has edges => (
               is       => "rw",
               isa      => "ArrayRef",
               default  => sub { [] },
           );

sub addEdge {
    my ($self, $node) = @_;

    push( @{$self->edges}, $node );
}

=head1 NAME

Dependency::Resolver::Node - Dependency resolver node

=head1 VERSION

version 0.01

=head1 SYNOPSIS

my $a = Dependency::Resolver::Node->new( name => 'a' );
my $b = Dependency::Resolver::Node->new( name => 'b' );
my $c = Dependency::Resolver::Node->new( name => 'c' );
my $d = Dependency::Resolver::Node->new( name => 'd' );
my $e = Dependency::Resolver::Node->new( name => 'e' );

$a->addEdge($b);    # a depends on b
$a->addEdge($d);    # a depends on d
$b->addEdge($c);    # b depends on c
$b->addEdge($e);    # b depends on e
$c->addEdge($d);    # c depends on d
$c->addEdge($e);    # c depends on e


=head1 SUBROUTINES/METHODS

=head2 addEdge($edge)

=head1 AUTHOR

Daniel Brosseau, C<< <dab at catapulse.org> >>

=cut

1;
