#ifndef _PARAMENT_H
#define _PARAMENT_H

#ifdef PARAMETER_FILE_SOURCE
int ParamEntry (ParamFile * pf, Parameter * p, char *name, char *mode,
		char *type, char *value, char *min, char *max, char *prompt);

#endif

int ParamAccess (ParamFile pfile, char *name);
/* Return the string representation of the named parameter's field's
**
	any of *mode, *type, *value, *min, *max, *prompt that are
	passed as NULL are ignored.  Otherwise they should point
	to enough memory to hold the string representation of the
	parameter field.  In general SZ_PFLINE is recomended.
**/

int ParamInfo (ParamFile pfile, char *name, char *mode, char *type,
	       char *value, char *min, char *max, char *prompt);
char *ParamResolve (ParamFile pfile, char *name, char *str, int max);


#endif /* ! _PARAMENT_H */
