#!/usr/bin/perl -w

use lib 't';
use Testdata;

use Test::More tests => @ciphers*@padstyles*(length($plaintext)+1) + 1;

BEGIN { use_ok (Crypt::ECB) }

my $ecb = Crypt::ECB->new;

foreach my $cipher (@ciphers)
{
	eval { $ecb->cipher($cipher) };
	SKIP: {	skip "$cipher not installed", @padstyles*(length($plaintext)+1) if $@;

		my $ks = $ecb->keysize || 56;
		$ecb->key( substr($key, 0, $ks) );

		foreach my $padstyle (@padstyles)
		{
			$ecb->padding($padstyle);

			foreach my $len (0..length($plaintext))
			{
				my $plain = substr($plaintext, 0, $len) =~ s/ /_/g;
				my $enc = $ecb->encrypt($plain);
				my $dec = $ecb->decrypt($enc);
				ok($dec eq $plain, "$cipher, $padstyle padding: en-/decrypting $len bytes plaintext");
			}
		}
	}
}
