package Database::Temp::Driver::DummyForTesting;

use strict;
use warnings;

# ABSTRACT: Create an ad-hoc database, dummy driver for testing

# VERSION: generated by DZP::OurPkgVersion

use Module::Load::Conditional qw( can_load );
use File::Spec;
use Carp qw( shortmess );

use Log::Any;
use Try::Tiny;

=pod

=encoding utf8

=cut

=head2 is_available

Can this driver provide a (fake/dummy) database?

Return boolean.

=cut

sub is_available {
    return 1;
}

=head2 new

Create a temp database.

User should never call this subroutine directly, only via L<Database::Temp>.

=cut

sub new {
    my ( $class, %params ) = @_;
    my $_log = Log::Any->get_logger( category => 'Database::Temp' );

    my $dsn = 'dbi:DummyForTesting';

    my %attrs;
    my %info;

    # Construct start method
    my $_start = sub {
        my ( $dbh, $name ) = @_;
        Log::Any->get_logger( category => 'Database::Temp' )->debugf( 'Created temp db \'%s\'', $name );
    };

    # Construct init method
    my $init;
    if ( ref $params{'init'} eq 'CODE' ) {
        $init = $params{'init'};
    }
    else {    # SCALAR
        $init = sub {
            return;
        }
    }

    # Construct deinit method
    my $deinit;
    if ( ref $params{'deinit'} eq 'CODE' ) {
        $deinit = $params{'deinit'};
    }
    else {    # SCALAR
        $deinit = sub {
            return;
        }
    }

    # Construct _cleanup method
    my $_cleanup = sub {
        my ( $dbh, $name, $info ) = @_;
        $_log->infof('Deleting testing dummy');
    };

    # Create database representing object.
    return Database::Temp::DB->new(
        driver   => ( __PACKAGE__ =~ m/^Database::Temp::Driver::(.*)$/msx )[0],
        name     => $params{'name'},
        cleanup  => $params{'cleanup'} // 0,
        _cleanup => $_cleanup,
        _start   => $_start,
        init     => $init,
        deinit   => $deinit,
        dsn      => $dsn,
        username => $params{'username'},
        password => $params{'password'},
        attr     => \%attrs,
        info     => \%info,
    );
}

1;

