/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import java.util.Arrays;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.instruct.Choose;
import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.style.Compilation;
import net.sf.saxon.style.ComponentDeclaration;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.style.XSLOtherwise;
import net.sf.saxon.style.XSLWhen;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.AxisIterator;
import net.sf.saxon.value.BooleanValue;

public class XSLChoose
extends StyleElement {
    private StyleElement otherwise;
    private int numberOfWhens = 0;

    public boolean isInstruction() {
        return true;
    }

    public void prepareAttributes() throws XPathException {
        AttributeCollection atts = this.getAttributeList();
        for (int a = 0; a < atts.getLength(); ++a) {
            this.checkUnknownAttribute(atts.getNodeName(a));
        }
    }

    public void validate(ComponentDeclaration decl) throws XPathException {
        NodeInfo curr;
        AxisIterator kids = this.iterateAxis((byte)3);
        while ((curr = kids.next()) != null) {
            if (curr instanceof XSLWhen) {
                if (this.otherwise != null) {
                    this.otherwise.compileError("xsl:otherwise must come last", "XTSE0010");
                }
                ++this.numberOfWhens;
                continue;
            }
            if (curr instanceof XSLOtherwise) {
                if (this.otherwise != null) {
                    ((XSLOtherwise)curr).compileError("Only one xsl:otherwise is allowed in an xsl:choose", "XTSE0010");
                    continue;
                }
                this.otherwise = (StyleElement)curr;
                continue;
            }
            if (curr instanceof StyleElement) {
                ((StyleElement)curr).compileError("Only xsl:when and xsl:otherwise are allowed here", "XTSE0010");
                continue;
            }
            this.compileError("Only xsl:when and xsl:otherwise are allowed within xsl:choose", "XTSE0010");
        }
        if (this.numberOfWhens == 0) {
            this.compileError("xsl:choose must contain at least one xsl:when", "XTSE0010");
        }
    }

    public boolean markTailCalls() {
        boolean found = false;
        AxisIterator kids = this.iterateAxis((byte)3);
        NodeInfo curr;
        while ((curr = kids.next()) != null) {
            if (!(curr instanceof StyleElement)) continue;
            found |= ((StyleElement)curr).markTailCalls();
        }
        return found;
    }

    public Expression compile(Compilation exec, ComponentDeclaration decl) throws XPathException {
        NodeInfo curr;
        int entries = this.numberOfWhens + (this.otherwise == null ? 0 : 1);
        Expression[] conditions = new Expression[entries];
        Expression[] actions = new Expression[entries];
        int w = 0;
        AxisIterator kids = this.iterateAxis((byte)3);
        while ((curr = kids.next()) != null) {
            if (curr instanceof XSLWhen) {
                conditions[w] = ((XSLWhen)curr).getCondition();
                Expression b = ((XSLWhen)curr).compileSequenceConstructor(exec, decl, true);
                if (b == null) {
                    b = Literal.makeEmptySequence();
                }
                try {
                    actions[w] = b = b.simplify();
                }
                catch (XPathException e) {
                    this.compileError(e);
                }
                if (this.getCompilation().getCompilerInfo().isCompileWithTracing()) {
                    actions[w] = XSLChoose.makeTraceInstruction((XSLWhen)curr, actions[w]);
                }
                if (conditions[w] instanceof Literal && ((Literal)conditions[w]).getValue() instanceof BooleanValue) {
                    if (((BooleanValue)((Literal)conditions[w]).getValue()).getBooleanValue()) {
                        entries = w + 1;
                        break;
                    }
                    --w;
                    --entries;
                }
                ++w;
                continue;
            }
            if (!(curr instanceof XSLOtherwise)) continue;
            Literal otherwise = Literal.makeLiteral(BooleanValue.TRUE);
            otherwise.setRetainedStaticContext(this.makeRetainedStaticContext());
            conditions[w] = otherwise;
            Expression b = ((XSLOtherwise)curr).compileSequenceConstructor(exec, decl, true);
            if (b == null) {
                b = Literal.makeEmptySequence();
                b.setRetainedStaticContext(this.makeRetainedStaticContext());
            }
            try {
                actions[w] = b = b.simplify();
            }
            catch (XPathException e) {
                this.compileError(e);
            }
            if (this.getCompilation().getCompilerInfo().isCompileWithTracing()) {
                actions[w] = XSLChoose.makeTraceInstruction((XSLOtherwise)curr, actions[w]);
            }
            ++w;
        }
        if (conditions.length != entries) {
            if (entries == 0) {
                return null;
            }
            if (entries == 1 && conditions[0] instanceof Literal && ((Literal)conditions[0]).getValue() instanceof BooleanValue) {
                if (((BooleanValue)((Literal)conditions[0]).getValue()).getBooleanValue()) {
                    return actions[0];
                }
                return null;
            }
            conditions = Arrays.copyOf(conditions, entries);
            actions = Arrays.copyOf(actions, entries);
        }
        Choose choose = new Choose(conditions, actions);
        choose.setInstruction(true);
        return choose;
    }
}

