# Config.PL
#
# Configuration file generation for ARS::Simple

# Just to tell make we are done with configuring
open CFG, '>', 'Config';
print CFG "\n";
close CFG;

# Are we being run from ActiveStates PPM
if ($0 =~ /\.PPM$/i)
{
    print "Running from PPM...\n\n";
    chdir '..';

    # find ARS::Simple.pm
    foreach $dir (@INC)
    {
        if (-e $dir.'/ARS/Simple.pm')
        {
            $configfile = $dir.'Simple.cfg';
            last;
        }
    }
    unless ($configfile)
    {
        print STDERR "The module ARS::Simple.pm is not found. Are you realy running the script via PPM install?\n";
        <STDIN>;
        exit(1);
    }
}
else
{
    # called directly
    unless (-d 'blib/lib')
    {
        die "Do not execute this script directly, run:\n\tperl Makefile.PL
\tmake\n\tmake test\n\tmake install\n
If you are using ActivePerl under Windows use 'nmake' or 'dmake' instead of 'make'.";
    }
}

if (($configfile && -f $configfile) || -f 'blib/lib/ARS/Simple.cfg') { exit; }

my $user     = '';
my $password = '';
my $proxy    = '';
unless ($ENV{PERL_MM_USE_DEFAULT} || $ENV{AUTOMATED_TESTING} || !-t STDIN)
{
    print "\n================ Set the defaults for module ARS::Simple ================\n";
    print "\nSpecify defaults for ARS::Simple? (y/N) ";
    $res = <STDIN>;
    exit unless $res =~ /^y$/i;

    if (! $configfile)
    {
        print "\n\t... will be saved to .../lib/ARS/Simple.cfg\n";
        $configfile = 'blib/lib/ARS/Simple.cfg';
    }
    else
    {
        print "\n\t... will be saved to $configfile\n";
    }

    #exit if -f $configfile;

    # Gather the defaults
    print "\nDefault user to use for Remedy: ";
    $user = <STDIN>;
    $user =~ s/^\s+//;
    $user =~ s/\s+$//;

    print "Password for user '$user': ";
    $password = <STDIN>;
    $password =~ s/^\s+//;
    $password =~ s/\s+$//;

    print "\nSaving config file, using the following:\n";
}

if (! $configfile)
{
    $configfile = 'blib/lib/ARS/Simple.cfg';
}
open $fh, '>', $configfile || die "failed to open $configfile: $!";
print $fh "# Config file for ARS::Simple\n# generated by Config.PL (".scalar(localtime).")\n# This file MUST be valid perl (as it is 'required')\n# Note user and password are obfuscated, NOT encrypted.\n\n";
print $fh q{%config = (} . "\n";

# Doing simple obfuscation of user and password
my $k = '5Jv@sI9^bl@D*j5H3@:7g4H[2]d%Ks314aNuGeX;';
my $x = substr($k, 0, length($user));
my $u = $user ^ $x;
my $up = unpack('H*', $u);
print $fh "\tuser     => '$up',\n";

$x = substr($k, 0, length($password));
$u = $password ^ $x;
$up = unpack('H*', $u);
print $fh "\tpassword => '$up',\n";
print $fh ");\n1;\n#--< End of File >--#\n";
close $fh;

unless ($ENV{PERL_MM_USE_DEFAULT} || $ENV{AUTOMATED_TESTING} || !-t STDIN)
{
    print "\tuser     => '$user' (obfuscated),\n";
    print "\tpassword => '$password' (obfuscated),\n";
    print "\nFinished configuration\n";
}


#####################################################################
# DO NOT REMOVE THE FOLLOWING LINE, IT IS NEEDED TO LOAD THIS LIBRARY
1;

#---< End of File >---#
