#!/usr/bin/perl

package eBay::API::XML::Call::GetProductSearchPage::GetProductSearchPageRequestType;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. GetProductSearchPageRequestType.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::Call::GetProductSearchPage::GetProductSearchPageRequestType

=head1 DESCRIPTION

Retrieves the attributes a seller can use to form a query when
searching for Pre-filled Item Information to use in a listing for
a category that is catalog-enabled. This call is applicable for
use cases related to listing items with Pre-filled Item
Information. Specifically, it retrieves data
that you use to construct valid "single-attribute" queries. The
attributes describe search criteria (e.g., Author) and sorting
criteria (e.g., Publication Year), as appropriate for the
category. GetProductSearchPage does not conduct the actual
product search. It only returns data about what you can search
on. Use the data as input to GetProductSearchResults to conduct
the actual search for product information. To retrieve Product
Finder search criteria (querying against multiple attributes),
use GetProductFinder instead. See the eBay Web Services guide for
an overview of Pre-filled Item Information and details about
searching for catalog products.



=head1 SYNOPSIS

=cut


=head1 INHERITANCE

eBay::API::XML::Call::GetProductSearchPage::GetProductSearchPageRequestType inherits from the L<eBay::API::XML::RequestDataType> class

=cut

use eBay::API::XML::RequestDataType;
our @ISA = ("eBay::API::XML::RequestDataType");



my @gaProperties = ( [ 'AttributeSetID', 'xs:int', '1', '', '' ]
	, [ 'AttributeSystemVersion', 'xs:string', '', '', '' ]
                    );
push @gaProperties, @{eBay::API::XML::RequestDataType::getPropertiesList()};

my @gaAttributes = ( 
                    );
push @gaAttributes, @{eBay::API::XML::RequestDataType::getAttributesList()};

=head1 Subroutines:

=cut

sub new {
  my $classname = shift;
  my %args = @_;
  my $self = $classname->SUPER::new(%args);
  return $self;
}

sub isScalar {
   return 0; 
}



=head2 setAttributeSetID()

A characteristic set ID that is associated with a
catalog-enabled category that supports product search pages.
You can pass an array of these IDs in the request.
Each characteristic set corresponds to a level in the
eBay category hierarchy at which all items share common characteristics.
Multiple categories can be mapped to the same characteristic set.
Each ID is used as a filter to limit the response content to fewer
characteristic sets. When IDs are specified, the call only returns
search page data for the corresponding characteristic sets.
When no IDs are specified, the call returns all the current
search page data in the system.

  RequiredInput: No
#    Argument: reference to an array  
                      of 'xs:int'

=cut

sub setAttributeSetID {
  my $self = shift;
  $self->{'AttributeSetID'} = 
		$self->convertArray_To_RefToArrayIfNeeded(@_);
}

=head2 getAttributeSetID()

#    Returns: reference to an array  
                      of 'xs:int'

=cut

sub getAttributeSetID {
  my $self = shift;
  return $self->_getDataTypeArray('AttributeSetID');
}


=head2 setAttributeSystemVersion()

A version of the search page definitions for the site. Typically, an
application passes the version value that was returned the last time the
application executed this call. Filter that causes the call to return only
the search pages for which the attribute meta-data has changed since the
specified version. The latest version value is not necessarily greater
than the previous value that was returned. Therefore, when comparing
versions, only compare whether the value has changed.

  RequiredInput: No
#    Argument: 'xs:string'

=cut

sub setAttributeSystemVersion {
  my $self = shift;
  $self->{'AttributeSystemVersion'} = shift
}

=head2 getAttributeSystemVersion()

#    Returns: 'xs:string'

=cut

sub getAttributeSystemVersion {
  my $self = shift;
  return $self->{'AttributeSystemVersion'};
}





##  Attribute and Property lists
sub getPropertiesList {
   my $self = shift;
   return \@gaProperties;
}

sub getAttributesList {
   my $self = shift;
   return \@gaAttributes;
}



1;   
