/*    NumberFormat.xs
 *
 *    $Id: NumberFormat.xs,v 1.6 2002/01/20 21:39:09 bstell Exp $
 *
 *    Copyright (c) 2000 Brian Stell
 *
 *    This package is free software and is provided ``as is'' without
 *    express or implied warranty. It may be used, redistributed and/or
 *    modified under the terms of the Perl Artistic License
 *    (see http://www.perl.com/perl/misc/Artistic.html)
 *
 */

extern "C" {
#include "EXTERN.h"
#include "perl.h"
#include "XSUB.h"
}

#include  "picu/picu_debug.h"
#include  "picu/picu_utf8.h"
#include  "picu/picu_util.h"
#include  "unicode/numfmt.h"
#include  "picu/NumberFormat.h"
#include  "picu/Locale.h"

char *NumberFormat_class_string = "ICU::NumberFormat";
static int debugLevel = 0;

#define ERR_OUT stdout


MODULE = ICU::NumberFormat    PACKAGE = ICU::NumberFormat

# This requires xsubpp version 1.925 or greater
REQUIRE: 1.925

NumberFormat *
createCurrencyInstance(char *CLASS, ...)
    PREINIT:
        UErrorCode status = U_ZERO_ERROR;
        SV *sv_status = NULL;
        Picu_Locale *locale = 0;
        int locale_index = 0;
        int status_index = 0;
    CODE:
        if (items > 3) {
            Perl_croak(aTHX_
            "Usage: new ICU::NumberFormat::createCurrencyInstance"
                                             "([\\$status])\n"
            "   or: new ICU::NumberFormat::createCurrencyInstance"
                                             "($locale [, \\$status])");
        }
        //
        // distinguish between a locale object and a status ref
        // ie: figure out what parameters we got
        //
        DEBUG100("items = %d", items);
        if (items == 3) {
            locale_index = 1;
            status_index = 2;
        }
        else if (items == 2) {
            if ((sv_isobject(ST(1))) && (IS_LOCALE_OBJECT(ST(1)))) {
                DEBUG100("param 1 is Locale");
                locale_index = 1;
            }
            else {
                // we will check if it is a status ref later
                status_index = 1;
            }
        }
        //
        // get the args
        //
        if (locale_index) {
            if ((!sv_isobject(ST(locale_index)))
                || (!IS_LOCALE_OBJECT(ST(locale_index)))) {
               Perl_croak(aTHX_ "param %d is not a Locale",
                                                          locale_index);
            }
            DEBUG100("param %d is a locale", locale_index);
            locale = (Picu_Locale *)SvIV((SV*)SvRV(ST(locale_index)));
        }
        if (status_index) {
            if (!SVIsIntRef(ST(status_index))) {
                Perl_croak(aTHX_ "param %d is not an integer reference",
                                 status_index);
            }
            DEBUG100("param %d is a status ref", status_index);
            sv_status = SvRV(ST(status_index));
            status = (UErrorCode)SvIV(sv_status);
            if (U_FAILURE(status)) {
                XSRETURN_UNDEF;
            }
        }

        //
        // Call the ICU function
        //
        if (locale) {
            RETVAL = NumberFormat::createCurrencyInstance(
                                    *locale->getIcuLocale(), status);
        }
        else {
            RETVAL = NumberFormat::createCurrencyInstance(status);
        }
        if (sv_status) {
            sv_setiv(sv_status, (IV)status);
        }
    OUTPUT:
        RETVAL

NumberFormat *
createInstance(char *CLASS, ...)
    PREINIT:
        UErrorCode status = U_ZERO_ERROR;
        SV *sv_status = NULL;
        Picu_Locale *locale = 0;
        int locale_index = 0;
        int status_index = 0;
    CODE:
        if (items > 3) {
            Perl_croak(aTHX_
            "Usage: new ICU::NumberFormat::createInstance"
                                             "([\\$status])\n"
            "   or: new ICU::NumberFormat::createInstance"
                                             "($locale [, \\$status])");
        }
        //
        // distinguish between a locale object and a status ref
        // ie: figure out what the parameters we have
        //
        DEBUG100("items = %d", items);
        if (items == 3) {
            locale_index = 1;
            status_index = 2;
        }
        else if (items == 2) {
            if ((sv_isobject(ST(1))) && (IS_LOCALE_OBJECT(ST(1)))) {
                DEBUG100("param 1 is Locale");
                locale_index = 1;
            }
            else {
                // we will check if it is a status ref later
                status_index = 1;
            }
        }

        //
        // get the args
        //
        if (locale_index) {
            if ((!sv_isobject(ST(locale_index)))
                || (!IS_LOCALE_OBJECT(ST(locale_index)))) {
               Perl_croak(aTHX_ "param %d is not a Locale",
                                                          locale_index);
            }
            DEBUG100("param %d is a locale", locale_index);
            locale = (Picu_Locale *)SvIV((SV*)SvRV(ST(locale_index)));
        }
        if (status_index) {
            if (!SVIsIntRef(ST(status_index))) {
                Perl_croak(aTHX_ "param %d is not an integer reference",
                                 status_index);
            }
            DEBUG100("param %d is a status ref", status_index);
            sv_status = SvRV(ST(status_index));
            status = (UErrorCode)SvIV(sv_status);
        }

        //
        // Call the ICU function
        //
        if (locale) {
            RETVAL = NumberFormat::createInstance(
                                      *locale->getIcuLocale(), status);
        }
        else {
            RETVAL = NumberFormat::createInstance(status);
        }
        if (sv_status) {
            sv_setiv(sv_status, (IV)status);
        }
    OUTPUT:
        RETVAL

void
NumberFormat::DESTROY()
    CODE:
        DEBUG100("NumberFormat::DESTROY()");
        delete THIS;
        DEBUG100("NumberFormat::DESTROY()");

const char *
NumberFormat::format(double number, ...)
    PREINIT:
        UnicodeString format;
        U8 *u8str;
        uint32_t u8len;
    CODE:
        if (items > 3) {
            Perl_croak(aTHX_ "Usage: $df->format(number, fieldPosition=0)");
        }
        if (items == 3) {
            int index = SvIV(ST(2));
            FieldPosition fp(index);
            THIS->format(number, format, fp);
        }
        else {
            THIS->format(number, format);
        }
        u8str = UnicodeStringToU8String(format, &u8len);
        DEBUG100(" "); 
        IF_DEBUG100 dump_U8String((U8*)u8str);
        DEBUG100(" "); 
        IF_DEBUG100 dump_UCharString(format.getBuffer(), format.length());
        ST(0) = sv_newmortal();
        sv_usepvn(ST(0), (char*)u8str, u8len);
    OUTPUT:

int
NumberFormat::getMinimumFractionDigits()
    CODE:
        RETVAL = THIS->getMinimumFractionDigits();
    OUTPUT:
        RETVAL

int
NumberFormat::getMinimumIntegerDigits()
    CODE:
        RETVAL = THIS->getMinimumIntegerDigits();
    OUTPUT:
        RETVAL

double
NumberFormat::parse(number_str, ...)
        const char *number_str;
    PREINIT:
        UnicodeString number_unistr(number_str, "UTF-8");
        UErrorCode status = U_ZERO_ERROR;
        SV *sv_status = NULL;
        Formattable result;
        ParsePosition *parse_pos = NULL;
        double val = 0;
        int position_index = 0;
        int status_index = 0;
    CODE:
        if (items > 3) {
            Perl_croak(aTHX_
            "Usage: new $nf->parse($number_str [, $parse_pos])\n"
            "   or: new $nf->parse($number_str [, \\$status])");
        }
        //
        // distinguish between a ParsePosition object and a status ref
        // ie: figure out what the parameters we have
        //
        DEBUG100("items = %d", items);
        if (items == 3) {
            if (sv_isobject(ST(2))) {
                DEBUG10("need to check that param 2 is really a "
                                                "ParsePosition object");
                DEBUG100("param 2 is ParsePosition object");
                Perl_croak(aTHX_ "do not support ParsePosition yet");
            }
            else if (SVIsIntRef(ST(2))) {
                sv_status = SvRV(ST(2));
                status = (UErrorCode)SvIV(sv_status);
            }
            else {
                Perl_croak(aTHX_ "ICU::DateFormat::parse: param 2 must "
                                 "be a ParsePosition or status ref");
            }
        }

        // debug: show the data
        DEBUG100(" "); 
        IF_DEBUG100  dump_U8String((U8*)number_str);
        DEBUG100(" "); 
        IF_DEBUG100 dump_UCharString(number_unistr.getBuffer(), 
                                       number_unistr.length());

        //
        // Call the ICU function
        //
        if (parse_pos != NULL) {
            THIS->parse(number_unistr, result, *parse_pos);
        }
        else {
            THIS->parse(number_unistr, result, status);
        }
        if (sv_status) {
            sv_setiv(sv_status, (IV)status);
        }
        if (U_FAILURE(status)) {
            DEBUG100("status = %s", u_errorName(status));
            XSRETURN_UNDEF;
        }
        if (result.getType() == Formattable::kDouble) {
            val = result.getDouble();
        }
        else {
            val = (double)result.getLong();
        }
        ST(0) = sv_newmortal();
        sv_setnv(ST(0), val);

int
setDebugLevel(...)
    CODE:
        RETVAL = debugLevel; // return old value
        if (items > 1) {
            Perl_croak(aTHX_ "Usage: ICU::DateFormat::setDebugLevel([new_debug_level])");
        }
        else if (items == 1) {
            debugLevel = SvIV(ST(0));
        }
        DEBUG100("debugLevel = %d", debugLevel);
    OUTPUT:
        RETVAL

void
NumberFormat::setMaximumFractionDigits(frac_digits)
        int frac_digits;
    CODE:
        THIS->setMaximumFractionDigits(frac_digits);

void
NumberFormat::setMinimumFractionDigits(frac_digits)
        int frac_digits;
    CODE:
        THIS->setMinimumFractionDigits(frac_digits);


