# Generated by default/object.tt
package Paws::CodeArtifact::PackageVersionDescription;
  use Moose;
  has DisplayName => (is => 'ro', isa => 'Str', request_name => 'displayName', traits => ['NameInRequest']);
  has Format => (is => 'ro', isa => 'Str', request_name => 'format', traits => ['NameInRequest']);
  has HomePage => (is => 'ro', isa => 'Str', request_name => 'homePage', traits => ['NameInRequest']);
  has Licenses => (is => 'ro', isa => 'ArrayRef[Paws::CodeArtifact::LicenseInfo]', request_name => 'licenses', traits => ['NameInRequest']);
  has Namespace => (is => 'ro', isa => 'Str', request_name => 'namespace', traits => ['NameInRequest']);
  has PackageName => (is => 'ro', isa => 'Str', request_name => 'packageName', traits => ['NameInRequest']);
  has PublishedTime => (is => 'ro', isa => 'Str', request_name => 'publishedTime', traits => ['NameInRequest']);
  has Revision => (is => 'ro', isa => 'Str', request_name => 'revision', traits => ['NameInRequest']);
  has SourceCodeRepository => (is => 'ro', isa => 'Str', request_name => 'sourceCodeRepository', traits => ['NameInRequest']);
  has Status => (is => 'ro', isa => 'Str', request_name => 'status', traits => ['NameInRequest']);
  has Summary => (is => 'ro', isa => 'Str', request_name => 'summary', traits => ['NameInRequest']);
  has Version => (is => 'ro', isa => 'Str', request_name => 'version', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::CodeArtifact::PackageVersionDescription

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::CodeArtifact::PackageVersionDescription object:

  $service_obj->Method(Att1 => { DisplayName => $value, ..., Version => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::CodeArtifact::PackageVersionDescription object:

  $result = $service_obj->Method(...);
  $result->Att1->DisplayName

=head1 DESCRIPTION

Details about a package version.

=head1 ATTRIBUTES


=head2 DisplayName => Str

The name of the package that is displayed. The C<displayName> varies
depending on the package version's format. For example, if an npm
package is named C<ui>, is in the namespace C<vue>, and has the format
C<npm>, then the C<displayName> is C<@vue/ui>.


=head2 Format => Str

The format of the package version. The valid package formats are:

=over

=item *

C<npm>: A Node Package Manager (npm) package.

=item *

C<pypi>: A Python Package Index (PyPI) package.

=item *

C<maven>: A Maven package that contains compiled code in a
distributable format, such as a JAR file.

=back



=head2 HomePage => Str

The homepage associated with the package.


=head2 Licenses => ArrayRef[L<Paws::CodeArtifact::LicenseInfo>]

Information about licenses associated with the package version.


=head2 Namespace => Str

The namespace of the package. The package component that specifies its
namespace depends on its type. For example:

=over

=item *

The namespace of a Maven package is its C<groupId>.

=item *

The namespace of an npm package is its C<scope>.

=item *

A Python package does not contain a corresponding component, so Python
packages do not have a namespace.

=back



=head2 PackageName => Str

The name of the requested package.


=head2 PublishedTime => Str

A timestamp that contains the date and time the package version was
published.


=head2 Revision => Str

The revision of the package version.


=head2 SourceCodeRepository => Str

The repository for the source code in the package version, or the
source code used to build it.


=head2 Status => Str

A string that contains the status of the package version. It can be one
of the following:

=over

=item *

C<Published>

=item *

C<Unfinished>

=item *

C<Unlisted>

=item *

C<Archived>

=item *

C<Disposed>

=back



=head2 Summary => Str

A summary of the package version. The summary is extracted from the
package. The information in and detail level of the summary depends on
the package version's format.


=head2 Version => Str

The version of the package.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::CodeArtifact>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

