# Generated by default/object.tt
package Paws::Kendra::QuerySuggestionsBlockListSummary;
  use Moose;
  has CreatedAt => (is => 'ro', isa => 'Str');
  has Id => (is => 'ro', isa => 'Str');
  has ItemCount => (is => 'ro', isa => 'Int');
  has Name => (is => 'ro', isa => 'Str');
  has Status => (is => 'ro', isa => 'Str');
  has UpdatedAt => (is => 'ro', isa => 'Str');

1;

### main pod documentation begin ###

=head1 NAME

Paws::Kendra::QuerySuggestionsBlockListSummary

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::Kendra::QuerySuggestionsBlockListSummary object:

  $service_obj->Method(Att1 => { CreatedAt => $value, ..., UpdatedAt => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::Kendra::QuerySuggestionsBlockListSummary object:

  $result = $service_obj->Method(...);
  $result->Att1->CreatedAt

=head1 DESCRIPTION

Summary information on a query suggestions block list.

This includes information on the block list ID, block list name, when
the block list was created, when the block list was last updated, and
the count of block words/phrases in the block list.

For information on the current quota limits for block lists, see Quotas
for Amazon Kendra
(https://docs.aws.amazon.com/kendra/latest/dg/quotas.html).

=head1 ATTRIBUTES


=head2 CreatedAt => Str

The date-time summary information for a query suggestions block list
was last created.


=head2 Id => Str

The identifier of a block list.


=head2 ItemCount => Int

The number of items in the block list file.


=head2 Name => Str

The name of the block list.


=head2 Status => Str

The status of the block list.


=head2 UpdatedAt => Str

The date-time the block list was last updated.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::Kendra>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

