package Net::Async::Redis::Commands;

use strict;
use warnings;

our $VERSION = '1.000'; # VERSION

=head1 NAME

Net::Async::Redis::Commands - mixin that defines the Redis commands available

=head1 DESCRIPTION

This is autogenerated from the list of commands available in L<https://redis.io/commands>.

It is intended to be loaded by L<Net::Async::Redis> to provide methods
for each available Redis command.

=cut

=head1 METHODS - Cluster

=head2 cluster_addslots

Assign new hash slots to receiving node.

=over 4

=item * slot [slot ...]

=back

=cut

sub cluster_addslots : method {
    my ($self, @args) = @_;
    $self->execute_command('CLUSTER ADDSLOTS' => @args)
}

=head2 cluster_count_failure_reports

Return the number of failure reports active for a given node.

=over 4

=item * node-id

=back

=cut

sub cluster_count_failure_reports : method {
    my ($self, @args) = @_;
    $self->execute_command('CLUSTER COUNT-FAILURE-REPORTS' => @args)
}

=head2 cluster_countkeysinslot

Return the number of local keys in the specified hash slot.

=over 4

=item * slot

=back

=cut

sub cluster_countkeysinslot : method {
    my ($self, @args) = @_;
    $self->execute_command('CLUSTER COUNTKEYSINSLOT' => @args)
}

=head2 cluster_delslots

Set hash slots as unbound in receiving node.

=over 4

=item * slot [slot ...]

=back

=cut

sub cluster_delslots : method {
    my ($self, @args) = @_;
    $self->execute_command('CLUSTER DELSLOTS' => @args)
}

=head2 cluster_failover

Forces a slave to perform a manual failover of its master..

=over 4

=item * [FORCE|TAKEOVER]

=back

=cut

sub cluster_failover : method {
    my ($self, @args) = @_;
    $self->execute_command('CLUSTER FAILOVER' => @args)
}

=head2 cluster_forget

Remove a node from the nodes table.

=over 4

=item * node-id

=back

=cut

sub cluster_forget : method {
    my ($self, @args) = @_;
    $self->execute_command('CLUSTER FORGET' => @args)
}

=head2 cluster_getkeysinslot

Return local key names in the specified hash slot.

=over 4

=item * slot

=item * count

=back

=cut

sub cluster_getkeysinslot : method {
    my ($self, @args) = @_;
    $self->execute_command('CLUSTER GETKEYSINSLOT' => @args)
}

=head2 cluster_info

Provides info about Redis Cluster node state.

=cut

sub cluster_info : method {
    my ($self, @args) = @_;
    $self->execute_command('CLUSTER INFO' => @args)
}

=head2 cluster_keyslot

Returns the hash slot of the specified key.

=over 4

=item * key

=back

=cut

sub cluster_keyslot : method {
    my ($self, @args) = @_;
    $self->execute_command('CLUSTER KEYSLOT' => @args)
}

=head2 cluster_meet

Force a node cluster to handshake with another node.

=over 4

=item * ip

=item * port

=back

=cut

sub cluster_meet : method {
    my ($self, @args) = @_;
    $self->execute_command('CLUSTER MEET' => @args)
}

=head2 cluster_nodes

Get Cluster config for the node.

=cut

sub cluster_nodes : method {
    my ($self, @args) = @_;
    $self->execute_command('CLUSTER NODES' => @args)
}

=head2 cluster_replicate

Reconfigure a node as a slave of the specified master node.

=over 4

=item * node-id

=back

=cut

sub cluster_replicate : method {
    my ($self, @args) = @_;
    $self->execute_command('CLUSTER REPLICATE' => @args)
}

=head2 cluster_reset

Reset a Redis Cluster node.

=over 4

=item * [HARD|SOFT]

=back

=cut

sub cluster_reset : method {
    my ($self, @args) = @_;
    $self->execute_command('CLUSTER RESET' => @args)
}

=head2 cluster_saveconfig

Forces the node to save cluster state on disk.

=cut

sub cluster_saveconfig : method {
    my ($self, @args) = @_;
    $self->execute_command('CLUSTER SAVECONFIG' => @args)
}

=head2 cluster_set_config_epoch

Set the configuration epoch in a new node.

=over 4

=item * config-epoch

=back

=cut

sub cluster_set_config_epoch : method {
    my ($self, @args) = @_;
    $self->execute_command('CLUSTER SET-CONFIG-EPOCH' => @args)
}

=head2 cluster_setslot

Bind a hash slot to a specific node.

=over 4

=item * slot

=item * IMPORTING|MIGRATING|STABLE|NODE

=item * [node-id]

=back

=cut

sub cluster_setslot : method {
    my ($self, @args) = @_;
    $self->execute_command('CLUSTER SETSLOT' => @args)
}

=head2 cluster_slaves

List slave nodes of the specified master node.

=over 4

=item * node-id

=back

=cut

sub cluster_slaves : method {
    my ($self, @args) = @_;
    $self->execute_command('CLUSTER SLAVES' => @args)
}

=head2 cluster_slots

Get array of Cluster slot to node mappings.

=cut

sub cluster_slots : method {
    my ($self, @args) = @_;
    $self->execute_command('CLUSTER SLOTS' => @args)
}

=head2 readonly

Enables read queries for a connection to a cluster slave node.

=cut

sub readonly : method {
    my ($self, @args) = @_;
    $self->execute_command('READONLY' => @args)
}

=head2 readwrite

Disables read queries for a connection to a cluster slave node.

=cut

sub readwrite : method {
    my ($self, @args) = @_;
    $self->execute_command('READWRITE' => @args)
}

=head1 METHODS - Connection

=head2 auth

Authenticate to the server.

=over 4

=item * password

=back

=cut

sub auth : method {
    my ($self, @args) = @_;
    $self->execute_command('AUTH' => @args)
}

=head2 echo

Echo the given string.

=over 4

=item * message

=back

=cut

sub echo : method {
    my ($self, @args) = @_;
    $self->execute_command('ECHO' => @args)
}

=head2 ping

Ping the server.

=over 4

=item * [message]

=back

=cut

sub ping : method {
    my ($self, @args) = @_;
    $self->execute_command('PING' => @args)
}

=head2 quit

Close the connection.

=cut

sub quit : method {
    my ($self, @args) = @_;
    $self->execute_command('QUIT' => @args)
}

=head2 select

Change the selected database for the current connection.

=over 4

=item * index

=back

=cut

sub select : method {
    my ($self, @args) = @_;
    $self->execute_command('SELECT' => @args)
}

=head2 swapdb

Swaps two Redis databases.

=over 4

=item * index

=item * index

=back

=cut

sub swapdb : method {
    my ($self, @args) = @_;
    $self->execute_command('SWAPDB' => @args)
}

=head1 METHODS - Generic

=head2 del

Delete a key.

=over 4

=item * key [key ...]

=back

=cut

sub del : method {
    my ($self, @args) = @_;
    $self->execute_command('DEL' => @args)
}

=head2 dump

Return a serialized version of the value stored at the specified key..

=over 4

=item * key

=back

=cut

sub dump : method {
    my ($self, @args) = @_;
    $self->execute_command('DUMP' => @args)
}

=head2 exists

Determine if a key exists.

=over 4

=item * key [key ...]

=back

=cut

sub exists : method {
    my ($self, @args) = @_;
    $self->execute_command('EXISTS' => @args)
}

=head2 expire

Set a key's time to live in seconds.

=over 4

=item * key

=item * seconds

=back

=cut

sub expire : method {
    my ($self, @args) = @_;
    $self->execute_command('EXPIRE' => @args)
}

=head2 expireat

Set the expiration for a key as a UNIX timestamp.

=over 4

=item * key

=item * timestamp

=back

=cut

sub expireat : method {
    my ($self, @args) = @_;
    $self->execute_command('EXPIREAT' => @args)
}

=head2 keys

Find all keys matching the given pattern.

=over 4

=item * pattern

=back

=cut

sub keys : method {
    my ($self, @args) = @_;
    $self->execute_command('KEYS' => @args)
}

=head2 migrate

Atomically transfer a key from a Redis instance to another one..

=over 4

=item * host

=item * port

=item * key|""

=item * destination-db

=item * timeout

=item * [COPY]

=item * [REPLACE]

=item * [KEYS key [key ...]]

=back

=cut

sub migrate : method {
    my ($self, @args) = @_;
    $self->execute_command('MIGRATE' => @args)
}

=head2 move

Move a key to another database.

=over 4

=item * key

=item * db

=back

=cut

sub move : method {
    my ($self, @args) = @_;
    $self->execute_command('MOVE' => @args)
}

=head2 object

Inspect the internals of Redis objects.

=over 4

=item * subcommand

=item * [arguments [arguments ...]]

=back

=cut

sub object : method {
    my ($self, @args) = @_;
    $self->execute_command('OBJECT' => @args)
}

=head2 persist

Remove the expiration from a key.

=over 4

=item * key

=back

=cut

sub persist : method {
    my ($self, @args) = @_;
    $self->execute_command('PERSIST' => @args)
}

=head2 pexpire

Set a key's time to live in milliseconds.

=over 4

=item * key

=item * milliseconds

=back

=cut

sub pexpire : method {
    my ($self, @args) = @_;
    $self->execute_command('PEXPIRE' => @args)
}

=head2 pexpireat

Set the expiration for a key as a UNIX timestamp specified in milliseconds.

=over 4

=item * key

=item * milliseconds-timestamp

=back

=cut

sub pexpireat : method {
    my ($self, @args) = @_;
    $self->execute_command('PEXPIREAT' => @args)
}

=head2 pttl

Get the time to live for a key in milliseconds.

=over 4

=item * key

=back

=cut

sub pttl : method {
    my ($self, @args) = @_;
    $self->execute_command('PTTL' => @args)
}

=head2 randomkey

Return a random key from the keyspace.

=cut

sub randomkey : method {
    my ($self, @args) = @_;
    $self->execute_command('RANDOMKEY' => @args)
}

=head2 rename

Rename a key.

=over 4

=item * key

=item * newkey

=back

=cut

sub rename : method {
    my ($self, @args) = @_;
    $self->execute_command('RENAME' => @args)
}

=head2 renamenx

Rename a key, only if the new key does not exist.

=over 4

=item * key

=item * newkey

=back

=cut

sub renamenx : method {
    my ($self, @args) = @_;
    $self->execute_command('RENAMENX' => @args)
}

=head2 restore

Create a key using the provided serialized value, previously obtained using DUMP..

=over 4

=item * key

=item * ttl

=item * serialized-value

=item * [REPLACE]

=back

=cut

sub restore : method {
    my ($self, @args) = @_;
    $self->execute_command('RESTORE' => @args)
}

=head2 sort

Sort the elements in a list, set or sorted set.

=over 4

=item * key

=item * [BY pattern]

=item * [LIMIT offset count]

=item * [GET pattern [GET pattern ...]]

=item * [ASC|DESC]

=item * [ALPHA]

=item * [STORE destination]

=back

=cut

sub sort : method {
    my ($self, @args) = @_;
    $self->execute_command('SORT' => @args)
}

=head2 touch

Alters the last access time of a key(s). Returns the number of existing keys specified..

=over 4

=item * key [key ...]

=back

=cut

sub touch : method {
    my ($self, @args) = @_;
    $self->execute_command('TOUCH' => @args)
}

=head2 ttl

Get the time to live for a key.

=over 4

=item * key

=back

=cut

sub ttl : method {
    my ($self, @args) = @_;
    $self->execute_command('TTL' => @args)
}

=head2 type

Determine the type stored at key.

=over 4

=item * key

=back

=cut

sub type : method {
    my ($self, @args) = @_;
    $self->execute_command('TYPE' => @args)
}

=head2 unlink

Delete a key asynchronously in another thread. Otherwise it is just as DEL, but non blocking..

=over 4

=item * key [key ...]

=back

=cut

sub unlink : method {
    my ($self, @args) = @_;
    $self->execute_command('UNLINK' => @args)
}

=head2 wait

Wait for the synchronous replication of all the write commands sent in the context of the current connection.

=over 4

=item * numslaves

=item * timeout

=back

=cut

sub wait : method {
    my ($self, @args) = @_;
    $self->execute_command('WAIT' => @args)
}

=head2 scan

Incrementally iterate the keys space.

=over 4

=item * cursor

=item * [MATCH pattern]

=item * [COUNT count]

=back

=cut

sub scan : method {
    my ($self, @args) = @_;
    $self->execute_command('SCAN' => @args)
}

=head1 METHODS - Geo

=head2 geoadd

Add one or more geospatial items in the geospatial index represented using a sorted set.

=over 4

=item * key

=item * longitude latitude member [longitude latitude member ...]

=back

=cut

sub geoadd : method {
    my ($self, @args) = @_;
    $self->execute_command('GEOADD' => @args)
}

=head2 geohash

Returns members of a geospatial index as standard geohash strings.

=over 4

=item * key

=item * member [member ...]

=back

=cut

sub geohash : method {
    my ($self, @args) = @_;
    $self->execute_command('GEOHASH' => @args)
}

=head2 geopos

Returns longitude and latitude of members of a geospatial index.

=over 4

=item * key

=item * member [member ...]

=back

=cut

sub geopos : method {
    my ($self, @args) = @_;
    $self->execute_command('GEOPOS' => @args)
}

=head2 geodist

Returns the distance between two members of a geospatial index.

=over 4

=item * key

=item * member1

=item * member2

=item * [unit]

=back

=cut

sub geodist : method {
    my ($self, @args) = @_;
    $self->execute_command('GEODIST' => @args)
}

=head2 georadius

Query a sorted set representing a geospatial index to fetch members matching a given maximum distance from a point.

=over 4

=item * key

=item * longitude

=item * latitude

=item * radius

=item * m|km|ft|mi

=item * [WITHCOORD]

=item * [WITHDIST]

=item * [WITHHASH]

=item * [COUNT count]

=item * [ASC|DESC]

=item * [STORE key]

=item * [STOREDIST key]

=back

=cut

sub georadius : method {
    my ($self, @args) = @_;
    $self->execute_command('GEORADIUS' => @args)
}

=head2 georadiusbymember

Query a sorted set representing a geospatial index to fetch members matching a given maximum distance from a member.

=over 4

=item * key

=item * member

=item * radius

=item * m|km|ft|mi

=item * [WITHCOORD]

=item * [WITHDIST]

=item * [WITHHASH]

=item * [COUNT count]

=item * [ASC|DESC]

=item * [STORE key]

=item * [STOREDIST key]

=back

=cut

sub georadiusbymember : method {
    my ($self, @args) = @_;
    $self->execute_command('GEORADIUSBYMEMBER' => @args)
}

=head1 METHODS - Hash

=head2 hdel

Delete one or more hash fields.

=over 4

=item * key

=item * field [field ...]

=back

=cut

sub hdel : method {
    my ($self, @args) = @_;
    $self->execute_command('HDEL' => @args)
}

=head2 hexists

Determine if a hash field exists.

=over 4

=item * key

=item * field

=back

=cut

sub hexists : method {
    my ($self, @args) = @_;
    $self->execute_command('HEXISTS' => @args)
}

=head2 hget

Get the value of a hash field.

=over 4

=item * key

=item * field

=back

=cut

sub hget : method {
    my ($self, @args) = @_;
    $self->execute_command('HGET' => @args)
}

=head2 hgetall

Get all the fields and values in a hash.

=over 4

=item * key

=back

=cut

sub hgetall : method {
    my ($self, @args) = @_;
    $self->execute_command('HGETALL' => @args)
}

=head2 hincrby

Increment the integer value of a hash field by the given number.

=over 4

=item * key

=item * field

=item * increment

=back

=cut

sub hincrby : method {
    my ($self, @args) = @_;
    $self->execute_command('HINCRBY' => @args)
}

=head2 hincrbyfloat

Increment the float value of a hash field by the given amount.

=over 4

=item * key

=item * field

=item * increment

=back

=cut

sub hincrbyfloat : method {
    my ($self, @args) = @_;
    $self->execute_command('HINCRBYFLOAT' => @args)
}

=head2 hkeys

Get all the fields in a hash.

=over 4

=item * key

=back

=cut

sub hkeys : method {
    my ($self, @args) = @_;
    $self->execute_command('HKEYS' => @args)
}

=head2 hlen

Get the number of fields in a hash.

=over 4

=item * key

=back

=cut

sub hlen : method {
    my ($self, @args) = @_;
    $self->execute_command('HLEN' => @args)
}

=head2 hmget

Get the values of all the given hash fields.

=over 4

=item * key

=item * field [field ...]

=back

=cut

sub hmget : method {
    my ($self, @args) = @_;
    $self->execute_command('HMGET' => @args)
}

=head2 hmset

Set multiple hash fields to multiple values.

=over 4

=item * key

=item * field value [field value ...]

=back

=cut

sub hmset : method {
    my ($self, @args) = @_;
    $self->execute_command('HMSET' => @args)
}

=head2 hset

Set the string value of a hash field.

=over 4

=item * key

=item * field

=item * value

=back

=cut

sub hset : method {
    my ($self, @args) = @_;
    $self->execute_command('HSET' => @args)
}

=head2 hsetnx

Set the value of a hash field, only if the field does not exist.

=over 4

=item * key

=item * field

=item * value

=back

=cut

sub hsetnx : method {
    my ($self, @args) = @_;
    $self->execute_command('HSETNX' => @args)
}

=head2 hstrlen

Get the length of the value of a hash field.

=over 4

=item * key

=item * field

=back

=cut

sub hstrlen : method {
    my ($self, @args) = @_;
    $self->execute_command('HSTRLEN' => @args)
}

=head2 hvals

Get all the values in a hash.

=over 4

=item * key

=back

=cut

sub hvals : method {
    my ($self, @args) = @_;
    $self->execute_command('HVALS' => @args)
}

=head2 hscan

Incrementally iterate hash fields and associated values.

=over 4

=item * key

=item * cursor

=item * [MATCH pattern]

=item * [COUNT count]

=back

=cut

sub hscan : method {
    my ($self, @args) = @_;
    $self->execute_command('HSCAN' => @args)
}

=head1 METHODS - Hyperloglog

=head2 pfadd

Adds the specified elements to the specified HyperLogLog..

=over 4

=item * key

=item * element [element ...]

=back

=cut

sub pfadd : method {
    my ($self, @args) = @_;
    $self->execute_command('PFADD' => @args)
}

=head2 pfcount

Return the approximated cardinality of the set(s) observed by the HyperLogLog at key(s)..

=over 4

=item * key [key ...]

=back

=cut

sub pfcount : method {
    my ($self, @args) = @_;
    $self->execute_command('PFCOUNT' => @args)
}

=head2 pfmerge

Merge N different HyperLogLogs into a single one..

=over 4

=item * destkey

=item * sourcekey [sourcekey ...]

=back

=cut

sub pfmerge : method {
    my ($self, @args) = @_;
    $self->execute_command('PFMERGE' => @args)
}

=head1 METHODS - List

=head2 blpop

Remove and get the first element in a list, or block until one is available.

=over 4

=item * key [key ...]

=item * timeout

=back

=cut

sub blpop : method {
    my ($self, @args) = @_;
    $self->execute_command('BLPOP' => @args)
}

=head2 brpop

Remove and get the last element in a list, or block until one is available.

=over 4

=item * key [key ...]

=item * timeout

=back

=cut

sub brpop : method {
    my ($self, @args) = @_;
    $self->execute_command('BRPOP' => @args)
}

=head2 brpoplpush

Pop a value from a list, push it to another list and return it; or block until one is available.

=over 4

=item * source

=item * destination

=item * timeout

=back

=cut

sub brpoplpush : method {
    my ($self, @args) = @_;
    $self->execute_command('BRPOPLPUSH' => @args)
}

=head2 lindex

Get an element from a list by its index.

=over 4

=item * key

=item * index

=back

=cut

sub lindex : method {
    my ($self, @args) = @_;
    $self->execute_command('LINDEX' => @args)
}

=head2 linsert

Insert an element before or after another element in a list.

=over 4

=item * key

=item * BEFORE|AFTER

=item * pivot

=item * value

=back

=cut

sub linsert : method {
    my ($self, @args) = @_;
    $self->execute_command('LINSERT' => @args)
}

=head2 llen

Get the length of a list.

=over 4

=item * key

=back

=cut

sub llen : method {
    my ($self, @args) = @_;
    $self->execute_command('LLEN' => @args)
}

=head2 lpop

Remove and get the first element in a list.

=over 4

=item * key

=back

=cut

sub lpop : method {
    my ($self, @args) = @_;
    $self->execute_command('LPOP' => @args)
}

=head2 lpush

Prepend one or multiple values to a list.

=over 4

=item * key

=item * value [value ...]

=back

=cut

sub lpush : method {
    my ($self, @args) = @_;
    $self->execute_command('LPUSH' => @args)
}

=head2 lpushx

Prepend a value to a list, only if the list exists.

=over 4

=item * key

=item * value

=back

=cut

sub lpushx : method {
    my ($self, @args) = @_;
    $self->execute_command('LPUSHX' => @args)
}

=head2 lrange

Get a range of elements from a list.

=over 4

=item * key

=item * start

=item * stop

=back

=cut

sub lrange : method {
    my ($self, @args) = @_;
    $self->execute_command('LRANGE' => @args)
}

=head2 lrem

Remove elements from a list.

=over 4

=item * key

=item * count

=item * value

=back

=cut

sub lrem : method {
    my ($self, @args) = @_;
    $self->execute_command('LREM' => @args)
}

=head2 lset

Set the value of an element in a list by its index.

=over 4

=item * key

=item * index

=item * value

=back

=cut

sub lset : method {
    my ($self, @args) = @_;
    $self->execute_command('LSET' => @args)
}

=head2 ltrim

Trim a list to the specified range.

=over 4

=item * key

=item * start

=item * stop

=back

=cut

sub ltrim : method {
    my ($self, @args) = @_;
    $self->execute_command('LTRIM' => @args)
}

=head2 rpop

Remove and get the last element in a list.

=over 4

=item * key

=back

=cut

sub rpop : method {
    my ($self, @args) = @_;
    $self->execute_command('RPOP' => @args)
}

=head2 rpoplpush

Remove the last element in a list, prepend it to another list and return it.

=over 4

=item * source

=item * destination

=back

=cut

sub rpoplpush : method {
    my ($self, @args) = @_;
    $self->execute_command('RPOPLPUSH' => @args)
}

=head2 rpush

Append one or multiple values to a list.

=over 4

=item * key

=item * value [value ...]

=back

=cut

sub rpush : method {
    my ($self, @args) = @_;
    $self->execute_command('RPUSH' => @args)
}

=head2 rpushx

Append a value to a list, only if the list exists.

=over 4

=item * key

=item * value

=back

=cut

sub rpushx : method {
    my ($self, @args) = @_;
    $self->execute_command('RPUSHX' => @args)
}

=head1 METHODS - Pubsub

=head2 psubscribe

Listen for messages published to channels matching the given patterns.

=over 4

=item * pattern [pattern ...]

=back

=cut

sub psubscribe : method {
    my ($self, @args) = @_;
    $self->execute_command('PSUBSCRIBE' => @args)
}

=head2 pubsub

Inspect the state of the Pub/Sub subsystem.

=over 4

=item * subcommand

=item * [argument [argument ...]]

=back

=cut

sub pubsub : method {
    my ($self, @args) = @_;
    $self->execute_command('PUBSUB' => @args)
}

=head2 publish

Post a message to a channel.

=over 4

=item * channel

=item * message

=back

=cut

sub publish : method {
    my ($self, @args) = @_;
    $self->execute_command('PUBLISH' => @args)
}

=head2 punsubscribe

Stop listening for messages posted to channels matching the given patterns.

=over 4

=item * [pattern [pattern ...]]

=back

=cut

sub punsubscribe : method {
    my ($self, @args) = @_;
    $self->execute_command('PUNSUBSCRIBE' => @args)
}

=head2 subscribe

Listen for messages published to the given channels.

=over 4

=item * channel [channel ...]

=back

=cut

sub subscribe : method {
    my ($self, @args) = @_;
    $self->execute_command('SUBSCRIBE' => @args)
}

=head2 unsubscribe

Stop listening for messages posted to the given channels.

=over 4

=item * [channel [channel ...]]

=back

=cut

sub unsubscribe : method {
    my ($self, @args) = @_;
    $self->execute_command('UNSUBSCRIBE' => @args)
}

=head1 METHODS - Scripting

=head2 eval

Execute a Lua script server side.

=over 4

=item * script

=item * numkeys

=item * key [key ...]

=item * arg [arg ...]

=back

=cut

sub eval : method {
    my ($self, @args) = @_;
    $self->execute_command('EVAL' => @args)
}

=head2 evalsha

Execute a Lua script server side.

=over 4

=item * sha1

=item * numkeys

=item * key [key ...]

=item * arg [arg ...]

=back

=cut

sub evalsha : method {
    my ($self, @args) = @_;
    $self->execute_command('EVALSHA' => @args)
}

=head2 script_debug

Set the debug mode for executed scripts..

=over 4

=item * YES|SYNC|NO

=back

=cut

sub script_debug : method {
    my ($self, @args) = @_;
    $self->execute_command('SCRIPT DEBUG' => @args)
}

=head2 script_exists

Check existence of scripts in the script cache..

=over 4

=item * sha1 [sha1 ...]

=back

=cut

sub script_exists : method {
    my ($self, @args) = @_;
    $self->execute_command('SCRIPT EXISTS' => @args)
}

=head2 script_flush

Remove all the scripts from the script cache..

=cut

sub script_flush : method {
    my ($self, @args) = @_;
    $self->execute_command('SCRIPT FLUSH' => @args)
}

=head2 script_kill

Kill the script currently in execution..

=cut

sub script_kill : method {
    my ($self, @args) = @_;
    $self->execute_command('SCRIPT KILL' => @args)
}

=head2 script_load

Load the specified Lua script into the script cache..

=over 4

=item * script

=back

=cut

sub script_load : method {
    my ($self, @args) = @_;
    $self->execute_command('SCRIPT LOAD' => @args)
}

=head1 METHODS - Server

=head2 bgrewriteaof

Asynchronously rewrite the append-only file.

=cut

sub bgrewriteaof : method {
    my ($self, @args) = @_;
    $self->execute_command('BGREWRITEAOF' => @args)
}

=head2 bgsave

Asynchronously save the dataset to disk.

=cut

sub bgsave : method {
    my ($self, @args) = @_;
    $self->execute_command('BGSAVE' => @args)
}

=head2 client_kill

Kill the connection of a client.

=over 4

=item * [ip:port]

=item * [ID client-id]

=item * [TYPE normal|master|slave|pubsub]

=item * [ADDR ip:port]

=item * [SKIPME yes/no]

=back

=cut

sub client_kill : method {
    my ($self, @args) = @_;
    $self->execute_command('CLIENT KILL' => @args)
}

=head2 client_list

Get the list of client connections.

=cut

sub client_list : method {
    my ($self, @args) = @_;
    $self->execute_command('CLIENT LIST' => @args)
}

=head2 client_getname

Get the current connection name.

=cut

sub client_getname : method {
    my ($self, @args) = @_;
    $self->execute_command('CLIENT GETNAME' => @args)
}

=head2 client_pause

Stop processing commands from clients for some time.

=over 4

=item * timeout

=back

=cut

sub client_pause : method {
    my ($self, @args) = @_;
    $self->execute_command('CLIENT PAUSE' => @args)
}

=head2 client_reply

Instruct the server whether to reply to commands.

=over 4

=item * ON|OFF|SKIP

=back

=cut

sub client_reply : method {
    my ($self, @args) = @_;
    $self->execute_command('CLIENT REPLY' => @args)
}

=head2 client_setname

Set the current connection name.

=over 4

=item * connection-name

=back

=cut

sub client_setname : method {
    my ($self, @args) = @_;
    $self->execute_command('CLIENT SETNAME' => @args)
}

=head2 command

Get array of Redis command details.

=cut

sub command : method {
    my ($self, @args) = @_;
    $self->execute_command('COMMAND' => @args)
}

=head2 command_count

Get total number of Redis commands.

=cut

sub command_count : method {
    my ($self, @args) = @_;
    $self->execute_command('COMMAND COUNT' => @args)
}

=head2 command_getkeys

Extract keys given a full Redis command.

=cut

sub command_getkeys : method {
    my ($self, @args) = @_;
    $self->execute_command('COMMAND GETKEYS' => @args)
}

=head2 command_info

Get array of specific Redis command details.

=over 4

=item * command-name [command-name ...]

=back

=cut

sub command_info : method {
    my ($self, @args) = @_;
    $self->execute_command('COMMAND INFO' => @args)
}

=head2 config_get

Get the value of a configuration parameter.

=over 4

=item * parameter

=back

=cut

sub config_get : method {
    my ($self, @args) = @_;
    $self->execute_command('CONFIG GET' => @args)
}

=head2 config_rewrite

Rewrite the configuration file with the in memory configuration.

=cut

sub config_rewrite : method {
    my ($self, @args) = @_;
    $self->execute_command('CONFIG REWRITE' => @args)
}

=head2 config_set

Set a configuration parameter to the given value.

=over 4

=item * parameter

=item * value

=back

=cut

sub config_set : method {
    my ($self, @args) = @_;
    $self->execute_command('CONFIG SET' => @args)
}

=head2 config_resetstat

Reset the stats returned by INFO.

=cut

sub config_resetstat : method {
    my ($self, @args) = @_;
    $self->execute_command('CONFIG RESETSTAT' => @args)
}

=head2 dbsize

Return the number of keys in the selected database.

=cut

sub dbsize : method {
    my ($self, @args) = @_;
    $self->execute_command('DBSIZE' => @args)
}

=head2 debug_object

Get debugging information about a key.

=over 4

=item * key

=back

=cut

sub debug_object : method {
    my ($self, @args) = @_;
    $self->execute_command('DEBUG OBJECT' => @args)
}

=head2 debug_segfault

Make the server crash.

=cut

sub debug_segfault : method {
    my ($self, @args) = @_;
    $self->execute_command('DEBUG SEGFAULT' => @args)
}

=head2 flushall

Remove all keys from all databases.

=over 4

=item * [ASYNC]

=back

=cut

sub flushall : method {
    my ($self, @args) = @_;
    $self->execute_command('FLUSHALL' => @args)
}

=head2 flushdb

Remove all keys from the current database.

=over 4

=item * [ASYNC]

=back

=cut

sub flushdb : method {
    my ($self, @args) = @_;
    $self->execute_command('FLUSHDB' => @args)
}

=head2 info

Get information and statistics about the server.

=over 4

=item * [section]

=back

=cut

sub info : method {
    my ($self, @args) = @_;
    $self->execute_command('INFO' => @args)
}

=head2 lastsave

Get the UNIX time stamp of the last successful save to disk.

=cut

sub lastsave : method {
    my ($self, @args) = @_;
    $self->execute_command('LASTSAVE' => @args)
}

=head2 monitor

Listen for all requests received by the server in real time.

=cut

sub monitor : method {
    my ($self, @args) = @_;
    $self->execute_command('MONITOR' => @args)
}

=head2 role

Return the role of the instance in the context of replication.

=cut

sub role : method {
    my ($self, @args) = @_;
    $self->execute_command('ROLE' => @args)
}

=head2 save

Synchronously save the dataset to disk.

=cut

sub save : method {
    my ($self, @args) = @_;
    $self->execute_command('SAVE' => @args)
}

=head2 shutdown

Synchronously save the dataset to disk and then shut down the server.

=over 4

=item * [NOSAVE|SAVE]

=back

=cut

sub shutdown : method {
    my ($self, @args) = @_;
    $self->execute_command('SHUTDOWN' => @args)
}

=head2 slaveof

Make the server a slave of another instance, or promote it as master.

=over 4

=item * host

=item * port

=back

=cut

sub slaveof : method {
    my ($self, @args) = @_;
    $self->execute_command('SLAVEOF' => @args)
}

=head2 slowlog

Manages the Redis slow queries log.

=over 4

=item * subcommand

=item * [argument]

=back

=cut

sub slowlog : method {
    my ($self, @args) = @_;
    $self->execute_command('SLOWLOG' => @args)
}

=head2 sync

Internal command used for replication.

=cut

sub sync : method {
    my ($self, @args) = @_;
    $self->execute_command('SYNC' => @args)
}

=head2 time

Return the current server time.

=cut

sub time : method {
    my ($self, @args) = @_;
    $self->execute_command('TIME' => @args)
}

=head1 METHODS - Set

=head2 sadd

Add one or more members to a set.

=over 4

=item * key

=item * member [member ...]

=back

=cut

sub sadd : method {
    my ($self, @args) = @_;
    $self->execute_command('SADD' => @args)
}

=head2 scard

Get the number of members in a set.

=over 4

=item * key

=back

=cut

sub scard : method {
    my ($self, @args) = @_;
    $self->execute_command('SCARD' => @args)
}

=head2 sdiff

Subtract multiple sets.

=over 4

=item * key [key ...]

=back

=cut

sub sdiff : method {
    my ($self, @args) = @_;
    $self->execute_command('SDIFF' => @args)
}

=head2 sdiffstore

Subtract multiple sets and store the resulting set in a key.

=over 4

=item * destination

=item * key [key ...]

=back

=cut

sub sdiffstore : method {
    my ($self, @args) = @_;
    $self->execute_command('SDIFFSTORE' => @args)
}

=head2 sinter

Intersect multiple sets.

=over 4

=item * key [key ...]

=back

=cut

sub sinter : method {
    my ($self, @args) = @_;
    $self->execute_command('SINTER' => @args)
}

=head2 sinterstore

Intersect multiple sets and store the resulting set in a key.

=over 4

=item * destination

=item * key [key ...]

=back

=cut

sub sinterstore : method {
    my ($self, @args) = @_;
    $self->execute_command('SINTERSTORE' => @args)
}

=head2 sismember

Determine if a given value is a member of a set.

=over 4

=item * key

=item * member

=back

=cut

sub sismember : method {
    my ($self, @args) = @_;
    $self->execute_command('SISMEMBER' => @args)
}

=head2 smembers

Get all the members in a set.

=over 4

=item * key

=back

=cut

sub smembers : method {
    my ($self, @args) = @_;
    $self->execute_command('SMEMBERS' => @args)
}

=head2 smove

Move a member from one set to another.

=over 4

=item * source

=item * destination

=item * member

=back

=cut

sub smove : method {
    my ($self, @args) = @_;
    $self->execute_command('SMOVE' => @args)
}

=head2 spop

Remove and return one or multiple random members from a set.

=over 4

=item * key

=item * [count]

=back

=cut

sub spop : method {
    my ($self, @args) = @_;
    $self->execute_command('SPOP' => @args)
}

=head2 srandmember

Get one or multiple random members from a set.

=over 4

=item * key

=item * [count]

=back

=cut

sub srandmember : method {
    my ($self, @args) = @_;
    $self->execute_command('SRANDMEMBER' => @args)
}

=head2 srem

Remove one or more members from a set.

=over 4

=item * key

=item * member [member ...]

=back

=cut

sub srem : method {
    my ($self, @args) = @_;
    $self->execute_command('SREM' => @args)
}

=head2 sunion

Add multiple sets.

=over 4

=item * key [key ...]

=back

=cut

sub sunion : method {
    my ($self, @args) = @_;
    $self->execute_command('SUNION' => @args)
}

=head2 sunionstore

Add multiple sets and store the resulting set in a key.

=over 4

=item * destination

=item * key [key ...]

=back

=cut

sub sunionstore : method {
    my ($self, @args) = @_;
    $self->execute_command('SUNIONSTORE' => @args)
}

=head2 sscan

Incrementally iterate Set elements.

=over 4

=item * key

=item * cursor

=item * [MATCH pattern]

=item * [COUNT count]

=back

=cut

sub sscan : method {
    my ($self, @args) = @_;
    $self->execute_command('SSCAN' => @args)
}

=head1 METHODS - Sorted_set

=head2 zadd

Add one or more members to a sorted set, or update its score if it already exists.

=over 4

=item * key

=item * [NX|XX]

=item * [CH]

=item * [INCR]

=item * score member [score member ...]

=back

=cut

sub zadd : method {
    my ($self, @args) = @_;
    $self->execute_command('ZADD' => @args)
}

=head2 zcard

Get the number of members in a sorted set.

=over 4

=item * key

=back

=cut

sub zcard : method {
    my ($self, @args) = @_;
    $self->execute_command('ZCARD' => @args)
}

=head2 zcount

Count the members in a sorted set with scores within the given values.

=over 4

=item * key

=item * min

=item * max

=back

=cut

sub zcount : method {
    my ($self, @args) = @_;
    $self->execute_command('ZCOUNT' => @args)
}

=head2 zincrby

Increment the score of a member in a sorted set.

=over 4

=item * key

=item * increment

=item * member

=back

=cut

sub zincrby : method {
    my ($self, @args) = @_;
    $self->execute_command('ZINCRBY' => @args)
}

=head2 zinterstore

Intersect multiple sorted sets and store the resulting sorted set in a new key.

=over 4

=item * destination

=item * numkeys

=item * key [key ...]

=item * [WEIGHTS weight [weight ...]]

=item * [AGGREGATE SUM|MIN|MAX]

=back

=cut

sub zinterstore : method {
    my ($self, @args) = @_;
    $self->execute_command('ZINTERSTORE' => @args)
}

=head2 zlexcount

Count the number of members in a sorted set between a given lexicographical range.

=over 4

=item * key

=item * min

=item * max

=back

=cut

sub zlexcount : method {
    my ($self, @args) = @_;
    $self->execute_command('ZLEXCOUNT' => @args)
}

=head2 zrange

Return a range of members in a sorted set, by index.

=over 4

=item * key

=item * start

=item * stop

=item * [WITHSCORES]

=back

=cut

sub zrange : method {
    my ($self, @args) = @_;
    $self->execute_command('ZRANGE' => @args)
}

=head2 zrangebylex

Return a range of members in a sorted set, by lexicographical range.

=over 4

=item * key

=item * min

=item * max

=item * [LIMIT offset count]

=back

=cut

sub zrangebylex : method {
    my ($self, @args) = @_;
    $self->execute_command('ZRANGEBYLEX' => @args)
}

=head2 zrevrangebylex

Return a range of members in a sorted set, by lexicographical range, ordered from higher to lower strings..

=over 4

=item * key

=item * max

=item * min

=item * [LIMIT offset count]

=back

=cut

sub zrevrangebylex : method {
    my ($self, @args) = @_;
    $self->execute_command('ZREVRANGEBYLEX' => @args)
}

=head2 zrangebyscore

Return a range of members in a sorted set, by score.

=over 4

=item * key

=item * min

=item * max

=item * [WITHSCORES]

=item * [LIMIT offset count]

=back

=cut

sub zrangebyscore : method {
    my ($self, @args) = @_;
    $self->execute_command('ZRANGEBYSCORE' => @args)
}

=head2 zrank

Determine the index of a member in a sorted set.

=over 4

=item * key

=item * member

=back

=cut

sub zrank : method {
    my ($self, @args) = @_;
    $self->execute_command('ZRANK' => @args)
}

=head2 zrem

Remove one or more members from a sorted set.

=over 4

=item * key

=item * member [member ...]

=back

=cut

sub zrem : method {
    my ($self, @args) = @_;
    $self->execute_command('ZREM' => @args)
}

=head2 zremrangebylex

Remove all members in a sorted set between the given lexicographical range.

=over 4

=item * key

=item * min

=item * max

=back

=cut

sub zremrangebylex : method {
    my ($self, @args) = @_;
    $self->execute_command('ZREMRANGEBYLEX' => @args)
}

=head2 zremrangebyrank

Remove all members in a sorted set within the given indexes.

=over 4

=item * key

=item * start

=item * stop

=back

=cut

sub zremrangebyrank : method {
    my ($self, @args) = @_;
    $self->execute_command('ZREMRANGEBYRANK' => @args)
}

=head2 zremrangebyscore

Remove all members in a sorted set within the given scores.

=over 4

=item * key

=item * min

=item * max

=back

=cut

sub zremrangebyscore : method {
    my ($self, @args) = @_;
    $self->execute_command('ZREMRANGEBYSCORE' => @args)
}

=head2 zrevrange

Return a range of members in a sorted set, by index, with scores ordered from high to low.

=over 4

=item * key

=item * start

=item * stop

=item * [WITHSCORES]

=back

=cut

sub zrevrange : method {
    my ($self, @args) = @_;
    $self->execute_command('ZREVRANGE' => @args)
}

=head2 zrevrangebyscore

Return a range of members in a sorted set, by score, with scores ordered from high to low.

=over 4

=item * key

=item * max

=item * min

=item * [WITHSCORES]

=item * [LIMIT offset count]

=back

=cut

sub zrevrangebyscore : method {
    my ($self, @args) = @_;
    $self->execute_command('ZREVRANGEBYSCORE' => @args)
}

=head2 zrevrank

Determine the index of a member in a sorted set, with scores ordered from high to low.

=over 4

=item * key

=item * member

=back

=cut

sub zrevrank : method {
    my ($self, @args) = @_;
    $self->execute_command('ZREVRANK' => @args)
}

=head2 zscore

Get the score associated with the given member in a sorted set.

=over 4

=item * key

=item * member

=back

=cut

sub zscore : method {
    my ($self, @args) = @_;
    $self->execute_command('ZSCORE' => @args)
}

=head2 zunionstore

Add multiple sorted sets and store the resulting sorted set in a new key.

=over 4

=item * destination

=item * numkeys

=item * key [key ...]

=item * [WEIGHTS weight [weight ...]]

=item * [AGGREGATE SUM|MIN|MAX]

=back

=cut

sub zunionstore : method {
    my ($self, @args) = @_;
    $self->execute_command('ZUNIONSTORE' => @args)
}

=head2 zscan

Incrementally iterate sorted sets elements and associated scores.

=over 4

=item * key

=item * cursor

=item * [MATCH pattern]

=item * [COUNT count]

=back

=cut

sub zscan : method {
    my ($self, @args) = @_;
    $self->execute_command('ZSCAN' => @args)
}

=head1 METHODS - String

=head2 append

Append a value to a key.

=over 4

=item * key

=item * value

=back

=cut

sub append : method {
    my ($self, @args) = @_;
    $self->execute_command('APPEND' => @args)
}

=head2 bitcount

Count set bits in a string.

=over 4

=item * key

=item * [start end]

=back

=cut

sub bitcount : method {
    my ($self, @args) = @_;
    $self->execute_command('BITCOUNT' => @args)
}

=head2 bitfield

Perform arbitrary bitfield integer operations on strings.

=over 4

=item * key

=item * [GET type offset]

=item * [SET type offset value]

=item * [INCRBY type offset increment]

=item * [OVERFLOW WRAP|SAT|FAIL]

=back

=cut

sub bitfield : method {
    my ($self, @args) = @_;
    $self->execute_command('BITFIELD' => @args)
}

=head2 bitop

Perform bitwise operations between strings.

=over 4

=item * operation

=item * destkey

=item * key [key ...]

=back

=cut

sub bitop : method {
    my ($self, @args) = @_;
    $self->execute_command('BITOP' => @args)
}

=head2 bitpos

Find first bit set or clear in a string.

=over 4

=item * key

=item * bit

=item * [start]

=item * [end]

=back

=cut

sub bitpos : method {
    my ($self, @args) = @_;
    $self->execute_command('BITPOS' => @args)
}

=head2 decr

Decrement the integer value of a key by one.

=over 4

=item * key

=back

=cut

sub decr : method {
    my ($self, @args) = @_;
    $self->execute_command('DECR' => @args)
}

=head2 decrby

Decrement the integer value of a key by the given number.

=over 4

=item * key

=item * decrement

=back

=cut

sub decrby : method {
    my ($self, @args) = @_;
    $self->execute_command('DECRBY' => @args)
}

=head2 get

Get the value of a key.

=over 4

=item * key

=back

=cut

sub get : method {
    my ($self, @args) = @_;
    $self->execute_command('GET' => @args)
}

=head2 getbit

Returns the bit value at offset in the string value stored at key.

=over 4

=item * key

=item * offset

=back

=cut

sub getbit : method {
    my ($self, @args) = @_;
    $self->execute_command('GETBIT' => @args)
}

=head2 getrange

Get a substring of the string stored at a key.

=over 4

=item * key

=item * start

=item * end

=back

=cut

sub getrange : method {
    my ($self, @args) = @_;
    $self->execute_command('GETRANGE' => @args)
}

=head2 getset

Set the string value of a key and return its old value.

=over 4

=item * key

=item * value

=back

=cut

sub getset : method {
    my ($self, @args) = @_;
    $self->execute_command('GETSET' => @args)
}

=head2 incr

Increment the integer value of a key by one.

=over 4

=item * key

=back

=cut

sub incr : method {
    my ($self, @args) = @_;
    $self->execute_command('INCR' => @args)
}

=head2 incrby

Increment the integer value of a key by the given amount.

=over 4

=item * key

=item * increment

=back

=cut

sub incrby : method {
    my ($self, @args) = @_;
    $self->execute_command('INCRBY' => @args)
}

=head2 incrbyfloat

Increment the float value of a key by the given amount.

=over 4

=item * key

=item * increment

=back

=cut

sub incrbyfloat : method {
    my ($self, @args) = @_;
    $self->execute_command('INCRBYFLOAT' => @args)
}

=head2 mget

Get the values of all the given keys.

=over 4

=item * key [key ...]

=back

=cut

sub mget : method {
    my ($self, @args) = @_;
    $self->execute_command('MGET' => @args)
}

=head2 mset

Set multiple keys to multiple values.

=over 4

=item * key value [key value ...]

=back

=cut

sub mset : method {
    my ($self, @args) = @_;
    $self->execute_command('MSET' => @args)
}

=head2 msetnx

Set multiple keys to multiple values, only if none of the keys exist.

=over 4

=item * key value [key value ...]

=back

=cut

sub msetnx : method {
    my ($self, @args) = @_;
    $self->execute_command('MSETNX' => @args)
}

=head2 psetex

Set the value and expiration in milliseconds of a key.

=over 4

=item * key

=item * milliseconds

=item * value

=back

=cut

sub psetex : method {
    my ($self, @args) = @_;
    $self->execute_command('PSETEX' => @args)
}

=head2 set

Set the string value of a key.

=over 4

=item * key

=item * value

=item * [EX seconds]

=item * [PX milliseconds]

=item * [NX|XX]

=back

=cut

sub set : method {
    my ($self, @args) = @_;
    $self->execute_command('SET' => @args)
}

=head2 setbit

Sets or clears the bit at offset in the string value stored at key.

=over 4

=item * key

=item * offset

=item * value

=back

=cut

sub setbit : method {
    my ($self, @args) = @_;
    $self->execute_command('SETBIT' => @args)
}

=head2 setex

Set the value and expiration of a key.

=over 4

=item * key

=item * seconds

=item * value

=back

=cut

sub setex : method {
    my ($self, @args) = @_;
    $self->execute_command('SETEX' => @args)
}

=head2 setnx

Set the value of a key, only if the key does not exist.

=over 4

=item * key

=item * value

=back

=cut

sub setnx : method {
    my ($self, @args) = @_;
    $self->execute_command('SETNX' => @args)
}

=head2 setrange

Overwrite part of a string at key starting at the specified offset.

=over 4

=item * key

=item * offset

=item * value

=back

=cut

sub setrange : method {
    my ($self, @args) = @_;
    $self->execute_command('SETRANGE' => @args)
}

=head2 strlen

Get the length of the value stored in a key.

=over 4

=item * key

=back

=cut

sub strlen : method {
    my ($self, @args) = @_;
    $self->execute_command('STRLEN' => @args)
}

=head1 METHODS - Transactions

=head2 discard

Discard all commands issued after MULTI.

=cut

sub discard : method {
    my ($self, @args) = @_;
    $self->execute_command('DISCARD' => @args)
}

=head2 exec

Execute all commands issued after MULTI.

=cut

sub exec : method {
    my ($self, @args) = @_;
    $self->execute_command('EXEC' => @args)
}

=head2 multi

Mark the start of a transaction block.

=cut

sub multi : method {
    my ($self, @args) = @_;
    $self->execute_command('MULTI' => @args)
}

=head2 unwatch

Forget about all watched keys.

=cut

sub unwatch : method {
    my ($self, @args) = @_;
    $self->execute_command('UNWATCH' => @args)
}

=head2 watch

Watch the given keys to determine execution of the MULTI/EXEC block.

=over 4

=item * key [key ...]

=back

=cut

sub watch : method {
    my ($self, @args) = @_;
    $self->execute_command('WATCH' => @args)
}


1;

__END__

=head1 AUTHOR

Tom Molesworth <TEAM@cpan.org>

=head1 LICENSE

Copyright Tom Molesworth 2015-2017. Licensed under the same terms as Perl itself.

