# Generated by default/object.tt
package Paws::LocationService::BatchDeleteGeofenceError;
  use Moose;
  has Error => (is => 'ro', isa => 'Paws::LocationService::BatchItemError', required => 1);
  has GeofenceId => (is => 'ro', isa => 'Str', required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::LocationService::BatchDeleteGeofenceError

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::LocationService::BatchDeleteGeofenceError object:

  $service_obj->Method(Att1 => { Error => $value, ..., GeofenceId => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::LocationService::BatchDeleteGeofenceError object:

  $result = $service_obj->Method(...);
  $result->Att1->Error

=head1 DESCRIPTION

Contains error details for each geofence that failed to delete from the
geofence collection.

=head1 ATTRIBUTES


=head2 B<REQUIRED> Error => L<Paws::LocationService::BatchItemError>

Contains details associated to the batch error.


=head2 B<REQUIRED> GeofenceId => Str

The geofence associated with the error message.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::LocationService>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

