# Generated by default/object.tt
package Paws::SMS::ServerReplicationParameters;
  use Moose;
  has Encrypted => (is => 'ro', isa => 'Bool', request_name => 'encrypted', traits => ['NameInRequest']);
  has Frequency => (is => 'ro', isa => 'Int', request_name => 'frequency', traits => ['NameInRequest']);
  has KmsKeyId => (is => 'ro', isa => 'Str', request_name => 'kmsKeyId', traits => ['NameInRequest']);
  has LicenseType => (is => 'ro', isa => 'Str', request_name => 'licenseType', traits => ['NameInRequest']);
  has NumberOfRecentAmisToKeep => (is => 'ro', isa => 'Int', request_name => 'numberOfRecentAmisToKeep', traits => ['NameInRequest']);
  has RunOnce => (is => 'ro', isa => 'Bool', request_name => 'runOnce', traits => ['NameInRequest']);
  has SeedTime => (is => 'ro', isa => 'Str', request_name => 'seedTime', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::SMS::ServerReplicationParameters

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::SMS::ServerReplicationParameters object:

  $service_obj->Method(Att1 => { Encrypted => $value, ..., SeedTime => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::SMS::ServerReplicationParameters object:

  $result = $service_obj->Method(...);
  $result->Att1->Encrypted

=head1 DESCRIPTION

The replication parameters for replicating a server.

=head1 ATTRIBUTES


=head2 Encrypted => Bool

Indicates whether the replication job produces encrypted AMIs.


=head2 Frequency => Int

The frequency of creating replication jobs for the server.


=head2 KmsKeyId => Str

The ID of the KMS key for replication jobs that produce encrypted AMIs.
This value can be any of the following:

=over

=item *

KMS key ID

=item *

KMS key alias

=item *

ARN referring to the KMS key ID

=item *

ARN referring to the KMS key alias

=back

If encrypted is enabled but a KMS key ID is not specified, the
customer's default KMS key for Amazon EBS is used.


=head2 LicenseType => Str

The license type for creating a replication job for the server.


=head2 NumberOfRecentAmisToKeep => Int

The number of recent AMIs to keep when creating a replication job for
this server.


=head2 RunOnce => Bool

Indicates whether to run the replication job one time.


=head2 SeedTime => Str

The seed time for creating a replication job for the server.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::SMS>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

