# Generated by default/object.tt
package Paws::SSMContacts::ContactChannel;
  use Moose;
  has ActivationStatus => (is => 'ro', isa => 'Str', required => 1);
  has ContactArn => (is => 'ro', isa => 'Str', required => 1);
  has ContactChannelArn => (is => 'ro', isa => 'Str', required => 1);
  has DeliveryAddress => (is => 'ro', isa => 'Paws::SSMContacts::ContactChannelAddress', required => 1);
  has Name => (is => 'ro', isa => 'Str', required => 1);
  has Type => (is => 'ro', isa => 'Str');

1;

### main pod documentation begin ###

=head1 NAME

Paws::SSMContacts::ContactChannel

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::SSMContacts::ContactChannel object:

  $service_obj->Method(Att1 => { ActivationStatus => $value, ..., Type => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::SSMContacts::ContactChannel object:

  $result = $service_obj->Method(...);
  $result->Att1->ActivationStatus

=head1 DESCRIPTION

The method that Incident Manager uses to engage a contact.

=head1 ATTRIBUTES


=head2 B<REQUIRED> ActivationStatus => Str

A Boolean value describing if the contact channel has been activated or
not. If the contact channel isn't activated, Incident Manager can't
engage the contact through it.


=head2 B<REQUIRED> ContactArn => Str

The ARN of the contact that contains the contact channel.


=head2 B<REQUIRED> ContactChannelArn => Str

The Amazon Resource Name (ARN) of the contact channel.


=head2 B<REQUIRED> DeliveryAddress => L<Paws::SSMContacts::ContactChannelAddress>

The details that Incident Manager uses when trying to engage the
contact channel.


=head2 B<REQUIRED> Name => Str

The name of the contact channel.


=head2 Type => Str

The type of the contact channel. Incident Manager supports three
contact methods:

=over

=item *

SMS

=item *

VOICE

=item *

EMAIL

=back




=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::SSMContacts>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

