/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.services.classfile;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.derby.iapi.services.io.AccessibleByteArrayOutputStream;

public final class ClassFormatOutput
extends DataOutputStream {
    public ClassFormatOutput() {
        this(512);
    }

    public ClassFormatOutput(int n) {
        super(new AccessibleByteArrayOutputStream(n));
    }

    public void putU1(int n) throws IOException {
        if (n > 255) {
            ClassFormatOutput.limit("U1", 255, n);
        }
        this.write(n);
    }

    public void putU2(int n) throws IOException {
        this.putU2("U2", n);
    }

    public void putU2(String string, int n) throws IOException {
        if (n > 65535) {
            ClassFormatOutput.limit(string, 65535, n);
        }
        this.write(n >> 8);
        this.write(n);
    }

    public void putU4(int n) throws IOException {
        this.writeInt(n);
    }

    public void writeTo(OutputStream outputStream) throws IOException {
        ((AccessibleByteArrayOutputStream)this.out).writeTo(outputStream);
    }

    public byte[] getData() {
        return ((AccessibleByteArrayOutputStream)this.out).getInternalByteArray();
    }

    static void limit(String string, int n, int n2) throws IOException {
        throw new IOException(string + "(" + n2 + " > " + n + ")");
    }
}

