/*
 * Decompiled with CFR 0.152.
 */
package thredds.catalog;

import java.io.IOException;
import java.net.URI;
import java.util.Formatter;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.catalog.InvCatalogImpl;
import thredds.catalog.InvCatalogRef;
import thredds.catalog.InvDatasetFeatureCollection;
import thredds.catalog.InvDatasetImpl;
import thredds.catalog.InvService;
import thredds.catalog.ServiceType;
import thredds.catalog.ThreddsMetadata;
import thredds.featurecollection.FeatureCollectionConfig;
import thredds.featurecollection.FeatureCollectionType;
import thredds.inventory.CollectionUpdateType;
import ucar.nc2.Attribute;
import ucar.nc2.ft.FeatureDataset;
import ucar.nc2.ft.FeatureDatasetPoint;
import ucar.nc2.ft.point.PointDatasetImpl;
import ucar.nc2.ft.point.collection.CompositeDatasetFactory;
import ucar.nc2.ft.point.collection.UpdateableCollection;
import ucar.nc2.thredds.MetadataExtractor;
import ucar.nc2.thredds.MetadataExtractorAcdd;
import ucar.unidata.util.StringUtil2;

public class InvDatasetFcPoint
extends InvDatasetFeatureCollection {
    private static final Logger logger = LoggerFactory.getLogger(InvDatasetFcPoint.class);
    private static final String FC = "fc.cdmr";
    private static final InvService collectionService = new InvService("collectionService", ServiceType.COMPOUND.toString(), "", "", "");
    private final FeatureDatasetPoint fd;
    private final Set<FeatureCollectionConfig.PointDatasetType> wantDatasets;

    InvDatasetFcPoint(InvDatasetImpl parent, String name, String path, FeatureCollectionType fcType, FeatureCollectionConfig config) {
        super(parent, name, path, fcType, config);
        this.makeCollection();
        Formatter errlog = new Formatter();
        try {
            this.fd = (FeatureDatasetPoint)CompositeDatasetFactory.factory(name, fcType.getFeatureType(), this.datasetCollection, errlog);
        }
        catch (Exception e) {
            if (e.getCause() != null) {
                throw new RuntimeException("Failed to create InvDatasetFcPoint, cause=", e.getCause());
            }
            throw new RuntimeException("Failed to create InvDatasetFcPoint", e);
        }
        this.state = new InvDatasetFeatureCollection.State(this, null);
        this.wantDatasets = config.pointConfig.datasets;
    }

    @Override
    public void finishConstruction() {
        super.finishConstruction();
        this.finish();
        ThreddsMetadata tmi = this.getLocalMetadataInheritable();
        MetadataExtractorAcdd acdd = new MetadataExtractorAcdd(Attribute.makeMap(this.fd.getGlobalAttributes()), this, tmi);
        acdd.extract();
        this.finish();
        if (this.fd.getBoundingBox() == null) {
            ThreddsMetadata.GeospatialCoverage coverage = this.getGeospatialCoverage();
            if (coverage != null) {
                ((PointDatasetImpl)this.fd).setBoundingBox(coverage.getBoundingBox());
            }
        } else if (this.getGeospatialCoverage() == null) {
            tmi.setGeospatialCoverage(MetadataExtractor.extractGeospatial(this.fd));
        }
        tmi.addVariables(MetadataExtractor.extractVariables(this.fd));
        this.finish();
    }

    @Override
    public FeatureDataset getFeatureDataset() {
        return this.fd;
    }

    @Override
    public void updateCollection(InvDatasetFeatureCollection.State localState, CollectionUpdateType force) {
        try {
            ((UpdateableCollection)((Object)this.fd)).update();
        }
        catch (IOException e) {
            logger.error("update failed", e);
        }
        if (this.fd.getCalendarDateRange() != null) {
            localState.dateRange = this.fd.getCalendarDateRange();
        } else if (this.getTimeCoverage() != null) {
            localState.dateRange = this.getCalendarDateCoverage();
        }
    }

    @Override
    public void updateProto() {
    }

    @Override
    public InvCatalogImpl makeCatalog(String match, String orgPath, URI catURI) {
        logger.debug("FcPoint make catalog for " + match + " " + catURI);
        InvDatasetFeatureCollection.State localState = this.checkState();
        try {
            if (match == null || match.length() == 0) {
                InvCatalogImpl main = this.makeCatalogTop(catURI, localState);
                main.addService(collectionService);
                main.getDataset().getLocalMetadataInheritable().setServiceName(collectionService.getName());
                main.finish();
                return main;
            }
            if (match.startsWith("files") && this.wantDatasets.contains((Object)FeatureCollectionConfig.PointDatasetType.Files)) {
                return this.makeCatalogFiles(catURI, localState, this.datasetCollection.getFilenames(), true);
            }
        }
        catch (Exception e) {
            logger.error("Error making catalog for " + this.path, e);
        }
        return null;
    }

    @Override
    protected void makeDatasetTop(InvDatasetFeatureCollection.State localState) {
        String id;
        InvDatasetImpl top = new InvDatasetImpl(this);
        top.setParent(null);
        InvDatasetImpl parent = (InvDatasetImpl)this.getParent();
        if (parent != null) {
            top.transferMetadata(parent, true);
        }
        if ((id = this.getID()) == null) {
            id = this.getPath();
        }
        ThreddsMetadata tmi = top.getLocalMetadataInheritable();
        if (localState.dateRange != null) {
            tmi.setTimeCoverage(localState.dateRange);
        }
        if (this.wantDatasets.contains((Object)FeatureCollectionConfig.PointDatasetType.cdmrFeature)) {
            InvDatasetImpl ds = new InvDatasetImpl(this, "Feature Collection");
            String name = this.getName() + "_" + FC;
            name = StringUtil2.replace(name, ' ', "_");
            ds.setUrlPath(this.path + "/" + name);
            ds.setID(id + "/" + name);
            ThreddsMetadata tm = ds.getLocalMetadata();
            ds.getLocalMetadataInheritable().setServiceName(collectionService.getName());
            ds.finish();
            top.addDataset(ds);
        }
        if (this.wantDatasets.contains((Object)FeatureCollectionConfig.PointDatasetType.Files) && this.topDirectory != null) {
            InvCatalogRef filesCat = new InvCatalogRef(this, "files", this.getCatalogHref("files"));
            filesCat.finish();
            top.addDataset(filesCat);
        }
        localState.top = top;
        this.finish();
    }

    static {
        collectionService.addService(InvService.ncss);
    }
}

