/*
 * Decompiled with CFR 0.152.
 */
package opennlp.grok.preprocess.tokenize;

import java.io.BufferedReader;
import java.io.Reader;
import java.util.ArrayList;
import opennlp.common.util.ObjectIntPair;
import opennlp.common.util.PerlHelp;
import opennlp.grok.preprocess.tokenize.TokContextGenerator;
import opennlp.maxent.ContextGenerator;
import opennlp.maxent.Event;
import opennlp.maxent.EventCollector;

public class TokEventCollector
implements EventCollector {
    private static final ContextGenerator cg = new TokContextGenerator();
    private BufferedReader br;

    public TokEventCollector(Reader data) {
        this.br = new BufferedReader(data);
    }

    public Event[] getEvents() {
        ArrayList<Event> elist = new ArrayList<Event>();
        try {
            String s = this.br.readLine();
            while (s != null) {
                String[] spaceToks = PerlHelp.split((String)s);
                int tok = 0;
                while (tok < spaceToks.length) {
                    StringBuffer sb = new StringBuffer(spaceToks[tok]);
                    if (!PerlHelp.isAlphanumeric((String)spaceToks[tok])) {
                        int lastIndex = sb.length() - 1;
                        int id = 0;
                        while (id < sb.length()) {
                            String[] context = cg.getContext((Object)new ObjectIntPair((Object)sb, id));
                            if (id == lastIndex) {
                                elist.add(new Event("T", context));
                            } else {
                                elist.add(new Event("F", context));
                            }
                            ++id;
                        }
                    }
                    ++tok;
                }
                s = this.br.readLine();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Event[] events = new Event[elist.size()];
        elist.toArray(events);
        return events;
    }

    public Event[] getEvents(boolean evalMode) {
        return this.getEvents();
    }
}

