/*
 * Decompiled with CFR 0.152.
 */
package gnu.trove;

import gnu.trove.THashIterator;
import gnu.trove.THashMap;
import gnu.trove.TObjectFunction;
import gnu.trove.TObjectHash;
import gnu.trove.TObjectHashIterator;
import gnu.trove.TObjectObjectProcedure;
import gnu.trove.TObjectProcedure;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class THashMap
extends TObjectHash
implements Map,
Serializable {
    protected transient Object[] _values;

    protected int setUp(int initialCapacity) {
        int capacity = super.setUp(initialCapacity);
        this._values = new Object[capacity];
        return capacity;
    }

    public Object put(Object key, Object value) {
        if (key == null) {
            throw new NullPointerException("null keys not supported");
        }
        Object previous = null;
        Object oldKey = null;
        int index = this.insertionIndex(key);
        if (index < 0) {
            index = -index - 1;
            previous = this._values[index];
        }
        oldKey = this._set[index];
        this._set[index] = key;
        this._values[index] = value;
        if (previous == null) {
            this.postInsertHook(oldKey == null);
        }
        return previous;
    }

    public boolean equals(Object other) {
        if (!(other instanceof Map)) {
            return false;
        }
        Map that = (Map)other;
        if (that.size() != this.size()) {
            return false;
        }
        return this.forEachEntry(new EqProcedure(that));
    }

    public boolean forEachKey(TObjectProcedure procedure) {
        return this.forEach(procedure);
    }

    public boolean forEachValue(TObjectProcedure procedure) {
        Object[] values = this._values;
        Object[] set = this._set;
        int i = values.length;
        while (i-- > 0) {
            if (set[i] == null || set[i] == TObjectHash.REMOVED || procedure.execute(values[i])) continue;
            return false;
        }
        return true;
    }

    public void transformValues(TObjectFunction function) {
        Object[] values = this._values;
        Object[] set = this._set;
        int i = values.length;
        while (i-- > 0) {
            if (set[i] == null || set[i] == TObjectHash.REMOVED) continue;
            values[i] = function.execute(values[i]);
        }
    }

    public boolean forEachEntry(TObjectObjectProcedure procedure) {
        Object[] keys = this._set;
        Object[] values = this._values;
        int i = keys.length;
        while (i-- > 0) {
            if (keys[i] == null || keys[i] == TObjectHash.REMOVED || procedure.execute(keys[i], values[i])) continue;
            return false;
        }
        return true;
    }

    protected void rehash(int newCapacity) {
        int oldCapacity = this._set.length;
        Object[] oldKeys = this._set;
        Object[] oldVals = this._values;
        this._set = new Object[newCapacity];
        this._values = new Object[newCapacity];
        int i = oldCapacity;
        while (i-- > 0) {
            if (oldKeys[i] == null || oldKeys[i] == TObjectHash.REMOVED) continue;
            Object o = oldKeys[i];
            int index = this.insertionIndex(o);
            this._set[index] = o;
            this._values[index] = oldVals[i];
        }
    }

    public Object get(Object key) {
        int index = this.index(key);
        return index < 0 ? null : this._values[index];
    }

    public void clear() {
        super.clear();
        Object[] keys = this._set;
        Object[] vals = this._values;
        int i = keys.length;
        while (i-- > 0) {
            keys[i] = null;
            vals[i] = null;
        }
    }

    public Object remove(Object key) {
        Object prev = null;
        int index = this.index(key);
        if (index >= 0) {
            prev = this._values[index];
            this.removeAt(index);
        }
        return prev;
    }

    protected void removeAt(int index) {
        super.removeAt(index);
        this._values[index] = null;
    }

    public Collection values() {
        return new ValueView(this);
    }

    public Set keySet() {
        return new KeyView();
    }

    public Set entrySet() {
        return new EntryView(this);
    }

    public boolean containsValue(Object val) {
        Object[] set = this._set;
        Object[] vals = this._values;
        if (val == null) {
            int i = vals.length;
            while (i-- > 0) {
                if (set[i] == null || set[i] == TObjectHash.REMOVED || val != vals[i]) continue;
                return true;
            }
        } else {
            int i = vals.length;
            while (i-- > 0) {
                if (set[i] == null || set[i] == TObjectHash.REMOVED || val != vals[i] && !val.equals(vals[i])) continue;
                return true;
            }
        }
        return false;
    }

    public boolean containsKey(Object key) {
        return this.contains(key);
    }

    public void putAll(Map map) {
        this.ensureCapacity(map.size());
        Iterator i = map.entrySet().iterator();
        while (i.hasNext()) {
            Entry e = (Entry)i.next();
            this.put(e.getKey(), e.getValue());
        }
    }

    private final void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
        stream.writeInt(this._size);
        class WriteProcedure
        implements TObjectObjectProcedure {
            IOException e;
            private final /* synthetic */ THashMap this$0;
            private final /* synthetic */ ObjectOutputStream val$stream;

            public boolean execute(Object key, Object value) {
                try {
                    this.val$stream.writeObject(key);
                    this.val$stream.writeObject(value);
                }
                catch (IOException ioe) {
                    this.e = ioe;
                    return false;
                }
                return true;
            }

            /* synthetic */ WriteProcedure(THashMap this$0, ObjectOutputStream val$stream) {
                this.val$stream = val$stream;
                this.this$0 = this$0;
                this.constructor$0(this$0);
            }

            private final void constructor$0(THashMap tHashMap) {
            }
        }
        WriteProcedure writeProcedure = new WriteProcedure(this, stream);
        if (!this.forEachEntry(writeProcedure)) {
            throw writeProcedure.e;
        }
    }

    private final void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        int size = stream.readInt();
        this.setUp(size);
        while (size-- > 0) {
            Object key = stream.readObject();
            Object val = stream.readObject();
            this.put(key, val);
        }
    }

    public THashMap() {
    }

    public THashMap(int initialCapacity) {
        super(initialCapacity);
    }

    public THashMap(int initialCapacity, float loadFactor) {
        super(initialCapacity, loadFactor);
    }

    public THashMap(Map map) {
        this(map.size());
        this.putAll(map);
    }

    private static final class EqProcedure
    implements TObjectObjectProcedure {
        private final Map _otherMap;

        public final boolean execute(Object key, Object value) {
            Object oValue = this._otherMap.get(key);
            return oValue == value || oValue != null && oValue.equals(value);
        }

        EqProcedure(Map otherMap) {
            this._otherMap = otherMap;
        }
    }

    protected class KeyView
    implements Set {
        public Iterator iterator() {
            return new TObjectHashIterator(THashMap.this);
        }

        public boolean remove(Object key) {
            return THashMap.this.remove(key) != null;
        }

        public boolean contains(Object key) {
            return THashMap.this.contains(key);
        }

        public boolean containsAll(Collection collection) {
            Iterator i = collection.iterator();
            while (i.hasNext()) {
                if (this.contains(i.next())) continue;
                return false;
            }
            return true;
        }

        public boolean removeAll(Collection collection) {
            boolean changed = false;
            Iterator i = collection.iterator();
            while (i.hasNext()) {
                if (!this.remove(i.next())) continue;
                changed = true;
            }
            return changed;
        }

        public void clear() {
            THashMap.this.clear();
        }

        public boolean add(Object obj) {
            throw new UnsupportedOperationException();
        }

        public int size() {
            return THashMap.this.size();
        }

        public Object[] toArray() {
            Object[] result = new Object[this.size()];
            Iterator e = this.iterator();
            int i = 0;
            while (e.hasNext()) {
                result[i] = e.next();
                ++i;
            }
            return result;
        }

        public Object[] toArray(Object[] a) {
            int size = this.size();
            if (a.length < size) {
                a = (Object[])Array.newInstance(a.getClass().getComponentType(), size);
            }
            Iterator it = this.iterator();
            int i = 0;
            while (i < size) {
                a[i] = it.next();
                ++i;
            }
            if (a.length > size) {
                a[size] = null;
            }
            return a;
        }

        public boolean isEmpty() {
            return THashMap.this.isEmpty();
        }

        public boolean addAll(Collection collection) {
            throw new UnsupportedOperationException();
        }

        public boolean retainAll(Collection collection) {
            boolean changed = false;
            Iterator i = this.iterator();
            while (i.hasNext()) {
                if (collection.contains(i.next())) continue;
                i.remove();
                changed = true;
            }
            return changed;
        }

        KeyView() {
        }

        protected final class EntryIterator
        extends THashIterator {
            private final /* synthetic */ THashMap this$1;

            public final Object objectAtIndex(int index) {
                THashMap tHashMap = this.this$1;
                if (tHashMap == null) {
                    throw null;
                }
                return tHashMap.new Entry(this.this$1._set[index], this.this$1._values[index], index);
            }

            EntryIterator(THashMap map) {
                super(map);
                this.this$1 = THashMap.this;
            }
        }
    }

    protected class ValueView
    extends KeyView {
        private final /* synthetic */ THashMap this$0;

        public Iterator iterator() {
            return new THashIterator(this, this.this$0){
                private final /* synthetic */ ValueView this$0;
                private final /* synthetic */ THashMap this$1;

                protected final Object objectAtIndex(int index) {
                    return this.this$1._values[index];
                }
                {
                    this.this$0 = this$0;
                    this.this$1 = ValueView.access$0(this.this$0);
                    this.constructor$0(this$0, hash);
                }

                private final void constructor$0(ValueView valueView, TObjectHash hash) {
                }
            };
        }

        public boolean contains(Object value) {
            return this.this$0.containsValue(value);
        }

        public boolean remove(Object value) {
            boolean changed = false;
            Object[] values = this.this$0._values;
            Object[] set = this.this$0._set;
            int i = values.length;
            while (i-- > 0) {
                if ((set[i] == null || set[i] == TObjectHash.REMOVED || value != values[i]) && (values[i] == null || !values[i].equals(value))) continue;
                this.this$0.removeAt(i);
                changed = true;
            }
            return changed;
        }

        static /* synthetic */ THashMap access$0(ValueView valueView) {
            return valueView.this$0;
        }

        ValueView(THashMap tHashMap) {
            THashMap tHashMap2 = tHashMap;
            if (tHashMap2 == null) {
                throw null;
            }
            this.this$0 = tHashMap;
        }
    }

    protected class EntryView
    extends KeyView {
        private final /* synthetic */ THashMap this$0;

        public Iterator iterator() {
            EntryView entryView = this;
            if (entryView == null) {
                throw null;
            }
            return entryView.new KeyView.EntryIterator(this.this$0);
        }

        public boolean remove(Object entry) {
            Object val;
            Object key = this.keyForEntry(entry);
            int index = this.this$0.index(key);
            if (index >= 0 && ((val = this.valueForEntry(entry)) == this.this$0._values[index] || val != null && val.equals(this.this$0._values[index]))) {
                this.this$0.removeAt(index);
                return true;
            }
            return false;
        }

        public boolean contains(Object entry) {
            Object val = this.this$0.get(this.keyForEntry(entry));
            Object entryValue = ((Map.Entry)entry).getValue();
            return entryValue == val || val != null && val.equals(entryValue);
        }

        protected Object valueForEntry(Object entry) {
            return ((Map.Entry)entry).getValue();
        }

        protected Object keyForEntry(Object entry) {
            return ((Map.Entry)entry).getKey();
        }

        EntryView(THashMap tHashMap) {
            THashMap tHashMap2 = tHashMap;
            if (tHashMap2 == null) {
                throw null;
            }
            this.this$0 = tHashMap;
        }
    }

    final class Entry
    implements Map.Entry {
        private final Object key;
        private Object val;
        private final int index;

        public final Object getKey() {
            return this.key;
        }

        public final Object getValue() {
            return this.val;
        }

        public final Object setValue(Object o) {
            if (THashMap.this._values[this.index] != this.val) {
                throw new ConcurrentModificationException();
            }
            THashMap.this._values[this.index] = o;
            this.val = o = this.val;
            return o;
        }

        Entry(Object key, Object value, int index) {
            this.key = key;
            this.val = value;
            this.index = index;
        }
    }
}

