/*
 * Decompiled with CFR 0.152.
 */
package org.maltparser.parser;

import org.maltparser.core.exception.MaltChainedException;
import org.maltparser.core.syntaxgraph.DependencyStructure;
import org.maltparser.parser.Algorithm;
import org.maltparser.parser.DependencyParserConfig;
import org.maltparser.parser.SingleMalt;
import org.maltparser.parser.Trainer;
import org.maltparser.parser.guide.ClassifierGuide;
import org.maltparser.parser.guide.OracleGuide;
import org.maltparser.parser.guide.SingleGuide;
import org.maltparser.parser.history.GuideHistory;
import org.maltparser.parser.history.action.GuideDecision;
import org.maltparser.parser.history.action.GuideUserAction;

public class BatchTrainer
extends Trainer {
    private OracleGuide oracleGuide;
    private int parseCount;

    public BatchTrainer(DependencyParserConfig manager) throws MaltChainedException {
        super(manager);
        ((SingleMalt)manager).addRegistry(Algorithm.class, this);
        this.setManager(manager);
        this.initParserState(1);
        this.setGuide(new SingleGuide(manager, (GuideHistory)((Object)this.parserState.getHistory()), ClassifierGuide.GuideMode.BATCH));
        this.oracleGuide = this.parserState.getFactory().makeOracleGuide(this.parserState.getHistory());
    }

    public DependencyStructure parse(DependencyStructure goldDependencyGraph, DependencyStructure parseDependencyGraph) throws MaltChainedException {
        this.parserState.clear();
        this.parserState.initialize(parseDependencyGraph);
        this.currentParserConfiguration = this.parserState.getConfiguration();
        ++this.parseCount;
        if (this.diagnostics) {
            this.writeToDiaFile(this.parseCount + "");
        }
        while (!this.parserState.isTerminalState()) {
            GuideUserAction action = this.parserState.getTransitionSystem().getDeterministicAction(this.parserState.getHistory(), this.currentParserConfiguration);
            if (action == null) {
                action = this.oracleGuide.predict(goldDependencyGraph, this.currentParserConfiguration);
                try {
                    this.classifierGuide.addInstance((GuideDecision)((Object)action));
                }
                catch (NullPointerException e) {
                    throw new MaltChainedException("The guide cannot be found. ", e);
                }
            } else if (this.diagnostics) {
                this.writeToDiaFile(" *");
            }
            if (this.diagnostics) {
                this.writeToDiaFile(" " + this.parserState.getTransitionSystem().getActionString(action));
            }
            this.parserState.apply(action);
        }
        this.copyEdges(this.currentParserConfiguration.getDependencyGraph(), parseDependencyGraph);
        parseDependencyGraph.linkAllTreesToRoot();
        this.oracleGuide.finalizeSentence(parseDependencyGraph);
        if (this.diagnostics) {
            this.writeToDiaFile("\n");
        }
        return parseDependencyGraph;
    }

    public OracleGuide getOracleGuide() {
        return this.oracleGuide;
    }

    public void train() throws MaltChainedException {
    }

    public void terminate() throws MaltChainedException {
        if (this.diagnostics) {
            this.closeDiaWriter();
        }
    }
}

