#!/usr/bin/env perl
use strict;
use warnings;

use Test::More;
use Math::Prime::Util qw/nth_prime/;

my %nthvals = (
                   1 =>                    2,
                   2 =>                    3,
                   4 =>                    7,
                   8 =>                   19,
                  16 =>                   53,
                  32 =>                  131,
                  64 =>                  311,
                 128 =>                  719,
                 256 =>                 1619,
                 512 =>                 3671,
                1024 =>                 8161,
                2048 =>                17863,
                4096 =>                38873,
                8192 =>                84017,
               16384 =>               180503,
               32768 =>               386093,
               65536 =>               821641,
              131072 =>              1742537,
              262144 =>              3681131,
              524288 =>              7754077,
             1048576 =>             16290047,
             2097152 =>             34136029,
             4194304 =>             71378569,
             8388608 =>            148948139,
            16777216 =>            310248241,
            33554432 =>            645155197,
            67108864 =>           1339484197,
           134217728 =>           2777105129,
           268435456 =>           5750079047,
           536870912 =>          11891268401,
          1073741824 =>          24563311309,
          2147483648 =>          50685770167,
          4294967296 =>         104484802057,
          8589934592 =>         215187847711,
         17179869184 =>         442795487221,
         34359738368 =>         910399916939,
         68719476736 =>        1870358526653,
        137438953472 =>        3839726846311,
        274877906944 =>        7877263558621,
        549755813888 =>       16149760533341,
       1099511627776 =>       33089240375501,
       2199023255552 =>       67756520645329,
       4398046511104 =>      138666449011757,
       8796093022208 =>      283634652716357,
      17592186044416 =>      579863159340527,
      35184372088832 =>     1184895616861903,
      70368744177664 =>     2420094683001859,
     140737488355328 =>     4940729268330643,
     281474976710656 =>    10082409897709157,
     562949953421312 =>    20566476729238691,
    1125899906842624 =>    41935796950796653,
    2251799813685248 =>    85476377250109733,
    4503599627370496 =>   174160587542317721,
    9007199254740992 =>   354733509412061993,
   18014398509481984 =>   722285281729443799,
   36028797018963968 =>  1470194760556507397,
   72057594037927936 =>  2991614170035124397,
                  10 =>                   29,
                 100 =>                  541,
                1000 =>                 7919,
               10000 =>               104729,
              100000 =>              1299709,
             1000000 =>             15485863,
            10000000 =>            179424673,
           100000000 =>           2038074743,
          1000000000 =>          22801763489,
         10000000000 =>         252097800623,
        100000000000 =>        2760727302517,
       1000000000000 =>       29996224275833,
      10000000000000 =>      323780508946331,
     100000000000000 =>     3475385758524527,
    1000000000000000 =>    37124508045065437,
   10000000000000000 =>   394906913903735329,
  100000000000000000 =>  4185296581467695669,
#  1000000000000000000 => 44211790234832169331,
# 10000000000000000000 => 465675465116607065549,
);

# Keep things to a reasonable run time, assuming using LMO nth_prime.
# Using LMOS or Lehmer, this will take a very long time.  Using a normal
# sieve method will need a much, much lower limit.
delete @nthvals{ grep { $_ > 100_000_000_000_000 } keys %nthvals };

plan tests => scalar(keys %nthvals);

foreach my $n (sort {$a <=> $b} keys %nthvals) {
  my $nth = $nthvals{$n};
  is( nth_prime($n), $nth, "Prime($n) = $nth" );
}
