# This Makefile.PL for Git-Wrapper was generated by
# inc::CheckGitConfig <self>
# and Dist::Zilla::Plugin::MakeMaker::Awesome 0.38.
# Don't edit it but the dist.ini and plugins used to construct it.

use strict;
use warnings;

# inserted by Dist::Zilla::Plugin::CheckBin 0.007
use Devel::CheckBin;
check_bin('git');

require File::Spec;
die 'git seems broken; maybe check your HOME environment variable?'
    if system('git config --list >'.File::Spec->devnull);

use ExtUtils::MakeMaker;

my %WriteMakefileArgs = (
  "ABSTRACT" => "Wrap git(7) command-line interface",
  "AUTHOR" => "Hans Dieter Pearcey <hdp\@cpan.org>, Chris Prather <chris\@prather.org>, John SJ Anderson <genehack\@genehack.org>",
  "CONFIGURE_REQUIRES" => {
    "Devel::CheckBin" => 0,
    "ExtUtils::MakeMaker" => 0,
    "File::Spec" => 0
  },
  "DISTNAME" => "Git-Wrapper",
  "LICENSE" => "perl",
  "NAME" => "Git::Wrapper",
  "PREREQ_PM" => {
    "File::Temp" => 0,
    "File::chdir" => 0,
    "IPC::Cmd" => 0,
    "IPC::Open3" => 0,
    "Scalar::Util" => 0,
    "Sort::Versions" => 0,
    "Symbol" => 0,
    "overload" => 0,
    "strict" => 0,
    "warnings" => 0
  },
  "TEST_REQUIRES" => {
    "File::Path" => 0,
    "File::Spec" => 0,
    "File::Temp" => 0,
    "IO::File" => 0,
    "POSIX" => 0,
    "Sort::Versions" => 0,
    "Test::Deep" => 0,
    "Test::Exception" => 0,
    "Test::More" => 0
  },
  "VERSION" => "0.045_090",
  "test" => {
    "TESTS" => "t/*.t"
  }
);

my %FallbackPrereqs = (
  "File::Path" => 0,
  "File::Spec" => 0,
  "File::Temp" => 0,
  "File::chdir" => 0,
  "IO::File" => 0,
  "IPC::Cmd" => 0,
  "IPC::Open3" => 0,
  "POSIX" => 0,
  "Scalar::Util" => 0,
  "Sort::Versions" => 0,
  "Symbol" => 0,
  "Test::Deep" => 0,
  "Test::Exception" => 0,
  "Test::More" => 0,
  "overload" => 0,
  "strict" => 0,
  "warnings" => 0
);

unless ( eval { ExtUtils::MakeMaker->VERSION(6.63_03) } ) {
  delete $WriteMakefileArgs{TEST_REQUIRES};
  delete $WriteMakefileArgs{BUILD_REQUIRES};
  $WriteMakefileArgs{PREREQ_PM} = \%FallbackPrereqs;
}

delete $WriteMakefileArgs{CONFIGURE_REQUIRES}
  unless eval { ExtUtils::MakeMaker->VERSION(6.52) };

WriteMakefile(%WriteMakefileArgs);
