package Net::Async::Spotify::Object::Generated::Device;

use strict;
use warnings;

our $VERSION = '0.001'; # VERSION
our $AUTHORITY = 'cpan:VNEALV'; # AUTHORITY

use mro;
use parent qw(Net::Async::Spotify::Object::Base);

=encoding utf8

=head1 NAME

Net::Async::Spotify::Object::Generated::Device - Package representing Spotify Device Object

=head1 DESCRIPTION

Autogenerated module.
Based on https://developer.spotify.com/documentation/web-api/reference/#objects-index
Check C<crawl-api-doc.pl> for more information.

=head1 PARAMETERS

Those are Spotify Device Object attributes:

=over 4

=item id

Type:String
Description:The device ID. This may be null.

=item is_active

Type:Boolean
Description:If this device is the currently active device.

=item is_private_session

Type:Boolean
Description:If this device is currently in a private session.

=item is_restricted

Type:Boolean
Description:Whether controlling this device is restricted. At present if this is “true” then no Web API commands will be accepted by this device.

=item name

Type:String
Description:The name of the device.

=item type

Type:String
Description:Device type, such as “computer”, “smartphone” or “speaker”.

=item volume_percent

Type:Integer
Description:The current volume in percent. This may be null.

=back

=cut

sub new {
    my ($class, %args) = @_;

    my $fields = {
        id => 'String',
        is_active => 'Boolean',
        is_private_session => 'Boolean',
        is_restricted => 'Boolean',
        name => 'String',
        type => 'String',
        volume_percent => 'Integer',
    };

    my $obj = next::method($class, $fields, %args);

    return $obj;
}

1;
