# generated with h2fields.pl
package Net::NfDump::Fields;
our %NFL_FIELDS_INT = (
	0x00000164 => 'first',
	0x00000264 => 'last',
	0x00000364 => 'received',
	0x00000464 => 'bytes',
	0x00000564 => 'pkts',
	0x00000664 => 'outbytes',
	0x00000764 => 'outpkts',
	0x00000864 => 'flows',
	0x00000916 => 'srcport',
	0x00000a16 => 'dstport',
	0x00000b08 => 'tcpflags',
	0x00000ca1 => 'srcip',
	0x00000da1 => 'dstip',
	0x00000ea1 => 'nexthop',
	0x00000f08 => 'srcmask',
	0x00001008 => 'dstmask',
	0x00001108 => 'tos',
	0x00001208 => 'dsttos',
	0x00001332 => 'srcas',
	0x00001432 => 'dstas',
	0x00001532 => 'nextas',
	0x00001632 => 'prevas',
	0x000017a1 => 'bgpnexthop',
	0x00001808 => 'proto',
	0x00001916 => 'srcvlan',
	0x00001a16 => 'dstvlan',
	0x00001ba2 => 'insrcmac',
	0x00001ca2 => 'outsrcmac',
	0x00001da2 => 'indstmac',
	0x00001ea2 => 'outdstmac',
	0x00001fab => 'mpls',
	0x00002016 => 'inif',
	0x00002116 => 'outif',
	0x00002208 => 'dir',
	0x00002308 => 'fwd',
	0x000024a1 => 'router',
	0x00002508 => 'systype',
	0x00002608 => 'sysid',
	0x00002764 => 'eventtime',
	0x00002832 => 'connid',
	0x00002908 => 'icmpcode',
	0x00002a08 => 'icmptype',
	0x00002b16 => 'xevent',
	0x00002ca1 => 'xsrcip',
	0x00002da1 => 'xdstip',
	0x00002e16 => 'xsrcport',
	0x00002f16 => 'xdstport',
	0x00003032 => 'iacl',
	0x00003132 => 'iace',
	0x00003232 => 'ixace',
	0x00003332 => 'eacl',
	0x00003432 => 'eace',
	0x00003532 => 'exace',
	0x000036aa => 'username',
	0x00003732 => 'ingressvrfid',
	0x00003808 => 'eventflag',
	0x00003932 => 'egressvrfid',
	0x00003a16 => 'blockstart',
	0x00003b16 => 'blockend',
	0x00003c16 => 'blockstep',
	0x00003d16 => 'blocksize',
	0x00003e64 => 'cl',
	0x00003f64 => 'sl',
	0x00004064 => 'al',
);

our %NFL_FIELDS_TXT = (
	'first' => 0x00000164,
	'last' => 0x00000264,
	'received' => 0x00000364,
	'bytes' => 0x00000464,
	'pkts' => 0x00000564,
	'outbytes' => 0x00000664,
	'outpkts' => 0x00000764,
	'flows' => 0x00000864,
	'srcport' => 0x00000916,
	'dstport' => 0x00000a16,
	'tcpflags' => 0x00000b08,
	'srcip' => 0x00000ca1,
	'dstip' => 0x00000da1,
	'nexthop' => 0x00000ea1,
	'srcmask' => 0x00000f08,
	'dstmask' => 0x00001008,
	'tos' => 0x00001108,
	'dsttos' => 0x00001208,
	'srcas' => 0x00001332,
	'dstas' => 0x00001432,
	'nextas' => 0x00001532,
	'prevas' => 0x00001632,
	'bgpnexthop' => 0x000017a1,
	'proto' => 0x00001808,
	'srcvlan' => 0x00001916,
	'dstvlan' => 0x00001a16,
	'insrcmac' => 0x00001ba2,
	'outsrcmac' => 0x00001ca2,
	'indstmac' => 0x00001da2,
	'outdstmac' => 0x00001ea2,
	'mpls' => 0x00001fab,
	'inif' => 0x00002016,
	'outif' => 0x00002116,
	'dir' => 0x00002208,
	'fwd' => 0x00002308,
	'router' => 0x000024a1,
	'systype' => 0x00002508,
	'sysid' => 0x00002608,
	'eventtime' => 0x00002764,
	'connid' => 0x00002832,
	'icmpcode' => 0x00002908,
	'icmptype' => 0x00002a08,
	'xevent' => 0x00002b16,
	'xsrcip' => 0x00002ca1,
	'xdstip' => 0x00002da1,
	'xsrcport' => 0x00002e16,
	'xdstport' => 0x00002f16,
	'iacl' => 0x00003032,
	'iace' => 0x00003132,
	'ixace' => 0x00003232,
	'eacl' => 0x00003332,
	'eace' => 0x00003432,
	'exace' => 0x00003532,
	'username' => 0x000036aa,
	'ingressvrfid' => 0x00003732,
	'eventflag' => 0x00003808,
	'egressvrfid' => 0x00003932,
	'blockstart' => 0x00003a16,
	'blockend' => 0x00003b16,
	'blockstep' => 0x00003c16,
	'blocksize' => 0x00003d16,
	'cl' => 0x00003e64,
	'sl' => 0x00003f64,
	'al' => 0x00004064,
);

our %NFL_FIELDS_DEFAULT_AGGR = (
	0x00000164 => 0x01,
	0x00000264 => 0x02,
	0x00000364 => 0x02,
	0x00000464 => 0x03,
	0x00000564 => 0x03,
	0x00000664 => 0x03,
	0x00000764 => 0x03,
	0x00000864 => 0x03,
	0x00000916 => 0x00,
	0x00000a16 => 0x00,
	0x00000b08 => 0x04,
	0x00000ca1 => 0x00,
	0x00000da1 => 0x00,
	0x00000ea1 => 0x00,
	0x00000f08 => 0x00,
	0x00001008 => 0x00,
	0x00001108 => 0x00,
	0x00001208 => 0x00,
	0x00001332 => 0x00,
	0x00001432 => 0x00,
	0x00001532 => 0x00,
	0x00001632 => 0x00,
	0x000017a1 => 0x00,
	0x00001808 => 0x00,
	0x00001916 => 0x00,
	0x00001a16 => 0x00,
	0x00001ba2 => 0x00,
	0x00001ca2 => 0x00,
	0x00001da2 => 0x00,
	0x00001ea2 => 0x00,
	0x00001fab => 0x00,
	0x00002016 => 0x00,
	0x00002116 => 0x00,
	0x00002208 => 0x00,
	0x00002308 => 0x00,
	0x000024a1 => 0x00,
	0x00002508 => 0x00,
	0x00002608 => 0x00,
	0x00002764 => 0x01,
	0x00002832 => 0x00,
	0x00002908 => 0x00,
	0x00002a08 => 0x00,
	0x00002b16 => 0x00,
	0x00002ca1 => 0x00,
	0x00002da1 => 0x00,
	0x00002e16 => 0x00,
	0x00002f16 => 0x00,
	0x00003032 => 0x00,
	0x00003132 => 0x00,
	0x00003232 => 0x00,
	0x00003332 => 0x00,
	0x00003432 => 0x00,
	0x00003532 => 0x00,
	0x000036aa => 0x00,
	0x00003732 => 0x00,
	0x00003808 => 0x00,
	0x00003932 => 0x00,
	0x00003a16 => 0x00,
	0x00003b16 => 0x00,
	0x00003c16 => 0x00,
	0x00003d16 => 0x00,
	0x00003e64 => 0x00,
	0x00003f64 => 0x00,
	0x00004064 => 0x00,
);

our %NFL_FIELDS_DEFAULT_SORT = (
	0x00000164 => 0x10,
	0x00000264 => 0x10,
	0x00000364 => 0x10,
	0x00000464 => 0x20,
	0x00000564 => 0x20,
	0x00000664 => 0x20,
	0x00000764 => 0x20,
	0x00000864 => 0x20,
	0x00000916 => 0x10,
	0x00000a16 => 0x10,
	0x00000b08 => 0x10,
	0x00000ca1 => 0x10,
	0x00000da1 => 0x10,
	0x00000ea1 => 0x10,
	0x00000f08 => 0x10,
	0x00001008 => 0x10,
	0x00001108 => 0x10,
	0x00001208 => 0x10,
	0x00001332 => 0x10,
	0x00001432 => 0x10,
	0x00001532 => 0x10,
	0x00001632 => 0x10,
	0x000017a1 => 0x10,
	0x00001808 => 0x10,
	0x00001916 => 0x10,
	0x00001a16 => 0x10,
	0x00001ba2 => 0x10,
	0x00001ca2 => 0x10,
	0x00001da2 => 0x10,
	0x00001ea2 => 0x10,
	0x00001fab => 0x00,
	0x00002016 => 0x10,
	0x00002116 => 0x10,
	0x00002208 => 0x10,
	0x00002308 => 0x10,
	0x000024a1 => 0x10,
	0x00002508 => 0x10,
	0x00002608 => 0x10,
	0x00002764 => 0x10,
	0x00002832 => 0x10,
	0x00002908 => 0x10,
	0x00002a08 => 0x10,
	0x00002b16 => 0x10,
	0x00002ca1 => 0x10,
	0x00002da1 => 0x10,
	0x00002e16 => 0x10,
	0x00002f16 => 0x10,
	0x00003032 => 0x10,
	0x00003132 => 0x10,
	0x00003232 => 0x10,
	0x00003332 => 0x10,
	0x00003432 => 0x10,
	0x00003532 => 0x10,
	0x000036aa => 0x10,
	0x00003732 => 0x10,
	0x00003808 => 0x10,
	0x00003932 => 0x10,
	0x00003a16 => 0x10,
	0x00003b16 => 0x10,
	0x00003c16 => 0x10,
	0x00003d16 => 0x10,
	0x00003e64 => 0x10,
	0x00003f64 => 0x10,
	0x00004064 => 0x10,
);

=pod

=head1 LIST OF ITEMS SUPPORTED BY Net::NfDump

  first => Timestamp of the first packet seen (in miliseconds)
  last => Timestamp of the last packet seen (in miliseconds)
  received => Timestamp regarding when the packet was received by collector
  bytes => The number of bytes
  pkts => The number of packets
  outbytes => The number of output bytes
  outpkts => The number of output packets
  flows => The number of flows (aggregated)
  srcport => Source port
  dstport => Destination port
  tcpflags => TCP flags
  srcip => Source IP address
  dstip => Destination IP address
  nexthop => IP next hop
  srcmask => Source mask
  dstmask => Destination mask
  tos => Source type of service
  dsttos => Destination type of service
  srcas => Source AS number
  dstas => Destination AS number
  nextas => BGP Next AS
  prevas => BGP Previous AS
  bgpnexthop => BGP next hop
  proto => IP protocol
  srcvlan => Source vlan label
  dstvlan => Destination vlan label
  insrcmac => In source MAC address
  outsrcmac => Out destination MAC address
  indstmac => In destination MAC address
  outdstmac => Out source MAC address
  mpls => MPLS labels
  inif => SNMP input interface number
  outif => SNMP output interface number
  dir => Flow directions ingress/egress
  fwd => Forwarding status
  router => Exporting router IP
  systype => Type of exporter
  sysid => Internal SysID of exporter
  eventtime => NSEL The time that the flow was created
  connid => NSEL An identifier of a unique flow for the device
  icmpcode => NSEL ICMP code value
  icmptype => NSEL ICMP type value
  xevent => NSEL Extended event code
  xsrcip => NSEL Mapped source IPv4 address
  xdstip => NSEL Mapped destination IPv4 address
  xsrcport => NSEL Mapped source port
  xdstport => NSEL Mapped destination port
  iacl => Hash value or ID of the ACL name
  iace => Hash value or ID of the ACL name
  ixace => Hash value or ID of an extended ACE configuration
  eacl => Hash value or ID of the ACL name
  eace => Hash value or ID of the ACL name
  exace => Hash value or ID of an extended ACE configuration
  username => NSEL username
  ingressvrfid => NEL NAT ingress vrf id
  eventflag => NAT event flag (always set to 1 by nfdump)
  egressvrfid => NAT egress VRF ID
  blockstart => NAT pool block start
  blockend => NAT pool block end
  blockstep => NAT pool block step
  blocksize => NAT pool block size
  cl => nprobe latency client_nw_delay_usec
  sl => nprobe latency server_nw_delay_usec
  al => nprobe latency appl_latency_usec

=cut

