/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.cas.impl;

import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.admin.FSIndexComparator;
import org.apache.uima.cas.impl.CASImpl;
import org.apache.uima.cas.impl.FSLeafIndexImpl;
import org.apache.uima.cas.impl.FeatureStructureImpl;
import org.apache.uima.cas.impl.LowLevelCAS;
import org.apache.uima.cas.impl.LowLevelIterator;
import org.apache.uima.internal.util.ComparableIntIterator;
import org.apache.uima.internal.util.ComparableIntPointerIterator;
import org.apache.uima.internal.util.IntComparator;
import org.apache.uima.internal.util.IntPointerIterator;
import org.apache.uima.internal.util.IntVector;
import org.apache.uima.internal.util.rb_trees.CompIntArrayRBT;

public class FSRBTSetIndex<T extends FeatureStructure>
extends FSLeafIndexImpl<T> {
    CompIntArrayRBT tree = null;

    public FSRBTSetIndex(CASImpl cas, Type type, int indexType) {
        super(cas, type, indexType);
    }

    @Override
    boolean init(FSIndexComparator comp) {
        boolean rc = super.init(comp);
        this.tree = new CompIntArrayRBT(this);
        return rc;
    }

    @Override
    public void flush() {
        this.tree.flush();
    }

    @Override
    boolean insert(int fs) {
        this.tree.insertKey(fs);
        return true;
    }

    @Override
    boolean insert(int fs, int count) {
        return this.insert(fs);
    }

    public FeatureStructure find(FeatureStructure fs) {
        LowLevelCAS llc = fs.getCAS().getLowLevelCAS();
        int addr = llc.ll_getFSRef(fs);
        int resultAddr = this.tree.getKeyForNode(this.tree.findKey(addr));
        if (resultAddr > 0) {
            return llc.ll_getFSForRef(resultAddr);
        }
        return null;
    }

    @Override
    public IntPointerIterator refIterator() {
        return this.tree.pointerIterator(this, null, this);
    }

    ComparableIntIterator refIterator(IntComparator comp) {
        return (ComparableIntIterator)((Object)this.tree.pointerIterator(this, null, comp));
    }

    @Override
    public ComparableIntPointerIterator<T> pointerIterator(IntComparator comp, int[] detectIllegalIndexUpdates, int typeCode) {
        return this.tree.pointerIterator(this, detectIllegalIndexUpdates, comp);
    }

    @Override
    protected IntPointerIterator refIterator(int fsCode) {
        ComparableIntPointerIterator it = this.tree.pointerIterator(this, null, null);
        it.moveTo(fsCode);
        return it;
    }

    public boolean contains(FeatureStructure fs) {
        return this.ll_contains(((FeatureStructureImpl)fs).getAddress());
    }

    boolean ll_contains(int fsAddr) {
        return this.tree.containsKey(fsAddr);
    }

    @Override
    public int size() {
        return this.tree.size();
    }

    @Override
    public void deleteFS(FeatureStructure fs) {
        int addr = ((FeatureStructureImpl)fs).getAddress();
        this.tree.deleteKey(addr);
    }

    @Override
    public LowLevelIterator ll_iterator() {
        return (LowLevelIterator)((Object)this.tree.pointerIterator(this, null, this));
    }

    @Override
    boolean remove(int fs) {
        return this.tree.deleteKey(fs);
    }

    @Override
    protected void bulkAddTo(IntVector v) {
        throw new UnsupportedOperationException();
    }

    public void setTree(CompIntArrayRBT compIntArrayRBT) {
        this.tree = compIntArrayRBT;
    }
}

