#!/usr/env/perl

use strict;
use warnings;
use v5.10;

$|++;

use Webservice::Judobase;
use Text::CSV_XS qw( csv );

use Data::Dumper;
$Data::Dumper::Sortkeys = 1;

my $srv = Webservice::Judobase->new;

my @data;

my $events = $srv->general->competitions;

my $data;

my @years = (
    qw/
        2021
        2020
        2019
        2018
        2017
        2016
        2015
        /
);

@years = ('2022');

my $number_of_events = 0;
my $counter          = 1;

for my $event (@$events) {
    next unless grep { $_ == $event->{comp_year} } @years;

    $data->{ $event->{comp_year} }{total_events}++;
    my $competitors = eval {
        $srv->general->competitors( event_id => $event->{id_competition} );
    };

    next unless ref $competitors eq 'ARRAY';

    for my $athlete (@$competitors) {
        if (   $athlete->{country_short} eq 'RUS'
            || $athlete->{country_short} eq 'RJF'
            || $athlete->{country_short} eq 'ROC' )
        {
            $data->{ $event->{comp_year} }{russians}++;
        }
    }

    $number_of_events++;
    $counter++;
}

say Dumper $data;


1;
