package Reddit::Client::Comment;

use strict;
use warnings;
use Carp;

require Reddit::Client::VotableThing;

# removed 4/18: media, url, ilink_flair_text, link_flair_css_class
#
# were these fields ever part of any comment, or were they copied form Link?
use base   qw/Reddit::Client::VotableThing/;
use fields qw/ 
	  num_reports created_utc
	  banned_by subreddit title author_flair_text is_self author media_embed
	  permalink author_flair_css_class selftext domain num_comments clicked
	  saved thumbnail subreddit_id approved_by selftext_html created hidden
	  over_18 parent_id replies body body_html
	  user_reports mod_reports
	  link_author link_id link_permalink link_title link_url 
/;

use constant type => "t1";

sub set_replies {
    my ($self, $value) = @_;
    if (ref $value && exists $value->{data}{children}) {
	    $self->{replies} = [ map { Reddit::Client::Comment->new($self->{session}, $_->{data}) } @{$value->{data}{children}} ];
    } else {
        $self->{replies} = [];
    }
}

sub replies {
    return shift->{replies};
}

sub reply {
    	my ($self, $text) = @_;
	$text || croak "need comment text";	
	my $cmtid = $self->{session}->submit_comment(parent_id=>$self->{name}, text=>$text);
	return "t1_".$cmtid if $cmtid;
	return $cmtid;
}
sub remove {
	my $self = shift;
	return $self->{session}->remove($self->{name});
}
sub spam {
	my $self = shift;
	return $self->{session}->spam($self->{name});
}
sub edit {
    	my ($self, $text) = @_;
	my $cmtid = $self->{session}->edit($self->{name}, $text);
	$self->{body} = $text if $cmtid;
	return $cmtid;
}
sub delete {
    	my $self = shift;
	my $cmtid = $self->{session}->delete($self->{name});
	return $cmtid;
}
# The API return a 'permalink' that starts at '/r/sub..'
# This just prepends the rest of the address
sub get_permalink {
	my $self = shift;
	my $parentid = substr $self->{link_id}, 3;

	return sprintf "%s/r/$self->{subreddit}/comments/%s//%s", $self->{session}->LINK_URL, $parentid, $self->{id};
}

1;

__END__

=pod

=head1 NAME

Reddit::Client::Comment

=head1 DESCRIPTION

Wraps a posted comment.

=head1 SUBROUTINES/METHODS

=over

=item replies()

Returns a list ref of replies underneath this comment.

=item reply(...)

Syntactic sugar for C<Reddit::Client::submit_comment()>.

=back

=head1 INTERNAL ROUTINES

=over

=item set_replies

Wraps the list of children in Comment class instances and ensures that comments
with no replies return an empty array for C<replies>.

=back

=head1 AUTHOR

<mailto:earthtone.rc@gmail.com>

=head1 LICENSE

BSD license

=cut
