/*
 * Decompiled with CFR 0.152.
 */
package org.couchbase.mock;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.sf.json.JSONObject;
import org.couchbase.mock.Bucket;
import org.couchbase.mock.CouchbaseMock;
import org.couchbase.mock.memcached.MemcachedServer;

public class CouchbaseBucket
extends Bucket {
    public CouchbaseBucket(String name, String hostname, int port, int numNodes, int bucketStartPort, int numVBuckets, CouchbaseMock cluster, String password) throws IOException {
        super(name, hostname, port, numNodes, bucketStartPort, numVBuckets, cluster, password);
    }

    public CouchbaseBucket(String name, String hostname, int port, int numNodes, int bucketStartPort, int numVBuckets) throws IOException {
        super(name, hostname, port, numNodes, bucketStartPort, numVBuckets, null);
    }

    @Override
    public String getJSON() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        List<MemcachedServer> active = this.activeServers();
        map.put("name", this.name);
        map.put("bucketType", "membase");
        map.put("authType", "sasl");
        map.put("saslPassword", this.getPassword());
        map.put("proxyPort", 0);
        map.put("uri", "/pools/default/buckets/" + this.name);
        map.put("streamingUri", "/pools/default/bucketsStreaming/" + this.name);
        map.put("flushCacheUri", "/pools/default/buckets/" + this.name + "/controller/doFlush");
        ArrayList<String> nodes = new ArrayList<String>();
        for (MemcachedServer server : active) {
            nodes.add(server.toString());
        }
        map.put("nodes", nodes);
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        HashMap<String, String> stats = new HashMap<String, String>();
        stats.put("uri", "/pools/default/buckets/" + this.name + "/stats");
        map.put("stats", stats);
        map.put("nodeLocator", "vbucket");
        HashMap<String, Object> vbm = new HashMap<String, Object>();
        vbm.put("hashAlgorithm", "CRC");
        vbm.put("numReplicas", 0);
        ArrayList<String> serverList = new ArrayList<String>();
        for (MemcachedServer server : active) {
            serverList.add(server.getSocketName());
        }
        vbm.put("serverList", serverList);
        ArrayList m = new ArrayList();
        for (short ii = 0; ii < this.numVBuckets; ii = (short)(ii + 1)) {
            MemcachedServer resp = this.datastore.getVBucket(ii).getOwner();
            ArrayList<Integer> line = new ArrayList<Integer>();
            line.add(active.indexOf(resp));
            m.add(line);
        }
        vbm.put("vBucketMap", m);
        map.put("vBucketServerMap", vbm);
        return JSONObject.fromObject(map).toString();
    }

    @Override
    public Bucket.BucketType getType() {
        return Bucket.BucketType.COUCHBASE;
    }
}

