use strict;
use warnings;
use SDL2::FFI qw[:all];
#
SDL_Init(SDL_INIT_VIDEO) == 0 || die 'Could not initialize SDL2: ' . SDL_GetError();
my $window
    = SDL_CreateWindow( 'XPM example', SDL_WINDOWPOS_UNDEFINED, SDL_WINDOWPOS_UNDEFINED, 350, 200,
    SDL_WINDOW_SHOWN ) // die 'Could not create window: ' . SDL_GetError();
my $screenSurface = SDL_GetWindowSurface($window) // die 'Could not get window: ' . SDL_GetError();

END {
    SDL_FreeSurface($screenSurface);
    SDL_DestroyWindow($window);
    SDL_Quit();
}
my $img = IMG_ReadXPMFromArray( [<DATA>] );
$img // die SDL_GetError();
SDL_BlitSurface( $img, undef, $screenSurface, undef );
SDL_UpdateWindowSurface($window);
SDL_Delay(2000);
SDL_FreeSurface($img);
__DATA__
350 200 200 2
   c None
.  c #012C012C80CB
X  c #025702578116
o  c #038303838161
O  c #04AE04AE81AC
+  c #05DA05DA81F7
@  c #070607068241
#  c #08310831828C
$  c #095D095D82D7
%  c #0A890A898322
&  c #0BB40BB4836D
*  c #0CE00CE083B8
=  c #0E0B0E0B8403
-  c #0F370F37844E
;  c #106310638499
:  c #118E118E84E4
>  c #12BA12BA852E
,  c #13E613E68579
<  c #1511151185C4
1  c #163D163D860F
2  c #17681768865A
3  c #1894189486A5
4  c #19C019C086F0
5  c #1AEB1AEB873B
6  c #1C171C178786
7  c #1D421D4287D1
8  c #1E6E1E6E881C
9  c #1F9A1F9A8866
0  c #20C520C588B1
q  c #21F121F188FC
w  c #231D231D8947
e  c #244824488992
r  c #2574257489DD
t  c #269F269F8A28
y  c #27CB27CB8A73
u  c #28F728F78ABE
i  c #2A222A228B09
p  c #2B4E2B4E8B53
a  c #2C792C798B9E
s  c #2DA52DA58BE9
d  c #2ED12ED18C34
f  c #2FFC2FFC8C7F
g  c #312831288CCA
h  c #325432548D15
j  c #337F337F8D60
k  c #34AB34AB8DAB
l  c #35D635D68DF6
z  c #370237028E41
x  c #382E382E8E8B
c  c #395939598ED6
v  c #3A853A858F21
b  c #3BB13BB18F6C
n  c #3CDC3CDC8FB7
m  c #3E083E089002
M  c #3F333F33904D
N  c #405F405F9098
B  c #418B418B90E3
V  c #42B642B6912E
C  c #43E243E29178
Z  c #450D450D91C3
A  c #46394639920E
S  c #476547659259
D  c #4890489092A4
F  c #49BC49BC92EF
G  c #4AE84AE8933A
H  c #4C134C139385
J  c #4D3F4D3F93D0
K  c #4E6A4E6A941B
L  c #4F964F969466
P  c #50C250C294B0
I  c #51ED51ED94FB
U  c #531953199546
Y  c #544554459591
T  c #5570557095DC
R  c #569C569C9627
E  c #57C757C79672
W  c #58F358F396BD
Q  c #5A1F5A1F9708
!  c #5B4A5B4A9753
~  c #5C765C76979D
^  c #5DA15DA197E8
/  c #5ECD5ECD9833
(  c #5FF95FF9987E
)  c #6124612498C9
_  c #625062509914
`  c #637C637C995F
'  c #64A764A799AA
]  c #65D365D399F5
[  c #66FE66FE9A40
{  c #682A682A9A8B
}  c #695669569AD5
|  c #6A816A819B20
 . c #6BAD6BAD9B6B
.. c #6CD86CD89BB6
X. c #6E046E049C01
o. c #6F306F309C4C
O. c #705B705B9C97
+. c #718771879CE2
@. c #72B372B39D2D
#. c #73DE73DE9D78
$. c #750A750A9DC2
%. c #763576359E0D
&. c #776177619E58
*. c #788D788D9EA3
=. c #79B879B89EEE
-. c #7AE47AE49F39
;. c #7C107C109F84
:. c #7D3B7D3B9FCF
>. c #7E677E67A01A
,. c #7F927F92A065
<. c #80BE80BEA0AF
1. c #81EA81EAA0FA
2. c #83158315A145
3. c #84418441A190
4. c #856C856CA1DB
5. c #86988698A226
6. c #87C487C4A271
7. c #88EF88EFA2BC
8. c #8A1B8A1BA307
9. c #8B478B47A352
0. c #8C728C72A39D
q. c #8D9E8D9EA3E7
w. c #8EC98EC9A432
e. c #8FF58FF5A47D
r. c #91219121A4C8
t. c #924C924CA513
y. c #93789378A55E
u. c #94A394A3A5A9
i. c #95CF95CFA5F4
p. c #96FB96FBA63F
a. c #98269826A68A
s. c #99529952A6D4
d. c #9A7E9A7EA71F
f. c #9BA99BA9A76A
g. c #9CD59CD5A7B5
h. c #9E009E00A800
j. c #9F2C9F2CA84B
k. c #A058A058A896
l. c #A183A183A8E1
z. c #A2AFA2AFA92C
x. c #A3DBA3DBA977
c. c #A506A506A9C2
v. c #A632A632AA0C
b. c #A75DA75DAA57
n. c #A889A889AAA2
m. c #A9B5A9B5AAED
M. c #AAE0AAE0AB38
N. c #AC0CAC0CAB83
B. c #AD37AD37ABCE
V. c #AE63AE63AC19
C. c #AF8FAF8FAC64
Z. c #B0BAB0BAACAF
A. c #B1E6B1E6ACF9
S. c #B312B312AD44
D. c #B43DB43DAD8F
F. c #B569B569ADDA
G. c #B694B694AE25
H. c #B7C0B7C0AE70
J. c #B8ECB8ECAEBB
K. c #BA17BA17AF06
L. c #BB43BB43AF51
P. c #BC6FBC6FAF9C
I. c #BD9ABD9AAFE7
U. c #BEC6BEC6B031
Y. c #BFF1BFF1B07C
T. c #C11DC11DB0C7
R. c #C249C249B112
E. c #C374C374B15D
W. c #C4A0C4A0B1A8
Q. c #C5CBC5CBB1F3
!. c #C6F7C6F7B23E
~. c #C823C823B289
^. c #C94EC94EB2D4
/. c #CA7ACA7AB31E
(. c #CBA6CBA6B369
). c #CCD1CCD1B3B4
_. c #CDFDCDFDB3FF
`. c #CF28CF28B44A
'. c #D054D054B495
]. c #D180D180B4E0
[. c #D2ABD2ABB52B
{. c #D3D7D3D7B576
}. c #D502D502B5C1
|. c #D62ED62EB60C
 X c #D75AD75AB656
.X c #D885D885B6A1
XX c #D9B1D9B1B6EC
oX c #DADDDADDB737
OX c #DC08DC08B782
+X c #DD34DD34B7CD
@X c #DE5FDE5FB818
#X c #DF8BDF8BB863
$X c #E0B7E0B7B8AE
%X c #E1E2E1E2B8F9
&X c #E30EE30EB943
*X c #E43AE43AB98E
=X c #E565E565B9D9
-X c #E691E691BA24
;X c #E7BCE7BCBA6F
:X c #E8E8E8E8BABA
:X:X:X:X;X;X:X:X:X:X;X;X;X:X:X:X;X;X;X;X:X:X;X;X;X:X:X:X;X;X;X:X:X:X;X;X;X:X:X:X;X;X;X;X:X:X;X;X;X:X:X:X;X;X;X:X:X:X;X;X;X:X:X:X;X;X;X;X:X:X;X;X;X:X:X:X;X;X;X:X:X:X;X;X;X:X:X:X;X;X;X;X:X:X;X;X;X:X:X:X;X;X;X:X:X:X;X;X;X:X:X:X;X;X:X:X:X:X;X;X;X:X:X:X;X;X;X:X:X:X;X;X;X:X:X:X;X;X;X:X:X:X;X;X;X:X:X:X;X;X;X:X:X:X;X;X;X:X:X:X;X;X;X:X:X:X;X;X;X:X:X:X;X;X;X;X:X:X;X;X;X:X:X:X;X;X;X:X:X:X;X;X;X:X:X:X;X:X:X:X:X:X;X;X;X:X:X:X;X;X;X;X:X:X;X;X;X:X:X:X;X;X;X:X:X:X;X;X;X:X:X:X;X;X;X;X:X:X;X;X;X:X:X:X;X;X;X:X:X:X;X;X;X:X:X:X;X;X:X:X:X:X:X:X:X:X:X:X;X;X;X:X:X:X:X:X:X:X:X:X;X;X:X:X:X:X:X:X:X:X:X:X;X;X;X:X:X:X:X:X:X:X:X:X;X;X;X:X:X:X;X;X;X:X:X:X;X;X;X:X:X:X;X;X;X:X:X:X;X;X:X:X:X:X;X;X;X:X:X:X;X;X;X:X:X:X;X;X;X:X
;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X
;X;X;X;X;X*X;X*X;X;X;X;X;X;X;X;X;X;X*X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X*X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X*X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X*X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X*X;X*X;X;X;X;X;X*X;X;X;X*X;X*X;X;X;X;X;X*X;X;X;X*X;X*X;X;X;X;X;X*X;X;X;X*X;X*X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X*X;X;X;X;X;X;X;X;X;X;X;X*X;X;X;X*X;X*X;X;X;X;X*X;X*X;X;X*X;X*X;X;X;X;X;X*X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X*X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X*X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X*X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X*X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X;X
*X*X;X*X;X*X*X*X;X*X*X*X*X*X;X*X*X;X*X*X;X*X*X*X*X*X;X*X*X*X*X*X;X*X*X*X*X*X;X*X*X;X*X*X;X*X*X*X*X*X;X*X*X*X*X*X;X*X*X*X*X*X;X*X*X;X*X;X;X*X*X*X*X*X;X*X*X*X*X*X;X*X*X*X*X*X;X*X*X;X*X;X;X*X*X*X*X*X;X*X*X*X*X*X;X*X*X*X*X*X;X*X*X*X*X*X*X;X*X;X*X;X*X*X*X;X*X*X*X;X*X;X*X;X*X*X*X;X*X;X*X;X*X;X*X;X*X*X*X;X*X*X*X;X*X;X*X;X*X*X*X*X*X*X;X*X*X*X*X*X;X*X*X;X*X*X;X*X*X*X*X*X;X*X*X*X;X*X;X*X;X*X;X*X;X*X*X;X*X*X;X*X;X*X;X*X;X*X*X;X*X*X;X*X*X*X*X*X;X*X*X*X*X*X;X*X*X*X*X*X;X*X*X;X*X*X;X*X*X*X*X*X;X*X*X*X*X*X;X*X*X*X*X*X;X*X;X;X$X*X;X$X;X$X;X$X;X*X*X;X$X;X;X$X;X$X;X$X;X*X;X;X$X*X;X$X;X$X;X$X;X*X*X;X$X;X;X$X;X$X;X$X;X*X*X;X$X;X;X*X$X;X$X*X;X*X*X;X$X;X;X*X$X;X$X*X;X*X;X*X*X*X;X*X$X;X$X*X;X*X*X;X$X;X;X*X$X;X$X;X
*X*X*X*X*X*X*X*X*X*X*X*X*X*X*X*X*X*X*X*X*X*X*X*X*X*X*X*X*X*X*X*X*X*X*X*X*X*X*X*X*X*X*X*X*X*X*X*X*X*X*X*X*X*X*X*X*X*X*X*X*X*X*X*X*X*X*X*X*X*X*X*X*X*X*X*X*X*X*X*X*X*X*X*X*X*X*X*X*X*X*X*X*X*X*X*X*X*X*X*X*X*X*X*X*X*X*X*X*X*X*X*X*X*X*X*X*X*X*X*X*X*X*X*X*X*X*X*X*X*X*X*X*X*X*X*X*X*X*X*X*X*X*X*X*X*X*X*X*X*X*X*X*X*X*X*X*X*X*X*X*X*X*X*X*X*X*X*X*X*X*X*X*X*X*X*X*X*X*X*X*X*X*X*X*X*X*X*X*X*X*X*X*X*X*X*X*X*X*X*X*X*X*X*X*X*X*X*X*X*X*X*X*X*X*X*X*X*X*X*X*X*X*X*X*X*X*X*X*X*X*X*X*X*X*X*X*X*X*X*X*X*X*X*X*X*X*X*X*X*X*X*X*X*X*X*X;X*X*X;X*X;X;X$X$X*X;X*X*X*X;X*X;X$X$X;X$X;X$X;X;X*X*X;X*X;X;X$X$X*X;X*X*X*X;X*X;X$X$X;X$X;X$X;X;X*X*X*X*X;X$X;X*X*X*X*X*X*X*X*X*X;X$X;X*X;X$X;X*X*X*X;X*X*X*X*X*X*X*X*X*X*X*X*X$X;X*X*X*X;X
*X*X*X*X*X#X*X*X*X*X#X*X*X*X*X#X#X*X*X*X*X#X*X*X*X*X*X*X*X*X*X*X*X*X#X*X*X*X*X#X#X*X*X*X*X#X*X*X*X*X*X*X*X*X*X*X*X*X#X*X*X*X*X#X*X*X*X$X*X$X*X*X*X$X$X*X*X*X*X*X$X*X*X*X$X*X$X*X*X*X*X$X$X*X*X*X*X$X$X*X*X*X*X*X$X*X*X*X$X*X$X*X@X*X*X*X*X*X*X*X*X*X*X*X*X@X*X*X*X*X*X*X*X*X*X*X*X*X*X@X*X@X*X*X*X*X*X*X*X@X*X*X*X*X*X*X*X*X*X*X#X*X*X*X*X*X*X*X#X*X#X*X*X*X*X*X*X*X#X*X*X#X*X*X#X*X*X*X*X*X*X*X#X*X*X*X*X*X*X*X*X*X#X*X*X#X*X*X#X*X*X*X#X*X*X*X*X*X*X*X*X*X*X*X*X*X#X*X*X*X*X#X#X*X*X*X*X#X*X*X*X*X*X*X*X*X*X*X*X*X#X*X*X*X*X#X$X*X$X*X$X$X$X;X*X$X$X*X*X$X$X*X$X;X$X*X$X*X$X$X$X*X$X*X$X$X$X;X*X$X$X*X*X$X$X*X$X;X$X*X$X*X$X$X$X*X$X*X$X$X*X*X*X$X*X*X*X$X*X*X$X$X*X*X$X*X$X$X*X*X$X*X$X*X$X;X*X$X*X*X*X$X*X*X*X*X$X*X$X*X
@X*X*X*X#X#X*X*X#X*X*X*X*X*X#X*X*X*X*X*X#X*X#X*X#X*X#X#X#X*X#X#X#X*X*X*X*X*X#X*X*X*X*X*X#X*X#X*X#X*X#X#X#X*X#X#X#X*X*X*X*X*X#X*X*X$X$X*X$X$X*X$X$X*X$X*X@X*X$X*X$X*X*X$X$X*X$X*X*X$X$X*X$X*X*X$X$X*X$X*X@X*X$X*X$X*X*X$X$X*X$X*X*X*X@X*X@X*X*X@X@X*X@X*X*X*X*X*X@X*X*X@X*X@X@X*X@X*X*X*X*X@X*X*X@X*X@X*X*X*X*X*X@X*X*X@X*X@X@X*X#X*X*X#X@X*X*X#X*X*X#X*X#X#X*X*X#X*X#X*X*X#X#X*X*X*X*X*X@X*X*X#X*X*X#X#X@X*X*X*X#X*X*X*X*X*X#X*X*X*X*X#X*X#X*X#X#X*X#X#X#X*X#X#X#X*X*X*X*X*X#X*X*X*X*X*X#X*X#X*X#X*X#X#X#X*X#X#X#X*X*X*X*X*X#X*X$X*X$X*X$X$X$X$X$X$X$X*X$X$X$X*X$X$X$X*X$X*X$X$X$X*X$X*X$X$X$X$X$X$X$X*X$X$X$X*X$X$X$X*X$X*X$X$X$X*X$X*X$X$X$X$X$X$X*X$X$X$X*X$X$X$X*X$X$X$X$X*X*X$X$X$X$X*X$X$X$X$X*X$X$X$X*X$X$X$X$X*X$X$X
#X#X@X#X#X*X#X#X#X@X#X#X@X#X#X#X#X#X@X#X#X#X*X#X#X#X#X*X#X#X#X*X#X@X#X#X@X#X#X#X#X#X@X#X#X#X*X#X#X#X#X*X#X#X#X*X#X@X#X#X@X#X#X#X$X$X@X$X$X$X$X$X@X$X$X$X$X$X@X$X$X@X$X$X@X$X$X@X$X$X@X$X$X@X@X*X@X$X$X$X$X$X@X$X$X@X$X$X@X$X$X@X@X*X@X*X@X@X@X*X*X@X*X@X@X@X@X@X@X@X@X*X@X*X@X@X*X@X@X@X*X@X@X*X*X@X*X@X@X@X@X@X#X@X@X*X@X*X@X@X*X#X@X*X#X@X@X*X@X#X*X@X#X*X@X#X#X@X*X#X@X*X#X@X#X#X@X#X#X@X@X*X@X#X#X*X#X#X@X#X#X@X#X#X@X#X#X@X#X#X#X*X#X#X#X*X#X#X#X*X#X#X#X*X#X@X#X#X@X#X#X#X#X#X@X#X#X#X*X#X#X#X#X*X#X#X#X*X#X@X#X#X@X#X#X#X$X$X$X$X$X$X$X$X$X$X$X$X$X$X$X$X$X$X$X$X$X$X$X$X$X$X$X$X$X$X$X$X$X$X$X$X$X$X$X$X$X$X$X$X$X$X$X$X$X$X$X$X$X$X$X$X$X$X$X$X$X$X$X$X$X$X$X$X$X$X$X$X$X$X$X$X$X$X$X$X$X$X$X$X$X$X$X$X$X$X$X$X$X@X
#X#X#X#X#X#X#X#X#X#X#X#X#X#X#X#X#X#X#X#X#X#X#X#X#X#X#X#X#X#X#X#X#X#X#X#X#X#X#X#X#X#X#X#X#X#X#X#X#X#X#X#X#X#X#X#X#X#X#X#X#X#X#X#X@X@X@X$X@X$X@X@X@X@X@X@X$X@X@X@X@X@X$X@X@X@X@X$X@X$X@X$X@X@X@X@X$X@X@X@X@X@X@X@X@X@X@X@X@X$X@X$X@X@X*X@X@X@X@X@X$X@X$X@X$X@X@X@X@X*X@X@X@X@X*X@X@X@X@X*X@X@X@X@X#X@X@X@X#X@X@X@X@X#X@X@X@X#X#X#X#X#X#X#X#X#X#X#X#X#X#X#X#X#X@X@X@X#X#X#X#X#X#X#X#X#X#X#X#X#X#X#X#X#X#X#X#X#X#X#X@X#X#X#X#X#X#X#X#X#X#X#X#X#X#X#X#X#X#X#X#X#X#X#X#X#X#X#X#X#X#X#X#X#X#X#X#X#X#X#X#X#X#X#X#X#X#X#X#X#X#X#X#X#X#X#X@X@X@X@X$X@X@X@X$X@X@X@X@X$X@X@X$X$X@X$X@X@X@X@X$X@X$X@X@X@X@X$X@X@X@X@X$X@X@X@X$X$X@X@X@X@X$X@X@X@X@X$X@X$X@X@X@X@X@X@X$X@X@X@X$X$X@X$X@X@X@X@X$X@X$X@X@X@X@X$X$X@X@X@X@X@X@X@X$X@X@X@X@X$X
@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X
@XoX@X@X@XoX@X@X@X@X@X@X@X@X@XoX@X@X@X@X@X@X@X@X@XoX@X@X@XoX@X@X@X@X@XoX@X@X@X@X@X@X@XoX@X@X@X@X@XoX@X@X@XoX@X@X@X@X@X@X@X@X@XoX@X@X@X@X@X@XoX@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@XoX@X@X@X@X@XoX@X@X@X@X@X@X@X@X@X@X@X@X@XoX@X@X@X@XoX@XoX@X@XoX@X@X@X@XoX@X@X@X@X@X@X@X@X@XoX@XoXoX@XoX@X@X@XoX@X@X@X@X@X@X@X@X@X@X@XoX@XoX@X@X@X@XoX@XoX@X@X@X@X@X@X@XoX@X@X@X@X@X@X@X@X@XoX@XoX@X@X@X@X@XoX@XoX@X@X@XoX@X@X@XoX@X@X@X@X@X@X@X@X@XoX@XoX@X@X@X@X@X@X@XoX@X@X@XoX@X@X@XoX@X@X@X@X@X@X@XoX@X@X@X@X@XoX@X@X@XoX@X@X@X@X@X@X@X@X@XoX@X@XoX@X@X@X@X@X@X@X@X@X@X@X@XoXoX@X@X@X@X@XoX@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@XoX@X@X@X@X@X@X@X@X@X@X@XoX@X@X@X@X@X@X@X@X@XoX@X@X@X@X@XoX@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@X@XoX@X
@XoXoXoX@XoXoXoXoXoXoXoXoXoX@XoXoXoXoXoXoXoXoXoX@XoXoXoX@XoXoXoXoXoX@XoXoXoXoXoXoXoX@XoXoXoXoXoX@XoXoXoX@XoXoXoXoXoXoXoXoXoX@XoXoXoXoXoXoX@XoX@X@XoXoX@XoXoXoXoXoXoX@XoXoXoXoXoXoX@XoXoXoX@XoXoXoXoXoXoX@XoXoXoX@XoXoXoXoX@XoXoX@XoXoXoXoX@XoX@XoXoX@XoXoXoXoXoXoXoXoXoX@XoXoXoXoX@XoXoXoX@XoXoXoXoXoX@XoXoXoXoXoX@XoX@XoX@XoXoX@XoXoXoXoXoXoXoXoXoXoX@XoXoXoXoXoXoXoXoX@XoXoXoXoXoXoXoX@XoXoXoXoXoX@XoXoXoXoXoXoXoXoXoXoXoXoXoX@XoXoXoXoXoXoXoXoXoX@XoXoXoXoXoXoXoX@XoXoXoXoXoXoXoX@XoXoXoXoXoX@XoXoXoX@XoXoXoXoXoXoXoXoXoX@XoXoX@XoXoX@XoXoXoXoXoXoXoX@XoX@XoXoX@XoXoXoX@XoXoXoXoX@XoXoXoXoXoX@XoXoX@XoXoXoXoXoX@XoX@XoXoX@XoXoXoXoXoXoX@XoX@X@XoXoX@XoXoXoXoXoX@XoXoXoX@XoXoXoXoX@XoXoXoXoXoXoXoXoXoX@XoXoXoX@XoXoXoXoX@X
oXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoXoX
oXoXoX XoXoXoX XoXoX XoXoXoXoX XoXoX XoX XoX XoXoXoXoX XoXoXoX X XoXoX X XoXoX X XoXoX X XoXoXoXoX XoXoXoXoX XoX XoXoXoXoX XoXoXoXoXoX XoXoX XoXoXoXoX XoXoXoX XoXoX XoXoXoX XoXoXoXoXoX XoXoXoXoXoX XoX XoXoXoXoX XoXoXoXoX XoX XoXoXoXoX XoXoXoXoX XoXoXoX XoXoXoXoXoXoX XoXoXoXoXoXoX XoXoXoXoXoXoXoXoXoX XoX XoXoXoXoXoXoXoX XoXoXoXoX XoXoXoXoX XoXoXoX XoXoXoXoXoXoX XoXoXoXoXoXoXoX XoXoXoXoX XoX XoXoXoXoX XoXoXoXoX XoX XoXoXoXoX XoXoXoXoX XoX XoXoXoXoXoX XoXoXoX XoXoXoX XoXoXoX XoXoXoXoX XoXoXoX XoXoX XoXoXoXoX X XoXoXoXoX XoXoXoXoX XoXoX XoX XoXoXoXoXoX XoXoX XoXoXoX XoXoXoXoX XoXoXoXoX XoX XoXoXoXoX XoXoXoXoXoX XoXoX XoXoXoXoX XoXoXoX XoXoXoXoX XoXoXoXoXoX XoXoXoX XoXoXoXoXoXoXoX XoX XoXoXoXoXoX
 XoX X X X XoX X X X XoX XoX X X X XoX XoX X XoX XoX X X X XoX XoX X XoXoX X XoXoX X XoX XoX X XoX X X XoX X X X XoX X XoX X X X X XoX X X X XoX XoX X X X XoX X X X XoX X X XoX XoX X X XoX X XoX XoX XoX X X X XoX X XoX XoX X XoX XoX X XoX X X X XoXoX X X X X XoX X X XoX X XoX X X XoX X XoX X X XoX X X X XoX X XoX X X X XoX XoX X XoX X X X XoXoX X X X X XoX X X XoX X X XoX X X XoX X X X XoX XoX XoX X XoX X X X XoX XoX XoX X XoX X X X XoX XoX X X X X XoX X X XoX X X XoX X X XoX XoX X X X XoX X X X XoX XoX X XoX X X X XoX X XoX XoX X XoX X X XoX X X XoX X X XoX X X XoX X XoX X X XoX X X X XoX X XoX X X X X XoX X X X XoX XoX X X X X X X XoX X X XoX X X X X XoX X X XoXoX X X XoX X X X XoX X XoX X
 X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X
 X X[. X X X[. X X X X X X X X[. X X X[. X X X[. X X[. X X X X X X X X X X X X X[. X X X[. X X X X X[. X X X[. X X X X X X X[. X X[. X X X[. X X X X[. X X X X X X X X X X X X X X X X X X X X X X[. X X X X X X X X[. X X X X X X X X X X X[. X X X[. X X X X X X X X X X X X X X X X X X X X X X X[. X X X[. X X X X X X X[. X X X X X X X X[. X X X[. X X[. X[. X X X[. X X X[. X X X[. X X X X X X X[. X X X X[. X X X[. X X X[. X X X X X X X[. X X X[. X X[. X X X[. X X X[. X X X[. X X X X X[. X X X X X X X X[. X X X[.[. X X X[. X X X[. X X X X X X X]. X X X]. X X X]. X X X]. X X X X X X X X X X[. X[. X X X[. X X X X X X[. X X X X X X X[. X X X X X X X X X X X X X X X X X X X X X[. X X X[. X X X X[. X X
 X[. X X[. X[. X[. X[.[. X[. X[. X[. X[.[. X[. X X[. X[.[.[.[. X[.[.[. X[.[.[. X X X[. X X X[. X[. X X[. X[. X[.[.[.[. X[. X X[. X X[. X[. X[. X[. X X[.[. X[.[.[. X[.[.[. X[.[.[. X[.[.[. X[.[.[. X[. X[.[. X[. X[. X[.[.[.[. X[.[.[. X[. X X[. X[. X[.[.[.[. X[.[.[. X[.[.[. X[. X[.[.[. X[.[.[. X X[. X[. X[.[.[.[. X[. X X[.[. X[.[. X[. X X[. X[. X X[. X[. X X[. X X X[. X X X[. X X X[. X X[. X[. X[.[.[. X X[. X[. X[. X[. X[. X[.[. X[. X X[. X[. X[. X X X[.[. X X[.[. X X[.[. X X[.[.[. X X[.[. X[.[. X[. X[.[. X[. X X X[. X]. X X[. X[. X].[. X[. X X X]. X X X]. X X X]. X X X]. X X].]. X]. X]. X X X[. X]. X]. X X]. X[. X]. X].[. X[. X X[. X[.[. X[.[.[. X[.[.[. X[.[.[. X[.[.]. X X[. X[. X[.[.[. X X[. X
[.[.[.[.[. X[.[.[.[. X[.[.[.[. X[.[.[. X[.[.[. X X[.[.[. X[.[.[.[. X[.[.[. X[.[.[.[.[.[.[.[.[.[. X[.[.[.[. X[.[.[. X[.[. X[.[.[.[.[. X[.[.[. X[. X[.[.[. X[.[.[.[.[.[. X[.[.[. X[.[.[. X[.[.[. X[.[. X[.[.[.[.[.[. X[.[.[. X[.[.[. X[.[. X[.[.[.[. X[.[.[. X[.[.[. X[.[.[. X[.[.[.[.[. X[.[.[. X X[.[.[.[. X[.[.[. X[.[. X[.[.[. X[.[.[.[.[.[.[.[. X[.[.[. X[.[.[.[.[.[.[.[.[.[.[.[.[.[.[.[.[.[.[.[.[. X[.[.[. X[.[.[.[.[.[. X[.[.[. X[.[.[.[.[.[.[.[.[.[.[. X[.[.[.[. X[.[.[. X[.[.[. X[.[.[. X[. X[.[.[.[. X[.[.[.[. X[.[.[. X X].]. X[. X]. X]. X].[. X].]. X].]. X].].]. X].].]. X].].]. X].]. X]. X]. X[. X X].]. X[. X]. X]. X]. X]. X].[. X]. X[.]. X]. X[.[.[. X[.[.[. X[.[.[. X[.[.[. X X[.[.[.[. X X[.[. X[.[.[.[.
[.[.[.[.[.[.[.[.[.[.[.[.[.[.[.[.[.[.[.[.[.[.[.[.[.[.[.[.[.[.[.[.[.[.[.[.[.[.[.[.[.[.[.[.[.[.[.[.[.[.[.[.[.[.[.[.[.[.[.[.[.[.[.[.[.[.].[.[.[.].[.[.[.[.[.[.[.[.[.[.[.[.[.[.[.[.[.[.[.[.[.[.[.[.[.[.[.[.[.[.[.[.[.[.[.[.[.[.[.[.[.[.[.[.[.[.[.[.[.[.[.[.[.[.[.[.[.[.[.[.[.[.[.[.[.[.[.[.[.[.[.[.[.[.[.[.[.[.[.[.[.[.[.[.[.[.[.[.[.[.[.[.[.[.[.[.[.[.[.[.[.[.[.[.[.[.[.[.[.[.[.[.[.[.[.[.[.[.[.[.[.[.[.[.[.[.[.[.[.[.[.[.[.[.[.[.[.[.[.[.[.[.[.[.[.[.[.[.[.[.[.[.[.[.[.[.[.[.[.[.[.[.[.[.[.[.[.[.[.[.[.[.[.[.[.[.[.[.[.[.[.[.[.[.[.[.[.].].].[.].[.].[.[.].[.[.].[.[.[.].]. X].].]. X].].]. X].].].].].].].].].].].[.[.].].].[.].[.].].].[.].[.[.[.].].].].].[.].[.[.[.[.[.[.[.[.[.[.[.[.[.[.[.[.[.].[.[.[.[.].].].[.[.].[.[.].
[.[.[.[.[.[.[.`.[.`.[.[.[.[.[.[.[.[.[.[.[.[.[.[.[.[.[.[.[.[.[.[.[.[.[.`.[.[.[.[.[.[.[.[.[.`.[.[.[.`.[.[.[.`.[.[.[.[.[.[.[.[.[.`.].].].].].[.].]._.[.].].].].].].].[.].].[.].].[.].[.].].].].].[.].[.[.[.[.[.[.[.[.[.[.[.].[.].[.].[.[.[.].[.].].[.].].[.].[.].[.`.[.[.`.[.`.[.[.[.[.`.[.[.[.[.`.[._.[.[.[._.[.[.[.[._.[.[.[.[.[.[.[.[.[.[.[.[.[.[.[.[.[.[.`.[.[.[.[.`.[.[.[.[.[.[.[.`.[.[.[.[.[.`.[.`.[.[.[.`.[.[.[.`.[.`.[.`.[.`.[.`.[.[.[.[.`.[.[.`.[.`.[.`.[.[.[.[.[.[.`.[.[.[.[.[.[.[.`.[.[.[.`.[.`.[.[.[.`.[.[.[.[.[.[.[.[.].].].].].].].].].].].].].].].].].].].].].].].].].].].].].].].].].].].].].].].].].].].].].].].].].].].].].].].].].].].].].].].].].].].].].].].].].].].].].].].].].].].].].].].].].].].].].].
`.`.`.`.`.`.[.`.[.`.`.`.`.`.`.`.`.`.`.`.`.`.`.`.`.`.`.`.`.`.`.`.`.`.[.`.`.`.`.`.`.`.`.`.[.`.`.`.[.`.`.`.[.`.`.`.`.`.`.`.`.`.[.`.].[._.].]._.].]._.].].[.]._.].].]._._.]._.].]._.]._._.].].].]._._.]._.[.]._.]._._.]._.]._.]._.]._.]._.[._.].]._.].[._.]._.]._.].[._._.[.[._._.[._.[.[._._.[._.[._.[._.[._.[._.[._._.[.[._._.[._.`.[._.`._.`._.[.`._.`.[.[.`.`.[._.[.[._.`.[._.`._.[.[._.`.[._.`.`.[.`.[.`.[.`.`.`.[.`.[.`.[.`.[.`.[.`.[.[.`.[.`.`.[.`.[.`.[.`.[.`.`.`.`.[.`.`.`.`.`.`.`.[.`.`.`.[.`.[.`.`.`.[.`.`.`.`.`.`.`.`.`.].]._.]._.].]._.].]._.].].]._.].].]._.]._.].].]._.]._.]._.].].].].]._.].].].]._.].].]._.].]._.].].]._.].].].]._._.].].].]._.].].]._.].].].]._.].]._.].].].]._.].]._.].].]._.].]._.].].].]._.
`.`.`.`.`.`._.`.`.`.`.`.`.`._.`.`.`.`.`.`.`.`.`.`.`.`.`.`.`.`.`.`.`.`.`.`.`.`.`.`.`.`.`.`.`.`.`.`.`.`.`.`.`.`.`.`.`.`.`.`.`.`.`._._.]._._._._._._.]._._._._.]._._._._.]._.]._.]._._._.]._._._._._._._._.]._._._._.]._.]._._._._._._._._.]._._._._._._.[._._._._.`.`._.`._.[._._.[._._._._._.[._._._.[._._._.[._._._.[._._._._._.`.`.`.`._.`._.`._.`.`.`._._._.`.`._._._.`.`.`.`.`._._._._.`._._.`.`.`.`.`.`.`.`.`.`.`.`.`.`._.`.`.`.`.`.`.`._._.`.`.`.`.`.`._.`.`.`.`.`.`.`.`.`.`.`.`.`.`.`.`.`._.`.`.`.`.`.`.`.`.`.`.`.`.`.`.`._._.]._.]._._.]._._._.]._._._.]._._._.]._.]._.]._._._.]._.]._._._._._.]._.]._._._._.]._._._._._._._._.]._.]._._._.]._.]._._._._.]._._._.]._._._.]._._._.]._._._._._.]._._._.]._._.]._._.]._.
_._._._._._._._._._._._._._._._._._._._._._._._._._._._._._._._._._._._._._._._._._._.`._._._.`._._._._._._._._._._._._._._._._._._._._._._._._._._._._._._._._._._._._._._._._._._._._._._._._._._._._._._._._._._._._._._._._._._._._._._._._._._._._._._._._._._._._._._._._._._._._._._._._._._._._._._._._._._._._._._._._._._._._._._._._._._._._._._._._._._._._._._._._._._._._._._._._._._._._._._._._._._._._._._._._._._._._._._._._._._._._._._._._._._._._._._._._._._._._._._._.`._._._._._._._._._._._._._._._._._._._._._._._._._._._._._._._._._._._._._._._._._._._._._._._._._._._._._._._._._._._._._._._._._._._._._._._._._._._._._._._._._._._._._._._._._._._._._._._._._._._._._._._._._._._._._._.
_._._./._./._._._._._._._._./._._._._./._./._._._._._._._._./._./._._./._.`._./._._./._./._._./._._._./._._._././._._./._._._._._._./._./._._._./._./._._._._./._._._._._._._./._./._._._._._._._._._./._./._._._._._._._._./._._._._./._./._._._._._._._._./._._._._._./._./._._._./._./._._./._./._./._._._./._._._._._._._./._._./._./._._./._._._./._._._./._._._./._._._._._./._._._._._._._._._._._._./._./._./._._._._._._._._._._._./._./._./._._._./._._./._./._._._._._._./._./._._./._._._./._._._./._./._./._._._._._._./._./._._./._._._././._./._._._._._./._./._._._._._._./._._._._./._._./._._._._._._._._./._._._./._._._._._._._._./._._./._._._._._./._./._._._./._./._._./._._._././._./._._._._._./._.
/./._././././././././././././._././._././././././././././././._././././././._././././._././././././././././././././././././././././._./._././././._././././././._./././././._./././././././././._./._././././././././././././._._./._././././././././././././._./././././._./././././._./././././._././././././._./././././._././././._./././././././././././././././././././././././././././././././././././._./._./././././././././././././._./._././././._./._././././././././././._././././././././././././._././././././././././._./././././././././._././._./././._./._./././././._././././._./././././././././././././._./._././././././././._./././._././././././._./././././._./././././././././._./././././././._.
/././././././././././././././.~./././././././././././././././.~./././././././././././././././././././././././././././././././././././.~./././././././././././././././././././././././.~./././././././././././././././././././.~./././././././././././././././././././././././././././.~./././././././././././././././././././././././././././././././././././././././././././././././././././././././././././././././././././.~./././././././././././././././.~./././././././././././.~./././././././././././././././././././././././././././././././././././././././././././././././.~././././././././././././././././././././././././././././././././././././././././././././././././././././././././././././././././././.
/.~./././.~./.~.~./././.~./.~.~./.~./././.~./.~.~./././.~./.~.~./././././.~././.~./.~././././././././.~././.~.~././././.~./././.~./.~.~./.~./.~./././.~././.~.~./.~./.~.~./.~././.~./.~./././.~./.~./././.~./.~.~./././.~./.~.~./.~./././.~./.~.~./././.~./.~././././.~././././.~./.~.~./././././././.~././.~.~./.~./.~.~./.~./.~./.~././././././././.~././.~.~././././.~././././.~./.~./././.~./.~./././.~./.~.~./././.~./.~.~./.~./././.~./.~.~./././.~./.~.~././.~./.~./././.~./.~.~./././././././.~././.~.~././.~./.~./././.~./.~.~././././././././././.~.~./.~./.~.~./.~./.~./.~.~./.~./.~./././././.~.~.~.~./././.~./.~.~.~./././.~./.~.~.~./.~./.~./.~.~./././.~././././.~./.~.~././././././././././.~.~./././.~.~./.
~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~./.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.
~.~.E.~.~.~.E.~.~.~.~.~.~.E.~.~.~.~.E.~.~.~.E.~.~.~.~.~.~.E.~.~.~.~.~.E.~.~.~.E.~.~.~.E.~.~.E.~.~.~.E.~.~.~.~.~.~.E.~.~.~.~.~.~.~.~.~.~.~.E.~.~.~.~.~.~.~.~.~.~.~.E.~.~.~.~.~.~.~.~.~.~.~.E.~.~.~.~.E.~.~.~.E.~.~.~.~.~.~.E.~.~.~.~.~.E.~.~.~.E.~.~.E.~.~.~.E.~.~.~.E.~.~.~.E.~.~.~.~.~.~.E.~.~.~.~.~.~.~.~.~.~.~.E.~.~.~.~.~.~.~.~.~.E.~.~.E.~.~.~.~.~.~.~.~.~.~.E.~.~.~.~.~.~.~.~.~.E.~.~.E.~.~.~.E.~.~.~.E.~.~.~.~.~.~.E.~.~.~.~.E.~.~.~.E.~.~.~.~.~.~.E.~.~.~.E.~.~.~.~.~.~.~.~.~.~.~.E.~.~.~.~.~.~.~.~.~.~.~.E.~.~.~.~.~.~.~.~.E.~.~.E.~.~.~.~.~.~.~.~.E.~.~.E.~.~.~.~.~.~.~.~.~.~.~.T.~.~.~.~.~.~.~.E.~.~.~.~.~.~.E.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.~.E.E.~.~.~.~.E.~.~.~.~.~.~.~.~.E.~.~.E.~.~.~.~.
E.~.~.~.E.~.~.~.E.E.~.~.E.E.~.~.E.~.~.~.E.~.~.~.E.E.~.~.E.E.~.~.E.~.~.~.~.E.~.E.~.E.~.~.E.~.E.~.E.~.~.E.~.E.~.~.E.~.E.~.E.~.E.E.~.E.~.~.E.~.E.~.E.~.E.E.~.E.~.~.E.~.E.~.E.~.E.E.~.E.~.~.E.~.E.~.E.~.~.~.E.~.~.~.E.E.~.~.E.E.~.~.E.~.~.~.E.~.~.~.E.E.~.~.E.E.~.~.E.~.~.~.~.E.~.E.~.E.~.~.E.~.E.~.E.~.E.E.~.E.~.~.E.~.E.~.E.~.E.E.~.E.~.~.E.~.E.~.E.~.E.E.~.E.~.~.E.~.E.~.E.~.E.E.~.E.E.~.E.~.~.~.E.~.~.~.E.~.~.~.E.E.~.~.E.E.~.~.E.~.~.~.E.~.~.~.E.E.~.~.E.E.~.~.E.~.E.~.E.~.E.E.~.E.~.~.E.~.E.~.E.~.E.E.~.E.~.~.E.~.E.~.E.~.E.E.E.~.~.~.E.~.E.~.~.~.T.~.E.~.~.~.E.~.E.~.~.~.T.~.T.~.~.~.T.~.~.~.T.~.~.~.E.~.E.~.E.E.~.E.~.E.~.E.E.E.~.E.T.E.~.E.E.E.~.E.T.E.~.E.E.E.~.E.~.~.E.~.E.~.~.~.E.~.E.~.~.~.T.~.E.~.~.~.E.~.E.~.~.~.
E.E.E.E.E.E.E.E.E.~.E.E.E.~.E.E.E.E.E.E.E.E.E.E.E.~.E.E.E.~.E.E.E.E.E.E.E.~.E.E.E.E.E.E.E.E.~.E.E.E.~.E.E.E.E.E.E.E.~.E.E.E.~.E.E.E.E.E.E.E.~.E.E.E.~.E.E.E.E.E.E.E.~.E.E.E.~.E.E.E.E.E.E.E.~.E.E.E.E.E.E.E.E.E.E.~.E.E.E.~.E.E.E.E.E.E.E.E.E.E.E.~.E.E.E.~.E.E.E.E.E.E.E.~.E.E.E.E.E.E.E.E.~.E.E.E.~.E.E.E.E.E.E.E.~.E.E.E.~.E.E.E.E.E.E.E.~.E.E.E.~.E.E.E.E.E.E.E.~.E.E.E.~.E.E.~.E.E.E.E.E.E.E.E.E.E.E.E.E.E.E.~.E.E.E.~.E.E.E.E.E.E.E.E.E.E.E.~.E.E.E.~.E.E.E.E.~.E.E.E.~.E.E.E.E.E.E.E.~.E.E.E.~.E.E.E.E.E.E.E.~.E.E.E.~.E.~.E.T.T.~.T.~.E.T.T.~.T.~.E.T.T.~.T.~.E.T.T.~.T.~.E.T.T.~.E.T.~.~.T.T.E.~.T.~.T.E.~.T.~.T.~.T.~.E.~.T.~.E.~.T.~.E.~.T.~.E.~.T.~.~.E.E.E.E.E.E.E.~.E.T.T.~.T.~.E.T.T.~.T.~.E.T.T.~.T.~.E.T.T.
E.E.E.E.E.E.E.E.E.E.E.E.E.E.E.E.E.E.E.E.E.E.E.E.E.E.E.E.E.E.E.E.E.E.E.E.E.E.E.E.E.E.E.E.E.E.E.E.E.E.E.E.E.E.E.E.E.E.E.E.E.E.E.E.E.E.E.E.E.E.E.E.E.E.E.E.E.E.E.E.E.E.E.E.E.E.E.E.E.E.E.E.E.E.E.E.E.E.E.E.E.E.E.E.E.E.E.E.E.E.E.E.E.E.E.E.E.E.E.E.E.E.E.E.E.E.E.E.E.E.E.E.E.E.E.E.E.E.E.E.E.E.E.E.E.E.E.E.E.E.E.E.E.E.E.E.E.E.E.E.E.E.E.E.E.E.E.E.E.E.E.E.E.E.E.E.E.E.E.E.E.E.E.E.E.E.E.E.E.E.E.E.E.E.E.E.E.E.E.E.E.E.E.E.E.E.E.E.E.E.E.E.E.E.E.E.E.E.E.E.E.E.E.E.E.E.E.E.E.E.E.E.E.E.E.E.E.E.E.E.E.E.E.E.E.E.E.E.E.E.E.E.E.E.E.E.~.T.T.~.T.T.~.T.E.~.T.E.~.T.T.~.T.T.~.T.E.~.T.E.T.T.~.T.~.T.~.T.T.~.T.~.T.~.E.E.T.~.T.~.T.~.E.E.T.~.T.~.T.~.E.E.T.~.T.~.T.~.E.E.T.E.E.E.E.E.E.E.E.E.E.E.E.E.E.E.E.E.E.E.E.E.E.E.E.E.E.E.E.E.
E.Y.E.E.E.Y.E.E.E.Y.E.E.E.Y.E.E.E.E.Y.E.E.E.Y.E.E.E.Y.E.E.E.Y.E.Y.E.E.E.E.Y.E.E.E.E.E.Y.E.E.Y.E.E.E.E.Y.Y.E.E.E.E.Y.E.E.Y.E.Y.E.E.E.T.E.E.T.T.E.E.T.T.E.E.E.T.E.E.T.T.E.E.T.T.E.E.E.T.E.E.T.T.E.T.E.T.E.E.T.E.E.T.E.T.E.E.T.E.E.T.E.T.E.E.T.E.E.T.E.T.E.E.T.E.E.E.E.E.Y.Y.E.E.E.E.Y.E.E.E.Y.E.E.Y.E.E.E.E.Y.E.E.E.Y.E.E.Y.E.E.E.Y.E.Y.E.Y.E.E.E.E.Y.E.E.E.Y.E.E.E.E.E.Y.E.E.E.Y.E.Y.E.E.I.E.E.E.E.Y.E.E.E.Y.E.E.E.Y.E.E.E.Y.E.E.E.E.Y.E.E.E.Y.E.E.E.Y.E.E.E.Y.E.E.E.Y.E.E.E.E.Y.Y.E.E.E.E.Y.Y.E.E.E.E.Y.E.E.Y.E.Y.E.E.E.E.Y.E.E.E.T.T.E.E.T.T.T.T.T.T.T.T.T.T.E.E.T.T.T.T.T.T.T.~.T.T.T.T.T.T.T.T.T.T.T.T.T.T.T.T.T.T.T.T.T.T.T.T.T.T.T.T.T.T.T.T.T.T.T.T.T.T.T.T.E.E.T.E.E.T.E.E.T.E.E.T.E.E.T.E.E.T.E.E.T.E.E.T.E.E.T.E.T.
Y.Y.E.Y.Y.Y.E.Y.Y.Y.E.Y.Y.Y.E.Y.Y.Y.Y.E.Y.Y.Y.E.Y.Y.Y.E.Y.Y.Y.E.Y.E.Y.Y.Y.E.Y.Y.Y.Y.E.Y.Y.Y.E.Y.Y.Y.Y.E.Y.E.Y.E.Y.Y.E.Y.Y.Y.Y.E.T.T.T.T.I.E.T.E.T.E.T.T.T.T.T.T.I.E.T.E.T.E.T.T.T.T.T.T.I.E.T.E.T.T.E.T.I.E.E.T.T.T.E.T.I.E.E.T.T.T.E.T.I.E.E.T.T.T.E.T.I.E.E.T.Y.E.I.E.Y.E.E.Y.I.E.Y.Y.E.Y.I.E.Y.E.E.Y.I.E.Y.Y.E.Y.I.E.Y.E.E.Y.E.Y.Y.E.Y.E.E.Y.I.E.Y.Y.E.Y.I.E.E.I.E.E.I.E.I.E.I.E.I.E.E.E.I.E.Y.Y.E.Y.Y.Y.E.Y.Y.Y.E.Y.Y.Y.E.Y.Y.Y.Y.E.Y.Y.Y.E.Y.Y.Y.E.Y.Y.Y.E.Y.Y.E.E.Y.E.Y.Y.Y.E.Y.E.Y.Y.E.E.Y.E.Y.Y.E.Y.Y.E.Y.E.Y.Y.E.Y.Y.Y.T.T.T.T.T.T.T.T.T.T.T.T.T.T.T.T.T.T.T.T.T.T.T.T.T.T.T.T.T.T.T.T.T.T.T.T.T.T.T.T.T.T.T.T.T.T.T.T.T.T.T.T.T.T.T.T.T.T.T.T.T.T.T.T.T.E.T.T.T.T.T.T.T.T.T.T.T.E.T.T.T.T.T.T.T.T.T.T.T.T.T.T.T.T.
Y.Y.Y.Y.Y.Y.Y.Y.Y.Y.Y.Y.Y.Y.Y.Y.Y.Y.Y.Y.Y.Y.Y.Y.Y.Y.Y.Y.Y.Y.Y.Y.Y.Y.Y.Y.Y.Y.Y.Y.Y.Y.Y.Y.Y.Y.Y.Y.Y.Y.Y.Y.Y.Y.Y.Y.Y.Y.Y.Y.Y.Y.Y.Y.T.T.I.E.T.I.I.T.I.I.T.I.T.T.I.T.T.I.I.T.I.I.T.I.T.T.I.E.T.I.I.T.T.I.T.I.T.I.I.E.T.I.T.I.T.I.I.E.T.I.T.I.T.I.I.E.T.I.T.I.T.I.I.E.I.Y.Y.I.E.I.I.E.Y.Y.I.E.I.E.I.I.E.I.I.E.Y.Y.I.E.I.E.I.I.E.I.I.E.I.E.I.I.E.I.I.E.Y.Y.I.E.I.E.I.I.E.I.I.I.I.E.I.E.I.E.I.I.I.E.I.E.Y.Y.Y.Y.Y.Y.Y.Y.Y.Y.Y.Y.Y.Y.Y.Y.Y.Y.Y.Y.Y.Y.Y.Y.Y.Y.Y.Y.Y.Y.Y.Y.Y.Y.I.Y.Y.Y.Y.Y.Y.Y.Y.Y.Y.Y.I.Y.Y.Y.Y.Y.Y.Y.Y.Y.Y.Y.Y.Y.I.Y.Y.Y.I.T.T.T.T.T.I.T.I.T.T.T.T.T.I.T.T.T.I.T.I.T.T.T.I.T.T.T.T.T.I.T.I.T.T.I.T.T.T.T.I.T.T.I.T.T.T.T.I.T.T.I.T.T.T.T.I.T.T.I.T.T.T.T.I.I.T.I.T.I.T.T.I.T.I.T.I.I.T.I.I.T.T.T.I.T.T.I.I.T.T.I.T.I.
Y.I.Y.I.Y.I.Y.I.Y.I.Y.I.Y.I.Y.I.I.Y.I.Y.Y.Y.I.Y.I.Y.I.Y.Y.Y.I.Y.Y.Y.Y.Y.I.Y.I.Y.Y.I.Y.Y.I.Y.I.Y.Y.I.Y.I.Y.I.Y.I.I.Y.I.Y.Y.Y.Y.I.I.I.I.I.T.I.I.I.I.T.I.I.I.I.I.I.T.I.I.I.I.T.I.I.I.I.I.I.I.I.I.I.I.I.I.T.I.I.I.I.I.I.I.T.I.I.I.I.I.I.I.T.I.I.I.I.I.I.I.T.I.I.I.I.I.Y.I.I.I.Y.I.I.Y.I.I.I.I.I.I.Y.I.I.I.Y.Y.I.I.I.I.I.I.I.I.Y.I.I.I.I.I.I.I.Y.I.I.I.E.I.I.I.I.I.E.I.I.E.I.E.I.I.I.I.E.I.I.E.I.I.I.Y.I.Y.I.Y.I.Y.I.Y.I.Y.I.Y.I.Y.I.I.Y.I.Y.Y.Y.I.Y.I.Y.I.Y.Y.Y.I.Y.I.Y.I.Y.I.I.Y.I.I.Y.I.Y.Y.I.Y.I.I.I.Y.I.Y.I.Y.I.Y.I.Y.I.I.Y.I.Y.I.I.I.I.T.I.I.I.I.T.I.I.I.I.I.I.I.I.I.I.I.T.I.I.I.I.I.I.I.I.I.I.I.T.I.I.I.I.T.I.I.T.I.I.I.I.T.I.I.T.I.I.I.I.T.I.I.T.I.I.I.I.T.I.I.T.I.I.I.T.I.I.I.T.I.I.T.I.I.T.I.I.I.I.I.I.I.I.I.T.I.I.I.I.
I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.L.I.L.I.I.I.I.L.I.Y.L.I.I.I.I.Y.I.I.I.Y.I.I.I.Y.I.I.I.I.L.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.
I.L.L.I.L.I.I.L.I.L.L.I.L.I.I.L.L.I.L.L.I.L.L.I.L.I.L.L.I.L.L.L.L.I.L.I.I.L.L.I.I.L.L.I.L.L.L.L.L.L.I.L.L.L.I.L.L.I.L.I.I.L.L.I.L.I.I.L.I.I.L.L.I.I.L.I.I.I.L.I.I.L.L.I.I.I.I.I.L.I.I.I.I.I.L.L.I.L.I.I.L.I.I.L.I.L.I.I.L.I.I.L.I.L.I.I.L.I.I.L.I.L.I.I.L.I.I.L.I.I.L.I.I.I.L.I.I.I.L.I.I.L.I.I.L.I.I.L.I.I.L.L.I.I.L.I.I.I.L.I.I.I.L.I.I.I.L.I.L.I.I.L.L.I.L.L.I.L.L.I.L.L.L.L.L.L.I.L.I.L.I.L.I.L.L.I.L.I.I.L.I.L.L.I.L.I.L.L.L.I.L.L.I.L.L.I.L.I.L.L.I.L.L.L.I.L.I.L.L.I.I.L.L.I.I.L.L.I.L.I.I.L.I.L.I.L.I.L.L.I.L.I.I.L.L.I.L.I.I.L.I.I.L.L.I.I.L.I.I.I.L.I.I.I.L.I.I.I.I.I.L.I.I.I.I.I.L.L.I.I.I.I.I.L.L.I.L.I.I.I.I.L.L.L.L.I.I.I.I.L.L.I.L.I.I.I.I.L.L.L.I.I.L.I.I.L.I.L.I.I.I.L.L.I.I.L.L.I.I.I.I.I.L.I.I.I.L.I.I.I.
L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.I.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.I.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.I.L.
L.L.L.L.H.L.H.L.L.H.L.H.L.L.L.H.L.L.L.L.L.L.L.H.L.L.L.L.L.H.L.L.L.L.H.L.L.H.L.L.L.L.L.L.L.H.L.L.L.L.L.H.H.L.H.L.L.L.L.H.L.L.L.L.L.H.L.L.L.L.L.H.L.L.L.L.L.L.L.L.L.L.L.H.L.L.L.L.L.L.L.H.L.L.L.L.L.L.L.H.L.L.L.L.L.H.L.L.L.L.L.H.L.L.L.H.L.L.L.L.L.H.L.L.L.L.L.H.H.L.H.L.H.L.H.L.L.L.L.H.L.L.L.L.L.L.L.L.L.H.L.L.L.L.L.H.H.L.H.L.L.L.L.L.L.L.L.L.L.L.L.H.L.L.L.L.L.L.L.L.L.H.L.L.L.L.L.L.L.L.L.L.L.L.L.H.L.L.L.L.L.L.L.L.L.H.L.L.L.L.L.L.L.L.L.H.L.H.L.L.L.L.L.H.L.L.H.L.L.H.L.L.L.L.L.L.L.H.L.L.H.L.H.L.H.L.H.L.L.L.L.L.H.L.H.L.L.H.L.L.L.L.L.H.L.L.L.H.H.L.H.L.L.L.L.L.L.L.L.L.L.L.L.H.L.L.L.L.L.L.L.H.L.L.L.L.L.H.L.L.L.L.L.H.L.L.L.L.L.L.L.H.L.H.L.L.L.L.L.H.L.L.L.H.H.L.H.L.L.L.L.H.L.L.L.L.L.H.L.L.L.L.L.H.L.L.L.H.H.L.
H.H.H.L.H.L.H.H.H.L.H.L.H.H.H.L.L.H.H.H.H.H.L.H.H.H.H.H.L.H.H.H.H.L.H.H.L.H.H.H.H.H.H.H.L.H.H.H.H.H.H.H.H.L.H.H.H.H.L.H.H.H.H.H.H.H.H.H.H.H.L.H.H.H.H.H.H.H.H.H.L.H.L.H.H.H.H.H.H.H.L.H.H.H.H.H.H.H.L.H.H.H.H.H.L.H.H.H.H.H.L.H.H.H.L.H.H.H.H.H.L.H.H.H.H.H.L.H.H.L.H.L.H.L.H.H.H.H.H.H.H.H.H.H.H.H.H.H.L.H.H.H.H.H.H.H.H.L.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.L.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.L.H.H.H.L.H.H.H.H.H.L.H.L.H.H.H.H.H.L.H.L.H.L.H.L.H.H.H.H.H.H.H.L.H.H.H.L.H.L.H.L.H.L.H.H.H.H.L.H.L.H.H.L.H.H.H.H.H.L.H.H.H.H.H.H.L.H.H.L.H.H.H.H.L.H.H.H.H.L.H.H.H.H.H.H.H.L.H.H.H.H.H.H.H.H.H.H.H.L.H.L.H.H.H.H.H.L.H.L.H.H.H.H.H.L.H.H.H.H.H.H.L.H.H.H.H.H.H.H.H.H.H.L.H.H.H.H.H.L.H.H.H.H.H.H.L.
H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.H.
H.H.H.S.S.H.H.H.S.H.H.H.H.H.H.S.H.S.H.H.H.H.S.H.H.S.H.H.H.H.S.H.H.H.H.H.S.H.H.H.S.H.H.H.S.H.H.H.H.H.H.H.H.H.H.H.H.H.H.S.S.H.H.H.H.H.H.H.H.H.H.S.H.H.H.S.H.H.H.H.H.S.H.H.H.S.H.H.H.S.H.H.H.S.H.H.H.H.H.S.S.H.H.H.S.H.H.H.H.H.H.S.H.H.H.S.S.H.H.H.S.H.H.H.H.H.H.S.H.H.S.H.H.H.H.H.H.H.H.H.S.H.H.H.H.S.H.H.H.H.S.H.H.H.H.H.H.H.H.H.H.H.S.H.H.H.S.H.H.H.H.H.S.H.H.H.H.S.H.H.H.H.S.H.H.H.S.H.H.H.S.H.H.H.H.H.S.H.H.H.H.S.H.H.H.H.S.H.H.H.S.H.H.S.H.H.S.H.H.H.H.H.H.S.H.H.S.H.S.H.H.H.S.H.H.H.S.H.H.H.S.H.H.H.S.H.H.H.H.H.H.S.S.H.H.H.S.H.H.H.H.H.H.S.H.H.H.H.H.H.H.H.Z.H.H.H.Z.H.H.H.H.Z.H.H.H.H.H.H.H.H.H.S.S.H.H.H.H.H.H.H.H.H.H.S.H.H.S.H.H.S.H.H.S.H.H.H.H.H.H.S.H.H.H.H.H.H.H.H.H.H.H.H.S.H.H.H.S.H.H.H.H.H.H.S.H.H.H.H.H.H.
H.S.S.H.H.H.S.H.H.H.S.H.H.S.S.H.S.H.H.S.S.S.H.S.H.S.H.H.H.H.S.H.S.S.H.S.H.S.H.S.H.S.H.S.H.S.H.S.S.H.H.S.H.H.S.H.H.S.S.H.H.H.S.H.S.H.S.S.S.H.H.H.S.H.S.H.S.H.S.S.S.H.S.H.S.H.S.H.S.H.S.H.S.H.S.H.H.S.S.H.H.H.S.H.H.H.S.H.H.S.S.H.H.S.S.H.H.H.S.H.H.H.S.H.H.S.S.H.S.S.H.S.H.H.S.H.H.S.S.H.H.H.S.H.H.S.H.H.H.H.S.H.S.H.H.S.H.H.S.H.S.H.H.S.H.S.H.H.H.H.S.H.H.H.S.H.H.S.H.H.H.H.S.H.S.H.H.S.H.S.H.H.H.S.S.H.H.H.S.H.H.S.H.H.S.H.H.S.H.H.S.H.S.S.H.S.H.H.S.H.H.S.S.H.S.H.H.S.H.S.H.S.H.S.H.S.H.S.H.S.H.H.S.H.S.H.S.S.H.S.S.H.H.H.S.H.H.H.Z.H.H.S.H.S.Z.H.H.Z.H.H.Z.H.H.H.H.Z.H.H.H.H.H.Z.H.H.Z.H.H.Z.H.S.H.S.H.H.H.Z.H.H.S.S.H.H.Z.H.H.H.Z.H.S.S.H.S.H.H.S.H.H.S.H.S.S.H.H.S.H.S.H.H.S.H.H.S.H.H.H.S.H.S.H.H.S.H.H.S.S.H.H.S.H.S.
S.S.H.S.S.S.S.S.S.S.S.S.S.H.S.S.H.S.S.S.S.H.H.S.S.S.S.S.S.S.S.S.H.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.H.S.S.S.S.S.S.H.S.S.H.S.S.S.S.S.S.S.S.H.S.S.H.S.S.H.S.S.S.H.S.S.S.H.S.S.S.H.S.S.H.S.S.S.S.S.S.S.S.S.S.S.H.S.S.S.H.S.S.S.S.S.S.S.S.S.S.S.H.S.S.S.H.H.S.S.S.S.S.S.H.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.H.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.H.H.S.S.S.S.S.S.H.S.S.S.S.S.S.H.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.H.S.S.H.S.S.H.S.S.S.S.S.Z.H.H.Z.Z.H.Z.H.H.Z.Z.H.Z.H.H.Z.S.Z.H.Z.Z.Z.Z.H.Z.H.Z.H.H.Z.H.Z.Z.H.Z.H.Z.S.Z.H.Z.H.S.H.Z.Z.H.H.Z.Z.H.H.S.H.H.S.Z.H.S.S.Z.H.Z.H.S.S.S.S.S.H.Z.S.S.S.S.H.Z.S.S.S.S.H.Z.S.S.S.S.H.S.S.S.S.S.H.
S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.H.Z.S.S.Z.H.H.Z.S.S.Z.H.H.Z.S.S.Z.H.Z.H.H.Z.H.Z.Z.Z.Z.Z.Z.H.Z.H.Z.H.H.Z.S.S.Z.H.S.S.Z.H.Z.S.S.S.Z.S.S.S.Z.H.Z.Z.H.Z.S.S.S.S.H.Z.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.
S.S.C.S.S.C.S.S.C.S.S.C.S.S.C.S.S.C.S.S.C.S.S.C.S.C.S.S.C.S.S.S.S.C.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.S.C.S.S.C.S.S.C.S.S.C.S.S.Z.S.Z.S.Z.S.Z.S.Z.S.Z.S.Z.S.Z.S.Z.S.Z.S.Z.S.Z.S.Z.S.Z.S.Z.S.Z.S.S.Z.S.Z.S.Z.S.Z.Z.S.Z.S.Z.S.Z.S.Z.S.Z.S.Z.S.Z.S.Z.S.Z.S.Z.S.Z.S.C.S.S.C.S.C.S.S.C.S.S.C.S.S.C.S.S.C.S.S.C.S.S.C.S.S.S.S.C.S.S.S.S.S.S.S.S.S.S.S.B.S.S.S.S.B.S.S.S.C.S.S.C.S.S.C.S.S.S.S.S.S.C.S.S.S.C.S.S.C.S.S.S.C.S.S.S.S.S.S.C.S.S.C.S.S.C.S.S.C.S.S.C.S.S.C.S.S.C.S.S.C.S.S.S.S.S.S.S.S.S.S.S.C.S.S.C.S.S.C.S.S.C.S.S.C.S.S.S.Z.Z.Z.Z.Z.S.Z.Z.Z.Z.Z.S.Z.Z.Z.Z.S.Z.Z.Z.Z.Z.Z.Z.H.Z.H.Z.Z.Z.Z.Z.Z.S.Z.Z.Z.Z.Z.S.Z.Z.Z.S.Z.S.Z.S.Z.S.Z.Z.Z.S.Z.Z.S.Z.S.Z.Z.Z.S.S.Z.S.Z.S.Z.S.Z.S.Z.S.Z.S.Z.S.Z.S.Z.S.Z.S.Z.S.Z.S.Z.S.Z.S.S.
C.C.C.S.C.S.C.C.S.C.C.C.S.C.C.S.C.S.C.C.S.C.C.C.S.C.C.S.C.S.C.C.C.C.S.C.C.C.S.C.C.C.S.C.C.C.S.C.C.C.C.S.C.S.C.C.S.C.C.C.S.C.C.S.S.Z.Z.S.Z.Z.S.Z.Z.S.Z.Z.S.Z.Z.S.Z.Z.B.S.B.S.Z.Z.B.S.Z.Z.Z.Z.B.S.B.S.Z.Z.S.Z.Z.Z.Z.Z.S.Z.Z.Z.Z.Z.Z.Z.Z.S.B.S.S.S.B.S.S.B.S.Z.Z.S.C.S.S.C.S.S.S.B.S.S.B.S.C.S.S.C.S.B.S.S.B.S.C.S.S.S.B.S.C.S.S.C.B.S.S.B.S.S.S.B.S.S.B.S.B.S.S.S.B.S.S.S.B.S.C.S.S.C.S.S.S.B.S.S.C.S.C.C.S.C.C.S.C.C.S.C.C.S.C.C.S.C.S.S.C.C.S.C.C.S.C.C.S.C.C.S.S.C.C.S.S.C.C.S.S.C.C.S.C.C.S.C.C.C.S.C.C.S.C.C.S.C.C.S.C.C.S.C.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.
C.C.C.C.C.C.C.C.C.C.C.C.C.C.C.C.C.C.C.C.C.C.C.C.C.C.C.C.C.C.C.C.C.C.C.C.C.C.C.C.C.C.C.C.C.C.C.C.C.C.C.C.C.C.C.C.C.C.C.C.C.C.C.C.B.Z.B.Z.Z.B.B.Z.B.Z.Z.B.B.Z.B.Z.B.Z.Z.Z.Z.Z.B.Z.Z.Z.B.S.B.Z.Z.B.Z.B.S.B.B.S.B.Z.S.B.B.S.B.S.Z.B.S.B.B.Z.Z.B.B.Z.Z.B.B.Z.B.S.B.Z.B.B.C.C.B.B.C.C.B.S.C.C.B.B.B.S.C.C.B.S.C.C.B.B.B.S.C.C.B.B.B.S.B.B.S.B.B.B.B.S.B.S.C.C.S.B.B.S.C.B.B.S.C.C.B.B.C.C.B.B.C.C.B.S.B.C.C.C.C.C.C.C.C.C.C.C.C.C.C.C.C.C.B.C.C.C.C.C.C.C.C.C.C.C.C.C.C.C.C.C.C.C.C.C.C.C.C.C.C.C.C.C.C.C.C.C.C.C.C.C.C.C.C.C.C.C.C.C.Z.Z.B.Z.B.Z.Z.Z.Z.B.Z.Z.B.Z.Z.Z.B.Z.Z.Z.B.Z.Z.B.B.Z.Z.Z.B.Z.Z.B.B.Z.B.Z.Z.Z.B.Z.B.Z.Z.Z.Z.B.Z.Z.Z.Z.B.Z.B.Z.Z.Z.Z.B.Z.Z.Z.B.Z.B.Z.B.Z.Z.B.Z.B.Z.Z.Z.B.Z.B.Z.Z.Z.B.Z.Z.Z.Z.B.Z.Z.B.Z.Z.Z.Z.B.
B.C.B.C.C.B.B.N.C.C.B.C.B.C.B.C.C.B.B.N.C.C.B.C.B.C.B.C.C.B.B.N.C.C.C.B.C.C.B.B.C.C.C.B.C.C.B.B.B.C.B.C.C.B.B.N.C.C.B.C.B.C.B.C.B.B.B.B.B.B.B.Z.Z.B.B.B.B.B.B.N.B.Z.Z.B.B.B.B.B.B.B.B.B.B.Z.B.B.B.B.B.B.B.B.B.B.B.B.B.B.Z.B.B.B.B.B.B.B.B.B.B.Z.B.B.B.Z.B.B.B.B.B.S.B.B.C.B.B.C.B.B.B.B.B.C.B.C.B.B.C.B.C.B.B.C.B.B.B.B.B.C.B.C.B.B.S.B.B.C.B.B.B.B.B.B.B.B.B.B.B.B.C.B.C.B.B.C.B.B.B.B.B.B.C.B.C.B.B.C.B.C.B.N.B.C.B.C.C.B.B.C.C.B.B.B.B.C.B.C.C.B.B.C.B.C.B.N.B.B.C.B.B.B.B.B.B.B.C.B.C.B.B.C.C.B.B.C.B.C.B.N.B.C.B.C.C.B.B.C.B.B.B.B.B.Z.B.B.Z.B.B.B.B.B.B.B.Z.B.B.B.B.Z.B.B.B.Z.B.B.B.Z.B.B.B.B.B.Z.B.B.B.B.B.Z.B.B.Z.B.B.B.B.B.B.B.B.Z.B.B.Z.B.B.B.B.B.B.B.B.B.Z.B.B.B.B.Z.B.B.B.B.B.Z.B.B.B.Z.B.B.Z.B.B.B.B.B.B.B.B.B.
B.B.B.N.B.B.B.N.N.B.B.B.B.B.B.N.B.B.B.N.N.B.B.B.B.B.B.N.B.B.B.N.B.N.B.B.B.N.N.N.B.N.B.B.B.N.N.N.B.B.B.N.B.B.B.N.N.B.B.B.B.B.B.N.B.B.B.N.B.B.B.B.B.B.B.B.B.B.B.N.B.B.B.B.B.B.B.N.B.B.B.B.B.B.N.N.B.B.B.B.B.B.B.N.B.B.B.B.B.B.B.B.B.B.B.N.B.B.B.B.B.B.B.B.B.B.B.N.B.B.B.B.B.B.B.B.B.B.B.N.B.B.B.B.B.B.B.B.B.B.B.B.B.B.B.N.B.B.B.B.B.B.B.B.B.B.B.B.B.B.B.N.B.B.B.B.B.B.B.B.B.B.B.B.B.B.B.N.B.B.B.B.B.B.B.B.B.B.B.N.B.B.B.B.B.B.B.B.B.B.B.N.B.B.B.B.B.B.B.B.B.B.B.N.B.B.B.B.B.B.N.N.B.B.B.B.B.B.N.N.B.B.B.B.B.B.B.N.B.B.B.B.B.B.B.B.B.B.B.N.B.B.B.B.B.B.B.B.B.B.B.N.B.B.B.B.B.B.N.N.B.B.B.B.B.B.N.N.B.B.B.B.B.B.B.N.B.B.B.B.B.B.B.B.B.B.B.N.B.B.B.B.B.B.B.B.B.B.B.N.B.B.B.B.B.B.B.B.B.B.B.N.B.B.B.B.B.B.B.B.B.B.B.B.B.B.B.N.B.B.
N.N.N.N.N.N.N.N.N.N.N.N.N.N.N.N.N.N.N.N.N.N.N.N.N.N.N.N.N.N.N.N.N.N.N.N.N.N.N.N.N.N.N.N.N.N.N.N.N.N.N.N.N.N.N.N.N.N.N.N.N.N.N.N.N.N.N.N.N.N.N.N.B.B.N.N.N.N.N.N.B.N.N.N.N.N.N.N.B.N.N.N.N.N.N.N.B.B.N.N.N.N.N.N.N.N.N.N.B.N.N.N.N.N.N.N.N.N.N.N.B.B.N.N.N.N.N.N.N.N.N.N.B.N.N.N.N.N.N.N.N.N.N.N.N.N.N.N.B.N.N.N.N.N.N.N.N.N.N.N.N.N.N.N.B.N.N.N.N.N.N.N.N.N.N.N.N.N.N.N.B.N.N.N.N.N.N.N.N.N.N.N.N.N.N.N.N.N.N.N.N.N.N.N.N.N.N.N.N.N.N.N.N.N.N.N.N.N.N.N.N.N.N.N.N.N.N.N.N.N.N.N.N.N.N.N.N.N.N.N.N.N.N.N.N.N.N.N.N.N.N.N.N.N.N.N.N.N.N.N.N.N.N.N.B.N.N.N.N.N.N.N.B.N.N.N.N.N.N.N.B.N.N.N.N.N.N.N.B.B.N.N.N.N.N.N.N.N.N.N.B.N.N.N.N.N.N.N.N.N.N.N.B.B.N.N.N.N.N.N.N.N.N.N.B.N.N.N.N.N.N.N.N.N.N.N.N.N.N.N.B.N.N.N.N.N.N.N.N.N.
N.N.N.N.N.b.N.N.N.b.N.N.N.N.N.N.N.N.N.N.N.b.N.N.N.N.N.N.N.b.N.N.N.N.N.N.N.N.N.N.N.N.N.N.N.N.N.N.N.N.N.N.N.b.N.N.N.b.N.N.N.N.N.N.b.N.N.N.b.N.N.N.N.N.N.N.N.b.N.N.N.N.N.N.N.N.N.b.N.N.N.N.N.N.N.N.N.N.b.N.N.N.b.N.N.N.N.N.N.N.N.N.b.N.N.N.b.N.N.N.N.N.b.N.N.N.b.N.b.N.N.N.N.N.N.N.N.N.b.N.N.N.N.N.b.N.N.N.N.N.N.N.N.N.b.N.N.N.N.N.N.N.N.N.N.N.N.N.N.N.b.N.N.N.N.b.b.N.N.N.N.N.N.N.b.N.N.N.b.N.N.N.N.N.N.N.N.b.N.N.N.b.N.N.N.N.N.N.N.N.b.N.N.N.N.N.N.N.N.N.N.b.N.N.N.N.N.N.b.N.N.N.N.N.N.N.N.N.b.N.N.N.N.N.N.b.N.N.N.b.N.N.N.N.N.N.N.N.b.N.N.N.N.N.N.N.N.N.b.N.N.N.N.N.N.N.N.N.b.N.N.N.N.N.N.N.b.N.N.N.b.N.N.N.b.N.N.N.N.N.N.N.N.N.N.N.b.N.N.N.N.b.N.N.N.N.b.N.N.N.N.N.N.b.B.N.N.N.N.N.N.b.N.N.b.N.N.N.N.N.N.N.N.N.N.N.b.N.N.N.
b.b.N.N.b.b.N.N.b.N.b.N.b.N.b.b.N.b.N.N.b.N.b.N.b.b.N.N.b.b.N.N.b.N.b.b.N.b.N.N.b.N.b.b.N.b.N.N.b.b.N.N.b.b.N.N.b.N.b.N.b.N.b.b.N.N.N.b.N.b.N.b.b.b.N.N.b.b.N.N.b.N.b.N.N.b.b.N.N.b.N.b.N.b.N.N.N.N.N.N.b.N.N.N.b.b.N.b.N.N.b.N.N.N.N.b.N.b.N.b.N.N.N.N.b.N.N.N.N.b.N.b.b.N.b.N.b.N.b.N.b.b.N.b.N.b.N.b.b.N.b.N.b.N.b.N.b.b.N.b.b.b.N.b.N.N.b.N.N.b.b.N.b.N.N.N.N.b.N.b.N.N.b.N.N.N.N.b.N.b.N.b.b.b.N.N.b.b.N.N.b.N.b.N.b.N.b.b.b.N.b.N.b.b.N.b.b.b.N.N.b.b.N.N.b.N.b.N.N.N.N.b.b.N.b.N.b.N.b.N.b.b.N.N.b.b.N.N.b.N.b.N.b.N.b.b.b.N.b.N.b.b.N.b.N.N.b.N.N.N.b.N.N.N.b.N.b.N.b.N.N.N.b.N.b.N.b.N.N.N.N.N.b.N.N.N.b.b.N.b.N.N.b.N.N.b.b.N.b.N.N.N.N.N.b.N.N.N.b.N.b.N.N.N.N.b.N.b.N.b.b.N.b.N.N.N.b.b.N.b.N.N.b.N.b.N.b.N.b.b.
b.N.b.b.b.N.b.b.b.b.N.b.b.b.N.b.b.b.b.b.b.b.N.b.b.N.b.b.b.N.b.b.b.b.N.b.b.b.b.b.b.b.N.b.b.b.b.b.b.N.b.b.b.N.b.b.b.b.N.b.b.b.N.b.b.b.b.N.b.b.b.b.b.N.b.b.b.N.b.b.b.b.b.b.b.N.b.b.b.N.b.b.b.b.b.b.b.b.b.b.b.b.b.b.N.b.b.b.b.b.b.b.b.b.b.N.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.N.b.b.b.b.N.b.b.b.N.b.b.b.b.b.b.N.b.b.b.b.N.b.b.b.N.b.b.b.b.N.b.b.b.b.b.b.b.N.b.b.b.b.b.b.N.b.b.b.b.b.b.b.b.b.b.N.b.b.b.b.b.N.b.b.b.N.b.b.b.b.N.b.b.b.N.b.N.b.b.b.N.b.b.b.b.N.b.b.b.N.b.b.b.b.b.b.b.b.b.N.b.b.b.b.N.b.b.b.b.N.b.b.b.N.b.b.b.b.N.b.b.b.N.b.N.b.b.b.N.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.N.b.b.b.b.b.b.b.N.b.b.b.b.b.b.b.b.b.b.b.N.b.b.b.b.b.b.b.b.N.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.N.b.b.b.N.b.b.b.b.b.b.N.b.b.b.b.b.b.b.N.b.b.b.N.b.
b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.b.
b.b.z.b.b.b.z.b.b.b.z.b.b.b.z.b.b.b.b.z.b.b.z.b.b.b.z.b.b.b.z.b.b.b.z.b.b.b.z.b.b.b.b.z.b.b.z.b.b.b.z.b.b.b.z.b.b.b.z.b.b.b.z.b.b.b.b.b.b.z.b.b.b.z.b.b.b.z.b.b.b.b.b.b.z.b.b.b.b.b.b.z.b.b.z.b.b.b.z.b.b.b.z.b.z.b.b.b.b.z.b.b.b.b.b.z.b.b.b.b.b.b.z.b.b.b.z.b.b.b.b.b.z.b.b.b.b.z.b.b.z.b.b.b.b.b.b.b.z.b.b.b.b.z.b.b.z.b.b.b.b.z.b.b.z.b.b.b.b.z.b.b.z.b.b.b.z.b.b.b.b.b.z.b.b.b.b.z.b.b.b.b.b.b.z.b.b.b.z.b.b.b.z.b.b.b.z.b.z.b.b.b.z.b.b.b.z.b.b.b.z.b.b.b.b.b.b.b.z.b.b.b.z.b.b.b.z.b.b.b.z.b.b.b.z.b.b.b.b.b.z.b.b.b.z.b.z.b.b.b.z.b.b.b.b.b.b.b.b.b.b.b.z.b.b.b.b.z.b.b.z.b.b.b.z.b.b.b.b.b.b.b.b.b.b.b.k.b.b.b.b.k.b.b.z.b.b.b.z.b.b.b.b.b.z.b.b.b.z.b.b.z.b.b.z.b.b.b.b.z.b.b.z.b.b.b.b.z.b.b.z.b.b.b.b.z.b.b.b.b.
z.b.b.b.z.b.b.b.z.b.b.b.b.z.b.z.b.z.z.b.z.b.b.b.z.b.b.b.z.b.b.b.z.b.b.b.b.z.b.z.b.z.z.b.z.b.b.b.z.b.b.b.z.b.b.b.z.b.b.b.b.z.b.z.b.z.b.b.z.z.b.b.z.b.z.b.z.b.z.b.z.z.b.b.z.b.z.z.b.z.z.b.z.b.b.b.z.b.b.b.z.b.b.b.b.b.z.b.z.b.z.b.b.z.b.b.z.z.b.b.z.b.z.b.z.b.z.b.z.b.z.z.b.b.b.z.z.b.z.b.b.b.b.z.z.b.z.z.b.b.b.z.z.b.z.b.b.b.b.z.z.b.z.b.b.b.b.z.z.b.z.b.z.b.b.z.z.b.z.b.b.z.z.b.b.z.b.z.b.z.b.b.z.b.b.b.z.b.b.b.z.b.b.b.b.z.b.z.b.b.b.z.b.b.z.b.b.z.b.z.b.z.b.z.z.z.b.b.z.b.z.z.b.b.b.z.b.b.z.b.b.z.b.z.b.z.b.z.z.b.b.b.b.z.b.z.b.b.b.b.b.b.b.b.k.b.b.k.k.b.b.k.b.b.b.b.b.b.k.b.b.b.b.b.b.b.b.b.k.b.b.k.k.b.b.k.b.b.k.b.b.z.b.k.b.b.z.b.b.z.b.z.z.b.b.b.z.b.b.b.z.b.z.b.z.b.b.z.z.b.z.b.z.b.b.z.b.z.z.b.b.b.b.z.b.z.z.b.b.z.
z.z.z.z.z.z.z.z.z.z.z.z.z.b.z.z.z.b.z.z.z.z.z.z.z.z.z.z.z.z.z.z.z.z.z.z.z.b.z.z.z.b.z.z.z.z.z.z.z.z.z.z.z.z.z.z.z.z.z.z.z.b.z.z.z.z.z.z.z.b.z.z.z.z.b.z.z.z.b.z.z.b.z.z.z.z.b.z.z.b.z.z.z.z.z.z.z.z.z.z.z.z.z.z.z.z.z.z.z.z.z.z.z.z.z.z.z.b.z.z.z.z.b.z.z.z.b.z.z.z.b.z.z.z.z.z.z.z.z.z.z.z.z.z.z.z.b.z.z.z.z.z.z.z.z.z.z.z.z.z.z.z.z.z.z.z.z.z.z.z.z.z.b.z.z.z.z.z.z.z.z.b.z.z.z.b.z.z.z.z.z.z.z.z.z.z.z.z.z.z.z.z.z.z.z.b.z.z.z.z.z.z.z.z.z.z.z.z.z.b.z.z.z.z.z.b.z.z.z.z.b.z.z.z.z.z.z.z.z.z.z.z.z.b.z.z.z.z.z.z.z.z.z.b.z.z.k.b.k.k.k.z.k.z.b.k.b.k.b.k.b.k.k.z.k.z.k.k.b.k.k.b.k.k.k.z.k.z.b.k.b.k.b.k.b.k.k.b.b.k.k.b.k.b.k.b.z.z.k.b.k.b.b.k.k.b.z.k.z.z.b.k.b.k.b.z.z.b.b.k.b.k.b.z.z.b.k.b.z.k.k.b.k.b.z.b.z.k.z.b.
z.z.z.z.z.z.z.z.z.z.z.z.z.z.z.z.z.z.z.z.z.z.z.z.z.z.z.z.z.z.z.z.z.z.z.z.z.z.z.z.z.z.z.z.z.z.z.z.z.z.z.z.z.z.z.z.z.z.z.z.z.z.z.z.z.z.z.z.z.z.z.z.z.z.z.z.z.z.z.z.z.z.z.z.z.z.z.z.z.z.z.z.z.z.z.z.z.z.z.z.z.z.z.z.z.z.z.z.z.z.z.z.z.z.z.z.z.z.z.z.z.z.z.z.z.z.z.z.z.z.z.z.z.z.z.z.z.z.z.z.z.z.z.z.z.z.z.z.z.z.z.z.z.z.z.z.z.z.z.z.z.z.z.z.z.z.z.z.z.z.z.z.z.z.z.z.z.z.z.z.z.z.z.z.z.z.z.z.z.z.z.z.z.z.z.z.z.z.z.z.z.z.z.z.z.z.z.z.z.z.z.z.z.z.z.z.z.z.z.z.z.z.z.z.z.z.z.z.z.z.z.z.z.z.z.z.z.z.z.z.z.z.z.z.z.z.z.z.z.z.z.z.z.z.z.z.b.k.z.b.z.z.z.z.k.b.k.z.b.k.k.b.k.b.z.z.k.b.k.k.b.k.k.b.k.b.z.z.k.b.k.k.b.k.k.b.k.b.z.z.k.b.k.k.b.k.z.b.k.b.k.b.k.z.z.z.b.k.z.b.k.k.z.z.z.z.z.z.k.k.z.z.z.z.z.z.z.z.z.z.z.z.z.z.k.z.z.z.z.z.
z.z.z.j.z.z.z.j.z.z.j.z.z.z.z.j.z.z.z.j.z.z.j.z.z.z.z.j.z.z.z.j.z.z.j.z.z.z.z.j.z.z.z.j.z.z.j.z.z.z.z.j.z.z.j.z.j.z.z.j.z.j.z.z.k.z.z.k.k.z.k.z.z.k.k.z.k.z.z.k.k.z.k.z.z.k.k.z.z.z.k.z.z.k.z.z.k.z.z.k.z.z.k.z.z.k.z.z.z.z.z.k.z.z.z.k.k.z.z.z.z.k.k.z.z.z.z.k.z.z.z.z.z.j.z.z.z.z.z.z.z.j.z.z.z.z.z.z.z.j.z.z.z.z.z.z.z.j.z.z.z.z.z.z.z.j.z.z.z.z.z.z.z.j.z.z.z.z.j.z.z.z.z.z.j.z.z.z.z.j.j.z.z.z.z.j.z.z.z.j.z.z.j.z.z.z.z.j.j.z.z.z.z.z.j.z.z.z.z.z.j.z.z.z.z.z.j.z.z.z.j.z.j.z.z.z.z.z.j.z.z.z.z.z.j.z.z.z.z.z.j.z.z.z.z.j.k.k.k.k.k.z.k.k.k.k.k.k.k.k.k.z.k.k.k.k.k.z.z.k.k.k.k.z.k.k.k.k.k.k.z.k.k.k.k.z.k.k.k.k.k.z.z.k.k.k.k.k.k.k.k.k.k.k.k.k.k.k.k.k.k.z.k.z.k.z.k.z.k.z.k.z.k.z.k.z.z.k.z.k.z.k.z.k.z.k.z.k.z.k.
j.z.j.j.j.j.z.j.j.j.j.z.j.z.j.j.j.j.z.j.j.j.j.z.j.z.j.j.j.j.z.j.j.j.j.z.j.z.j.j.j.j.z.j.j.j.j.z.j.z.j.j.j.j.z.j.z.j.j.z.j.z.j.j.z.k.k.k.k.k.z.k.k.k.k.k.z.k.k.k.k.k.z.k.k.k.k.k.k.k.k.z.h.k.k.k.k.z.h.k.k.k.k.z.h.k.k.k.k.z.h.k.z.h.k.k.h.z.z.h.k.k.h.z.z.h.k.h.h.z.j.z.h.z.j.z.j.z.j.z.h.z.j.z.h.z.j.z.h.z.j.z.j.z.j.z.h.z.j.z.j.z.j.z.h.z.j.z.j.z.j.z.h.z.j.z.h.h.z.z.h.z.j.h.z.z.h.z.h.h.z.z.j.z.j.j.j.j.z.j.j.j.j.z.j.z.j.j.j.z.z.j.j.j.j.z.z.j.j.j.j.z.z.j.j.j.j.z.z.j.j.z.j.z.z.j.j.j.j.z.z.j.j.j.j.z.z.j.j.j.j.z.j.z.j.j.k.k.k.k.k.k.k.k.k.k.k.k.k.k.k.k.k.k.k.k.k.k.k.k.k.k.k.k.k.k.k.k.k.k.k.k.k.k.k.k.k.k.k.k.k.k.k.k.k.k.k.k.k.k.k.k.k.k.k.k.k.k.k.k.k.k.k.k.k.k.k.k.k.k.k.k.k.k.k.k.k.k.k.k.k.k.k.k.k.k.k.k.k.k.
j.j.j.j.j.j.j.j.j.j.j.j.j.j.j.j.j.j.j.j.j.j.j.j.j.j.j.j.j.j.j.j.j.j.j.j.j.j.j.j.j.j.j.j.j.j.j.j.j.j.j.j.j.j.j.j.j.j.j.j.j.j.j.j.h.k.h.k.h.h.h.k.h.k.h.h.h.k.h.k.h.h.h.k.h.k.h.h.k.h.h.h.k.h.k.h.h.h.k.h.k.h.h.h.k.h.k.h.h.h.k.h.h.k.h.k.h.h.h.k.h.k.h.h.h.k.h.h.h.j.h.j.h.j.h.j.h.j.h.j.h.j.h.j.h.j.h.j.h.j.h.j.h.j.h.j.h.j.h.j.h.j.h.j.h.j.h.j.h.j.h.j.h.j.h.j.h.z.h.h.h.h.h.z.h.h.h.h.h.z.h.h.j.j.j.j.j.j.j.j.j.j.j.j.j.j.j.j.j.j.h.j.j.j.j.j.h.j.j.j.j.j.h.j.j.j.j.j.h.j.j.h.j.j.h.j.j.j.j.j.h.j.j.j.j.j.h.j.j.j.j.j.j.j.j.j.k.h.k.h.k.k.k.h.k.h.k.k.k.h.k.h.k.k.k.h.k.h.k.k.k.h.k.h.k.k.k.h.k.h.k.k.k.h.k.h.k.k.k.h.k.h.k.k.k.h.k.h.k.h.k.h.k.h.k.k.k.h.h.h.h.k.h.k.h.k.h.k.h.k.h.k.h.k.h.k.h.k.h.k.h.k.h.k.h.k.h.k.h.k.
h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.f.h.h.
f.h.f.f.f.f.f.h.h.f.f.h.h.f.f.h.h.f.f.h.f.h.h.f.f.h.f.f.f.f.f.h.f.f.f.h.h.f.f.h.h.f.f.h.f.h.h.f.f.h.f.f.f.f.f.h.f.f.h.f.f.h.f.f.f.f.f.f.f.f.f.h.h.f.f.h.h.f.f.h.h.f.f.h.f.h.h.f.f.h.h.h.f.h.h.f.h.f.f.h.h.f.f.h.h.f.f.h.f.h.h.f.f.h.f.f.f.f.f.h.f.f.h.f.f.h.f.f.f.h.f.h.h.f.h.f.f.h.f.h.h.f.f.f.f.h.f.h.h.f.h.f.f.h.f.h.h.f.f.f.f.h.f.h.h.f.h.f.f.h.f.h.h.f.f.f.f.h.f.h.h.f.h.f.f.h.f.h.h.f.f.f.h.f.f.h.f.h.h.f.f.h.f.f.f.f.f.h.f.f.f.h.h.f.f.h.h.f.f.h.h.h.f.h.h.f.f.h.h.f.f.h.f.h.h.f.f.h.h.h.f.h.h.f.h.f.f.h.h.f.f.h.h.f.f.h.h.f.f.h.h.f.f.h.h.f.f.h.f.h.h.f.f.h.f.f.f.f.f.h.f.f.h.f.f.h.f.f.f.f.f.h.f.h.h.f.f.h.f.f.f.f.f.h.h.f.f.h.h.f.f.h.h.f.f.h.f.h.h.f.h.f.h.h.f.h.f.f.h.f.h.h.h.f.f.f.h.f.h.h.f.h.f.h.f.h.f.f.f.h.
f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.
f.f.f.f.f.f.f.f.f.i.f.f.f.f.f.i.f.f.f.f.i.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.i.f.f.f.f.i.f.f.f.f.f.f.f.f.f.f.f.f.f.i.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.i.f.f.f.i.f.i.f.f.f.f.i.f.f.f.f.f.i.f.i.f.f.f.i.f.f.f.f.f.i.f.f.f.f.i.f.f.f.f.f.f.f.f.f.f.f.f.f.i.f.f.f.f.f.f.f.i.f.f.f.f.f.f.f.i.f.f.f.f.f.f.f.i.f.f.f.f.f.f.f.i.f.f.f.f.f.f.f.i.f.f.f.f.f.f.f.i.f.f.f.f.f.f.f.i.f.f.f.f.f.f.f.i.f.f.f.f.f.f.f.f.f.i.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.i.f.f.f.f.i.f.f.f.f.f.i.f.i.f.f.f.f.i.f.f.f.f.f.i.f.i.f.f.f.f.i.f.f.f.f.i.f.f.f.f.f.i.f.f.f.f.f.i.f.f.f.f.i.f.f.f.f.f.f.f.f.f.f.f.f.f.i.f.f.f.f.f.f.f.f.f.i.f.f.f.f.f.f.f.f.f.f.f.f.i.f.f.f.f.f.i.f.f.f.f.i.f.f.f.f.f.i.f.f.f.f.f.f.f.i.f.f.f.f.f.f.f.i.f.f.f.f.f.f.f.f.f.f.f.
i.f.i.f.i.i.f.f.f.f.i.f.i.f.i.f.i.f.f.i.f.i.i.f.i.f.i.f.i.i.f.f.f.i.f.i.f.f.f.f.i.f.f.i.f.i.i.f.i.f.i.f.i.i.f.f.f.f.i.f.f.i.f.i.i.f.i.f.i.i.f.f.f.f.i.f.f.i.f.i.f.i.i.f.f.i.i.f.f.i.f.i.f.f.f.i.f.f.i.f.i.f.i.f.i.f.f.i.f.i.i.f.i.f.i.f.i.i.f.f.f.f.i.f.f.i.f.i.i.f.i.f.f.i.f.i.i.f.i.f.i.f.f.f.i.f.i.f.f.i.f.i.i.f.i.f.i.f.f.f.i.f.i.f.f.i.f.i.i.f.i.f.i.f.f.f.i.f.i.f.f.i.f.i.i.f.i.f.i.f.f.f.i.f.f.i.f.i.i.f.i.f.i.f.i.i.f.f.f.i.f.i.f.f.f.f.i.f.f.i.f.i.i.f.f.i.f.i.f.i.f.i.i.f.i.f.i.f.i.f.f.i.i.f.f.i.f.f.i.f.i.f.i.i.f.f.f.f.i.f.i.f.i.f.i.f.f.i.f.i.i.f.i.f.i.f.i.i.f.f.f.f.i.f.f.i.f.i.i.f.f.i.f.i.i.f.i.f.i.f.i.i.f.f.f.f.i.f.i.f.i.f.i.f.f.i.f.i.i.f.i.i.f.f.i.f.f.f.i.i.f.f.i.f.f.f.i.i.f.f.f.i.f.i.i.f.i.f.f.i.
i.f.i.f.i.f.i.i.i.f.f.i.i.f.i.f.i.i.f.i.i.f.f.i.i.f.i.f.i.f.i.i.i.f.i.f.i.i.i.i.i.i.f.i.i.f.f.i.i.f.i.f.i.f.i.i.i.f.i.f.i.f.i.f.i.f.i.f.i.f.i.i.i.f.i.f.i.f.i.f.i.f.f.i.i.f.f.i.i.f.i.f.i.i.i.f.i.f.f.i.i.f.i.f.i.i.f.i.i.f.f.i.i.f.i.f.i.f.i.i.i.f.i.f.i.f.i.f.f.i.f.i.i.f.i.f.f.i.f.i.f.i.i.i.f.i.f.i.i.f.i.f.f.i.f.i.f.i.i.i.f.i.f.i.i.f.i.f.f.i.f.i.f.i.i.i.f.i.f.i.i.f.i.f.f.i.f.i.f.i.i.i.i.i.f.i.i.f.f.i.i.f.i.f.i.f.i.i.i.f.i.f.i.i.i.i.i.i.f.i.i.f.f.i.i.f.i.f.i.f.i.f.f.i.f.i.f.i.f.f.i.f.f.i.f.i.i.f.i.f.i.f.i.f.i.i.i.f.f.i.i.f.i.f.i.i.f.i.i.f.f.i.i.f.i.f.i.f.i.i.i.f.i.f.i.f.i.f.i.i.f.i.i.f.f.i.i.f.i.f.i.f.i.i.i.f.f.i.i.f.i.f.i.i.f.i.i.f.f.i.i.f.i.i.f.i.i.i.i.f.i.i.f.i.i.i.i.f.i.i.i.f.i.f.f.i.f.i.f.i.
i.f.i.i.i.f.i.i.i.i.i.i.i.f.i.i.i.i.f.i.i.i.i.f.i.f.i.i.i.f.i.i.i.i.f.i.i.i.i.i.i.i.f.i.i.i.i.f.i.f.i.i.i.f.i.i.i.i.i.f.i.i.i.i.f.i.i.i.i.f.i.i.i.i.i.f.i.i.i.i.i.i.f.i.i.i.i.f.i.i.i.i.f.i.i.i.i.i.i.i.i.f.i.i.i.i.f.i.i.i.i.f.i.f.i.i.i.f.i.i.i.i.i.f.i.i.i.i.i.i.i.i.i.i.f.i.i.i.i.i.i.f.i.i.i.i.i.i.i.i.f.i.i.i.i.i.i.f.i.i.i.i.i.i.i.i.f.i.i.i.i.i.i.f.i.i.i.i.i.i.i.i.f.i.i.i.i.i.i.f.i.i.i.i.f.i.i.i.i.f.i.f.i.i.i.f.i.i.i.i.f.i.i.i.i.i.i.f.i.i.i.i.f.i.i.f.i.i.i.f.i.i.i.f.i.i.i.i.i.i.i.i.i.f.i.i.i.i.i.f.i.i.i.f.i.i.i.i.i.i.i.f.i.i.i.i.f.i.i.i.i.f.i.f.i.i.i.f.i.i.i.i.i.f.i.i.i.i.i.i.f.i.i.i.i.f.i.f.i.i.i.f.i.i.i.i.i.i.i.f.i.i.i.i.f.i.i.i.i.f.i.i.i.f.f.i.i.i.i.i.i.f.i.f.i.i.i.i.i.f.i.i.i.f.i.i.i.i.i.i.
i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.i.
y.i.y.i.y.y.i.y.i.y.i.y.y.y.i.y.i.y.i.y.i.y.i.y.y.i.y.i.y.i.y.i.y.y.i.y.i.y.y.y.y.y.y.y.y.y.y.y.y.i.y.i.y.y.y.i.y.i.y.i.y.i.y.i.y.i.y.i.y.i.y.i.y.i.y.i.y.i.y.i.y.y.y.y.y.i.y.y.i.i.i.y.i.y.i.y.y.y.i.y.i.y.y.y.y.i.y.i.y.i.y.i.y.i.y.i.y.y.y.i.y.i.y.i.y.y.y.i.i.i.y.y.i.y.i.y.y.y.i.y.i.y.y.y.i.i.y.y.i.y.i.y.y.y.i.y.i.y.y.y.i.i.y.y.i.y.i.y.y.y.i.y.i.y.y.y.i.i.y.y.i.y.i.y.y.y.i.y.i.y.y.y.i.y.i.y.i.y.i.y.y.i.y.i.y.i.y.i.y.y.i.y.i.y.y.y.y.y.y.y.y.y.y.y.y.y.i.y.y.y.i.y.i.y.i.y.y.y.i.y.i.y.y.y.i.y.y.y.y.i.y.i.y.i.y.i.i.y.i.i.i.y.i.y.y.i.y.i.y.i.y.i.y.i.y.i.i.i.y.i.y.i.y.i.i.i.y.i.i.i.i.i.i.i.i.i.y.i.i.i.y.i.y.i.i.y.i.i.i.y.i.y.y.i.y.i.y.i.y.i.i.y.y.y.i.y.i.y.y.y.i.y.i.y.y.y.i.y.y.y.i.y.i.y.y.y.i.y.i.y.
y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.i.r.y.y.y.y.i.y.y.y.i.y.y.y.i.y.y.y.r.y.y.y.y.y.y.y.r.y.y.y.y.r.y.r.y.r.y.r.y.y.r.y.y.y.y.y.r.y.i.r.y.y.y.y.i.y.y.y.i.y.y.y.i.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.
y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.w.y.y.y.w.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.w.y.y.w.y.y.y.y.w.y.y.w.y.y.y.y.w.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.r.r.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.r.y.y.y.y.y.y.y.y.y.y.y.r.y.y.y.y.y.r.y.y.y.y.r.r.y.y.y.y.y.y.y.y.y.r.y.y.y.y.r.r.y.y.y.y.y.y.y.y.y.r.y.y.y.y.r.r.y.y.y.y.y.y.y.y.w.y.y.y.w.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.w.y.y.y.y.y.y.r.r.y.r.r.y.r.r.r.y.r.r.r.r.r.y.r.r.y.r.y.y.r.y.r.r.y.r.y.y.r.r.y.r.y.r.y.r.y.r.y.r.y.y.r.r.y.y.r.r.y.r.r.y.r.r.r.y.r.r.r.r.r.y.y.r.y.y.y.y.y.y.y.y.y.y.y.r.y.y.y.r.y.y.y.y.y.y.y.y.y.y.y.
w.y.w.w.w.y.w.y.w.w.y.w.w.y.w.w.y.w.y.w.y.w.y.y.w.y.w.w.w.w.y.w.w.y.w.w.y.w.w.y.y.w.y.w.y.w.y.w.w.w.y.w.w.y.w.y.w.w.y.w.y.y.0.y.y.y.y.0.y.y.0.y.y.y.y.0.y.y.0.y.y.w.y.w.y.w.w.y.y.0.y.0.w.w.y.w.y.y.0.y.r.r.0.y.y.0.0.y.y.0.0.y.0.r.y.0.r.r.r.y.0.r.y.0.r.r.r.y.r.r.r.r.0.r.y.0.r.y.0.r.r.r.r.r.r.r.0.y.0.y.y.0.y.y.0.y.r.r.0.y.r.r.0.y.0.y.y.0.y.y.0.y.r.r.0.y.r.r.0.y.0.y.y.0.y.y.0.y.r.r.0.y.y.w.y.w.y.w.y.y.w.y.w.w.w.w.y.w.w.y.w.w.y.w.w.y.y.w.y.w.y.w.y.w.w.w.y.w.w.y.0.y.w.w.y.w.w.y.0.y.y.0.y.w.y.0.y.w.w.y.y.w.w.w.y.0.r.r.r.r.r.r.r.r.r.r.r.r.r.r.r.r.r.r.r.r.r.r.r.r.r.r.r.r.r.r.r.r.r.r.r.r.r.r.r.r.r.r.r.r.r.r.r.r.r.r.r.r.r.r.r.r.r.r.r.r.r.r.r.r.r.r.r.r.0.r.y.0.r.y.0.r.r.r.r.r.r.r.r.r.0.r.y.0.r.y.0.r.r.r.
w.w.w.w.y.w.w.w.w.w.w.w.y.w.w.y.0.w.y.w.y.w.w.w.w.y.w.y.w.w.y.w.y.w.w.y.w.y.w.y.0.y.0.y.y.w.w.y.w.w.y.0.y.0.y.0.w.w.y.0.y.0.y.0.0.w.y.0.y.0.y.0.0.w.y.0.y.0.y.0.0.0.y.0.y.0.y.y.0.y.0.y.w.0.y.0.y.0.y.y.r.y.r.y.0.y.0.y.y.0.y.y.r.0.y.0.y.0.y.0.r.0.y.0.y.0.y.0.r.y.r.y.y.y.0.y.y.0.y.y.r.y.r.y.r.y.r.y.y.y.0.y.y.0.y.y.r.y.r.y.r.y.r.y.y.y.0.y.y.0.y.y.y.0.0.y.r.y.y.0.y.y.0.y.y.0.y.y.0.y.y.y.0.w.y.w.y.w.w.w.w.y.w.y.w.w.y.w.y.w.w.y.y.w.w.y.w.y.w.w.y.w.w.y.w.y.y.w.w.y.y.w.w.y.y.w.w.y.y.w.0.y.0.y.w.y.0.y.w.y.y.0.w.y.0.y.r.r.0.r.r.r.r.r.r.r.0.r.r.r.r.r.r.0.r.r.r.0.r.r.r.0.r.r.r.0.r.r.r.r.r.r.r.0.r.r.r.r.0.r.r.r.r.r.r.r.0.r.r.r.r.r.r.r.0.r.r.r.r.r.r.y.r.y.r.r.0.y.y.r.0.y.r.y.r.y.r.y.r.y.r.r.0.y.y.r.0.y.y.0.
w.w.w.w.w.w.w.w.w.w.w.w.w.w.w.w.w.w.w.0.w.w.w.w.0.w.0.w.w.w.w.w.w.w.w.w.0.w.0.w.w.w.0.0.w.w.w.w.w.w.0.y.w.w.0.y.w.w.0.y.w.w.0.y.w.w.0.y.w.w.0.y.y.0.0.y.y.0.0.y.0.y.w.w.w.w.0.0.w.w.w.w.0.y.w.w.0.y.0.0.0.0.0.0.r.0.0.0.0.y.0.0.0.r.0.r.0.r.0.r.0.r.0.r.0.r.0.r.0.0.0.0.0.0.0.0.0.y.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.y.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.y.0.0.0.y.0.0.0.0.0.y.0.0.0.0.0.y.0.0.0.0.0.0.w.w.w.0.w.w.w.w.0.w.0.w.w.w.w.0.w.w.w.w.0.w.w.w.0.w.w.w.w.w.w.w.w.0.w.w.w.0.w.w.w.0.w.w.w.0.w.w.w.w.0.0.0.y.w.w.0.0.0.y.w.w.w.0.r.0.r.0.0.0.0.r.0.r.r.0.0.r.0.r.0.r.0.r.0.r.0.r.0.r.0.r.0.r.0.r.0.0.r.0.r.r.0.r.0.0.r.r.0.0.r.0.r.0.r.0.0.0.0.r.0.r.r.0.0.r.0.r.0.0.0.0.0.r.0.0.0.r.r.0.0.0.0.0.0.0.0.0.0.r.0.0.0.r.r.0.0.0.
w.w.0.w.0.w.0.w.w.w.0.w.0.w.0.w.0.w.w.0.w.0.0.w.w.0.w.0.0.w.0.0.0.w.w.0.0.w.0.w.w.0.0.w.0.w.0.0.0.0.w.0.0.0.w.0.0.0.w.0.0.0.w.0.0.0.w.0.0.0.w.0.0.0.0.0.0.0.0.0.0.w.0.0.0.0.0.y.0.0.0.0.0.y.0.0.0.0.r.0.0.0.0.r.0.0.0.r.0.0.0.0.0.0.r.0.0.0.r.0.0.0.r.0.0.0.r.0.0.0.0.r.0.0.0.r.0.0.r.0.0.0.0.r.0.0.0.r.0.0.0.r.0.0.r.0.0.0.0.0.0.0.0.r.0.0.0.r.0.0.r.0.0.0.0.y.0.0.0.0.0.0.0.y.0.0.0.0.0.y.0.0.w.0.0.w.0.w.w.0.0.w.0.w.w.0.0.w.w.0.0.w.0.0.w.0.0.w.0.0.0.0.0.0.0.0.w.0.0.0.w.0.0.0.w.0.0.0.w.0.w.0.0.w.w.0.0.w.w.0.w.0.0.w.0.0.0.r.0.0.0.r.0.0.r.0.0.0.0.0.0.0.0.0.r.0.0.0.r.0.0.0.r.0.0.0.r.0.0.0.0.0.0.0.0.r.0.0.r.0.0.0.0.0.0.r.0.0.0.r.0.0.r.0.0.0.0.0.0.0.0.0.0.r.0.0.0.r.0.0.r.0.0.0.0.r.0.0.0.r.0.0.0.r.0.0.r.0.0.0.
9.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.9.9.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.9.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.9.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.
9.9.9.9.9.9.9.9.9.9.9.9.9.9.9.9.9.9.9.9.9.9.9.9.9.9.9.9.9.9.9.9.9.9.9.9.9.9.9.9.9.9.9.9.9.9.9.9.9.9.9.9.9.9.9.9.9.9.9.9.9.9.9.9.9.9.9.9.9.9.9.9.9.9.9.9.9.9.9.9.0.9.9.9.9.9.9.9.9.9.9.9.9.9.9.9.9.9.9.9.9.9.9.9.9.9.9.9.9.9.9.9.9.9.9.9.9.9.9.9.9.9.9.9.9.9.9.9.0.9.9.9.9.9.9.9.9.9.9.9.9.9.9.9.9.9.9.9.9.9.9.9.9.9.9.9.9.9.9.9.0.9.9.9.9.9.9.9.9.9.9.9.9.9.9.9.9.9.9.9.9.9.9.9.9.9.9.9.9.9.9.9.9.9.9.9.9.9.9.9.9.9.9.9.9.9.9.9.9.9.9.9.9.9.9.9.9.9.9.9.9.9.9.9.9.9.9.9.9.9.9.9.9.9.9.9.9.9.9.9.0.9.9.9.9.9.9.9.9.9.9.9.9.9.9.9.9.9.9.9.9.9.9.9.9.9.9.9.9.9.9.9.9.9.9.9.9.9.9.9.9.9.9.9.9.9.9.9.0.0.9.9.9.9.9.9.9.9.9.9.9.9.9.9.9.9.9.9.9.9.9.9.9.9.9.9.9.9.9.9.0.9.9.9.9.9.9.9.9.9.9.9.9.9.9.9.9.9.9.9.9.9.9.9.9.9.9.9.9.9.
9.9.9.5.9.9.9.5.9.9.9.5.9.9.9.5.9.9.9.9.5.9.9.9.5.9.9.9.9.5.9.9.9.9.9.5.9.9.5.9.9.9.5.9.9.9.9.5.9.9.5.9.9.9.5.9.9.9.5.9.9.9.5.9.9.9.5.9.9.9.5.9.9.9.5.9.9.9.5.9.9.9.9.9.9.9.9.5.9.9.5.9.9.9.5.9.9.9.9.5.9.9.5.9.9.9.5.9.9.9.9.5.9.9.9.9.9.9.9.9.5.9.9.9.5.9.9.9.9.9.9.9.9.9.9.5.9.9.5.9.9.9.5.9.9.9.5.9.9.9.9.9.9.9.9.5.9.9.5.9.9.9.9.9.9.9.5.9.9.9.9.9.9.9.9.5.5.9.9.9.5.9.9.9.9.5.9.9.9.9.5.9.9.9.9.9.5.9.9.9.9.9.5.9.9.9.9.9.9.9.9.9.9.9.9.5.5.9.9.9.5.9.9.9.9.9.9.9.9.9.9.9.5.9.9.9.5.9.9.9.9.9.9.9.9.9.5.9.9.9.9.9.9.9.9.5.9.9.9.5.9.9.5.9.9.9.5.9.9.9.9.5.9.9.9.9.9.9.9.9.9.9.9.9.9.9.9.9.9.9.9.9.9.9.9.5.9.9.9.5.9.9.5.9.9.9.5.9.9.9.5.9.9.9.9.5.9.9.5.9.9.9.9.9.9.9.9.5.9.9.5.9.9.9.5.9.9.9.5.9.9.9.9.9.9.9.9.5.9.9.
5.9.9.9.5.9.9.9.5.9.9.9.5.9.9.9.5.9.5.5.9.9.9.5.9.9.5.9.5.9.5.9.9.5.9.9.5.5.9.9.9.5.9.5.9.5.5.9.5.9.9.9.5.9.9.9.5.9.9.9.5.9.9.9.5.9.9.9.5.9.9.9.5.9.9.9.5.9.9.9.9.5.9.5.9.5.5.9.5.9.9.9.9.5.9.5.9.5.5.9.5.5.9.9.9.5.9.5.9.5.5.9.5.5.9.5.5.5.9.5.9.5.9.5.9.5.9.5.9.5.9.5.9.5.5.9.5.9.9.9.9.5.9.5.5.9.5.9.5.9.5.5.9.9.5.9.5.9.5.9.9.5.5.9.5.9.5.9.5.9.5.5.9.5.5.9.9.9.9.5.9.9.5.9.5.9.5.9.5.9.5.9.9.9.5.9.5.9.5.9.5.9.5.9.5.9.5.5.5.9.5.5.9.9.5.9.9.9.9.5.9.9.5.9.5.5.9.5.5.5.9.5.9.5.9.5.9.5.9.5.5.9.5.9.5.9.5.9.5.9.5.5.9.9.5.9.9.5.5.9.5.5.9.9.9.5.9.5.9.5.5.9.5.5.9.5.5.5.9.5.5.5.9.5.5.5.9.5.9.9.5.5.9.9.5.9.9.5.5.9.5.5.9.9.5.5.9.9.9.5.9.5.9.5.5.9.5.5.9.9.9.5.9.5.9.5.5.9.5.9.9.9.9.5.9.5.5.9.5.9.5.9.5.5.9.9.5.9.9.5.
5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.9.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.9.5.5.5.5.9.5.5.5.9.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.9.5.5.5.9.5.5.5.5.5.5.5.9.5.5.5.5.9.5.5.9.5.5.5.5.9.5.5.5.9.5.9.5.5.5.9.5.5.5.5.5.5.9.5.5.5.5.5.9.5.5.5.9.5.5.5.5.5.5.5.9.5.5.9.5.5.5.5.5.5.9.5.5.5.5.9.5.5.5.5.9.5.5.5.9.5.5.5.5.9.5.5.9.5.5.5.5.5.5.5.5.5.5.5.5.5.5.9.5.5.5.5.5.5.5.5.5.5.5.9.5.5.5.5.5.5.9.5.5.5.9.5.5.5.5.5.5.5.5.5.5.5.5.9.5.5.5.9.5.5.5.5.5.5.9.5.5.5.5.5.5.5.5.9.5.5.5.5.5.5.9.5.5.5.5.5.5.9.5.5.9.5.5.5.5.9.5.5.5.9.5.9.5.5.5.9.5.5.5.5.9.5.5.5.9.5.5.5.5.9.5.5.5.5.5.5.5.9.5.5.9.5.5.5.9.5.5.5.9.5.5.5.5.9.5.5.9.5.5.5.9.5.5.5.9.5.5.5.5.5.5.5.9.5.5.9.5.5.5.5.5.5.9.5.5.5.5.5.5.
5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.
5.2.5.5.5.5.2.5.5.2.5.5.5.5.2.5.5.5.5.5.5.2.5.5.2.5.5.5.5.5.5.5.5.5.5.2.5.5.2.5.5.5.2.5.5.5.2.5.5.5.5.2.5.5.5.2.5.5.5.2.5.5.5.2.5.5.5.2.5.5.5.2.5.5.5.2.5.5.5.2.5.5.2.5.5.5.2.5.5.5.2.5.5.5.5.2.5.5.5.2.5.5.2.5.5.5.2.5.5.5.2.5.5.2.5.5.5.5.2.5.5.5.5.5.2.5.5.5.5.5.2.5.5.5.2.5.2.5.5.2.5.2.5.5.2.5.5.5.5.2.5.5.5.2.5.5.5.2.5.5.2.5.5.5.2.5.5.5.2.5.5.5.5.2.5.5.2.5.5.5.5.2.5.5.5.5.5.5.2.5.5.5.5.2.5.5.5.5.2.5.2.5.5.5.5.2.5.5.5.2.5.5.2.5.2.5.2.5.5.5.5.2.5.5.5.2.5.5.5.5.2.5.5.5.5.5.2.5.5.5.5.5.5.5.2.5.5.5.2.5.5.5.5.2.5.5.5.5.5.2.5.2.5.5.5.5.5.5.5.2.2.5.5.2.5.5.5.5.2.5.5.2.5.5.5.5.2.5.2.5.5.5.5.2.5.5.5.5.5.2.2.5.5.5.2.5.5.5.5.5.5.2.5.5.5.2.2.5.5.5.5.5.2.5.5.5.2.5.5.5.2.5.5.5.5.2.5.5.2.5.2.5.5.5.2.5.5.5.2.5.
5.2.2.2.5.2.2.2.5.2.2.2.5.2.2.2.2.2.5.2.2.2.5.2.2.5.2.2.5.2.2.2.2.2.5.2.2.2.2.2.2.2.2.5.2.2.2.5.2.5.2.2.2.2.5.2.2.5.2.2.2.2.2.2.2.5.2.2.2.2.5.2.2.5.2.2.2.2.5.2.2.2.2.5.2.2.2.5.2.2.2.5.2.5.2.2.2.2.5.2.2.2.2.5.2.2.2.5.2.2.2.5.5.2.2.2.5.2.2.2.5.2.2.2.2.5.2.5.2.2.2.5.2.2.2.5.5.2.2.5.2.5.2.2.5.2.2.2.2.5.2.2.2.5.2.2.2.5.2.2.2.5.2.2.2.5.2.2.2.5.2.2.5.2.2.2.2.5.2.5.2.2.5.2.2.5.2.2.2.5.2.2.2.2.5.2.2.2.2.5.5.2.2.2.2.5.2.2.2.5.2.2.5.2.5.2.2.5.2.5.2.2.2.2.5.2.2.2.5.2.2.2.5.2.2.2.2.5.2.2.2.5.2.2.2.5.2.2.2.5.2.2.5.2.2.2.5.2.2.5.2.2.5.2.<.5.2.5.2.5.2.5.2.5.<.5.5.2.2.5.2.5.<.5.5.2.5.2.2.5.5.2.2.5.<.5.5.2.2.5.2.5.5.2.2.5.5.2.2.5.2.2.5.2.2.5.2.5.5.2.2.2.2.5.2.2.2.5.2.2.2.5.2.5.2.2.5.2.2.2.2.5.2.2.2.5.2.2.2.5.
2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.<.2.2.2.2.2.2.2.<.2.<.2.2.2.<.2.2.<.2.2.2.2.<.2.2.<.2.2.<.5.2.<.2.2.<.2.2.<.2.2.<.2.2.<.2.2.2.<.2.2.<.2.2.2.2.2.<.2.2.<.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.2.
2.2.2.,.2.2.2.2.2.,.2.2.2.2.2.,.2.2.2.2.2.2.2.2.2.2.2.,.2.2.2.2.2.2.,.2.,.2.2.2.,.2.,.2.,.2.,.2.2.2.2.2.,.2.,.2.2.2.,.2.,.2.2.2.2.2.2.2.2.2.:.2.2.:.2.2.2.2.2.2.:.2.2.2.:.2.2.2.2.2.2.2.2.2.2.2.2.:.2.2.2.2.2.2.:.2.2.2.:.2.2.2.2.2.2.2.2.2.2.:.2.2.:.2.2.2.2.:.<.2.2.2.<.2.2.2.2.<.2.2.2.2.2.<.2.2.<.2.2.<.2.2.2.2.2.2.2.2.<.2.2.2.2.2.2.2.<.2.2.<.2.2.<.2.2.<.2.2.:.2.2.2.2.:.2.2.2.2.2.2.2.2.2.2.2.,.2.2.2.2.2.2.2.,.2.2.2.2.2.2.2.,.2.2.2.2.2.2.2.,.2.2.,.2.2.2.2.2.2.2.,.2.2.2.2.2.,.2.2.2.,.2.2.2.,.2.2.2.2.2.2.2.2.2.,.2.<.2.<.2.<.2.<.2.<.2.<.2.<.2.<.2.<.2.<.2.<.2.<.2.2.<.2.<.2.<.2.<.<.<.2.<.<.2.<.2.<.2.<.2.<.2.<.2.<.<.2.<.<.2.<.2.<.2.<.2.<.2.<.2.<.2.<.2.<.2.<.2.<.2.2.<.2.<.2.<.2.2.<.2.<.2.2.2.<.2.2.2.2.2.
,.,.2.,.,.,.,.,.2.,.,.,.,.,.2.,.,.,.,.,.,.,.,.,.,.,.2.,.,.,.,.,.,.2.,.2.,.,.,.2.,.2.,.2.,.2.,.2.,.,.,.2.,.2.,.,.,.2.,.2.,.,.,.2.2.:.2.:.:.2.:.2.2.2.2.:.2.:.:.2.2.2.:.2.2.2.:.2.2.:.:.2.:.2.2.:.2.2.2.:.2.:.:.2.2.2.:.2.2.2.:.2.2.:.:.2.:.2.:.2.2.2.2.:.2.:.2.2.:.2.:.2.:.2.:.2.2.:.:.2.:.2.2.:.<.2.:.2.2.:.2.:.:.2.:.2.:.2.:.2.:.2.:.2.:.2.:.2.2.:.<.2.:.2.2.:.2.2.2.:.2.:.2.2.:.2.:.2.:.2.:.2.2.,.2.,.,.2.,.,.,.,.2.,.,.2.,.,.,.,.2.,.,.2.,.,.,.,.2.,.,.2.,.2.2.:.,.2.:.2.,.,.,.2.:.2.,.,.,.2.,.2.:.2.,.2.:.2.2.:.,.2.:.2.,.,.<.<.<.<.<.<.<.<.<.<.<.<.<.<.<.<.<.<.<.<.<.<.<.<.<.<.<.<.<.<.<.<.<.<.<.<.<.<.<.<.<.<.<.<.<.<.<.<.<.<.<.<.<.<.<.<.<.<.<.<.<.<.<.<.<.<.<.<.<.<.<.2.<.<.<.2.<.<.<.<.<.<.<.<.2.:.<.<.<.2.:.<.<.:.
,.,.,.,.,.,.,.,.,.,.,.,.,.,.,.,.,.,.,.,.,.,.,.,.,.,.,.,.,.,.,.,.,.,.,.,.,.,.,.,.,.,.,.,.,.,.,.,.,.,.,.,.,.,.,.,.,.,.,.,.,.,.,.,.:.2.:.2.:.2.:.2.2.:.2.:.:.2.:.2.:.:.2.:.:.:.2.:.:.2.:.2.2.:.:.:.2.:.2.:.:.2.:.2.:.:.2.:.:.:.2.:.:.2.:.2.:.2.2.:.2.:.:.2.:.2.:.:.<.<.<.:.<.<.2.:.:.:.2.<.:.<.:.<.2.:.2.:.:.:.2.2.:.2.2.:.:.2.2.:.:.2.2.:.:.2.2.:.:.2.:.:.:.2.:.2.2.:.:.2.:.2.:.:.:.2.2.:.:.2.2.:.,.,.:.,.,.,.,.,.,.,.:.,.,.,.,.,.,.,.:.,.,.,.,.,.:.2.:.,.2.:.,.,.:.2.:.,.,.,.,.,.2.:.,.,.,.2.:.,.,.,.2.:.,.,.2.:.:.2.:.,.,.,.,.,.<.<.:.<.:.<.:.<.<.<.<.:.<.<.<.:.<.<.<.<.<.<.<.:.<.:.<.:.<.<.<.<.<.<.<.<.<.<.<.:.<.<.<.:.<.<.<.:.<.<.<.<.<.<.<.:.<.<.<.:.<.<.<.:.:.<.<.<.:.<.<.:.:.<.<.<.:.<.:.<.<.<.:.<.:.2.:.<.:.<.<.<.:.<.
:.,.:.,.,.:.,.:.,.:.,.,.:.,.:.,.,.:.,.:.,.:.,.,.:.,.:.,.,.:.,.:.,.:.,.:.:.,.:.,.,.:.,.:.,.:.,.:.:.,.:.,.,.:.,.:.,.:.,.:.:.,.:.,.:.:.:.,.:.:.:.:.:.:.:.:.:.:.:.:.2.:.:.:.2.:.:.:.:.:.:.:.:.2.:.:.:.:.:.:.:.:.:.:.2.:.:.:.2.:.:.:.:.:.:.:.:.:.:.:.:.:.:.:.:.:.:.2.:.:.<.:.:.:.:.:.:.<.:.:.:.<.:.:.:.:.:.:.:.<.:.:.:.:.:.:.:.:.:.:.:.:.:.:.:.:.:.:.:.:.:.2.:.:.:.:.:.:.:.:.:.:.:.2.:.:.:.:.:.:.:.:.,.:.,.:.:.,.:.:.,.:.,.:.:.,.:.:.,.:.,.:.:.,.:.:.:.:.,.:.:.,.:.:.:.:.:.,.:.,.:.:.:.,.:.:.:.:.:.,.:.:.:.,.:.:.:.:.:.:.:.,.:.,.:.:.:.<.:.:.:.<.:.<.:.:.<.:.:.:.:.:.:.:.:.:.:.:.<.:.<.:.:.:.:.:.:.:.:.:.:.:.:.:.:.:.:.:.<.:.:.:.:.:.:.:.:.:.:.:.:.:.:.:.<.:.:.:.:.:.:.:.:.<.:.:.:.:.:.:.:.:.:.<.:.:.:.<.:.:.:.:.:.<.:.:.:.<.:.:.
:.:.:.:.:.:.:.:.:.:.:.:.:.:.:.:.:.:.:.:.:.:.:.:.:.:.:.:.:.:.:.:.:.:.:.:.:.:.:.-.:.:.:.:.:.:.:.:.:.:.:.-.:.:.:.:.:.:.:.:.:.:.:.-.:.:.:.:.:.:.:.:.:.:.:.:.:.:.:.:.:.:.:.:.:.:.:.:.:.:.:.:.:.:.:.:.:.:.:.:.:.:.:.-.:.:.:.:.:.:.:.:.:.:.:.-.:.:.:.:.:.:.:.:.:.:.:.:.:.:.:.:.:.:.:.:.:.:.:.:.:.:.:.:.:.:.:.:.:.:.:.-.:.:.:.:.:.:.:.:.:.:.:.:.:.:.:.:.:.:.:.-.:.:.:.:.:.:.:.:.:.:.:.:.:.:.:.:.:.:.:.:.:.:.:.:.:.:.:.:.:.:.:.:.:.:.:.:.:.:.:.:.:.:.:.:.:.:.:.:.:.:.:.:.:.:.:.-.:.:.:.:.:.:.:.:.:.:.:.-.:.:.:.:.:.:.:.:.:.:.:.-.:.:.:.:.:.:.:.:.:.:.:.:.:.:.:.:.:.:.:.:.:.:.:.-.:.:.:.:.:.:.:.:.:.:.:.-.:.:.:.:.:.:.:.:.:.:.:.:.:.:.:.:.:.:.:.:.:.:.:.:.:.:.:.:.:.:.:.:.:.:.:.:.:.:.:.:.:.:.:.:.:.:.:.:.:.:.:.:.:.:.:.-.:.:.:.:.:.:.
:.-.-.-.-.-.-.:.-.-.-.-.:.-.-.-.-.-.-.:.-.-.-.-.:.-.-.-.-.-.-.:.-.-.-.:.-.:.-.-.-.:.:.-.-.-.-.:.-.:.-.-.-.:.:.-.-.-.-.:.-.:.-.-.:.-.-.-.:.:.-.:.:.-.-.:.:.-.:.-.-.:.:.-.:.-.-.:.:.-.:.-.-.:.:.-.-.-.-.:.-.:.-.-.-.:.:.-.-.-.-.:.-.:.-.-.:.:.:.:.-.-.-.-.:.-.-.-.:.:.:.-.-.-.-.-.:.-.-.-.:.:.-.:.-.-.-.:.-.:.-.-.:.:.:.-.-.-.-.:.:.:.:.-.-.-.-.:.-.:.-.-.:.:.:.-.-.-.-.-.:.-.-.-.:.-.-.:.-.-.-.-.:.-.-.-.-.:.-.-.:.-.-.-.-.:.-.-.:.-.-.-.-.:.-.-.-.:.-.-.-.-.-.-.-.:.-.-.:.:.:.-.-.-.-.:.-.:.-.-.:.:.:.-.-.-.-.:.-.:.-.-.:.:.:.-.-.-.-.-.:.-.-.-.:.:.-.:.-.-.-.:.-.:.-.-.:.:.:.-.-.-.-.:.-.:.-.-.:.:.-.-.-.-.-.-.:.:.-.-.-.:.-.-.:.:.-.-.-.-.-.-.:.:.-.-.-.:.-.-.:.:.:.:.-.-.:.:.:.:.-.-.:.:.:.:.-.-.-.:.-.:.-.-.:.:.:.-.-.-.
-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.
-.-.-.&.-.-.-.-.-.-.&.-.-.-.-.&.-.-.-.-.-.-.&.-.-.-.-.&.-.-.-.-.-.&.-.-.-.-.-.-.&.-.-.-.-.&.-.-.-.-.-.-.&.-.-.-.-.&.-.-.-.-.-.-.-.-.-.&.-.-.-.-.&.-.-.&.-.-.&.-.-.&.-.-.&.-.-.&.-.-.&.-.-.&.-.-.-.&.-.-.-.-.-.-.&.-.-.-.-.&.-.-.-.-.-.-.&.-.-.-.-.-.&.-.-.-.-.-.&.-.-.-.-.-.&.-.-.-.-.&.-.-.-.-.-.&.-.-.-.-.-.-.&.-.-.-.-.&.-.-.&.-.-.-.-.&.-.-.-.-.-.-.&.-.-.-.-.-.&.-.-.-.-.&.-.-.-.-.-.-.&.-.-.-.-.&.-.-.-.-.-.-.-.&.-.-.-.-.-.-.-.&.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.&.-.-.-.-.&.-.-.-.-.-.-.&.-.-.-.-.&.-.-.-.-.-.-.&.-.-.-.-.-.&.-.-.-.-.&.-.-.-.-.-.&.-.-.-.-.-.-.&.-.-.-.-.&.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.&.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.&.-.-.-.-.-.&.-.-.&.-.-.&.-.-.&.-.-.&.-.-.-.&.-.-.-.-.-.-.&.-.-.-.-.&.
&.&.-.&.&.&.&.&.-.&.&.-.&.&.-.&.&.&.-.&.&.-.&.&.-.&.&.-.&.&.&.&.-.&.&.-.&.&.-.&.&.-.&.&.-.&.&.-.&.&.-.&.&.-.&.&.-.&.&.-.&.&.-.&.&.&.-.&.-.&.&.-.&.&.-.&.&.-.&.&.&.&.&.&.-.&.&.-.&.&.-.&.-.&.&.-.&.&.-.&.-.&.&.-.&.&.-.&.&.-.&.&.&.&.&.&.-.&.&.-.&.&.-.&.&.&.&.&.&.-.&.&.-.&.&.-.&.&.&.&.-.&.&.-.&.&.-.&.&.&.&.-.&.&.&.&.&.&.-.&.&.&.&.-.&.&.&.&.&.&.-.&.&.&.-.&.&.-.&.&.-.&.&.-.&.&.&.&.-.&.&.-.&.&.-.&.&.-.&.&.&.&.-.&.&.-.&.&.&.&.-.&.&.-.&.&.&.&.-.&.&.-.&.&.&.-.&.&.-.&.&.-.&.&.-.&.&.-.&.&.-.&.&.-.&.&.-.&.&.-.&.&.-.&.&.-.&.&.&.-.&.&.-.&.&.-.&.&.&.&.-.&.&.-.&.&.-.&.&.-.&.-.&.&.-.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.-.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.-.&.&.&.&.&.&.&.-.&.&.&.&.&.-.&.&.-.&.&.-.&.&.&.&.-.&.&.&.&.&.&.
&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.
&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.@.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.@.&.&.&.&.&.&.&.&.&.&.&.@.&.&.&.&.&.&.&.&.&.&.&.&.&.&.@.@.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.@.@.&.&.&.&.&.&.@.@.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.@.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.@.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.@.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.@.&.&.&.&.&.&.@.&.&.@.&.&.@.&.&.&.&.&.&.&.&.@.&.&.@.&.&.&.&.&.&.&.&.@.&.&.@.&.&.@.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.@.@.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.@.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.@.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.&.
@.@.&.@.&.@.@.&.@.&.@.@.@.@.&.@.@.&.@.@.@.&.&.@.@.&.@.@.&.@.@.&.@.&.@.@.@.&.@.@.@.&.&.@.@.&.@.@.@.&.@.@.@.&.&.@.@.&.@.@.@.&.@.@.@.&.@.@.&.@.&.&.@.&.@.@.@.@.&.@.&.@.@.&.@.&.@.@.@.@.&.@.&.@.&.&.@.@.&.@.&.@.&.&.@.&.@.@.@.@.&.@.&.@.@.&.@.&.@.@.@.@.&.@.&.@.@.&.@.&.&.@.@.&.@.@.&.@.@.&.@.&.@.@.@.@.&.@.@.&.@.&.&.@.@.&.@.@.&.@.@.&.@.&.&.@.@.&.@.@.&.@.@.&.@.@.@.&.&.@.@.&.@.@.&.@.@.&.@.&.@.@.&.@.@.&.@.@.@.&.&.@.&.@.&.@.@.&.&.@.@.&.@.@.@.&.&.@.&.@.&.@.@.&.@.&.&.@.&.&.@.&.@.&.@.@.@.@.@.&.&.&.@.&.@.&.@.&.@.@.@.&.&.&.@.&.&.O.&.&.&.O.&.O.@.@.&.@.@.&.O.&.O.&.O.&.@.@.&.O.&.@.&.&.@.&.O.&.&.@.&.@.&.@.&.@.&.@.&.@.&.@.&.&.&.@.&.@.&.@.&.@.&.@.&.@.&.@.&.&.&.@.@.&.@.@.&.@.&.@.@.&.@.&.@.@.@.@.&.@.@.&.@.&.&.@.@.&.@.&.
@.@.@.@.@.&.@.@.@.&.@.@.@.@.&.@.@.@.@.&.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.&.@.@.@.&.&.@.@.@.@.@.@.&.@.@.@.&.&.@.@.@.@.@.@.&.@.@.@.&.@.@.@.@.@.@.@.@.@.&.@.@.@.@.&.@.@.&.@.@.@.&.@.@.@.@.@.@.&.@.@.@.@.@.@.&.@.@.@.@.@.@.&.@.@.&.@.@.@.&.@.@.@.&.@.@.@.@.@.@.@.&.@.@.@.@.&.@.@.@.@.&.@.&.@.@.@.@.&.@.@.@.@.@.&.@.@.@.@.@.&.@.@.@.&.@.@.@.@.@.@.@.&.@.@.@.@.@.&.@.@.&.@.&.@.@.@.@.@.&.@.&.@.@.@.&.@.@.@.@.@.&.@.&.@.@.@.@.@.&.@.&.@.@.@.@.@.&.@.&.@.@.@.@.@.&.@.&.@.@.&.@.@.@.@.@.@.&.@.@.@.&.@.@.&.@.@.@.@.&.@.@.@.@.@.@.@.@.@.@.@.@.&.O.&.&.O.&.@.@.@.&.&.@.@.&.&.@.@.&.@.&.@.&.O.&.&.O.&.&.O.&.@.@.@.&.@.@.&.@.@.&.@.&.@.@.&.@.@.@.@.&.@.@.&.@.@.&.@.&.@.@.&.@.@.@.@.@.&.@.@.@.&.@.@.&.@.@.@.@.&.@.@.@.@.@.&.@.@.@.&.@.&.@.@.@.
@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.O.&.O.O.@.@.@.&.O.O.@.@.O.O.@.@.O.@.O.@.@.@.O.O.O.&.O.O.@.@.@.&.O.@.@.@.@.@.@.@.O.@.@.@.@.@.@.@.O.@.@.@.@.@.@.@.O.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.O.@.O.@.@.@.
@.@.@.@.@.@.@.@.@.@.@.o.@.@.@.@.@.@.@.@.@.@.@.@.@.@.o.@.@.@.@.@.@.@.o.o.@.o.@.o.o.@.@.@.o.@.o.@.@.@.o.@.o.@.@.@.@.o.@.o.@.@.@.@.@.@.o.@.@.@.@.@.@.@.@.@.@.@.@.@.@.o.o.@.@.o.o.@.@.@.@.@.@.@.o.@.@.@...@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.O.@.O.@.@.@.@...@.@.@.@.O.@.O.O.@.O.O.@.O.O.@.@.O.@.O.@.@.O.@.O.@.O.@.@.O.@.O.O.@.O.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.o.@.@.o.o.@.@.o.o.@.@.o.o.@.@.o.o.@.@.@.o.@.@.@.@.@.@.@.o.@.@.@.@.@.@.@.o.@.@.@.@.@.@.@.o.@.@.@.@.@.o.@.@.@.o.@.o.@.@.@.@.@.@.@.@.o.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.O.O.@.O.O.O.O.O.@.O.@.O.@.O.@.O.@.O.@.@.O.O.@.@.O.O.@.O.O.@.O.O.@.O.O.@.O.O.@.O.@.O.O.O.@.@.@.O.@.O.O.@.O.O.@.O.@.O.O.O.@.@.@.@.O.@.O.O.@.O.@.@.O.O.@.@.O.@.O.@.@.O.@.O.@.O.@.@.O.@.O.O.@.
@.o.o.o.o.o.o.o.o.o.@.o.o.o.o.o.o.o.o.o.@.o.o.@.o.@.o.@.@.o.o.o.o.@.o.@.o.@.o.@.o.o.o.o.@.o.@.o.o.o.@.o.@.o.o.@.o.@.o.@.o.o.o.o.o.@.o.@.@...o.@.@.....@.o...@...@...@.@...@.@.@.@.....@...@.o.@.o.@.@.o...@...@.@.....@.o...@.....@...O.@...@.@.O.O...@.@.O...@.O.O.O.O.O.O.O.O.O.O.O.O.O.O.O.@.O.O.O.O.O.O.O.O.O.O.O.O.O.O.@...@...@...@.....@.@.....@...@.@.....@.@.@...@.@...@...@.@...@.@.@...o.@.....@...@...o.@.....@...@...o.@.....@...@...o.@.....@...@.o.o.o.@.o.@.o.o.o.@...o.@...@.o.o.o.o.o.o.o.o.o.@.o.o.@...o.@.o.O.O.O.O.O.O.O.O.O.O.O.O.O.O.O.O.O.O.O.O.O.O.O.O.O.O.O.O.O.O.O.O.O.O.O.O.O.O.O.O.O.O.O.O.O.O.O.O.O.O.O.O.O.O.O.O.O.O.O.O.O.O.O.O.O.O.O.O.O.O.@...O.O.O.O.O.O.O.@.O.O.O.O.O.O.O.O.O.O.O.O.O.O.
o.o.o.o.o.o.o.o.o.o.o.o.o.o.o.o.o.o.o.o.o.o.o.o.o.o.o.o.o.o.o.o.o.o.o.o.o.o.o.o.o.o.o.o.o.o.o.o.@...o.o.o.o.@...o.o...@.o.o.o.o...@.o.o...@.o.......@...o.@...@.@.......@...@.....@...@.@...@.....@.o.o...@.o.......o.o.o.@...@.O...@.O...@.O.....O.@.....@.O.....@...O...O.O.O.O.O.O.....O.O.O...@.O.....O.......O.O...O.@...O.@.......@...@.....@...@...@.@.......@...@.......@...@...@.......o.o.@...o.@...@.@.......@...@...o.o.@...o.o.o.o.@...o.@...@.@...o.@...o.@...o.@...@...o.@...o.@.o.o.o.o.o.o.o.....o.@...o.o.o.o.O...O.O.O.O.O.O...O.O.....O.....O.O.O...O...O.O.O.O.O.O.O...O.O.O...O...O.O.O.O...O.O.O.O...O...O...O...O.O.O.O.O...O.O.O.O.O.....@...O...O.O.O.O.O.O.....O.O.O...@.O.....O.......O.O...O.@.
o...o...o...........o.....o.o.......o.....o.o...o...o.....o.......o...o...o.......o...o.o.....o.......o.o.........o.......o.....................o.....................@.........................................@...................................................................O.....................O...........................@...........................@...........@...............@.......................@.........o.........o.o.......................o.............o...............o.......o...............o.o.....................O.....O...O.......O...........................O.......................O.......O...................................................O.....................O.................
............ . ................. ... . ..................... ............... . ................. ... . ..................... . ............. . ................. ... . ..................... . ............. . ..................... . ..................... . ......... ... . ......... ... . ............. . ................. ... . ..................... ........... ... . ......... ... . ................. ... . ......................... ... . ................. ... . ......... ... . ............. . ..................... . ..................... . ......... ... . ......... . . . ................. ... . ......................... ... . ................. ... . ......... ... . ............. . .............
 . . . . . . . ... . . . . . . . . . . ... . . . . . . . ... . . . . . . . . . . . . . . . . . . . . . ... . . . ... . . ... . ..... ....... . ..... . . . . ... . . . ..... . ..... . . . . . ..... ....... . . . . . . . . ... . . . ..... . ..... ....... . ......... . . . . . ..... . . . ............. . ....... ......... . . . ....... ..... . . ... . . . ..... . . . . ....... . . . ....... . . . ... . . . ..... . ... . . . . . ... . . . . . . . . . . ... . . . . . ..... . . . ..... . ..... . ..... . . . . ... . . . ..... . ..... . . ... . . . . ... . . . . ....... . . . ..... . . ....... . . . ..... . ..... . . ....... . . . ....... ......... . . . . . ..... . . . ............. . ....... . ...
 . . . . . . . . . . . . . . . . . . . . . . . . . . . . . .[  . . . . . .[  . . . .[  . . . . . .[  . . . .[  . . . . . . .[  . . .[  . .[  . . . .[  . . . . . .[  . . . .[  . . . . . .[  . . . .[  . .[  . . . .[  . . . . . . .[  . . . . . . .[  . .[  . . . . . . .[  . . . . . . .[  . . . . .[  .[  . . . .[  . . . . . .[  . . . .[  . . . . . . . . . . . . . .[  . . . . . . .[  . . . .[  . . . . . .[  . . . .[  . . .[  . . . . . .[  . . . .[  . . . . . .[  . . . . . . .[  . . . . . . .[  . . . .[  . . . . . . .[  . . . . . . .[  . .[  . . . . . . .[  . . . . . .[  . . . . . . . . . . . . . . . . . . . . . . . . . . . .[  . . . .[  . . . . . .[  . . . . . . .[  . . . . .[  .[  . . . .[  . . .
 .[ [ [ [  .[  .[  .[ [  .[ [ [ [  .[  .[  .[ [  .[ [ [  .[  .[  .[  .[  . .[  .[ [  . . .[  .[  . .[  .[ [  . . .[  .[  .[  .[  . . .[  . .[  .[ [  . . .[  .[  . .[  .[ [  . . .[  .[  . .[  . . . .[  . .[  .[ [  . . .[  .[  .[  .[ [ [ [  . . . .[  . .[  .[  .[  .[  .[  .[  .[  .[  .[  . . .[  . . .[  .[ [  . . .[  .[  . .[  .[ [  . . .[  .[ [  .[ [ [  .[  .[  .[  .[  .[  .[  .[  .[ [  . . .[  .[  . .[  .[ [  . .[ [  . . .[  .[  . .[  .[ [  . .[  .[  .[  .[  .[  .[  .[  .[  . .[  .[  . .[  .[ [  . . .[  .[  .[  .[ [ [ [  . . . .[  . .[  .[  .[  .[  .[  . .[  .[  .[  .[ [  .[ [  .[ [ [ [  .[  .[  .[ [ [  .[ [  .[ [ [  . .[  .[ [  . .[  .[  .[  .[  .[  .[  .[  .[  . . .[  . . .[  .[ [  . . .[
[ [ [  .[ [  .[ [ [ [  .[ [ [  .[ [  .[ [ [ [  .[ [ [  .[  .[ [ [ [ [ [ [ [ [  .[ [  .[ [ [ [ [ [ [ [  .[ [  .[ [ [ [ [ [  .[ [  .[ [ [ [ [ [  .[ [  .[ [ [ [ [ [ [ [  .[ [  .[ [ [ [ [ [ [ [ [  .[ [ [ [ [ [  .[ [  .[ [ [ [ [ [  .[ [ [  .[ [  .[ [ [ [ [ [ [ [ [  .[ [ [  .[ [ [  .[ [ [  .[ [  .[ [ [ [ [  .[ [  .[ [ [ [ [ [ [ [  .[ [  .[ [ [ [ [  .[ [ [ [ [  .[ [ [  .[ [ [  .[ [ [  .[ [ [  .[ [ [ [ [ [ [ [  .[ [  .[ [ [  .[ [ [ [ [ [ [ [  .[ [ [ [ [ [  .[ [ [  .[ [ [  .[ [ [  .[ [ [ [ [ [ [ [  .[ [  .[ [ [ [ [ [  .[ [ [  .[ [  .[ [ [ [ [ [ [ [ [  .[ [ [  .[ [ [ [  .[ [ [  .[ [  .[ [ [  .[ [ [  .[ [ [ [  .[ [ [  .[ [ [  .[ [ [  .[ [ [ [ [ [  .[ [ [  .[ [ [  .[ [ [  .[ [  .[ [ [ [ [  .[ [  .[ [ [
[ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [
[ [ [ ` [ [ [ [ [ [ [ [ [ ` [ [ [ ` [ [ [ [ [ ` [ [ [ [ [ ` [ [ [ [ [ [ [ [ [ ` [ [ [ [ [ ` [ [ [ ` [ [ [ [ [ ` [ [ [ [ [ ` [ [ [ ` [ ` [ [ [ [ [ ` [ [ [ [ [ [ ` [ [ ` [ [ [ [ [ ` [ [ [ [ [ [ [ ` [ ` [ [ [ [ [ ` [ [ [ [ [ [ ` [ [ ` [ [ [ [ [ ` [ [ [ [ [ [ [ [ [ [ [ [ [ [ ` [ ` [ ` [ ` [ [ [ [ [ [ [ ` [ ` [ [ [ ` [ ` [ [ [ ` [ ` [ [ ` [ [ [ [ [ ` [ [ ` [ ` [ [ [ [ [ ` [ ` [ [ [ [ [ [ [ [ ` [ [ [ [ [ ` [ ` [ [ [ [ [ ` [ [ [ [ [ ` [ [ [ [ [ [ ` [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ ` [ [ ` [ ` [ [ ` [ [ [ [ [ [ [ [ ` [ [ [ [ [ ` [ [ [ [ [ ` [ [ [ ` [ [ [ ` [ [ [ ` [ [ [ [ [ ` [ [ [ ` [ ` [ [ [ ` [ ` [ [ [ ` [ ` [ [ [ ` [ ` [ [ [ ` [ ` [ ` [ ` [ ` [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ ` [ ` [ [ [ ` [
` ` ` ` ` ` ` ` ` ` ` ` [ ` ` ` [ ` ` ` ` ` [ ` ` ` ` ` [ ` ` ` [ ` ` ` ` ` [ ` ` ` ` ` [ ` ` ` [ ` ` ` ` ` [ ` ` ` ` ` [ ` ` ` [ ` [ ` ` ` ` ` [ ` ` ` ` ` ` [ ` ` ` ` ` ` ` ` [ ` ` ` ` ` ` [ [ ` [ ` ` ` ` ` [ ` ` ` ` ` ` [ ` ` ` ` ` ` ` ` [ ` ` ` ` ` ` [ ` ` ` ` ` ` ` ` ` [ ` [ ` [ ` [ ` ` ` ` ` [ ` [ ` ` ` [ ` [ ` ` ` ` ` [ ` ` ` ` ` ` ` ` [ ` ` ` ` [ ` [ ` ` ` ` ` [ ` [ ` ` ` ` [ ` [ ` ` ` ` ` [ ` [ ` ` ` ` ` ` ` ` ` ` ` [ ` ` ` ` ` ` ` ` [ ` ` ` ` ` ` ` ` ` ` ` ` ` ` ` ` [ ` [ ` ` ` ` [ ` ` ` ` ` ` ` ` ` [ ) [ ` ` ` [ ) [ ` ` ` [ ) [ ` [ ) [ ` [ ) [ ` [ ) [ ` [ ) [ ` [ ` ` ` [ ` [ ` ` ` [ ` [ ` ` ` [ ` [ ` ` ` [ ` [ ` ` ` [ ` [ ` [ ` [ ` [ ` [ ` ` ` ` ` ` ` ` ` ` ` ` ` [ ` [ ` ` ` [ ` [
` ` ` ` ` ` ` ` ` ` ` ` ` ` ` ` ` ` ` ` ` ` ` ` ` ` ` ` ` ` ` ` ` ` ` ` ` ` ` ` ` ` ` ` ` ` ` ` ` ` ` ` ` ` ` ` ` ` ` ` ` ` ` ` ` ` ` ` ` ` ` ` ` ` ` ` ` ` ` ` ` ` ` ` ` ` ` ` ` ` ` ` ` ` ` ` ` ` ` ` ` ` ` ` ` ` ` ` ` ` ` ` ` ` ` ` ` ` ` ` ` ` ` ` ` ` ` ` ` ` ` ` ` ` ` ` ` ` ` ` ` ` ` ` ` ` ` ` ` ` ` ` ` ` ` ` ` ` ` ` ` ` ` ` ` ` ` ` ` ` ` ` ` ` ` ` ` ` ` ` ` ` ` ` ` ` ` ` ` ` ` ` ` ` ` ` ` ` ` ` ` ` ` ` ` ` ` ` ` ` ` ` ` ` ` ` ` ` ` ` ` ` ` ` ` ` ` ` ` ` ` ` ` ` ` ` ` ` ` ` ` ` ` ` ` ` ` ` ` ` ` ` ` ` ` ` [ ) ` ` ` [ ) ` ` ` ` ` [ ) ` ` ` ` [ ) ` ` [ ) ` ` [ ) ` ` [ ) ` ` ` ` [ ) ) [ ` ` ` ` ) [ ` ` ` ` ` ` ` ` ` ` ` ` ` ` ` ` ` ` ` ` ` ` ` ` ` ` ` ` ` ` ` ` ` ` ` ` ` ` ` ` ` ` ` ` ` ` ` `
` ` ` ` / ` ` ` ` / ` ` ` ` / ` ` ` / ` ` / ` ` ` / ` ` ` ` / ` ` ` / ` ` / ` ` ` / ` ` ` ` / ` ` ` / ` ` / ` ` ` / ` ` ` ` / ` ` ` ^ ` ^ ` ` ` ` ^ ` ` ` ` ` ^ ` ` ` ` ^ ` ` ` ` ^ ` ` ` ` ` ^ ` ` ^ ` ^ ` ` ` ` ^ ` ` ` ` ` ^ ` ` ` ` ^ ` ` ` ` ^ ` ` ` ` ` ^ ` ) ` ) ` ) ` ` ) ` ) ` ) ` ) ` ` ) ` ) ) ` ) ` ` ) ` ) ) ` ) ` ` ` ` ` ` ` ` ` ^ ` ` ` ` ^ ` ` ` ` ^ ` ` ` ` ` ` ` ^ ` ` ` ` ` ` ^ ` ` ` ` ^ ` ` ` ^ ` / ` ` ` ` ` ` ` ` ` ` / / ` ` ` ` ` / ` ` ` ` / ` ` ` ` ` ` ` / ` ` ` ` ` / ` ` ` ` / ` ` ` ` ` / ` ` ` ) ` ) ) ) ) ) ` ) ` ) ) ) ` ) ` ) ) ) ` ) ) ) ` ) ) ) ` ) ) ) ` ` ) ` ) ) ` ) ) ) ` ) ` ) ) ` ) ) ` ) ` ` ) ` ) ) ` ) ` ) ` ) ` ) ` ) ` ) ` ) ` ` ) ` ) ` ) ` ` ` ) ` ) ) ` ) ` ` ) ` ) ) )
/ ` ` ` ` ` / ` ` / ` ` / ` ` ` / ` ` ` / / ` / ` / ` ` / ` ` ` / ` ` ` / / ` / ` / ` ` / ` ` ` / ` ` ` / / ` / ` / ` ` / ` ` ` ` ^ ` ^ ` ` ` ^ ` ` ^ ` ^ ` ^ ` ` ^ ` ^ ` ` ` ^ ` ` ^ ` ^ ` ^ ` ` ^ ` ^ ` ` ` ^ ` ` ^ ` ^ ` ^ ` ` ^ ` ^ ` ` ` ^ ` ` ^ ` ^ ` ^ ` ) ) ) ) ` ) ) ) ) ) ) ) ) ) ) ` ^ ` ) ) ) ) ) ) ) ` ) ) ) ) ) ) ` ^ ` ^ ` ` ` ` ` ^ ^ ` ` ^ ` ` ^ ` ^ ` ` ` ^ ^ ^ ` ^ ` ` ` ^ ^ ` ^ ` ` ^ ` ` ` ` / ^ ` ` ` ` ^ ` ` ^ / ` / ^ ` ` ^ ` ` ^ ` ` ` ^ / ` / ` ` ^ / ^ / ` / ` ` ^ / / ` ` ` ^ ` ` ` ` / ^ ` ` ` ` ^ ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ` ) ) ) ) ) ` ) ) ) ` ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ` ) ) ) ) ` ) ) ) ) ) ` ) ) ) ) ) ) ) ) ) ) )
/ / ^ / ^ / / / / ` ^ / / / ^ / / / ^ / / ` ` / / ` ^ / / / ^ / / / ^ / / ` ` / / ` ^ / / / ^ / / / ^ / / ` ` / / ` ^ / / / ^ / ^ ` ^ ` ^ ^ ^ ` ^ ` ` ^ ^ ` ^ ` ^ ` ^ ` ^ ^ ^ ` ^ ` ` ^ ^ ` ^ ` ^ ` ^ ` ^ ^ ^ ` ^ ` ` ^ ^ ` ^ ` ^ ` ^ ` ^ ^ ^ ` ^ ` ` ^ ^ ` ^ ` ^ ) ) ^ ^ ) ^ ) ^ ) ^ ) ) ) ) ^ ) ^ ) ) ) ^ ) ) ^ ^ ) ) ^ ) ^ ) ^ ` ^ ` ^ ^ ^ ^ ^ ` ` ^ ` ^ ^ ` ` ^ ` ^ ^ ` / ` ` ^ ` ^ ^ ` / ` ` / ^ ` / ^ ^ ` ^ ` / ` ^ ^ ` / ^ ` / ` ^ ` / ` ` / ^ ` / ^ ^ ` ^ ` ` / ^ ` / ` ^ ` ` / ^ ` / ` / ^ ^ ` / ^ ^ ` ^ ` / ` ^ ^ ` / ^ ) ) ) ) ^ ) ) ) ) ^ ) ) ) ^ ) ) ) ) ^ ) ) ) ^ ) ) ) ^ ) ) ) ^ ) ^ ) ) ) ^ ) ) ) ) ^ ) ) ^ ) ^ ) ) ) ^ ) ) ^ ^ ) ^ ) ) ) ^ ) ) ^ ) ^ ) ) ) ) ^ ^ ) ) ^ ^ ) ^ ) ) ^ ^ ) ) ^ ) ) ) ) ^ ) ^ )
/ / / / / / / / / / / / / / / / / / / / / / ^ ^ / / / / / / / / / / / / / / ^ ^ / / / / / / / / / / / / / / ^ ^ / / / / / / / / ^ ^ ^ ^ ` ^ ^ ^ ^ ^ ^ ^ ^ ` ^ ^ ^ ^ ^ ^ ` ^ ^ ^ ^ ^ ^ ^ ^ ` ^ ^ ^ ^ ^ ^ ` ^ ^ ^ ^ ^ ^ ^ ^ ` ^ ^ ^ ^ ^ ^ ` ^ ^ ^ ^ ^ ^ ^ ^ ` ^ ^ ^ ) ^ ^ ^ ) ^ ) ^ ^ ^ ) ^ ^ ^ ^ ^ ^ ) ^ ^ ^ ) ^ ^ ) ) ^ ^ ^ ^ ) ^ ^ ` ^ ^ ^ ^ ^ ^ ^ ^ ` ^ ^ ^ ^ ^ ^ ^ ^ / / / / ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ / / / ^ ^ / / ^ ^ ^ ^ / / / / ^ ^ ^ ^ ^ ^ ^ ^ ^ / / / ^ ^ ^ ^ / / / / ^ ^ ^ ^ / / ^ ^ ^ / / / ^ / / / ^ ^ / / ^ ^ ^ ^ ^ ) ^ ) ^ ^ ^ ^ ^ ^ ^ ) ^ ^ ^ ) ^ ) ^ ^ ^ ^ ) ^ ^ ) ^ ^ ^ ^ ^ ^ ^ ^ ) ^ ^ ^ ) ^ ^ ^ ^ ) ^ ) ^ ^ ^ ^ ) ^ ^ ^ ^ ^ ^ ^ ) ^ ^ ^ ) ^ ^ ^ ^ ) ^ ^ ) ^ ^ ) ^ ^ ^ ) ^ ^ ^ ^ ^ ) ^ ^ ) ^ ^ ^ ^ ) ^ ^
^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^
^ ^ ! ^ ! ! ! ! ^ ! ^ ! ! ! ! ! ^ ^ ! ^ ! ! ! ! ^ ! ^ ! ! ! ! ! ^ ^ ! ^ ! ! ! ! ^ ! ^ ! ! ! ! ! ^ ^ ! ^ ! ! ! ! ^ ! ^ ! ! ! ! ! ^ ^ ! ^ ^ ! ^ ! ^ ! ^ ! ^ ! ^ ! ^ ^ ! ^ ^ ! ^ ! ^ ! ^ ! ^ ! ^ ! ^ ^ ! ^ ^ ! ^ ! ^ ! ^ ! ! ! ! ! ^ ^ ! ^ ! ! ! ! ^ ! ^ ! ! ! ! ! ^ ^ ^ ! ^ ! ^ ! ! ^ ! ^ ! ^ ! ^ ^ ! ^ ! ^ ! ! ! ^ ! ! ! ! ^ ! ^ ! ! ^ ! ^ ! ! ! ! ! ! ! ! ^ ! ! ^ ^ ! ! ! ! ^ ! ! ! ^ ! ^ ! ! ! ! ^ ! ^ ! ^ ! ! ^ ^ ^ ! ^ ! ^ ! ! ! ^ ! ^ ! ^ ! ! ^ ! ^ ! ^ ! ! ^ ^ ^ ! ^ ! ^ ! ! ! ^ ! ^ ! ^ ! ! ^ ! ^ ! ^ ! ! ^ ^ ^ ! ^ ! ^ ! ! ! ^ ! ^ ! ^ ! ! ^ ! ^ ! ^ ^ ! ^ ^ ^ ! ^ ! ^ ! ! ! ^ ! ^ ! ! ! ! ! ! ! ! ! ! ! ^ ^ ! ! ! ! ^ ! ! ! ^ ! ^ ! ! ! ^ ! ^ ! ^ ! ! ! ^ ^ ! ! ! ^ ! ^ ! ! ^ ! ^ ! ^ ! ! ^ ! ^ ! ^ ! ! ^ ^ ^ ! ^ !
! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ^ ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ^ ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ^ ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ^ ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! !
! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! R R ! ! ! ! ! ! R R ! ! ! ! ! ! R R ! ! ! ! ! ! R R ! ! ! ! ! ! R R ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! R ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! R ! ! ! ! ! ! ! R ! ! ! ! ! ! ! ! ! ! ! R ! ! ! R ! ! ! ! ! ! ! R ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! R ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! R ! ! ! R ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! R ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! R ! ! ! ! ! ! ! ! R !
R R ! R ! R R ! R R ! R ! R R ! R R ! R ! R R ! R R ! R ! R R ! R R ! R ! R R ! R R ! R ! R R ! R R ! R ! R R ! R R ! R ! R R ! R R ! R ! R ! ! R R ! R ! R ! ! R R ! R ! R ! ! R R ! R ! R ! ! R R ! R ! R ! ! R R ! R ! R R ! R R ! R ! R R ! R R ! R ! R R ! R ! R R R R ! R R ! R R R ! ! R R R R ! R R ! R ! R R ! R ! R R R ! R R ! R R ! ! R ! R ! R R ! ! R R ! R R ! R R ! R R ! R R ! ! R ! R ! R R ! ! R R ! R R ! R R ! R R ! R R ! ! R ! R ! R R ! ! R R ! R R ! R R ! R R R ! R R ! R ! R ! R R ! R ! R R R R ! R R ! R ! R ! R R ! R ! R ! R ! ! R ! R R R R ! R R ! R R ! R R ! ! R ! R ! R ! R ! R R ! R R ! R R ! R R ! R R ! ! R ! R ! R R ! ! R R ! R R ! R R ! R R R ! R R ! R ! R ! R R ! R ! R R ! !
R R R R R ! R R R ! R R R ! R R R R R R R ! R R R ! R R R ! R R R R R R R ! R R R ! R R R ! R R R R R R R ! R R R ! R R R ! R R R R R R R ! R R R ! R R R ! R R R R R R R ! R R R ! R R R ! R R R R R R R ! R R R ! R R R ! R R R R R R R ! R R R ! R R R ! R R R R ! R R ! R R R R R ! R R R R R ! R R R R R ! ! R R R R R R ! R R R ! ! R R R R R R ! R ! R R R R ! R R ! R R R R R ! ! R R R R R R ! R ! R R R R ! R R ! R R R R R ! ! R R R R R R ! R ! R R R R ! R R ! R R R R R ! ! R R R R R R ! R ! R R R R ! R R ! R R R R R R R R R R R R R R R R R R R ! R R R R ! R R R R ! ! R R R R R R ! R R R ! R R R R R ! R R R R R ! ! R R R R R R R R R ! R R ! R R R R ! R R R R ! ! R R R R R R ! R ! R R R R ! R R R
R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R
R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R R U R U R U R U R U R U R U R R R U R U R U R R R R R U R U R R R U R U R U R U R U R U R U R R R U R U R U R U R U R U R U R R R U R U R U R U R U R U R U R R R U R U R U R U R U R U R U R R R R U R R R R R R R R R R R R U R R R R R R R R U R R R R R U R R U R U R R R U R U R R U R U R R R U R U R R R R U R U R R R U R U R R U R R R R R U R R R R R R U R U R R R U R U R R U R R R R R U R R R R R R U R U R R R U R U R R U R R R R R U R R R R R R R R R R R R R R R R R R R R R R R U R R R R R R R R R U R R R R R U R R R R R R R R U R R R R R U R U R R R U R R R U R R R R U U R R R R U R R U R U R R R U R U R R U R R R R R U R R
R U U U U U U U U U U U U U U U R U U U U U U U U U U U U U U U R U R U R U R U R U R U R U R U R U R U R U R U U U U U R U R U U R U R U R U R U R U R U R U R U R U R U R U R U R U R U R U R U R U R U R U R R U R U R U R U R U R U R U R U R U R U R U R U U U R U U U U U U U U U R U U R U R U U U U U U R U U U U U R U U U R U R U U U R U R U U R U R U U U R U R U U U R U R U U U R U R U U R U U U U U R U U U U U U R U R U U U R U R U U R U U U U U R U U U U U U R U R U U U R U R U U R U U U U U R U U U U U U R P U R U U R P U R U U R P U R P R U U U U U U U U U R U U U U U R U U U U U R U U R U R U U U U R U R U U U R U R U R U U U U R R U U U U R U R U R U U U R U R U U R U U U U U R U U U
U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U U
U P U U U P U U U P U U P U P U U P U U U P U U U P U U U P U U P U P U P U P U P U P U P U P U P U P U P U P U P U P U P U P U P U P U P U P U P U P U P U P U U P U U U P U P U P U U U P U U U P U P U P U P U P U P U P U P U P U P U P U P U P U P U P U P P U P U U P P U P U U P P U P U U P P U P U U P P U P U U P P U U U U P P U P U U P P U U U U P P U P U U P P U U U U P P U P U U P P U U U U P P U P U U P P U U U U P P U P U U P P U U U U P P U P U U P P U U U U P P U P U U P P U U U U P P U P U U P P U P U U P P U P U U P P U P U U P P U P U U P P U P U U P P U P U U P P U P U U P P U P U U P P U P U U P P U P U U P P U P U U P P U P U U P P U P U U P P U P U U P P U P U U P P U P U U P
K P P P K P P P K P P P P P P P K P P P K P P P K P P P K P P P P P U P P P P P P P U P P P P P P P U P P P P P P P U P P P P P P P P P P P P P P P P P P P P P P P P P P P P P P P P P P P P P P P P P P P P P P P P P P P P P P P P P P P P P P P P P P P P P P U P U P P P P U P P P P U P U P P P P U P P K P U P U P P P P U K P P K U K U P U K U U K P U K U K U P U K U U K P U K U K U P U K U U K P U K U K U P U K U U K P P K U K U P U K U U K P U K U K U P U K U U K P U K U K U P U K U U K P U K U K U P U K U P P P P P U P P P P P P P P P K P P P P P P P P U P P P P U P U P P P P U P P K P U P U P P P P P P P P P P P P P P P P P P P P P P P P P P P P P P P P P P P P P P P P P P P P P P P P P P
P K P K P K P K P K P K P K K K P K P K P K P K P K P K P K K K K K K P K K K K K K K P K K K K K K K P K K K K K K K P K K K K P K P K P K P K P K P K P K K K K K K P K K K K K K K P K K K K P K P K P K P K P K P K P K K K P K P K P K P K P K P K P K P K K K K K K P K K K P K K K K K K K P K K K P K K K K K K K P K K P K K K K P K P K K K K P K K K K P K P K K K K P K K K K P K P K K K K P K K K K P K P K K K K P K K K K P K P K K K K P K K K K P K P K K K K P K K K K P K P K K K K P K K K K P K P K K K K P K P K K K K P K P K K P K P K K P K P P K P K K P K K K K K K K P K K K P K K K K K K K P K K P K P K K P K P P K P K P K P K K P K P P K P K P K P K K P K P P K P K P K P K K P K P P K
K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K
K K K F K K F K K K K F K K K K K K K F K K F K K K K F K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K K F K K K K F K K F K F K K K K K K K K K K K K K K K K K F K K K K F K K F K K K K F K K K K K K F K K K K F K K F K K K K F K F K K K K K K K K F K K K K K K K K K K F K K K F K K K K K K K F K K K F K K K K K F K K F K K K F K K K F K K K F K K K K K K K K F K K K F K K F K K K K F K F K K K F K K K K F K K K F K K K F K K K F K K K F K K K K F K K K F K K F K K K F K K K F K K K F K K K K K K K K K K F K K K K K K K K K F K K F K K K K K K K K K K F K K K F K K K K K K K K F K K K K K K K K K K K K K K K K K K K K F K K F K K K K K K K K K K K K K K K K K K K
K K F K F K F K K K F K K F K F K F K F F K F K K F F K K F K F F K F F K F K K F K F F K F K F F K F F K F K K F K F F K F K F K F K F K F F K K F K F K K K F F K F F K F K K F K F F F K F K K F K F K F F K K F K F K F K F K F K F K F F K K F K F K F F K F K F K F K F F F K F K F F K F F F K K F F K K F K F K F K F F K K K F K F F K F K K K F K K K F K K K K F K F F K F K F F K F F K K K F K K K F K K K K F K F K K K F K F K F F K K K F K K K F K K K K F K F K F F K F K K K F K K K F K K K F K K K K F K F F K F K F F K F F F K K F F K K F F K F K K F K F K F K F F K F F F K K F F K K F K F K F K F F F K F K F F K F F K F F F K F F F F K F K F F K F K F K F F K F F K F F F K F F F F K F K F
F F F F K F F F F F F F F F F F F K F F F K F F F K F F F F F F F F K F F F F F F F K F F F F F F F K F F F F F F F K F F F F F F K F F F K F F F K F F F F F F F F K F F F F F F F K F K F F F F K F F F K F F F K F F F F F F F K F F F K F F F K F F F K F F F F K F F F K F K F F F K F F F F K F F F K F F F F K F F F K F F F F K F F F F F F F F F F F F F F F F F K F F F K F F F K F F F F F F F F F F F F F F F K F F F F F K F F F F F F F F F F F F F F F F F K F F F K F F F F F F F F F F F F F F F F F F F K F F K F F F K F F F F K F F F K F F K F F F F F F F K F F F K F F F F K F F F K F F F F K F F F K F F K F F F K F F F F K F F F K F F K F F F K F F K F F F K F F F F F F K F F F K K F F F F F
F F F F F F F F F F F F F F F F F F F F F F F F F F F F F F F F F F F F F F F F F F F F F F F F F F F F F F F F F F F F F F F F F F F F F F F F F F F F F F F F F F F F F F F F F F F F F F F F F F F F F F F F F F F F F F F F F F F F F F F F F F F F F F F F F F F F F F F F F F F F F F F F F F F S F F F F F F F F F F F F F F F F F F F F F F F S F F F F F F F F F F F F F F F F F F F F F F F S F F F S F F F F F F F F F F F F F F F F F F F F F F F F F F F F F F F F F F F F F F F F F F F S F F F S F F F F F F F F F F F F F F F F F F F S F F F S F F F F F F F F F F F F F F F F F F F S F F F F F F F F F F F F F F F F F F F F F F F S F F F F F F F F F F F F F F F F F F F F F F F S F F F F F F F F F F
S F S S S S S F S F F S S F S S S F S S S S S F S F F S S F S S F F S S S S S F S F F S S F S S F F S S S S S F S F F S S F S S F F S F F S S F S F F S S F F F F F S S S S S F F F S F F S S F S F S S S S S F S S S S S F S S F F F S S F F S F S S F F S S F F F S F S S F S F S S F S S F S S F S S S F S S F F S S S S S F S S S S S F S S S F S S S F S S F S S F S F F S F S S F S F F S S F S S S F S S S F S S S S S F S F F S S F S S F S S F F S F S F F F S S S F S F S S F S F F S S F S S S F S S S F S S S S S F F S S F F S S F S F S S S F S S F S S F S S F S F S S F S S F S S F S S S F S S F F S S S S S F F S S F F S S F S F S S S F S S F S S F S S F S F S S F S S F S S F S S S F S S S F S S S S
S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S
S S S S S S S S B S S S S S S S S S S S S S S S B S S S S S S S S S S S S S S S B S S S S S S S S S S S S S S S B S S S S S S S S S B S B S S S S B S S S S S B S S S S B S S S B S S S S S B S S S S S S S S S S S S S S S S S S S B S B S S S S B S S S S S B S S S S S S B S S S S S S S B S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S S B S S S S S S S B S S S S S S S S S S S S S S S S S S S B S S S S S S S S S S B S S S S S B S S S S B S S S S S B S S S S S S S S S S S S S S S S S S S S B S S S S S B S S S S S S S S S S S S S S B S S S S S S S B S S S S S S S S S S S S S S S S S S B S S S S S B S S S S S S S S S S S S S S B S S S S S S S B S S S S S S S S S S S S S S S
B S B S B B S S B S S S B S B S B S B S B B S S B S S S B S B S B S B S B B S S B S S S B S B S B S B S B B S S B S S S B S B S B S B S S B S B B S B S S S S S S S S S S B S S B S S S S S S S B S B S B B S S S B S S B S B S B S B S S S S B S S B S S S S S B S S S B S S S B S S S B S S S B S B S S B S S B S B S B B S S S B S S S S S S B S B S S B S S B S S B S B B S B S S B S B B S B S B S S S B S B S B S B B S S B S S S B S B S B S B S S B S S S B S S B S S S B S S B S B B S B S B S S S B S B S B S B B S S S S B S S S S S B S B S S S B S B S S S B S S S B S S S B S S S B S B S S B S S B S B S B B S S S S B S S S S S B S B S S B S S B S S S B S S S B S S S B S S S B S B S S B S S B S B S B S
B S B S B S B B S B B B B S B S B S B S B S B B S B B B S B S S B S B S B S B B S B B B B S B S B S B S B S B B S B B B S B S S S B S B B S B S S B S B B B N B B B N B B S B N S B N B B B N B S B S S B S B B S B B B S B S S S B S S B B B S B B S B B B B B B B B S B B B S B B B S B B B S S B S B S B B B S B S S B S B B S B B B B B B B S B S B S B B B B B S B B S S B B B S B B S S B S B S B B S S B B S B S B S B B S B B B S B S S B S B B S B B B S B B S S B B S B B S B B S S B S B S B B S S B B S B S B S B B B S S B B B B B S B S B B S S B B B B S B B B S B B B S B B B S S B S B S B B B S B S S B S B B B S S B B B B B S B S B S B B B B B B S B B B S B B B S B B B S S B S B S B B B S B S S S B
B S B B B S B B B S B B B S B B B S B B B S B B B S B B B B B B B S B B B S B B B S B B B S B B B S B B B S B B B S B B B B B B N B B S N S B B B S S B B B B S B B B S S B B S B S S B B B B S N B B B B S B B S B B B N B B B N B B B S B B B B S N S B B S N B B S B B S B B B B S B B S B B B B N B S B B B N B B B B S B B S B B B B B B S B B B B B B S B B B S B B B B S B B S B B B B S B B B B B B B B B S B B B S B B B S B B B B B B B B B S B B S B B B B B B B B B B B S B B B B S B B B B B B B B B S B B B S B B B B S B B B S B B B N B B B S B B B S B B S B B B B S B B S B B B B N B S B B B N B B B B S B B B B S B B B S B B B N B S B B B B B S B B S B B B B S B B S B B B B N B S B B B N B B B B B
B N B B B B B B B B B B B N B B B N B B B B B B B B B B B B B B B N B B B B B B B B B B B N B B B N B B B B B B B B B B B B B B B B B B N B B B N N N B B B B B B B N N N N N N N N N B B B B N B B B B N B B B B B B B B B B B B B B N N B B B B B N B B B B B B B N N B B N B B B N N B B N B B B B B B B B B B B B B N B B B B B B B B B B B B B B B B B B B B B B B B B B B B B B B B B B B B B B B B B B B B B B B B B B B B B B B B B B B B B B B B B B B B B B B B B B B B B B B B B B B B B B B B B B B B B B B B B B B B N N B B B B B B B B B B N N B B B N N B B N B B B N N B B N B B B B B B B B B B B B B N B B B B N N B B B B B B B B B B B B B B B N N B B N B B B N N B B N B B B B B B B B B B B B B B N
N B N N N N N N N N N N N N N N N N N B N N N N N N N N N N N N N B N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N m N N N m N N N m N B N N B N N N N N N N N N N N N N N N B m B B B B B B m B m B B m B B B B N N B B N N B B N N B B N N B B N N N B B N B N N B B N B B N N B B N B B N B B m B m B B m m B B m m B B m B B N N B B N N B N N N N N N B B N N N N B B N N N N N N N N N N N N N N N N N N N N m N N N m N N N m N N N m B N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N m N B N m N N N N N N N N B N N N N N N N N N N N N N
m m N m m m m N N m m m m N N m m m m m N m m m m N N m m m m N m m N m m m m N N m m m m N N m m m m N N m m m m N N m m m m N m N N m m m m N N m m m m N N m m m m N N m m m m N N m m m m N m N N m m m m N N m m m m N N m m m m m m N m m m m m N m m m m m N m m m N m m m N m m m m m m N m m N m m m N N m m m m N N m m m m m m m m m m B m m m m m m m m m m m m m m m m m m m m m m m m m m m m m m m m m m m m m m m m m m m m m m m m m B m m m m N N m m N N m m m m m m m m m m m B m m m m m m m m m m m m m m m m m m m N m m m m m N m m m m m N m m m N m m m m N m N m N m m N m m N m m N m m N m m N m m m N m m m N N m m m m N N m m m m N m m m m m m m N m m m N m m N m m N m m m m m N m m N m
m m m m m m m m m m m m m m m m m m m m m m m m m m m m m m m b m m m m m m m m m m m m m m m m m m m m m m m m m m m m m m m m m m m m m m m b m m m m m m m m m m m m m m m m m m m m m m m m m m m m m m m b m m m m m m m m m m m m m m m m m m m m m m m m m m m m m m m m m m m m m m m m m m m m m m m b m m m m m m m m m m m m m m m m m m m m m m m m m m m m m m m m m m m m m m m m m m m m m m m m m m m m m m m m m m m m m m m m m m m b m m m m m m m m m m m m m m m m m m m m m m m m m m m m m m m m m m m m m m m m m m m m m m m m m m m m m m m m m m m m m m m m m m m m m m m m m m m m m m m m m m m m m m m m m m m m m m m m m m m m m m m m m m m m m m m m m m m m m m m m m m m m m m m m m m
b m m m b m b m m m m b b m m m m b b b m m m b b m m m b m b b m b m m m b m b m m b m m b m m b m b m m m m b b m m m b m b m b m m m b m b b m m m b b m m m m b b b m m b m m b m m m b m b b m m m b m b b m m m b b m m m m b m b m m m m m m m m m b m b m m m m m m b b m m m m m m b b b m m m b m b b m m m b b m m m m b m b m m m b m m m m m b m b m m m b m m b m m m b m m m b m m m m m m m m m b m b m m m m b m m m b b m m m b m b b m m m m m m m b m m m b m m m b m m m b m m m m m b m b m m m m m m m m m b b b m m m m m m m m m b m b m m m m m m b b m m m b m m b b m m m b b m m m b m b b m m m b m m m b b m m m b m b b m m m b m m m m m m b b m m b m m m b b m m m m m b m b m m m b m m
b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b b
b b z b b b z b b b z b b b z b z b b b z b b b b b b b b z b b b b z b b b z b b b z b b b z b b b b z b z b b b b z b b b z b b b b b b z b b b z b b b b b b z b b b z b b b b b z b b b z b b b b b b z b b b b z b b b z b b b b z b b z b b b z b b b z b b b b b z b b b b b b b b b z b b b b b b z b b b z b b b b b b b b b z b b z b b b z b b b z b b b z b b b b z b b z b b b b z b b b z b b b z b b b z b b z b b z b b b b b b b b b b b z b b b b z b b b b z b b z b b b b z b b z b b b z b b b b z b b b z z b b b z b b b b b z b b b z b b b b b z b b b b b b b z b b b b z b b b b b b b b z b b b b b b z b b b b b b b b z b b b b b b b b b b b b b b b b b b b z b b b b b b b b b b z b b b b
z z b b z z b b z b b b b z b z b b b z b z b z z z b b z z b b z b b b z b b b z b b b b z b z b z b b z b z b z z b b z z b b z z b b z z b b z b z b z b z z b b b z b z b z z b b b z b b b z z b b z z b b z b z b z b b z b z z b z b b b z b b b z b b b z b z b b b b z z b z b z b z b z z b b z z b b z b z b z b z z b z z b z b b b z b b b z b b b b z b z b z z b b z b z b z z b z b b b b z b z b z z b z b b b z b z b z b z z b z b b z b z b b z b z b z z b b z b z b z z b z b b b z b b b z b b b b z b z b b b z b z b z z b b b z b b b z b z b b b b z z b z b b b b z z b z b z b z z z b z b z z b z z b z b z b z z z b z b z z b z z b z b b z b b z b z z z b z b z b z z z b z z z b z b z b
z b z z z b z z z z z z z b z z z z z b z z z z z b z z z b z z z z z z z z z z z z z z z b z z z z z z z z b z z b z z z b z z z b z z z b z z z z b z z z b z z z z b z z z z z z z z z z z z z b z z z b z z z z b z z z b z z b z z z z z z z z z z z z z z z z z z z z z b z z z z b z z z z b z z z b z z z z b z z z b z z b z z z z z z z z z z z z z z z b z z z b z z z b z z z z b z z z z z z b z z z b z z z z z z z z b z z z b z z z z z z z b z z b z z z b z z z b z z z b z z z z z z z z z z z z z z z b z z z z z b z z z z z z z z z z z z z z z z z z z b z z z z z z z z z z b z z z b z b z z z b z z z z z b z z z b z b z z z b z z z z z z z z z z z z z b z b z z z z z z b z z z b z z b z z z
z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z z
z h z z z h z z z z z z z z z h z z z z z h z z z h z z z h z z z h z z z h z z z z z z z z z h z z h z z z z h z h z z z h z z h z z z h z z z z z z z z h z z z z z z z h z z z h z z z h z z z h z z z h z z z z z z z z z h z z h z z z z z z h z z z h z z z z h z z z h z h z z z h z z z h z z z h z z z z z h z z z h z z z h z z z z z z z z z z z z z z z z z z z z h z z h z z z z z z h z z h z z z z h z z z z h z z z h z z z z h z z h z z z z h z z z z z z z h z z h z z z z z z z z z z z z z h z z z z h z z z z z z z h z z z h z z z h z z z z z z h z z z z z z z z h z z z z h z h z z z z h z z h z z z z z h z h z z z z h z z h z z z z z z z h z z z h z z z h z z z h z z z h z z z z z h z z z
h z h z h z h z h z h h z z h z z h z z h h z z h z h z h z h z h z h z h z h z h z h h z z h z z h h z h z z z h z h z h z h z z h z h z h z h h z z z z h h z z h z z h h z z h z h z h z h z h z h z h z h z h z h h z z h z h z z z h z h h h z h z h z h z h h z z h z z h z z z h z z h z z h z h z h z h h z z z z h z h h z h z h z h h h h z h h h z h h z h h z z h z h z h z h z h h h z h z z z z h h z h z h z h z z h z h z h h z z h z h z h h z h z h h z z h z h z h z h z h h h h z h h h z h z z h h h z h z z h z z h h z z h z h z h z h z h h z z h z h h z h z z h h z z z h z h z z z h h z h z z z z h z h z h z z z h h z h z z z z h h h z z h z h h z z z h z z h z z h z h z h z h h z z z z h
h h z h h h z h h h h z h h h h h h h h h z h h h h z h h h z h h h z h h h z h h h h z h h h h h z h h h h h h h h z h h h z h h h h z h h h z h h f h h z h f h h h h h z h h h h z h h h z h h h z h h h z h h h h z h h h h z h f h h h h z h h z h h h z h h z h h h h z h h h h z h h h h h h h z h h h z h h h h h z h h z h h h h h h z z h h h z h h h h h h z h h h h z h h h h h h z z h h h h h h h h h h h z h h h h z h h h z h h h z h h h z h h h h h z h h h h z h h h h h h z z h h h z h h h h h h z h h h h h h h h h z h h h h z h h h z h h z h h h h z h h h h h h z h h h z h h h h h z h h h h h h h z h z h h h h h z h h h h h h h z h z h h h h z h h h h z h h h h h h h z h h h z h h h h h h
h h h h h h h h h h h h h h h h h h h h h h h h h h h h h h h h h h h h h h h h h h h h h h h h h h h h h h h h h h h h h h h h h h h h h h h h h h h h f h h h h h h h h h h h h h h h h h h h h h h h h h h h h h h h f h h h h h h h h h h h h h h h h h h h h h h h h h h h h h h h h h h h h h h h h h h h h h h h h h h h h h h h h h h h h h h h h h h h h h h h h h h h h h h h h h h h h h h h h h h h h h h h h h h h h h h h h h h h h h h h h h h h h h h h h h h h h h h h h h h h h h h h h h h h h h h h h h h h h h h h h h h h h h h h h h h h h h h h h h h h h h h h h h h h h h h h h h h h h h h h h h h h h h h h h h h h h h h h h h h h h h h h h h h h h h h h h h h h h h h h h h h h h h h h h h
h f f h f h h f f h f h f f f h f h h f f h f h h f f h f h h f h f f h f h h f f h f h f f f h h h f h h f h h h f f h f h h f f h h f h f f h h f h f f h h f h f f h h f h f f h h f h f f h f h h f h f f h h f h f f h h f h f f h h f h f f h h f h f f h f h f h f h h f f h h f f h f h h f f h f h h f f h f h f f f h h h f h h f h h f h h f h h f h h f h h f h h f h h d h d h h h h d h h h d h h h h h h d h h h f h h h h f f h f h h h h f f h h f h f f h h f h h d h d h h h h d h h h h d h d h h h h h h h h f f h h f h f f h h f h f f h h f h f f h h f h f f h h f h f f f f h f h f h f h f h f h f h f f f h f h f h f h f h f h f h h f h f f h h f f h h f f h f h h f f h f h h f f h f h f f
f f f f f f f f f f f f f f f f f f f f f f f f f f f f f f f f f f f f f f f f f f f f f f f f f f f f d d f f f f d f f f d d f f f f f f f f f f f f f f f f f f f f f f f f f f f f f f f f f f f f f f f f f f f f f f f f f f f f f f f f f f f f f f d d f f f f f f d f f f f f f f f f f f f f f f f f f f f f f f f f f f f f d d f f f f d d f f f f d d f f f f d d h d d d d h d d d d h d d d h d d h d d d h d d d h d d d d h d d h d d d d h d d d d h d h d d h d d d d h d d h d d d h d d d d h d d h d d d f f f f f f f f f f f f f f f f f f f f f f f f f f f f f f d d f f f f f f f f f f f f f f f f f f f f f f f f f f f f f f f f f f f f f f f f f f f f f f f f f f f f f f f f f f f f f f
d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d d
d d d d d d d p d d d d d p d d d d d p d p d d d d d p d d d d d d d d d p d d d d d p d p d d d d d p d d d d d d d d d p d d d d d d d d d p d p d d d d d p d d d d d p d d d d d p d d d d d d d d d p d d d d d p d d p d p d d d p d p d d p d d d d d p d d d p d p d d d d d p d d d d d d d d d p d d d d d p d p d d d d d d d p d d d d d p d d d d d d d d d p d d d d d p d p d d p d p d p d d d d p d p p d p d p d p d p d p d d p d p d p d p d d d d d d d p d d d d d p d d d d d p d d p d p d d p d p d d d d d d d p d d d d d p d d p d p d d d p d p d d p d d d d d p d d d p p d p d d d d d d d d p p d p d p d p d p d p d p d p d d d d p d d p d p d d p d p d d d p d d d d d p d d d p d d
d p p p p p d p p p p p d p p p p p d p p p p p p p d p p p p p p p p p d p p p p p d p p p p p p p d p p p p p p p p p d p p p d p p p p p d p p d p p p p d p p p p p d p p p p p d p p p p p p p p p d p p p p p d p p d p d p p p d p d p p d p p p p p d p d p d p p p p p p p d p p p p p p p p p d p p p p p d p p p p p p p p p d p p p p p d p p p p p p p p p d p p p p p d p p p p p d p d p d p p p p d p d p d p d d p d p d p d p p d p d p d p d d p p p p p d p p p p p d p p p p p d p p d p d p p p d p d p p p p p p d p p p p p d p p d p d p p p d p d p p d p p p p p d p p p p p p d p p p p p p p p p p p d p d p d p p p d p d p d p p d p d p p d p d p p p d p d p p d p p p p p d p p p p d p d
p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p p
p p t p p t p p p t p p p p t p p t p p p p p p p p p t t p p p p t p p p p t p p t p p p p p p p p p t t p p p p t p p p p t p p p t p p t p p t p p p p p p t t p p p t p p p p p p t t p p p p p t p p t p p p p t p t p p p p p p t t p p p t p p p p p p t p t p p p p p p p p p t t p p p p t p p p p t p p t p p p p p p t p p p t p p p p p p t t p p p p t p p p p t p p t p p p p p p t p p p t p p p p p t p p p t p t p p p t p p p p p t p p p t p p t p p p p t p p p t p p t p p p p t p t p p p p p p t t p p p p p t p p t p p p p t p t p p p p p p t t p p p t p p p p p p t p p p p p p p p p p t p p p p p p p t p p p p p p p t p p p p p p p t p t p p p p p p t t p p p p t p p p p t p p t p p t p
p p t p t t p t p t p p p p t p t p p p t p p t p t t p p p t p p t p p p p t p t p p p t p p t p t t p p p t p p t p p p p t p p p t p t t p t p p t p p t t p p t p t p t p t p t t p p p t p p t p p p p t p t p p p t p p t p t t p p p t p p p t p p t t p t p p p t p p t p t t p p p t p p t p p p p t p t p p p t p p t p t p t p t p t p t t p p p t p p t p p t p p t t p p p t p p t p p t p t p t t t p p t p t p p p p t p p p t p t p p t p t p p t p p t t p p t p t p p t p p t t p p t p t p t p t t p p p t p p t p p p p t p t p p p t p p t t p p p p p t p p p t p p t t p t p p t p p t p t p p t p t p p t t p t p p t p t t p t p p t p t p p t p t p t p t t p p p t p p t p p p t t p t p t p t p
t t t t t p p t t t t t t t t t t t t t t t t t t p t t t t t t t t t t t t t t t t t t t t t t t p t t t t t t t t t t t t t t t t t t t p p t t t t t t p t t t t t t t t t t t p t t t t t t t t t t t t t t t t t t t t t t t t p t t t t t t t t t t p t t t t t t t t t t t p t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t p t t t t t t t t t t t t t t t t t t t t t t t t t t p t t p t t t t t t t t t t t t t t t t t t t t t t t t p t t t t t p t t t t t p t t t t t t t t p t t t p t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t p t t t t t t t t t t t t t t t t t t t p p t t t t t t p p t t t t t t t t t t p t t t p t t t t t t t t t t t p t t t t p t t t
t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t t
w t t w t t w t t w t t w t t t t t t w t t w t t t w t t w t t t w t t w t t t t t t w t t w t t t w t t w t t t w t t w t t t w t t w t t w t w t t w t t w t t t t t t t t t t t w t t w t t t t w t t w t t t t w t t w t t t t w t t w t t t w t t w t t w t t t w t t w t t t w t t w t t t w t t w t t t t t t w t t w t t t t t t t t t t t w t t w t t t w t t t t t t t t t w t t w t t w t t w t t w t t t t t t w t t w t t w t t w t t t t t t w t t w t t w t t w t t w t t w t t t t w t t w t t t t w t t w t t t t w t t w t t t t w t t w t t t t w t t w t t w t t t w t t w w t t t t w t t w t t t t t w t w t t w t w t t w t t w t w t t t t w t t w t t t t w t t w t t t w t t w t t t t t t w t t
w t w w w t w w t w w t w t w w w w t w w t w w w w w t w w t w w t w w t w w w w w t w w t w w w w w t w t w w t w w t w t w w w t w w t w w t w w t w t w w t t w w t t w w t w w w t w w t w t w w t w w t w t w w t t w w t w w w t t w w t w w t w t w t t w w t w w t w w w w w w t w w t w t w w t w w w w w t w w t w w w w t w w t w w w w w w t w w t w w w t w w w w t w w w w w t w w w w w w w t w w w t w w t w w w w w w w w t w w w t w w t w w w w t w w w t w w t w w w w t w w t w w w w w w w w w w w t w w t w w t w w t w t w w t t w w t w w w t t w w t w w t w t w t t t w t w t t w w t w t t w w t w w t t w w t w w t w w t w w t w w w t w w t w w w w w w t w w t w t w w t w w w w w t w w t
w w w w w w w w w w w w w w w w w w w w w w w w w w w w w w w w w w w w w w w w w w w w w w w w w w w w w w w w w w w w w w w w w w w w w w w w w w w w w w w w w w w w w w w w w w w w w w w w w w w w w w w w w w w w w w w w w w w w w w w w w w w w w w 0 w w w w w w w w w w w w w w w w w w w w w w w w w w w w w w w w w w w w w w w w w w w w w w w w w w w w w w w w w w w w w w w w w w w w w w w w w w w w w w w w w w w w w w w w w w w w w w w w w w w w w w w w w w w w w w w w w w w w w w w w w w w w w w w w w w w w w w w w w w w w w w w w w w w w w w w w w w w w w w w 0 w w w w w 0 w w w w w 0 w w w w w w 0 w w w w w w w w w w w w w w w w w w w w w w w w w w w w w w w w w w w w w w w w w w w w
w w w w w 0 w w w w 0 w w 0 w w w w w 0 w 0 w w w w 0 w w w w 0 w 0 w w w w 0 w w w w 0 w 0 w w 0 w 0 w w 0 w w 0 w 0 w w 0 w w 0 w w 0 w 0 0 w w 0 0 w w 0 0 w 0 0 w 0 0 0 w 0 0 w 0 w w 0 0 w w 0 0 w w 0 w 0 0 0 w 0 0 0 w 0 0 w 0 0 w 0 0 w w 0 0 w w 0 0 w w w w 0 w 0 w w w w 0 w 0 w 0 w w 0 w w w w 0 w w w w 0 w 0 w w w w w 0 w 0 w w w w 0 w 0 w 0 w w w 0 w w w w w w 0 w w w w w w w w w w w w w w w w w w w w w w w w w w w w w w w w w w w w w w w w w w w w w w 7 w w w w w w w w w w w w w w w w w w w 7 w w w w 0 0 w w 0 w 0 0 0 w 0 0 0 w 0 0 w 0 0 w 0 0 w w 0 0 w w 0 0 w 0 0 w 0 w 0 0 w w 0 0 w 0 w 0 w w 0 w 0 0 w w 0 0 w w w 0 w 0 w w w w 0 w 0 w w w w 0 w 0 w 0 w w 0 w w w w 0 w w w w 0 w 0
0 7 w 7 0 w 7 0 0 7 w 7 0 w 7 0 w 7 0 0 0 0 0 0 7 w 7 w 7 0 w 7 0 w 7 0 7 w 0 0 w 7 0 0 0 0 0 0 0 0 w 7 0 w 7 w 0 0 w 7 0 w 7 w 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 w 0 0 0 0 0 0 0 w 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 w 7 0 0 0 0 0 0 7 w 0 0 0 0 w 7 0 w 7 0 7 w 0 0 w 7 0 0 0 0 0 0 w 7 0 0 0 0 0 0 7 w 0 0 0 0 w 7 0 w 7 w 0 0 7 w w 7 0 0 w 7 7 w w 7 9 w 7 9 w 7 7 w 7 w 7 w 7 w w 7 9 w 7 9 w 7 7 w 7 w 7 w 7 w w 7 w 7 7 w 7 w w w w 7 7 w 7 w w 7 7 w w 7 w w 7 w 7 w w w w 7 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 w 7 0 0 0 0 0 0 7 w 0 0 0 0 w 7 0 w 7 0 7 w 0 0 w 7 0 0 0 0
7 0 w 7 0 0 0 0 7 0 w 7 0 0 0 0 7 w 7 0 w 7 0 w 0 0 0 0 0 0 0 7 0 7 0 w 7 w 0 7 7 w 7 0 0 7 0 w 7 0 0 0 7 0 0 7 7 0 0 0 7 0 0 7 7 0 0 7 0 0 0 0 7 0 0 0 7 0 0 7 7 0 7 0 0 7 0 0 7 0 7 0 7 0 0 0 0 0 7 0 0 0 0 7 7 0 7 0 0 0 7 0 7 0 0 7 0 0 0 0 7 0 0 0 7 0 0 0 7 w 7 0 0 7 0 w 7 w 0 7 7 w 7 0 0 7 0 w 7 w 0 7 7 w 7 0 0 7 0 w 7 w 7 0 0 7 0 w 7 w 0 7 7 w 7 0 0 7 w 0 7 0 w 7 7 w 7 w 0 7 w 0 7 w 7 w 9 w 7 w w 7 w 9 7 w 7 w 7 w 7 w 9 w 7 w w 7 w 9 7 w 7 w 7 7 w 7 7 w w 7 7 7 w 7 7 w w 7 7 w 7 w w 7 w 7 7 w 7 w 7 w 7 w 0 0 7 0 0 0 0 7 7 0 7 0 0 0 7 0 7 0 0 7 0 0 0 0 7 0 0 0 7 0 0 0 7 0 7 0 7 7 0 0 0 0 7 0 7 0 7 0 0 0 0 7 7 0 7 0 0 7 0 0 7 0 7 0 7 w 7 0 0 7 0 w 7 w 0 7 7 w 7 0 0 7 0 w 7 w 0 7 7 w 7 0 0 0
7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 0 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 0 7 7 7 7 7 7 7 0 7 7 7 7 7 7 7 7 7 0 7 7 7 7 7 0 7 7 7 7 7 0 7 7 7 7 7 7 7 7 7 7 7 7 0 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 w 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 0 7 7 7 7 7 0 7 7 7 7 7 0 7 7 7 7 7 7 7 7 7 7 7 7 0 7 7 7 0 7 0 7 7 0 7 7 7 7 0 7 0 7 0 7 7 7 7 7 7 0 7 7 7 7 7 7 7 0 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7
7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7
7 7 7 5 7 7 5 7 7 7 7 5 7 7 5 7 5 7 7 7 5 7 5 7 5 7 5 7 5 7 5 7 7 5 7 7 7 7 7 5 7 7 7 7 7 5 7 5 7 7 7 5 7 7 7 7 7 7 7 5 7 7 7 7 7 7 7 7 7 7 7 5 7 7 7 5 7 7 7 7 7 7 7 7 7 5 7 7 7 7 5 7 5 7 7 7 5 7 5 7 7 7 7 5 7 7 7 7 5 7 5 5 7 7 7 7 7 7 7 5 7 7 7 5 7 5 7 5 7 7 7 7 7 5 7 7 7 7 7 5 7 7 7 7 7 5 7 7 7 7 7 5 7 7 7 7 7 5 7 5 7 7 7 7 7 5 7 7 7 7 7 5 7 7 7 7 7 5 7 7 7 7 7 5 7 5 7 7 7 5 7 5 7 7 5 7 5 7 5 7 5 7 5 7 7 7 5 7 7 7 5 7 5 7 5 7 5 7 5 7 7 7 5 5 7 7 7 7 7 7 5 7 5 7 5 7 7 7 5 7 5 7 5 7 5 7 5 7 7 7 5 7 5 7 5 7 5 7 5 7 7 7 7 5 7 7 7 7 5 7 5 5 7 7 7 7 7 7 7 5 7 7 7 5 7 5 7 5 5 7 5 7 5 7 7 7 5 7 5 7 5 7 5 7 7 7 7 5 7 7 7 7 7 5 7 7 7 7 5 5 7 7 7 7 7 5 7 7 7 7 7 5 7 7 7 7 7 5 7 7 7 7 7 5 7 7 7 7 5 5
5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5
5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 1 5 5 5 1 5 5 5 5 1 5 5 5 5 1 5 5 5 5 1 5 5 1 5 5 5 1 5 5 5 1 5 5 5 1 5 5 5 1 5 5 5 1 5 5 5 5 5 5 5 5 5 1 5 5 5 1 5 5 5 5 5 1 5 5 5 5 1 5 5 1 5 5 5 1 5 1 5 5 5 1 5 5 5 5 1 5 5 5 5 1 5 1 5 5 5 1 5 5 5 1 5 5 5 1 5 5 5 5 5 1 5 5 5 1 5 5 5 1 5 5 5 5 1 5 5 5 1 5 5 5 1 5 5 1 5 5 5 5 5 5 5 5 1 5 5 5 1 5 5 1 5 5 5 5 1 5 5 5 1 5 5 5 1 5 5 1 5 5 5 5 5 5 5 5 5 1 5 5 5 1 5 5 5 5 1 5 5 5 5 1 5 5 5 5 5 5 5 5 1 5 5 1 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 1 5 5 5 1 5 5 5 5 1 5 5 1 5 5 5 1 5 5 5 5 1 5 5 5 5 1 5 1 5 5 5 1 5 5 5 1 5 5 5 1 5 5 5 5 5 5 5 5 5 1 5 5 5 5 5 5 5 5 1 1 5 5 5 1 5 5 5 5 1 5 5 5 5 1 5 5 5 1 5 5 5 1 5 5 5 5 1 5 5 1 5 5 5 1 5 5 5 1 5 5 5 1 5 5 5
1 1 5 1 1 1 5 1 1 1 5 1 1 1 5 1 1 5 1 1 5 5 5 1 5 5 1 5 1 5 1 5 5 1 1 5 1 5 5 5 5 1 5 1 5 1 1 5 1 5 5 5 1 5 5 5 1 5 5 5 1 5 5 5 1 1 5 1 1 1 5 1 5 1 5 1 5 1 5 1 5 1 5 1 5 1 1 5 1 5 5 5 5 1 5 1 5 5 5 1 5 5 1 5 1 5 1 5 1 5 1 5 5 1 5 1 5 1 5 1 5 1 5 1 5 1 5 1 1 5 5 5 5 1 5 1 5 1 1 5 1 5 5 5 1 5 5 5 5 1 5 1 1 5 1 5 1 5 1 1 1 5 5 5 5 1 5 1 5 1 1 5 1 5 5 5 1 5 5 5 5 1 5 1 1 5 1 5 1 5 1 1 1 5 1 1 5 5 5 1 5 5 1 5 1 5 1 5 1 5 1 5 1 5 1 1 5 5 1 5 1 5 1 5 1 1 5 1 1 1 5 1 1 1 5 1 1 1 5 1 1 5 1 1 5 5 5 1 5 5 1 5 1 5 1 5 5 5 5 1 5 5 1 5 1 5 1 5 1 5 1 5 5 1 5 1 5 1 5 1 5 1 5 1 5 1 5 1 1 5 1 1 1 5 1 5 1 5 1 1 5 5 1 5 5 5 5 1 5 5 1 5 1 5 1 5 1 5 1 5 1 5 5 5 5 1 5 1 5 1 1 5 1 5 5 5 1 5 5 5 5 1 5 1 1 5 1 5 1 5
5 1 1 1 5 1 1 1 5 1 1 1 5 1 1 1 1 1 5 1 1 1 1 1 1 1 1 1 1 1 1 1 1 5 1 1 1 1 1 1 1 5 1 1 1 5 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 5 1 1 1 5 1 1 1 1 1 1 5 1 1 1 1 1 5 1 1 1 5 1 1 1 1 1 1 1 5 1 1 1 1 1 1 1 1 1 1 1 1 1 1 5 1 1 1 1 1 1 5 1 1 1 1 1 1 1 5 1 1 1 1 1 1 1 1 1 5 1 1 1 5 1 1 1 1 1 1 1 1 1 1 1 5 1 1 1 5 1 1 1 1 5 1 1 1 1 1 1 5 1 1 1 5 1 1 1 1 1 1 1 1 1 1 1 5 1 1 1 5 1 1 1 1 5 1 1 1 5 1 1 1 1 1 1 1 1 1 1 1 1 1 5 1 1 1 1 1 1 5 1 1 1 1 5 1 1 1 5 1 1 1 5 1 1 1 5 1 1 1 5 1 1 1 1 1 5 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 5 1 1 1 1 1 1 5 1 1 1 1 1 1 1 5 1 1 1 1 1 1 5 1 5 1 1 1 1 1 1 5 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 5 1 1 1 1 1 1 1 1 5 1 1 1 5 1 1 1 1 1 1 1 1 1 1 1 5 1 1 5 1 1 1 1 1
1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1
1 > 1 1 1 1 > 1 1 > 1 1 1 1 > 1 1 1 1 1 1 > 1 1 > 1 1 1 1 1 1 1 1 1 > 1 > 1 1 1 > 1 1 1 > 1 1 1 1 > 1 1 1 1 > 1 1 > 1 1 1 1 > 1 1 > 1 1 1 1 > 1 1 1 1 1 > 1 1 1 1 1 > 1 1 1 > 1 1 1 > 1 1 1 1 > > 1 1 1 1 > 1 1 1 1 1 1 > 1 1 1 1 1 1 1 > 1 1 1 1 1 1 1 > 1 1 1 > 1 1 > 1 > 1 1 1 1 > 1 > 1 1 1 > 1 1 1 1 > 1 1 1 1 > 1 > 1 1 1 > 1 1 1 1 > 1 1 1 1 > 1 > 1 1 1 > 1 1 1 1 > 1 1 1 1 > 1 > 1 1 1 1 1 1 1 1 > 1 1 > 1 1 1 1 1 1 1 1 1 > 1 > 1 1 1 > 1 1 1 > 1 1 1 1 > 1 1 1 1 > 1 1 > 1 1 1 1 > 1 1 1 1 1 1 > 1 1 > 1 1 1 1 1 1 1 > 1 1 1 1 > 1 1 1 1 1 1 > 1 1 1 1 1 1 1 > 1 1 1 1 1 1 1 > 1 1 1 1 1 > 1 1 1 1 1 1 > 1 1 1 > 1 1 > 1 1 1 > 1 1 1 1 1 1 1 > 1 1 1 1 1 > 1 1 1 1 > 1 1 1 > 1 1 > 1 1 1 > 1 1 1 1 > 1 1 > 1 > 1
1 > > > 1 > > > 1 > > > 1 > > > > > 1 > > > 1 > > 1 > > 1 > > > 1 > > > > 1 > > > 1 > > > 1 > > > 1 > > > > 1 > > 1 > > > > 1 > 1 > > > 1 > > > 1 > > > > 1 > 1 > > > 1 > > > 1 > > > 1 > 1 > > > 1 > 1 > > 1 > > 1 > > > 1 > > 1 > > > > 1 > 1 1 > > > > 1 > 1 1 > > 1 > 1 > > 1 > > > > 1 > > > 1 > > 1 > > > 1 > > > > 1 > > > 1 > > 1 > > > 1 > > > > 1 > > > 1 > > 1 > > > 1 > > > > 1 > > > > 1 > > > 1 > > 1 > > 1 > > > 1 > > > > 1 > > > 1 > > > 1 > > 1 > > > 1 > > > 1 > > > 1 > > > > > 1 > > > 1 > > 1 > > 1 > > > > 1 > 1 > > 1 > > 1 > > > 1 > > 1 > > > > 1 > 1 1 > > > > 1 > 1 > > 1 1 > 1 > > > > 1 > 1 > > > > 1 > 1 > 1 1 > > 1 > > > 1 > > > > > 1 > 1 > > > > 1 > > > > 1 > > > 1 > 1 > > 1 > > > > 1
> > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > ; > > > > > > > ; > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > ; > > > > > > > ; > > > > > > > > > ; > ; > > > > > > > ; > > > > > > > > ; > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > >
> ; > > > > > ; > > > > > ; > > > > > > > > > > > ; > > > > > ; > > ; > ; > > > ; > ; > ; > ; > ; > > > ; > ; > > > ; > ; > > > ; ; > ; > > > ; > ; > ; > ; > ; ; > ; > ; > ; > ; > > > ; > ; > ; > ; > ; > ; > ; > ; > ; > ; ; ; > ; > ; > ; > ; > ; > ; > ; > ; > ; > > > ; > ; > ; > > > ; > ; > ; > > > ; > ; > ; > > > ; > > > > ; > > > > > > > ; > > > > > > > ; > > > > > > > ; > > > > > > > > > > - > > > > > > > > > > > = > > > > > > > > > > > > > > > > > > > = > > > = > > > > > > > > > > > > > > > > > > > = > > ; > ; > ; > ; > ; > > > ; > ; > ; > ; > ; > ; ; > ; > ; > ; > ; > ; > ; > ; ; ; > ; > ; > ; > > ; > ; > ; > ; > ; > ; > ; > ; ; > ; > ; > ; > ; > ; > ; > ; > ; > ; > ; > ; > ; > ; > > >
> = = > = ; > = = > = ; > = = > = ; = > = ; = ; > = = > = ; > = ; ; ; ; ; = ; ; ; ; ; > ; ; ; ; ; = ; ; ; ; ; = ; ; ; ; ; = ; ; ; ; ; ; = ; ; ; ; ; ; ; ; ; ; ; ; ; ; ; ; ; ; ; ; ; ; ; ; ; ; ; ; ; ; ; ; ; ; ; ; ; ; ; ; ; ; ; ; ; ; ; ; ; ; ; ; ; ; ; ; ; ; ; ; ; ; = ; ; ; ; ; ; ; = ; ; ; ; ; ; ; = ; ; ; ; ; ; ; = ; ; ; ; = ; > = = > = ; = ; > = = > = ; = ; > = = > = ; = ; > = = > = ; = - = > = = > > - = - > = - - = > = > = = = = > = = = > = = = > = = = > = > > = > = > = = = = > = = = > = = = > = = = > = > > = ; ; ; ; ; ; ; ; ; ; ; ; ; ; ; ; ; ; ; ; ; ; ; ; ; ; ; ; ; ; ; ; ; ; ; ; ; ; ; ; ; ; ; ; ; ; ; ; ; ; ; ; ; ; ; ; ; ; ; ; ; ; ; ; ; ; ; ; ; > ; ; ; ; ; ; ; > ; ; ; ; ; ; ; > ; ; ; ; ; ; ; ;
= = = ; ; = = = = ; = = = = = ; = = ; = = = = = = = = ; ; = = = = ; = = = ; = ; = = ; = = = = = = ; = ; ; = = ; ; = = = = ; = ; = ; = ; ; = = ; = ; ; = = ; = ; = ; = ; = ; = = = = ; = = ; = = = ; = = = ; = ; ; = ; = ; = = = = ; = ; ; = = ; = ; = = = ; = ; ; = = ; = ; = = ; = = ; = ; = = ; = = ; = ; = = ; = = ; = ; = = ; = = = = ; = = ; = = = = ; = = ; = = = = ; = = ; = = = = ; = = = - - - = - - - = - - - - - = - = > = = = > = = = > = = = > = = = > = = > = = = = > = = = > = = = > = = = > = = = > = = > = = = = ; = = = ; = ; = = ; = = = = = = ; = ; ; = = ; = ; = = = ; = ; ; = ; = ; = = = = ; = ; ; = = ; = = = = ; = ; = = ; = ; = ; = = = ; = = ; = = = = ; = = ; = = = = ; = = ; = = = = ; = = = =
= = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = =
% = % = = = % = = = = = = = = = = = = % = = % = % = % = = = % = = = = = = = = = = = = % = = % = % = % = = = % = = = = = = = = = = = = % = = = = = % = = = = = % = = = = = = % = % = % = = = % = = = % = % = % = = = = % = = % = % = % = = = % = = = = = = = = = = = = % = = = = = = = % = = = = = = = % = = = = = = = % = = = = = = = % = = = = = = = % = = = = = = = % = = = = = = = % = = = = = % = = = % = = = % = % = % = = = = % = % = % = % = % = = = % = % = % = % = % = = = % = % = % = % = % = = = % = % = % = % = % = = = % = % = % = = = = % = = % = % = % = = = % = = = = = = = = = = = = % = = % = % = % = = = % = = = % = % = % = = = % = = = = = = = = = % = % = = = = % = = % = = = = % = = % = = = = % = =
% = % % % = % % % % % % % % % % = % = % % % % = % = % % % = % % % % % % % % % % = % = % % % % = % = % % % = % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % = % = % % = % = % % % = % = % = % = % = % % % % = % = % % % = % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % = % % % % % % % = % % % = % % % % % = = % = % = % = % % % = % = % = % = % = % % % = % = % = % = % = % % % = % = % = % = % = % % % = % = % = % = % = % % % % = % = % % % = % % % % % % % % % % = % = % % % % = % = % % % = % % % % % = % = % % % = % % % % % % = % % % % % = % = % % % % % = % = % % % % % = % = % % % % %
% % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % %
% % % @ % % % % @ % % @ % % @ % % @ % % % @ % % % % % @ % % % % @ % % @ % % @ % % @ % % % @ % % % % % @ % % % % @ % % @ % % @ % % % % % @ % % % % % @ % % % % % @ % % % % @ % % % % % @ % % @ % % @ % % @ % % @ % % @ % % % @ % % % % % @ % % % % @ % % @ % % @ % % % % % % % @ % % % % % % % @ % % % % % % % @ % % % % % % % @ % % % % % % % @ % % % % % % % @ % % % % % % % @ % % % % % % % @ @ % % % % % @ % % % % % @ % % % % @ % % @ % % @ % % @ % % @ % % @ % % @ % % @ % % @ % % @ % % @ % % @ % % @ % % @ % % @ % % @ % % @ % % @ % % @ % % @ % % % @ % % % % % @ % % % % @ % % @ % % @ % % @ % % % @ % % % % % @ % % % % % @ % % % % % @ % % % % @ % % % @ % % % % % @ % @ % % % % % @ % @ % % % % % @ % @ % % % %
@ % @ @ @ @ @ @ % @ @ @ @ @ % @ @ @ % @ @ % @ @ % @ @ % @ @ @ % @ @ @ @ @ % @ @ @ @ % @ @ % @ @ % @ @ % @ @ @ % @ @ @ @ @ % @ @ @ @ @ % @ @ @ @ @ % @ @ @ @ @ % @ @ @ @ @ % @ @ @ @ @ % @ @ @ @ @ % @ @ @ @ @ % @ @ @ @ @ % @ @ @ @ @ % @ @ @ @ @ % @ @ @ @ @ % @ % @ @ @ % @ @ @ @ @ @ @ % @ @ % @ @ @ @ @ % @ @ % @ @ % @ @ @ @ @ % @ @ % @ @ % @ @ @ @ @ % @ @ % @ @ % @ @ @ @ @ % @ @ % @ @ @ % @ @ @ @ @ @ % @ @ @ @ @ % @ @ @ @ % @ @ @ @ @ % @ @ @ @ @ % @ @ @ @ @ % @ @ @ @ % @ @ % @ @ % @ @ % @ @ @ % @ @ @ @ @ % @ @ @ @ % @ @ % @ @ % @ @ % @ % @ @ % @ @ % @ @ % @ @ % @ @ % @ @ % @ @ @ % @ % @ @ % @ @ % @ @ % @ @ % @ @ % @ @ % @ @ @ % @ % @ @ % @ @ @ @ @ % @ @ % @ @ % @ @ @ @ @ % @ @ % @ @ % @ @ @ @ %
@ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @
o @ @ @ @ @ o @ @ @ o @ o @ @ @ @ @ @ @ @ @ @ @ @ @ @ o @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ o @ @ @ @ @ @ @ @ @ @ @ @ @ @ o @ @ @ o @ o @ @ @ @ @ o @ @ @ o @ o @ @ @ @ @ o @ @ @ o @ o @ @ @ @ @ o @ @ @ o @ o @ @ @ @ @ o @ @ @ o @ o @ @ @ @ @ o @ @ @ @ o @ @ @ @ @ @ @ @ @ @ @ o @ o @ @ @ @ @ o @ @ @ @ @ o @ @ @ @ @ o @ @ @ @ @ o @ @ @ @ @ o @ @ @ @ @ o @ @ @ @ @ o @ @ @ @ @ @ @ @ @ @ o @ @ @ o @ o @ @ @ @ @ o @ @ @ o @ o @ @ @ @ @ o @ @ @ o @ o @ @ @ @ @ @ @ @ @ @ @ @ @ @ o @ @ @ @ @ @ @ @ @ @ @ @ @ o @ @ @ @ @ @ @ @ @ @ @ o @ @ @ @ @ @ @ @ @ @ @ o @ @ @ @ @ @ @ @ @ @ @ o @ @ @ @ @ @ @ @ @ @ @ o @ @ @ @ @ @ @ @ @ @ @ o @ @ @ o @ @ @ @ @ o @ @ @ @ @ o @ @ @ @ @ o @ @ @ @ @ o @ @ @ @
@ o @ o o @ o @ o @ o @ o @ o o o @   @   @   @ o o @ o o o o @ @ o o o o o @ o o o o @ o o o o o o @ o o o o @ @ o o o o o @ o o @ o @ o @ o @ o @ o o o @ o @ o @ o @ o @ o o o @ o @ o @ o @ o @ o o o @ o @ o @ o @ o @ o o o @ o @ o @ o @ o @ o o o @ o @ o o @ o @   o @ @ o o @ o o @ o @ o o @ o o @ o o o o o @ o o @ o o @ o o o o @ @ o o @ o o @ o o o o o @ o o @ o o @ o o o o @ o o @ o o @ o @ o @ o @ o @ o o o @ o @ o @ o @ o @ o o o @ o @ o @ o @ o @ o o o @   @ o o o o o o @ o o o o @ @ o o o o o @ o @ o o o o o o o o o @   @ o o o o o o o o o o o @ o o o o o o o o o o o @ o o o o o o o o o o o @ o o o o o o o o o o o @ o o o @ o o @ o o @ o o o o o @ o o @ o o @ o o o o @ @ o o @ o o
o o o o o o o o o @   @ o o o o o o o o o o @     o o o o o o o o o o o   @ o o o o o o o o o o   o o o o o o o o o o o   @ o o @ o o o o @ o o o o o o o o o o o @ o o o o o o @ o o o o @ o o o o o o o o o o o @ o o o o o o @ o o o o @ o o o o o o o o o o o o o o o o o o   @ o o o o o @   @ o o o o o @ o o o o @ o o o o o o o o o o o   @ o o o o o @ o o o o @ o o o o o o o o o o o o o o o o o o o o @ o o o o o o @ o o o o @ o o o o o o o o o o o o   @ o o o o o o o o o o o o   o o o o o o o o o o o   @ o o o o o @ o o o o o o @ o o o @ o o o o o o o o o o o o @ o o o o o o @ o o o @ o o o o o o o o o o o o @ o o o o o o @ o o o @ o   o o o o o o @ o o o o @ o o o o o o o o o o o   @ o o o o
o   o o o   o o     o o   o   o o o   o   o   @   o   @   o   @   o   @ o   o   o o   o   o   @   o o o   o o o   o   @ o   o     o   o     o o o   o o o   o o     o o   o   o   o   o     o o o   o o o   o o     o o   o   o   o   o     o o o   o o o   o o   o   o o o   o o   o   o o   o o   o     @ o     o o     o   o   o   o o o   o o   o     @ o     o o     o   o   o   o o o   o o o o o o   o o     o o   o   o   o   o     o o o   o o o   o o   o o o o   o o o o   o   o   @   o   @   o   @   o   @ o   o   o o o   o o   o o     o o     o o o   o   o o     @ o   o o   o o     o o     o o o   o   o o     @ o   o o   o o     o o     o o o o     @ o     o o     o   o   o   o o o   o o   o     @
    o       o     o     o   o   o         o       o       o       o     o       o         o       o       o       o     o         o   o     o       o       o       o         o   o   o     o       o       o       o         o   o   o     o       o       o         o o       o           o     o         o     o       o   o       o o       o           o     o       o   o       o o           o       o       o         o   o   o     o     o       o       o     o       o         o       o       o       o     o           o         o       o       o       o   o         o         o       o       o       o   o         o         o       o       o   o         o     o       o   o       o o       o
