use warnings;
use strict;

use Carp;
use FindBin qw($Bin);
use lib "$Bin/../lib";

use Benchmark qw(:all);

use BoutrosLab::TSVStream::Format::AnnovarInput::Human::Fixed;
use BoutrosLab::TSVStream::Format::None::Dyn;

# BoutrosLab::TSVStream::Format::None::Dyn->meta->make_immutable;

my $datastart = tell DATA;

sub process {
	my $class = shift;
	my $rargs = shift // [];
	my $wargs = shift // [];
	seek DATA, 0, $datastart;
	my $reader = $class->reader(
		handle => \*DATA,
		@$rargs,
	);
	my $writer = $class->writer(
		file => '/dev/null',
		@$wargs,
	);
	while (my $rec = $reader->read) {
		$writer->write($rec);
	}
}

sub validchr {
	my $chr = shift;
	$chr =~ s/^chr//;
	return 1 if $chr =~ /[XYM]/;
	return 0 unless $chr =~ /^\d+$/;
	return $chr >= 0 && $chr <= 21;
}

sub validpos {
	my $pos = shift;
	return $pos =~ /^\d+$/;
}

sub validref {
	my $ref = shift;
	return 1 if $ref eq '-';
	return $ref =~ /^[CAGT]+$/ && length($ref) <= 500;
}

sub hprocess {
	my $class = shift;
	my $rargs = shift // [];
	my $wargs = shift // [];
	seek DATA, 0, $datastart;
	open my $outfh, '>', '/dev/null';
	while (<DATA>) {
		chomp;
		s/^\s+//;
		s/\s+$//;
		my @f = split "\t";
		my %f;
		@f{ qw(chr start end ref alt) } = @f;
		validchr($f{chr});
		validpos($f{start});
		validpos($f{end});
		validref($f{ref});
		validref($f{alt});
		print $outfh join("\t",@f{ qw(chr start end ref alt) } );
	}
}

timethese( 100000, {
	Dyn        => sub {
					process(
						'BoutrosLab::TSVStream::Format::None::Dyn',
						undef,
						[ dyn_fields => [ qw(chr start end ref alt) ] ],
					) },
	HumanFixed => sub { process( 'BoutrosLab::TSVStream::Format::AnnovarInput::Human::Fixed' ) },
	Hash       => sub { hprocess( ) },
});

__END__
chr	start	end	ref	alt
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr1	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
chr2	1	2	CA	GT
