/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.provider;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.Map;
import java.util.logging.Level;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.jaxrs.ext.MessageContext;
import org.apache.cxf.jaxrs.provider.AbstractConfigurableProvider;
import org.apache.cxf.jaxrs.utils.ExceptionUtils;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.PhaseInterceptorChain;

@Produces(value={"text/html"})
@Provider
public abstract class AbstractResponseViewProvider
extends AbstractConfigurableProvider
implements MessageBodyWriter<Object> {
    private static final String MESSAGE_RESOURCE_PATH_PROPERTY = "redirect.resource.path";
    private boolean useClassNames;
    private boolean strictPathCheck;
    private Map<String, String> beanNames = Collections.emptyMap();
    private String beanName;
    private String resourcePath;
    private Map<String, String> resourcePaths = Collections.emptyMap();
    private Map<String, String> classResources = Collections.emptyMap();
    private Map<? extends Enum<?>, String> enumResources = Collections.emptyMap();
    private String locationPrefix;
    private String resourceExtension;
    private String errorView = "/error";
    private boolean logRedirects;
    private MessageContext mc;

    @Context
    public void setMessageContext(MessageContext context) {
        this.mc = context;
    }

    public MessageContext getMessageContext() {
        return this.mc;
    }

    public void setUseClassNames(boolean use) {
        this.useClassNames = use;
    }

    public boolean isUseClassNames() {
        return this.useClassNames;
    }

    public void setStrictPathCheck(boolean use) {
        this.strictPathCheck = use;
    }

    public void setBeanNames(Map<String, String> beanNames) {
        this.beanNames = beanNames;
    }

    public void setBeanName(String beanName) {
        this.beanName = beanName;
    }

    public void setResourcePath(String resourcePath) {
        this.resourcePath = resourcePath;
    }

    public void setResourcePaths(Map<String, String> resourcePaths) {
        this.resourcePaths = resourcePaths;
    }

    @Override
    public long getSize(Object t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mt) {
        return -1L;
    }

    public void setClassResources(Map<String, String> resources) {
        this.classResources = resources;
    }

    public void setEnumResources(Map<? extends Enum<?>, String> enumResources) {
        this.enumResources = enumResources;
    }

    public void setLocationPrefix(String locationPrefix) {
        this.locationPrefix = locationPrefix;
    }

    public void setResourceExtension(String resourceExtension) {
        this.resourceExtension = resourceExtension;
    }

    public void setErrorView(String errorView) {
        this.errorView = errorView;
    }

    @Override
    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mt) {
        if (this.useClassNames && this.getClassResourceName(type) != null) {
            return true;
        }
        if (this.resourcePath != null || this.classResourceSupported(type)) {
            return true;
        }
        if (!this.resourcePaths.isEmpty()) {
            String path = this.getRequestPath();
            for (String requestPath : this.resourcePaths.keySet()) {
                boolean result = this.strictPathCheck ? path.endsWith(requestPath) : path.contains(requestPath);
                if (!result) continue;
                return true;
            }
        }
        return this.getMessageContext() != null && this.getMessageContext().get(MESSAGE_RESOURCE_PATH_PROPERTY) != null;
    }

    protected boolean classResourceSupported(Class<?> type) {
        String typeName = type.getName();
        if (type.isEnum()) {
            for (Enum<?> o : this.enumResources.keySet()) {
                if (!o.getClass().getName().equals(typeName)) continue;
                return true;
            }
            for (String name : this.classResources.keySet()) {
                if (!name.startsWith(typeName)) continue;
                return true;
            }
            return false;
        }
        return this.classResources.containsKey(typeName);
    }

    protected String getPathFromMessageContext() {
        Object resourcePathProp;
        if (this.getMessageContext() != null && (resourcePathProp = this.getMessageContext().get(MESSAGE_RESOURCE_PATH_PROPERTY)) != null) {
            StringBuilder sb = new StringBuilder();
            if (this.locationPrefix != null) {
                sb.append(this.locationPrefix);
            }
            sb.append(resourcePathProp.toString());
            if (this.resourceExtension != null) {
                sb.append(this.resourceExtension);
            }
            return sb.toString();
        }
        return null;
    }

    protected String getBeanName(Object bean) {
        if (this.beanName != null) {
            return this.beanName;
        }
        String name = this.beanNames.get(bean.getClass().getName());
        if (name != null) {
            return name;
        }
        Class<?> resourceClass = bean.getClass();
        if (this.isUseClassNames() && this.doGetClassResourceName(resourceClass) == null) {
            for (Class<?> cls : bean.getClass().getInterfaces()) {
                if (this.doGetClassResourceName(cls) == null) continue;
                resourceClass = cls;
                break;
            }
        }
        return resourceClass.getSimpleName().toLowerCase();
    }

    protected String getResourcePath(Class<?> cls, Object o) {
        String currentResourcePath = this.getPathFromMessageContext();
        if (currentResourcePath != null) {
            return currentResourcePath;
        }
        if (!this.resourcePaths.isEmpty()) {
            String path = this.getRequestPath();
            for (Map.Entry<String, String> entry : this.resourcePaths.entrySet()) {
                if (!path.endsWith(entry.getKey())) continue;
                return entry.getValue();
            }
        }
        if (!this.enumResources.isEmpty() || !this.classResources.isEmpty()) {
            String clsResourcePath;
            String name = cls.getName();
            if (cls.isEnum()) {
                String enumResource = this.enumResources.get(o);
                if (enumResource != null) {
                    return enumResource;
                }
                name = name + "." + o.toString();
            }
            if ((clsResourcePath = this.classResources.get(name)) != null) {
                return clsResourcePath;
            }
        }
        if (this.isUseClassNames()) {
            return this.getClassResourceName(cls);
        }
        return this.resourcePath;
    }

    protected String getRequestPath() {
        Message inMessage = PhaseInterceptorChain.getCurrentMessage().getExchange().getInMessage();
        return (String)inMessage.get("org.apache.cxf.request.uri");
    }

    protected String getClassResourceName(Class<?> type) {
        String resourceName = this.doGetClassResourceName(type);
        if (resourceName == null) {
            Class<?> in;
            Class<?>[] classArray = type.getInterfaces();
            int n = classArray.length;
            for (int i = 0; i < n && (resourceName = this.doGetClassResourceName(in = classArray[i])) == null; ++i) {
            }
        }
        return resourceName;
    }

    protected String doGetClassResourceName(Class<?> type) {
        String simpleName = StringUtils.uncapitalize(type.getSimpleName());
        String thePrefix = this.locationPrefix == null ? this.getDefaultLocationPrefix() : this.locationPrefix;
        String theExtension = this.resourceExtension == null ? this.getDefaultResourceExtension() : this.resourceExtension;
        String resourceName = thePrefix + simpleName + theExtension;
        if (this.resourceAvailable(resourceName)) {
            return resourceName;
        }
        return null;
    }

    protected void handleViewRenderingException(String viewName, Throwable exception) {
        LOG.log(Level.WARNING, String.format("Error forwarding to '%s': %s", viewName, exception.getMessage()), exception);
        if (this.errorView != null) {
            HttpServletRequest httpRequest = this.getMessageContext().getHttpServletRequest();
            httpRequest.setAttribute("javax.servlet.error.exception", exception);
            httpRequest.setAttribute("javax.servlet.error.status_code", 500);
            httpRequest.setAttribute("javax.servlet.error.message", exception.getMessage());
            try {
                this.getMessageContext().getServletContext().getRequestDispatcher(this.errorView).forward(httpRequest, this.getMessageContext().getHttpServletResponse());
            }
            catch (Exception e) {
                LOG.log(Level.SEVERE, String.format("Error forwarding to error page '%s': %s", this.errorView, e.toString()), e);
                this.handleInternalViewRenderingException(exception);
            }
        } else {
            this.handleInternalViewRenderingException(exception);
        }
    }

    protected void handleInternalViewRenderingException(Throwable exception) {
        this.getMessageContext().put("http.request.redirected", Boolean.FALSE);
        throw ExceptionUtils.toInternalServerErrorException(exception, null);
    }

    protected String getDefaultLocationPrefix() {
        return "";
    }

    protected String getDefaultResourceExtension() {
        return "";
    }

    protected abstract boolean resourceAvailable(String var1);

    public boolean isLogRedirects() {
        return this.logRedirects;
    }

    public void setLogRedirects(boolean logRedirects) {
        this.logRedirects = logRedirects;
    }
}

