#!/usr/bin/perl

package eBay::API::XML::Call::GetLiveAuctionCatalogDetails::GetLiveAuctionCatalogDetailsResponseType;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. GetLiveAuctionCatalogDetailsResponseType.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::Call::GetLiveAuctionCatalogDetails::GetLiveAuctionCatalogDetailsResponseType

=head1 DESCRIPTION

Returns all the upcoming eBay Live Auctions catalogs and sale schedules that the user has created.



=head1 SYNOPSIS

=cut


=head1 INHERITANCE

eBay::API::XML::Call::GetLiveAuctionCatalogDetails::GetLiveAuctionCatalogDetailsResponseType inherits from the L<eBay::API::XML::ResponseDataType> class

=cut

use eBay::API::XML::ResponseDataType;
our @ISA = ("eBay::API::XML::ResponseDataType");

use eBay::API::XML::DataType::LiveAuctionCatalogType;


my @gaProperties = ( [ 'LiveAuctionCatalog', 'ns:LiveAuctionCatalogType', '1'
	     ,'eBay::API::XML::DataType::LiveAuctionCatalogType', '1' ]
                    );
push @gaProperties, @{eBay::API::XML::ResponseDataType::getPropertiesList()};

my @gaAttributes = ( 
                    );
push @gaAttributes, @{eBay::API::XML::ResponseDataType::getAttributesList()};

=head1 Subroutines:

=cut

sub new {
  my $classname = shift;
  my %args = @_;
  my $self = $classname->SUPER::new(%args);
  return $self;
}

sub isScalar {
   return 0; 
}



=head2 setLiveAuctionCatalog()

Each eBay Live Auctions catalog describes one live auction catalog created by the user,
along with one or more sale schedules.
Use this information to determine an appropriate combination of catalog and schedule IDs
in which to list lot items with AddLiveAuctionItem.
Only returns details about catalogs that contain pending sales.
That is, if a catalog has no sales or all its sales have ended,
the catalog details are not returned.

#    Argument: reference to an array  
                      of 'ns:LiveAuctionCatalogType'

=cut

sub setLiveAuctionCatalog {
  my $self = shift;
  $self->{'LiveAuctionCatalog'} = 
		$self->convertArray_To_RefToArrayIfNeeded(@_);
}

=head2 getLiveAuctionCatalog()

  Returned: Conditionally
#    Returns: reference to an array  
                      of 'ns:LiveAuctionCatalogType'

=cut

sub getLiveAuctionCatalog {
  my $self = shift;
  return $self->_getDataTypeArray('LiveAuctionCatalog');
}





##  Attribute and Property lists
sub getPropertiesList {
   my $self = shift;
   return \@gaProperties;
}

sub getAttributesList {
   my $self = shift;
   return \@gaAttributes;
}



1;   
