/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.referencing.provider;

import java.lang.reflect.Array;
import java.nio.file.Path;
import java.util.Arrays;
import javax.measure.Quantity;
import javax.measure.Unit;
import org.apache.sis.internal.jdk8.JDK8;
import org.apache.sis.internal.referencing.j2d.AffineTransform2D;
import org.apache.sis.internal.util.Utilities;
import org.apache.sis.math.DecimalFunctions;
import org.apache.sis.parameter.Parameters;
import org.apache.sis.referencing.datum.DatumShiftGrid;
import org.apache.sis.referencing.operation.transform.LinearTransform;
import org.apache.sis.util.collection.Cache;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.NoninvertibleTransformException;

public abstract class DatumShiftGridFile<C extends Quantity<C>, T extends Quantity<T>>
extends DatumShiftGrid<C, T> {
    private static final long serialVersionUID = -4471670781277328193L;
    static final Cache<Object, DatumShiftGridFile<?, ?>> CACHE = new Cache<Object, DatumShiftGridFile<?, ?>>(4, 32768L, true){

        @Override
        protected int cost(DatumShiftGridFile<?, ?> datumShiftGridFile) {
            int n = 1;
            for (Object object : datumShiftGridFile.getData()) {
                n *= Array.getLength(object);
            }
            return n;
        }
    };
    public final ParameterDescriptorGroup descriptor;
    private final Path[] files;
    protected final int nx;
    protected double accuracy;

    protected DatumShiftGridFile(Unit<C> unit, Unit<T> unit2, boolean bl, LinearTransform linearTransform, int n, int n2, ParameterDescriptorGroup parameterDescriptorGroup, Path ... pathArray) {
        super(unit, linearTransform, new int[]{n, n2}, bl, unit2);
        this.descriptor = parameterDescriptorGroup;
        this.files = pathArray;
        this.nx = n;
        this.accuracy = Double.NaN;
    }

    DatumShiftGridFile(Unit<C> unit, Unit<T> unit2, boolean bl, double d, double d2, double d3, double d4, int n, int n2, ParameterDescriptorGroup parameterDescriptorGroup, Path ... pathArray) throws NoninvertibleTransformException {
        this(unit, unit2, bl, new AffineTransform2D(d3, 0.0, 0.0, d4, d, d2).inverse(), n, n2, parameterDescriptorGroup, pathArray);
    }

    protected DatumShiftGridFile(DatumShiftGridFile<C, T> datumShiftGridFile) {
        super(datumShiftGridFile);
        this.descriptor = datumShiftGridFile.descriptor;
        this.files = datumShiftGridFile.files;
        this.nx = datumShiftGridFile.nx;
        this.accuracy = datumShiftGridFile.accuracy;
    }

    final <NC extends Quantity<NC>, NT extends Quantity<NT>> DatumShiftGridFile<NC, NT> castTo(Class<NC> clazz, Class<NT> clazz2) {
        super.getCoordinateUnit().asType(clazz);
        super.getTranslationUnit().asType(clazz2);
        return this;
    }

    protected final DatumShiftGridFile<C, T> useSharedData() {
        Object[] objectArray = this.getData();
        for (DatumShiftGridFile datumShiftGridFile : CACHE.values()) {
            Object[] objectArray2 = datumShiftGridFile.getData();
            if (!Arrays.deepEquals(objectArray, objectArray2)) continue;
            return this.setData(objectArray2);
        }
        return this;
    }

    protected abstract DatumShiftGridFile<C, T> setData(Object[] var1);

    protected abstract Object[] getData();

    @Override
    public double getCellPrecision() {
        return this.accuracy / 10.0;
    }

    public Matrix gridToTarget() {
        return null;
    }

    public final void setFileParameters(Parameters parameters) {
        if (this.files.length != 0) {
            int n = 0;
            for (GeneralParameterDescriptor generalParameterDescriptor : this.descriptor.descriptors()) {
                ParameterDescriptor parameterDescriptor;
                if (!(generalParameterDescriptor instanceof ParameterDescriptor) || !Path.class.isAssignableFrom((parameterDescriptor = (ParameterDescriptor)generalParameterDescriptor).getValueClass())) continue;
                parameters.getOrCreate(parameterDescriptor).setValue(this.files[n]);
                if (++n != this.files.length) continue;
                break;
            }
        }
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (super.equals(object)) {
            DatumShiftGridFile datumShiftGridFile = (DatumShiftGridFile)object;
            return Arrays.equals(this.files, datumShiftGridFile.files) && Arrays.deepEquals(this.getData(), datumShiftGridFile.getData());
        }
        return false;
    }

    @Override
    public int hashCode() {
        return super.hashCode() + Arrays.hashCode(this.files);
    }

    public String toString() {
        return Utilities.toString(this.getClass(), "file", this.files.length != 0 ? this.files[0] : null);
    }

    static final class Float<C extends Quantity<C>, T extends Quantity<T>>
    extends DatumShiftGridFile<C, T> {
        private static final long serialVersionUID = -9221609983475286496L;
        final float[][] offsets;

        Float(int n, Unit<C> unit, Unit<T> unit2, boolean bl, double d, double d2, double d3, double d4, int n2, int n3, ParameterDescriptorGroup parameterDescriptorGroup, Path ... pathArray) throws NoninvertibleTransformException {
            super(unit, unit2, bl, d, d2, d3, d4, n2, n3, parameterDescriptorGroup, pathArray);
            this.offsets = new float[n][];
            int n4 = JDK8.multiplyExact(n2, n3);
            for (int i = 0; i < n; ++i) {
                this.offsets[i] = new float[n4];
                Arrays.fill(this.offsets[i], java.lang.Float.NaN);
            }
        }

        private Float(DatumShiftGridFile<C, T> datumShiftGridFile, float[][] fArray) {
            super(datumShiftGridFile);
            this.offsets = fArray;
        }

        @Override
        protected final DatumShiftGridFile<C, T> setData(Object[] objectArray) {
            return new Float<C, T>(this, (float[][])objectArray);
        }

        @Override
        protected final Object[] getData() {
            return this.offsets;
        }

        @Override
        public final int getTranslationDimensions() {
            return this.offsets.length;
        }

        @Override
        public final double getCellValue(int n, int n2, int n3) {
            return DecimalFunctions.floatToDouble(this.offsets[n][n2 + n3 * this.nx]);
        }
    }
}

