/*
 * Decompiled with CFR 0.152.
 */
package org.maltparser.core.syntaxgraph.feature;

import java.util.LinkedHashMap;
import java.util.Map;
import org.maltparser.core.exception.MaltChainedException;
import org.maltparser.core.feature.function.AddressFunction;
import org.maltparser.core.feature.function.FeatureFunction;
import org.maltparser.core.feature.value.AddressValue;
import org.maltparser.core.feature.value.FeatureValue;
import org.maltparser.core.feature.value.SingleFeatureValue;
import org.maltparser.core.symbol.SymbolTable;
import org.maltparser.core.symbol.SymbolTableHandler;
import org.maltparser.core.symbol.nullvalue.NullValues;
import org.maltparser.core.syntaxgraph.SyntaxGraphException;
import org.maltparser.core.syntaxgraph.node.DependencyNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DistanceFeature
implements FeatureFunction {
    protected AddressFunction addressFunction1;
    protected AddressFunction addressFunction2;
    protected SymbolTableHandler tableHandler;
    protected SymbolTable table;
    protected SingleFeatureValue featureValue = new SingleFeatureValue(this);
    protected String normalizationString;
    protected Map<Integer, String> normalization;

    public DistanceFeature(SymbolTableHandler tableHandler) throws MaltChainedException {
        this.setTableHandler(tableHandler);
        this.normalization = new LinkedHashMap<Integer, String>();
    }

    @Override
    public void initialize(Object[] arguments) throws MaltChainedException {
        if (arguments.length != 3) {
            throw new SyntaxGraphException("Could not initialize DistanceFeature: number of arguments is not correct. ");
        }
        if (!(arguments[0] instanceof AddressFunction)) {
            throw new SyntaxGraphException("Could not initialize DistanceFeature: the first argument is not an address function. ");
        }
        if (!(arguments[1] instanceof AddressFunction)) {
            throw new SyntaxGraphException("Could not initialize DistanceFeature: the second argument is not an address function. ");
        }
        if (!(arguments[2] instanceof String)) {
            throw new SyntaxGraphException("Could not initialize DistanceFeature: the third argument is not a string. ");
        }
        this.setAddressFunction1((AddressFunction)arguments[0]);
        this.setAddressFunction2((AddressFunction)arguments[1]);
        this.setSymbolTable(this.tableHandler.addSymbolTable("DISTANCE", 1, "one"));
        this.normalizationString = (String)arguments[2];
        String[] items = this.normalizationString.split("\\|");
        if (items.length <= 0 || !items[0].equals("0")) {
            throw new SyntaxGraphException("Could not initialize DistanceFeature (" + this + "): the third argument (normalization) must contain a list of integer values separated with | and the first element must be 0.");
        }
        int tmp = -1;
        for (int i = 0; i < items.length; ++i) {
            int v;
            try {
                v = Integer.parseInt(items[i]);
            }
            catch (NumberFormatException e) {
                throw new SyntaxGraphException("Could not initialize DistanceFeature (" + this + "): the third argument (normalization) must contain a sorted list of integer values separated with |", e);
            }
            this.normalization.put(v, ">=" + v);
            this.table.addSymbol(">=" + v);
            if (tmp != -1 && tmp >= v) {
                throw new SyntaxGraphException("Could not initialize DistanceFeature (" + this + "): the third argument (normalization) must contain a sorted list of integer values separated with |");
            }
            tmp = v;
        }
    }

    @Override
    public Class<?>[] getParameterTypes() {
        Class[] paramTypes = new Class[]{AddressFunction.class, AddressFunction.class, String.class};
        return paramTypes;
    }

    @Override
    public String getSymbol(int code) throws MaltChainedException {
        return this.table.getSymbolCodeToString(code);
    }

    @Override
    public int getCode(String symbol) throws MaltChainedException {
        return this.table.getSymbolStringToCode(symbol);
    }

    @Override
    public void updateCardinality() {
        this.featureValue.setCardinality(this.table.getValueCounter());
    }

    @Override
    public void update() throws MaltChainedException {
        AddressValue arg1 = this.addressFunction1.getAddressValue();
        AddressValue arg2 = this.addressFunction2.getAddressValue();
        if (arg1.getAddress() == null || arg2.getAddress() == null) {
            this.featureValue.setCode(this.table.getNullValueCode(NullValues.NullValueId.NO_NODE));
            this.featureValue.setSymbol(this.table.getNullValueSymbol(NullValues.NullValueId.NO_NODE));
            this.featureValue.setKnown(true);
            this.featureValue.setNullValue(true);
        } else {
            DependencyNode node1 = (DependencyNode)arg1.getAddress();
            DependencyNode node2 = (DependencyNode)arg2.getAddress();
            if (!node1.isRoot() && !node2.isRoot()) {
                int index1 = node1.getIndex();
                int index2 = node2.getIndex();
                int distance = Math.abs(index1 - index2);
                int lower = -1;
                boolean f = false;
                for (Integer upper : this.normalization.keySet()) {
                    if (distance >= lower && distance < upper) {
                        this.featureValue.setCode(this.table.getSymbolStringToCode(this.normalization.get(lower)));
                        this.featureValue.setSymbol(this.normalization.get(lower));
                        f = true;
                        break;
                    }
                    lower = upper;
                }
                if (!f) {
                    this.featureValue.setCode(this.table.getSymbolStringToCode(this.normalization.get(lower)));
                    this.featureValue.setSymbol(this.normalization.get(lower));
                }
                this.featureValue.setKnown(true);
                this.featureValue.setNullValue(false);
            } else {
                this.featureValue.setCode(this.table.getNullValueCode(NullValues.NullValueId.ROOT_NODE));
                this.featureValue.setSymbol(this.table.getNullValueSymbol(NullValues.NullValueId.ROOT_NODE));
                this.featureValue.setKnown(true);
                this.featureValue.setNullValue(true);
            }
        }
    }

    @Override
    public FeatureValue getFeatureValue() {
        return this.featureValue;
    }

    @Override
    public SymbolTable getSymbolTable() {
        return this.table;
    }

    public AddressFunction getAddressFunction1() {
        return this.addressFunction1;
    }

    public void setAddressFunction1(AddressFunction addressFunction1) {
        this.addressFunction1 = addressFunction1;
    }

    public AddressFunction getAddressFunction2() {
        return this.addressFunction2;
    }

    public void setAddressFunction2(AddressFunction addressFunction2) {
        this.addressFunction2 = addressFunction2;
    }

    public SymbolTableHandler getTableHandler() {
        return this.tableHandler;
    }

    public void setTableHandler(SymbolTableHandler tableHandler) {
        this.tableHandler = tableHandler;
    }

    public void setSymbolTable(SymbolTable table) {
        this.table = table;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        return obj.toString().equals(this.toString());
    }

    public int hashCode() {
        return 217 + (null == this.toString() ? 0 : this.toString().hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Distance(");
        sb.append(this.addressFunction1.toString());
        sb.append(", ");
        sb.append(this.addressFunction2.toString());
        sb.append(", ");
        sb.append(this.normalizationString);
        sb.append(')');
        return sb.toString();
    }
}

