#!perl

use strict;
use warnings;

use Test::More 0.88;
use Date::WeekNumber qw/ cpan_week_number /;

my @TESTS =
(
    # 2011 / 2012
    ['2011-01-02', ['2011-01-02'],                              '2011-W01'],
    ['2011-12-24', [2011,12,24],                                '2011-W51'],
    ['2011-12-25', [year => 2011, month => 12, day => 25],      '2011-W52'],
    ['2011-12-29', [{year => 2011, month => 12, day => 29}],    '2011-W52'],
    ['2011-12-30', [1325286835],                                '2011-W52'],
    ['2011-12-31', ['2011-12-31'],                              '2011-W52'],
    ['2012-01-01', ['2012-01-01'],                              '2012-W01'],
    ['2012-01-02', ['2012-01-02'],                              '2012-W01'],
    ['2012-01-03', ['2012-01-03'],                              '2012-W01'],
    ['2012-01-04', ['2012-01-04'],                              '2012-W01'],
    ['2012-01-05', ['2012-01-05'],                              '2012-W01'],
    ['2012-01-06', ['2012-01-06'],                              '2012-W01'],
    ['2012-01-07', ['2012-01-07'],                              '2012-W01'],
    ['2012-01-08', ['2012-01-08'],                              '2012-W02'],

    # 2006 / 2007
    ['2006-01-01', ['2006-01-01'],                              '2006-W01'],
    ['2006-12-30', ['2006-12-30'],                              '2006-W52'],
    ['2006-12-31', ['2006-12-31'],                              '2006-W53'],
    ['2007-01-01', ['2007-01-01'],                              '2006-W53'],
    ['2007-01-02', ['2007-01-02'],                              '2006-W53'],
    ['2007-01-03', ['2007-01-03'],                              '2006-W53'],
    ['2007-01-04', ['2007-01-04'],                              '2006-W53'],
    ['2007-01-05', ['2007-01-05'],                              '2006-W53'],
    ['2007-01-06', ['2007-01-06'],                              '2006-W53'],
    ['2007-01-07', ['2007-01-07'],                              '2007-W01'],

);

foreach my $test (@TESTS) {
    my ($date, $args_ref, $expected_week_number) = @$test;
    my $week_number = cpan_week_number(@$args_ref);

    is($week_number, $expected_week_number,
       "$date is in week $expected_week_number");
}

done_testing();

