package Locales::DB::Language::zu;

use strict;
use warnings;

# Auto generated from CLDR
use if $Locales::_UNICODE_STRINGS, 'utf8';

$Locales::DB::Language::zu::VERSION = '0.09';

$Locales::DB::Language::zu::cldr_version = '2.0';

%Locales::DB::Language::zu::misc_info = (
    'characters'   => { 'more_information' => "\?" },
    'cldr_formats' => {
        '_decimal_format_decimal' => "\,",
        '_decimal_format_group'   => ' ',
        '_percent_format_percent' => "\%",
        'decimal'                 => "\#\,\#\#0\.\#\#\#",
        'ellipsis'                => {
            'final'   => "\{0\}…",
            'initial' => "…\{0\}",
            'medial'  => "\{0\}…\{1\}"
        },
        'language' => "Language\:\ \{0\}",
        'list'     => {
            2        => "I\-\{0\}\ ne\-\{1\}",
            'end'    => "\{0\}\,\ no\-\{1\}",
            'middle' => "\{0\}\,\ \{1\}",
            'start'  => "\{0\}\,\ \{1\}"
        },
        'locale'    => "\{0\}\ \(\{1\}\)",
        'percent'   => "\#\,\#\#0\%",
        'territory' => "Region\:\ \{0\}"
    },
    'delimiters' => {
        'alternate_quotation_end'   => '”',
        'alternate_quotation_start' => '“',
        'quotation_end'             => '’',
        'quotation_start'           => '‘'
    },
    'fallback'    => ['en_za'],
    'orientation' => {
        'characters' => "left\-to\-right",
        'lines'      => "top\-to\-bottom"
    },
    'plural_forms' => {
        'category_list' => [
            'one',
            'other'
        ],
        'category_rules'          => { 'one' => "n\ is\ 1" },
        'category_rules_compiled' => {
            'one' => sub {
                if ( ( ( $_[0] == 1 ) ) ) { return 'one'; }
                return;
            }
        }
    },
    'posix' => {
        'nostr'  => "cha\:c",
        'yesstr' => "yebo\:y"
    },
);

%Locales::DB::Language::zu::code_to_name = (
    'aa'     => 'Afar',
    'ab'     => "isi\-Abkhazian",
    'ace'    => 'Achinese',
    'ach'    => 'Acoli',
    'ada'    => 'Adangme',
    'ady'    => 'Adyghe',
    'ae'     => 'Avestan',
    'af'     => 'isiBhunu',
    'afa'    => "Afro\-Asiatic\ Language",
    'afh'    => 'Afrihili',
    'agq'    => 'Aghem',
    'ain'    => 'Ainu',
    'ak'     => 'Akan',
    'akk'    => 'Akkadian',
    'ale'    => 'Aleut',
    'alg'    => "Algonquian\ Language",
    'alt'    => "Southern\ Altai",
    'am'     => "isi\-Amharic",
    'an'     => 'Aragonese',
    'ang'    => "Old\ English",
    'anp'    => 'Angika',
    'apa'    => "Apache\ Language",
    'ar'     => "isi\-Alabhu",
    'arc'    => 'Aramaic',
    'arn'    => 'Araucanian',
    'arp'    => 'Arapaho',
    'art'    => "Artificial\ Language",
    'arw'    => 'Arawak',
    'as'     => "isi\-Assamese",
    'asa'    => 'Asu',
    'ast'    => 'Asturian',
    'ath'    => "Athapascan\ Language",
    'aus'    => "Australian\ Language",
    'av'     => 'Avaric',
    'awa'    => 'Awadhi',
    'ay'     => "isi\-Aymara",
    'az'     => "isi\-Azeria",
    'ba'     => 'Bashkir',
    'bad'    => 'Banda',
    'bai'    => "Bamileke\ Language",
    'bal'    => 'Baluchi',
    'ban'    => 'Balinese',
    'bas'    => 'Basaa',
    'bat'    => "Baltic\ Language",
    'be'     => "isi\-Belarusian",
    'bej'    => 'Beja',
    'bem'    => 'Bemba',
    'ber'    => 'Berber',
    'bez'    => 'Bena',
    'bg'     => "isi\-Bulgari",
    'bh'     => 'IsiBhihari',
    'bho'    => 'Bhojpuri',
    'bi'     => 'Bislama',
    'bik'    => 'Bikol',
    'bin'    => 'Bini',
    'bla'    => 'Siksika',
    'bm'     => 'Bambara',
    'bn'     => "isi\-Bengali",
    'bnt'    => 'Bantu',
    'bo'     => "isi\-Tibetan",
    'br'     => "isihlobo\ sase\ Britain",
    'bra'    => 'Braj',
    'brx'    => 'Bodo',
    'bs'     => "isi\-Bosnian",
    'btk'    => 'Batak',
    'bua'    => 'Buriat',
    'bug'    => 'Buginese',
    'byn'    => 'Blin',
    'ca'     => "isi\-Catalan",
    'cad'    => 'Caddo',
    'cai'    => "Central\ American\ Indian\ Language",
    'car'    => 'Carib',
    'cau'    => "Caucasian\ Language",
    'cay'    => 'Cayuga',
    'cch'    => 'Atsam',
    'ce'     => 'Chechen',
    'ceb'    => 'Cebuano',
    'cel'    => "Celtic\ Language",
    'cgg'    => 'Chiga',
    'ch'     => 'Chamorro',
    'chb'    => 'Chibcha',
    'chg'    => 'Chagatai',
    'chk'    => 'Chuukese',
    'chm'    => 'Mari',
    'chn'    => "Chinook\ Jargon",
    'cho'    => 'Choctaw',
    'chp'    => 'Chipewyan',
    'chr'    => 'Cherokee',
    'chy'    => 'Cheyenne',
    'cmc'    => "Chamic\ Language",
    'co'     => 'Corsican',
    'cop'    => 'Coptic',
    'cpe'    => "English\-based\ Creole\ or\ Pidgin",
    'cpf'    => "French\-based\ Creole\ or\ Pidgin",
    'cpp'    => "Portuguese\-based\ Creole\ or\ Pidgin",
    'cr'     => 'Cree',
    'crh'    => "Crimean\ Turkish",
    'crp'    => "Creole\ or\ Pidgin",
    'cs'     => "isi\-Czech",
    'csb'    => 'Kashubian',
    'cu'     => "Church\ Slavic",
    'cus'    => "Cushitic\ Language",
    'cv'     => 'Chuvash',
    'cy'     => "isi\-Welsh",
    'da'     => "isi\-Danish",
    'dak'    => 'Dakota',
    'dar'    => 'Dargwa',
    'dav'    => 'Taita',
    'day'    => 'Dayak',
    'de'     => 'isiJalimani',
    'de_at'  => "isi\-Austrian\ German",
    'de_ch'  => "isi\-Swiss\ High\ German",
    'del'    => 'Delaware',
    'den'    => 'Slave',
    'dgr'    => 'Dogrib',
    'din'    => 'Dinka',
    'dje'    => 'Zarma',
    'doi'    => 'Dogri',
    'dra'    => "Dravidian\ Language",
    'dsb'    => "Lower\ Sorbian",
    'dua'    => 'Duala',
    'dum'    => "Middle\ Dutch",
    'dv'     => "isi\-Divehi",
    'dyo'    => "Jola\-Fonyi",
    'dyu'    => 'Dyula',
    'dz'     => "isi\-Dzongkha",
    'ebu'    => 'Embu',
    'ee'     => 'Ewe',
    'efi'    => "isi\-Efik",
    'egy'    => "Ancient\ Egyptian",
    'eka'    => 'Ekajuk',
    'el'     => "isi\-Greek",
    'elx'    => 'Elamite',
    'en'     => 'isiNgisi',
    'en_au'  => "isi\-Austrillian\ English",
    'en_ca'  => "i\-Canadian\ English",
    'en_gb'  => "i\-British\ English",
    'en_us'  => "i\-U\.S\.\ English",
    'enm'    => "Middle\ English",
    'eo'     => "isi\-Esperanto",
    'es'     => 'isiSpeyini',
    'es_419' => "isi\-Latin\ American\ Spanish",
    'es_es'  => "isi\-Iberian\ Spanish",
    'et'     => "isi\-Estonia",
    'eu'     => "isi\-Basque",
    'ewo'    => 'Ewondo',
    'fa'     => "isi\-Persian",
    'fan'    => 'Fang',
    'fat'    => 'Fanti',
    'ff'     => 'Fulah',
    'fi'     => "isi\-Finnish",
    'fil'    => "isi\-Filipino",
    'fiu'    => "Finno\-Ugrian\ Language",
    'fj'     => "isi\-Fijian",
    'fo'     => "isi\-Faroese",
    'fon'    => 'Fon',
    'fr'     => 'isiFulentshi',
    'fr_ca'  => "i\-Canadian\ French",
    'fr_ch'  => "isi\-Swiss\ French",
    'frm'    => "Middle\ French",
    'fro'    => "Old\ French",
    'frr'    => "Northern\ Frisian",
    'frs'    => "Eastern\ Frisian",
    'fur'    => 'Friulian',
    'fy'     => "isi\-Western\ Frisian",
    'ga'     => "isi\-Irish",
    'gaa'    => 'Ga',
    'gay'    => 'Gayo',
    'gba'    => 'Gbaya',
    'gd'     => "i\-Scottish\ Gaelic",
    'gem'    => "Germanic\ Language",
    'gez'    => 'Geez',
    'gil'    => 'Gilbertese',
    'gl'     => "isi\-Galicia",
    'gmh'    => "Middle\ High\ German",
    'gn'     => "isi\-Guarani",
    'goh'    => "Old\ High\ German",
    'gon'    => 'Gondi',
    'gor'    => 'Gorontalo',
    'got'    => 'Gothic',
    'grb'    => 'Grebo',
    'grc'    => "Ancient\ Greek",
    'gsw'    => "isi\-Swiss\ German",
    'gu'     => "isi\-Gujarati",
    'guz'    => 'Gusii',
    'gv'     => 'Manx',
    'gwi'    => "Gwich\Ê\¼in",
    'ha'     => "isi\-Hausa",
    'hai'    => 'Haida',
    'haw'    => "isi\-Hawaiian",
    'he'     => "isi\-Hebrew",
    'hi'     => 'isiHindi',
    'hil'    => 'Hiligaynon',
    'him'    => 'Himachali',
    'hit'    => 'Hittite',
    'hmn'    => 'Hmong',
    'ho'     => "Hiri\ Motu",
    'hr'     => "isi\-Croatian",
    'hsb'    => "Upper\ Sorbian",
    'ht'     => "isi\-Haitian",
    'hu'     => "isi\-Hungarian",
    'hup'    => 'Hupa',
    'hy'     => "isi\-Armenia",
    'hz'     => 'Herero',
    'ia'     => "Izilimi\ ezihlangene",
    'iba'    => 'Iban',
    'id'     => "isi\-Indonesian",
    'ie'     => 'Izilimu',
    'ig'     => "isi\-Igbo",
    'ii'     => "Sichuan\ Yi",
    'ijo'    => 'Ijo',
    'ik'     => 'Inupiaq',
    'ilo'    => 'Iloko',
    'inc'    => "Indic\ Language",
    'ine'    => "Indo\-European\ Language",
    'inh'    => 'Ingush',
    'io'     => 'Ido',
    'ira'    => "Iranian\ Language",
    'iro'    => "Iroquoian\ Language",
    'is'     => "isi\-Icelandic",
    'it'     => "isi\-Italian",
    'iu'     => 'Inuktitut',
    'ja'     => "isi\-Japanese",
    'jbo'    => 'Lojban',
    'jmc'    => 'Machame',
    'jpr'    => "Judeo\-Persian",
    'jrb'    => "Judeo\-Arabic",
    'jv'     => "isi\-Javanese",
    'ka'     => "isi\-Georgian",
    'kaa'    => "Kara\-Kalpak",
    'kab'    => 'Kabyle',
    'kac'    => 'Kachin',
    'kaj'    => 'Jju',
    'kam'    => 'Kamba',
    'kar'    => 'Karen',
    'kaw'    => 'Kawi',
    'kbd'    => 'Kabardian',
    'kcg'    => 'Tyap',
    'kde'    => 'Makonde',
    'kea'    => 'Kabuverdianu',
    'kfo'    => 'Koro',
    'kg'     => 'Kongo',
    'kha'    => 'Khasi',
    'khi'    => "Khoisan\ Language",
    'kho'    => 'Khotanese',
    'khq'    => "Koyra\ Chiini",
    'ki'     => 'Kikuyu',
    'kj'     => 'Kuanyama',
    'kk'     => "isi\-Kazakh",
    'kl'     => 'Kalaallisut',
    'kln'    => 'Kalenjin',
    'km'     => "isi\-Khmer",
    'kmb'    => 'Kimbundu',
    'kn'     => "isi\-Kannada",
    'ko'     => "isi\-Korean",
    'kok'    => 'Konkani',
    'kos'    => 'Kosraean',
    'kpe'    => 'Kpelle',
    'kr'     => 'Kanuri',
    'krc'    => "Karachay\-Balkar",
    'krl'    => 'Karelian',
    'kro'    => 'Kru',
    'kru'    => 'Kurukh',
    'ks'     => "isi\-Kashmiri",
    'ksb'    => 'Shambala',
    'ksf'    => 'Bafia',
    'ksh'    => 'Colognian',
    'ku'     => "isi\-Kurdish",
    'kum'    => 'Kumyk',
    'kut'    => 'Kutenai',
    'kv'     => 'Komi',
    'kw'     => 'Cornish',
    'ky'     => "isi\-Kirghiz",
    'la'     => "isi\-Latin",
    'lad'    => 'Ladino',
    'lag'    => 'Langi',
    'lah'    => 'Lahnda',
    'lam'    => 'Lamba',
    'lb'     => "isi\-Luxembourgish",
    'lez'    => 'Lezghian',
    'lg'     => 'Ganda',
    'li'     => 'Limburgish',
    'ln'     => "isi\-Lingala",
    'lo'     => "i\-Lao",
    'lol'    => 'Mongo',
    'loz'    => 'Lozi',
    'lt'     => "isi\-Lithuanian",
    'lu'     => "Luba\-Katanga",
    'lua'    => "Luba\-Lulua",
    'lui'    => 'Luiseno',
    'lun'    => 'Lunda',
    'luo'    => 'Luo',
    'lus'    => 'Lushai',
    'luy'    => 'Luyia',
    'lv'     => "isi\-Latvia",
    'mad'    => 'Madurese',
    'mag'    => 'Magahi',
    'mai'    => 'Maithili',
    'mak'    => 'Makasar',
    'man'    => 'Mandingo',
    'map'    => "Austronesian\ Language",
    'mas'    => 'Masai',
    'mdf'    => 'Moksha',
    'mdr'    => 'Mandar',
    'men'    => 'Mende',
    'mer'    => 'Meru',
    'mfe'    => 'Morisyen',
    'mg'     => "isi\-Malagasy",
    'mga'    => "Middle\ Irish",
    'mgh'    => "Makhuwa\-Meetto",
    'mh'     => 'Marshallese',
    'mi'     => "isi\-Maori",
    'mic'    => 'Micmac',
    'min'    => 'Minangkabau',
    'mis'    => "Miscellaneous\ Language",
    'mk'     => "isi\-Macedonia",
    'mkh'    => "Mon\-Khmer\ Language",
    'ml'     => "isi\-Malayalam",
    'mn'     => "isi\-Mongolian",
    'mnc'    => 'Manchu',
    'mni'    => 'Manipuri',
    'mno'    => "Manobo\ Language",
    'mo'     => 'Moldavian',
    'moh'    => 'Mohawk',
    'mos'    => 'Mossi',
    'mr'     => "isi\-Marathi",
    'ms'     => "isi\-Malay",
    'mt'     => "isi\-Malta",
    'mua'    => 'Mundang',
    'mul'    => "Multiple\ Languages",
    'mun'    => "Munda\ Language",
    'mus'    => 'Creek',
    'mwl'    => 'Mirandese',
    'mwr'    => 'Marwari',
    'my'     => "isi\-Burmese",
    'myn'    => "Mayan\ Language",
    'myv'    => 'Erzya',
    'na'     => 'Nauru',
    'nah'    => 'Nahuatl',
    'nai'    => "North\ American\ Indian\ Language",
    'nap'    => 'Neapolitan',
    'naq'    => 'Nama',
    'nb'     => "i\-Norwegian\ Bokmål",
    'nd'     => "isi\-North\ Ndebele",
    'nds'    => "Low\ German",
    'ne'     => "isi\-Nepali",
    'new'    => 'Newari',
    'ng'     => 'Ndonga',
    'nia'    => 'Nias',
    'nic'    => "Niger\-Kordofanian\ Language",
    'niu'    => 'Niuean',
    'nl'     => "i\-Dutch",
    'nl_be'  => "isi\-Flemish",
    'nmg'    => 'Kwasio',
    'nn'     => "i\-Norwegian\ Nynorsk",
    'no'     => 'IsiNoweyi',
    'nog'    => 'Nogai',
    'non'    => "Old\ Norse",
    'nqo'    => "N\â\\Ko",
    'nr'     => "South\ Ndebele",
    'nso'    => "isi\-Northern\ Sotho",
    'nub'    => "Nubian\ Language",
    'nus'    => 'Nuer',
    'nv'     => 'Navajo',
    'nwc'    => "Classical\ Newari",
    'ny'     => "isi\-Nyanja",
    'nym'    => 'Nyamwezi',
    'nyn'    => 'Nyankole',
    'nyo'    => 'Nyoro',
    'nzi'    => 'Nzima',
    'oc'     => "Isi\-Osithani",
    'oj'     => 'Ojibwa',
    'om'     => 'Oromo',
    'or'     => "isi\-Oriya",
    'os'     => "isi\-Ossetic",
    'osa'    => 'Osage',
    'ota'    => "Ottoman\ Turkish",
    'oto'    => "Otomian\ Language",
    'pa'     => "isi\-Punjabi",
    'paa'    => "Papuan\ Language",
    'pag'    => 'Pangasinan',
    'pal'    => 'Pahlavi',
    'pam'    => 'Pampanga',
    'pap'    => 'Papiamento',
    'pau'    => 'Palauan',
    'peo'    => "Old\ Persian",
    'phi'    => "Philippine\ Language",
    'phn'    => 'Phoenician',
    'pi'     => 'Pali',
    'pl'     => "isi\-Polish",
    'pon'    => 'Pohnpeian',
    'pra'    => "Prakrit\ Language",
    'pro'    => "Old\ Proven\Ã\§al",
    'ps'     => "isi\-Pushto",
    'pt'     => "isi\-Portuguese",
    'pt_br'  => "isi\-Brazillian\ Portuguese",
    'pt_pt'  => "isi\-Iberian\ Portuguese",
    'qu'     => "isi\-Quechua",
    'raj'    => 'Rajasthani',
    'rap'    => 'Rapanui',
    'rar'    => 'Rarotongan',
    'rm'     => "isi\-Romansh",
    'rn'     => "isi\-Rundi",
    'ro'     => "isi\-Romanian",
    'roa'    => "Romance\ Language",
    'rof'    => 'Rombo',
    'rom'    => 'Romany',
    'ru'     => "isi\-Russian",
    'rup'    => 'Aromanian',
    'rw'     => "isi\-Kinyarwanda",
    'rwk'    => 'Rwa',
    'sa'     => "isi\-Sanskrit",
    'sad'    => 'Sandawe',
    'sah'    => 'Sakha',
    'sai'    => "South\ American\ Indian\ Language",
    'sal'    => "Salishan\ Language",
    'sam'    => "Samaritan\ Aramaic",
    'saq'    => 'Samburu',
    'sas'    => 'Sasak',
    'sat'    => 'Santali',
    'sbp'    => 'Sangu',
    'sc'     => 'Sardinian',
    'scn'    => 'Sicilian',
    'sco'    => 'Scots',
    'sd'     => "isi\-Sindhi",
    'se'     => "e\-Northern\ Sami",
    'see'    => 'Seneca',
    'seh'    => 'Sena',
    'sel'    => 'Selkup',
    'sem'    => "Semitic\ Language",
    'ses'    => "Koyraboro\ Senni",
    'sg'     => "isi\-Sango",
    'sga'    => "Old\ Irish",
    'sgn'    => "Sign\ Language",
    'sh'     => "Serbo\-Croatian",
    'shi'    => 'Tachelhit',
    'shn'    => 'Shan',
    'si'     => "i\-Sinhala",
    'sid'    => 'Sidamo',
    'sio'    => "Siouan\ Language",
    'sit'    => "Sino\-Tibetan\ Language",
    'sk'     => "isi\-Slovak",
    'sl'     => "isi\-Slovenian",
    'sla'    => "Slavic\ Language",
    'sm'     => "isi\-Samoan",
    'sma'    => "Southern\ Sami",
    'smi'    => "Sami\ Language",
    'smj'    => "Lule\ Sami",
    'smn'    => "Inari\ Sami",
    'sms'    => "Skolt\ Sami",
    'sn'     => 'isiShona',
    'snk'    => 'Soninke',
    'so'     => "isi\-Somali",
    'sog'    => 'Sogdien',
    'son'    => 'Songhai',
    'sq'     => "isi\-Albania",
    'sr'     => "isi\-Serbian",
    'srn'    => "Sranan\ Tongo",
    'srr'    => 'Serer',
    'ss'     => 'isiSwati',
    'ssa'    => "Nilo\-Saharan\ Language",
    'ssy'    => 'Saho',
    'st'     => 'isiSuthu',
    'su'     => "isi\-Sundanese",
    'suk'    => 'Sukuma',
    'sus'    => 'Susu',
    'sux'    => 'Sumerian',
    'sv'     => "isi\-Swedish",
    'sw'     => 'isiSwahili',
    'swb'    => 'Comorian',
    'swc'    => "Congo\ Swahili",
    'syc'    => "Classical\ Syriac",
    'syr'    => 'Syriac',
    'ta'     => "isi\-Tamil",
    'tai'    => "Tai\ Language",
    'te'     => "isi\-Telugu",
    'tem'    => 'Timne',
    'teo'    => 'Teso',
    'ter'    => 'Tereno',
    'tet'    => "isi\-Tetum",
    'tg'     => "isi\-Tajik",
    'th'     => "isi\-Thai",
    'ti'     => "isi\-Tigrinya",
    'tig'    => 'Tigre',
    'tiv'    => 'Tiv',
    'tk'     => "isi\-Turkmen",
    'tkl'    => 'Tokelau',
    'tl'     => 'Tagalog',
    'tlh'    => 'IsiKlingoni',
    'tli'    => 'Tlingit',
    'tmh'    => 'Tamashek',
    'tn'     => "isi\-Tswana",
    'to'     => "isi\-Tonga",
    'tog'    => "Nyasa\ Tonga",
    'tpi'    => "isi\-Tok\ Pisin",
    'tr'     => "isi\-Turkish",
    'trv'    => 'Taroko',
    'ts'     => "isi\-Tsonga",
    'tsi'    => 'Tsimshian',
    'tt'     => "isi\-Tatar",
    'tum'    => 'Tumbuka',
    'tup'    => "Tupi\ Language",
    'tut'    => "Altaic\ Language",
    'tvl'    => 'Tuvalu',
    'tw'     => 'Twi',
    'twq'    => 'Tasawaq',
    'ty'     => "isi\-Tahitian",
    'tyv'    => 'Tuvinian',
    'tzm'    => "Central\ Morocco\ Tamazight",
    'udm'    => 'Udmurt',
    'ug'     => "isi\-Uyghur",
    'uga'    => 'Ugaritic',
    'uk'     => "isi\-Ukrainian",
    'umb'    => 'Umbundu',
    'und'    => "Ulimi\ olungaziwa",
    'ur'     => "isi\-Urdu",
    'uz'     => "isi\-Uzbek",
    'vai'    => 'Vai',
    've'     => "isi\-Venda",
    'vi'     => "isi\-Vietnamese",
    'vo'     => "Volap\Ã\¼k",
    'vot'    => 'Votic',
    'vun'    => 'Vunjo',
    'wa'     => 'Walloon',
    'wae'    => 'Walser',
    'wak'    => "Wakashan\ Language",
    'wal'    => 'Walamo',
    'war'    => 'Waray',
    'was'    => 'Washo',
    'wen'    => "Sorbian\ Language",
    'wo'     => "isi\-Wolof",
    'xal'    => 'Kalmyk',
    'xh'     => 'isiXhosa',
    'xog'    => 'Soga',
    'yao'    => 'Yao',
    'yap'    => 'Yapese',
    'yav'    => 'Yangben',
    'yi'     => "ulimu\ olwi\ Yidish",
    'yo'     => "isi\-Yoruba",
    'ypk'    => "Yupik\ Language",
    'yue'    => 'Cantonese',
    'za'     => 'Zhuang',
    'zap'    => 'Zapotec',
    'zbl'    => 'Blissymbols',
    'zen'    => 'Zenaga',
    'zh'     => "isi\-Chinese",
    'znd'    => 'Zande',
    'zu'     => 'isiZulu',
    'zun'    => 'Zuni',
    'zxx'    => "Akukho\ okuqukethwe\ kolimi",
    'zza'    => 'Zaza',
);

%Locales::DB::Language::zu::name_to_code = (
    'achinese'                      => 'ace',
    'acoli'                         => 'ach',
    'adangme'                       => 'ada',
    'adyghe'                        => 'ady',
    'afar'                          => 'aa',
    'afrihili'                      => 'afh',
    'afroasiaticlanguage'           => 'afa',
    'aghem'                         => 'agq',
    'ainu'                          => 'ain',
    'akan'                          => 'ak',
    'akkadian'                      => 'akk',
    'akukhookuqukethwekolimi'       => 'zxx',
    'aleut'                         => 'ale',
    'algonquianlanguage'            => 'alg',
    'altaiclanguage'                => 'tut',
    'ancientegyptian'               => 'egy',
    'ancientgreek'                  => 'grc',
    'angika'                        => 'anp',
    'apachelanguage'                => 'apa',
    'aragonese'                     => 'an',
    'aramaic'                       => 'arc',
    'arapaho'                       => 'arp',
    'araucanian'                    => 'arn',
    'arawak'                        => 'arw',
    'aromanian'                     => 'rup',
    'artificiallanguage'            => 'art',
    'asturian'                      => 'ast',
    'asu'                           => 'asa',
    'athapascanlanguage'            => 'ath',
    'atsam'                         => 'cch',
    'australianlanguage'            => 'aus',
    'austronesianlanguage'          => 'map',
    'avaric'                        => 'av',
    'avestan'                       => 'ae',
    'awadhi'                        => 'awa',
    'bafia'                         => 'ksf',
    'balinese'                      => 'ban',
    'balticlanguage'                => 'bat',
    'baluchi'                       => 'bal',
    'bambara'                       => 'bm',
    'bamilekelanguage'              => 'bai',
    'banda'                         => 'bad',
    'bantu'                         => 'bnt',
    'basaa'                         => 'bas',
    'bashkir'                       => 'ba',
    'batak'                         => 'btk',
    'beja'                          => 'bej',
    'bemba'                         => 'bem',
    'bena'                          => 'bez',
    'berber'                        => 'ber',
    'bhojpuri'                      => 'bho',
    'bikol'                         => 'bik',
    'bini'                          => 'bin',
    'bislama'                       => 'bi',
    'blin'                          => 'byn',
    'blissymbols'                   => 'zbl',
    'bodo'                          => 'brx',
    'braj'                          => 'bra',
    'buginese'                      => 'bug',
    'buriat'                        => 'bua',
    'caddo'                         => 'cad',
    'cantonese'                     => 'yue',
    'carib'                         => 'car',
    'caucasianlanguage'             => 'cau',
    'cayuga'                        => 'cay',
    'cebuano'                       => 'ceb',
    'celticlanguage'                => 'cel',
    'centralamericanindianlanguage' => 'cai',
    'centralmoroccotamazight'       => 'tzm',
    'chagatai'                      => 'chg',
    'chamiclanguage'                => 'cmc',
    'chamorro'                      => 'ch',
    'chechen'                       => 'ce',
    'cherokee'                      => 'chr',
    'cheyenne'                      => 'chy',
    'chibcha'                       => 'chb',
    'chiga'                         => 'cgg',
    'chinookjargon'                 => 'chn',
    'chipewyan'                     => 'chp',
    'choctaw'                       => 'cho',
    'churchslavic'                  => 'cu',
    'chuukese'                      => 'chk',
    'chuvash'                       => 'cv',
    'classicalnewari'               => 'nwc',
    'classicalsyriac'               => 'syc',
    'colognian'                     => 'ksh',
    'comorian'                      => 'swb',
    'congoswahili'                  => 'swc',
    'coptic'                        => 'cop',
    'cornish'                       => 'kw',
    'corsican'                      => 'co',
    'cree'                          => 'cr',
    'creek'                         => 'mus',
    'creoleorpidgin'                => 'crp',
    'crimeanturkish'                => 'crh',
    'cushiticlanguage'              => 'cus',
    'dakota'                        => 'dak',
    'dargwa'                        => 'dar',
    'dayak'                         => 'day',
    'delaware'                      => 'del',
    'dinka'                         => 'din',
    'dogri'                         => 'doi',
    'dogrib'                        => 'dgr',
    'dravidianlanguage'             => 'dra',
    'duala'                         => 'dua',
    'dyula'                         => 'dyu',
    'easternfrisian'                => 'frs',
    'ekajuk'                        => 'eka',
    'elamite'                       => 'elx',
    'embu'                          => 'ebu',
    'englishbasedcreoleorpidgin'    => 'cpe',
    'enorthernsami'                 => 'se',
    'erzya'                         => 'myv',
    'ewe'                           => 'ee',
    'ewondo'                        => 'ewo',
    'fang'                          => 'fan',
    'fanti'                         => 'fat',
    'finnougrianlanguage'           => 'fiu',
    'fon'                           => 'fon',
    'frenchbasedcreoleorpidgin'     => 'cpf',
    'friulian'                      => 'fur',
    'fulah'                         => 'ff',
    'ga'                            => 'gaa',
    'ganda'                         => 'lg',
    'gayo'                          => 'gay',
    'gbaya'                         => 'gba',
    'geez'                          => 'gez',
    'germaniclanguage'              => 'gem',
    'gilbertese'                    => 'gil',
    'gondi'                         => 'gon',
    'gorontalo'                     => 'gor',
    'gothic'                        => 'got',
    'grebo'                         => 'grb',
    'gusii'                         => 'guz',
    "gwich\Ê\¼in"                 => 'gwi',
    'haida'                         => 'hai',
    'herero'                        => 'hz',
    'hiligaynon'                    => 'hil',
    'himachali'                     => 'him',
    'hirimotu'                      => 'ho',
    'hittite'                       => 'hit',
    'hmong'                         => 'hmn',
    'hupa'                          => 'hup',
    'iban'                          => 'iba',
    'ibritishenglish'               => 'en_gb',
    'icanadianenglish'              => 'en_ca',
    'icanadianfrench'               => 'fr_ca',
    'ido'                           => 'io',
    'idutch'                        => 'nl',
    'ijo'                           => 'ijo',
    'ilao'                          => 'lo',
    'iloko'                         => 'ilo',
    'inarisami'                     => 'smn',
    'indiclanguage'                 => 'inc',
    'indoeuropeanlanguage'          => 'ine',
    'ingush'                        => 'inh',
    'inorwegianbokmål'             => 'nb',
    'inorwegiannynorsk'             => 'nn',
    'inuktitut'                     => 'iu',
    'inupiaq'                       => 'ik',
    'iranianlanguage'               => 'ira',
    'iroquoianlanguage'             => 'iro',
    'iscottishgaelic'               => 'gd',
    'isiabkhazian'                  => 'ab',
    'isialabhu'                     => 'ar',
    'isialbania'                    => 'sq',
    'isiamharic'                    => 'am',
    'isiarmenia'                    => 'hy',
    'isiassamese'                   => 'as',
    'isiaustriangerman'             => 'de_at',
    'isiaustrillianenglish'         => 'en_au',
    'isiaymara'                     => 'ay',
    'isiazeria'                     => 'az',
    'isibasque'                     => 'eu',
    'isibelarusian'                 => 'be',
    'isibengali'                    => 'bn',
    'isibhihari'                    => 'bh',
    'isibhunu'                      => 'af',
    'isibosnian'                    => 'bs',
    'isibrazillianportuguese'       => 'pt_br',
    'isibulgari'                    => 'bg',
    'isiburmese'                    => 'my',
    'isicatalan'                    => 'ca',
    'isichinese'                    => 'zh',
    'isicroatian'                   => 'hr',
    'isiczech'                      => 'cs',
    'isidanish'                     => 'da',
    'isidivehi'                     => 'dv',
    'isidzongkha'                   => 'dz',
    'isiefik'                       => 'efi',
    'isiesperanto'                  => 'eo',
    'isiestonia'                    => 'et',
    'isifaroese'                    => 'fo',
    'isifijian'                     => 'fj',
    'isifilipino'                   => 'fil',
    'isifinnish'                    => 'fi',
    'isiflemish'                    => 'nl_be',
    'isifulentshi'                  => 'fr',
    'isigalicia'                    => 'gl',
    'isigeorgian'                   => 'ka',
    'isigreek'                      => 'el',
    'isiguarani'                    => 'gn',
    'isigujarati'                   => 'gu',
    'isihaitian'                    => 'ht',
    'isihausa'                      => 'ha',
    'isihawaiian'                   => 'haw',
    'isihebrew'                     => 'he',
    'isihindi'                      => 'hi',
    'isihlobosasebritain'           => 'br',
    'isihungarian'                  => 'hu',
    'isiiberianportuguese'          => 'pt_pt',
    'isiiberianspanish'             => 'es_es',
    'isiicelandic'                  => 'is',
    'isiigbo'                       => 'ig',
    'isiindonesian'                 => 'id',
    'isiirish'                      => 'ga',
    'isiitalian'                    => 'it',
    'isijalimani'                   => 'de',
    'isijapanese'                   => 'ja',
    'isijavanese'                   => 'jv',
    'isikannada'                    => 'kn',
    'isikashmiri'                   => 'ks',
    'isikazakh'                     => 'kk',
    'isikhmer'                      => 'km',
    'isikinyarwanda'                => 'rw',
    'isikirghiz'                    => 'ky',
    'isiklingoni'                   => 'tlh',
    'isikorean'                     => 'ko',
    'isikurdish'                    => 'ku',
    'isilatin'                      => 'la',
    'isilatinamericanspanish'       => 'es_419',
    'isilatvia'                     => 'lv',
    'isilingala'                    => 'ln',
    'isilithuanian'                 => 'lt',
    'isiluxembourgish'              => 'lb',
    'isimacedonia'                  => 'mk',
    'isimalagasy'                   => 'mg',
    'isimalay'                      => 'ms',
    'isimalayalam'                  => 'ml',
    'isimalta'                      => 'mt',
    'isimaori'                      => 'mi',
    'isimarathi'                    => 'mr',
    'isimongolian'                  => 'mn',
    'isinepali'                     => 'ne',
    'isingisi'                      => 'en',
    'isinhala'                      => 'si',
    'isinorthernsotho'              => 'nso',
    'isinorthndebele'               => 'nd',
    'isinoweyi'                     => 'no',
    'isinyanja'                     => 'ny',
    'isioriya'                      => 'or',
    'isiosithani'                   => 'oc',
    'isiossetic'                    => 'os',
    'isipersian'                    => 'fa',
    'isipolish'                     => 'pl',
    'isiportuguese'                 => 'pt',
    'isipunjabi'                    => 'pa',
    'isipushto'                     => 'ps',
    'isiquechua'                    => 'qu',
    'isiromanian'                   => 'ro',
    'isiromansh'                    => 'rm',
    'isirundi'                      => 'rn',
    'isirussian'                    => 'ru',
    'isisamoan'                     => 'sm',
    'isisango'                      => 'sg',
    'isisanskrit'                   => 'sa',
    'isiserbian'                    => 'sr',
    'isishona'                      => 'sn',
    'isisindhi'                     => 'sd',
    'isislovak'                     => 'sk',
    'isislovenian'                  => 'sl',
    'isisomali'                     => 'so',
    'isispeyini'                    => 'es',
    'isisundanese'                  => 'su',
    'isisuthu'                      => 'st',
    'isiswahili'                    => 'sw',
    'isiswati'                      => 'ss',
    'isiswedish'                    => 'sv',
    'isiswissfrench'                => 'fr_ch',
    'isiswissgerman'                => 'gsw',
    'isiswisshighgerman'            => 'de_ch',
    'isitahitian'                   => 'ty',
    'isitajik'                      => 'tg',
    'isitamil'                      => 'ta',
    'isitatar'                      => 'tt',
    'isitelugu'                     => 'te',
    'isitetum'                      => 'tet',
    'isithai'                       => 'th',
    'isitibetan'                    => 'bo',
    'isitigrinya'                   => 'ti',
    'isitokpisin'                   => 'tpi',
    'isitonga'                      => 'to',
    'isitsonga'                     => 'ts',
    'isitswana'                     => 'tn',
    'isiturkish'                    => 'tr',
    'isiturkmen'                    => 'tk',
    'isiukrainian'                  => 'uk',
    'isiurdu'                       => 'ur',
    'isiuyghur'                     => 'ug',
    'isiuzbek'                      => 'uz',
    'isivenda'                      => 've',
    'isivietnamese'                 => 'vi',
    'isiwelsh'                      => 'cy',
    'isiwesternfrisian'             => 'fy',
    'isiwolof'                      => 'wo',
    'isixhosa'                      => 'xh',
    'isiyoruba'                     => 'yo',
    'isizulu'                       => 'zu',
    "iu\.s\.english"                => 'en_us',
    'izilimiezihlangene'            => 'ia',
    'izilimu'                       => 'ie',
    'jju'                           => 'kaj',
    'jolafonyi'                     => 'dyo',
    'judeoarabic'                   => 'jrb',
    'judeopersian'                  => 'jpr',
    'kabardian'                     => 'kbd',
    'kabuverdianu'                  => 'kea',
    'kabyle'                        => 'kab',
    'kachin'                        => 'kac',
    'kalaallisut'                   => 'kl',
    'kalenjin'                      => 'kln',
    'kalmyk'                        => 'xal',
    'kamba'                         => 'kam',
    'kanuri'                        => 'kr',
    'karachaybalkar'                => 'krc',
    'karakalpak'                    => 'kaa',
    'karelian'                      => 'krl',
    'karen'                         => 'kar',
    'kashubian'                     => 'csb',
    'kawi'                          => 'kaw',
    'khasi'                         => 'kha',
    'khoisanlanguage'               => 'khi',
    'khotanese'                     => 'kho',
    'kikuyu'                        => 'ki',
    'kimbundu'                      => 'kmb',
    'komi'                          => 'kv',
    'kongo'                         => 'kg',
    'konkani'                       => 'kok',
    'koro'                          => 'kfo',
    'kosraean'                      => 'kos',
    'koyraborosenni'                => 'ses',
    'koyrachiini'                   => 'khq',
    'kpelle'                        => 'kpe',
    'kru'                           => 'kro',
    'kuanyama'                      => 'kj',
    'kumyk'                         => 'kum',
    'kurukh'                        => 'kru',
    'kutenai'                       => 'kut',
    'kwasio'                        => 'nmg',
    'ladino'                        => 'lad',
    'lahnda'                        => 'lah',
    'lamba'                         => 'lam',
    'langi'                         => 'lag',
    'lezghian'                      => 'lez',
    'limburgish'                    => 'li',
    'lojban'                        => 'jbo',
    'lowersorbian'                  => 'dsb',
    'lowgerman'                     => 'nds',
    'lozi'                          => 'loz',
    'lubakatanga'                   => 'lu',
    'lubalulua'                     => 'lua',
    'luiseno'                       => 'lui',
    'lulesami'                      => 'smj',
    'lunda'                         => 'lun',
    'luo'                           => 'luo',
    'lushai'                        => 'lus',
    'luyia'                         => 'luy',
    'machame'                       => 'jmc',
    'madurese'                      => 'mad',
    'magahi'                        => 'mag',
    'maithili'                      => 'mai',
    'makasar'                       => 'mak',
    'makhuwameetto'                 => 'mgh',
    'makonde'                       => 'kde',
    'manchu'                        => 'mnc',
    'mandar'                        => 'mdr',
    'mandingo'                      => 'man',
    'manipuri'                      => 'mni',
    'manobolanguage'                => 'mno',
    'manx'                          => 'gv',
    'mari'                          => 'chm',
    'marshallese'                   => 'mh',
    'marwari'                       => 'mwr',
    'masai'                         => 'mas',
    'mayanlanguage'                 => 'myn',
    'mende'                         => 'men',
    'meru'                          => 'mer',
    'micmac'                        => 'mic',
    'middledutch'                   => 'dum',
    'middleenglish'                 => 'enm',
    'middlefrench'                  => 'frm',
    'middlehighgerman'              => 'gmh',
    'middleirish'                   => 'mga',
    'minangkabau'                   => 'min',
    'mirandese'                     => 'mwl',
    'miscellaneouslanguage'         => 'mis',
    'mohawk'                        => 'moh',
    'moksha'                        => 'mdf',
    'moldavian'                     => 'mo',
    'mongo'                         => 'lol',
    'monkhmerlanguage'              => 'mkh',
    'morisyen'                      => 'mfe',
    'mossi'                         => 'mos',
    'multiplelanguages'             => 'mul',
    'mundalanguage'                 => 'mun',
    'mundang'                       => 'mua',
    'nahuatl'                       => 'nah',
    'nama'                          => 'naq',
    'nauru'                         => 'na',
    'navajo'                        => 'nv',
    'ndonga'                        => 'ng',
    'neapolitan'                    => 'nap',
    'newari'                        => 'new',
    'nias'                          => 'nia',
    'nigerkordofanianlanguage'      => 'nic',
    'nilosaharanlanguage'           => 'ssa',
    'niuean'                        => 'niu',
    'nogai'                         => 'nog',
    'northamericanindianlanguage'   => 'nai',
    'northernfrisian'               => 'frr',
    'nubianlanguage'                => 'nub',
    'nuer'                          => 'nus',
    'nyamwezi'                      => 'nym',
    'nyankole'                      => 'nyn',
    'nyasatonga'                    => 'tog',
    'nyoro'                         => 'nyo',
    'nzima'                         => 'nzi',
    "n\â\\ko"                  => 'nqo',
    'ojibwa'                        => 'oj',
    'oldenglish'                    => 'ang',
    'oldfrench'                     => 'fro',
    'oldhighgerman'                 => 'goh',
    'oldirish'                      => 'sga',
    'oldnorse'                      => 'non',
    'oldpersian'                    => 'peo',
    "oldproven\Ã\§al"             => 'pro',
    'oromo'                         => 'om',
    'osage'                         => 'osa',
    'otomianlanguage'               => 'oto',
    'ottomanturkish'                => 'ota',
    'pahlavi'                       => 'pal',
    'palauan'                       => 'pau',
    'pali'                          => 'pi',
    'pampanga'                      => 'pam',
    'pangasinan'                    => 'pag',
    'papiamento'                    => 'pap',
    'papuanlanguage'                => 'paa',
    'philippinelanguage'            => 'phi',
    'phoenician'                    => 'phn',
    'pohnpeian'                     => 'pon',
    'portuguesebasedcreoleorpidgin' => 'cpp',
    'prakritlanguage'               => 'pra',
    'rajasthani'                    => 'raj',
    'rapanui'                       => 'rap',
    'rarotongan'                    => 'rar',
    'romancelanguage'               => 'roa',
    'romany'                        => 'rom',
    'rombo'                         => 'rof',
    'rwa'                           => 'rwk',
    'saho'                          => 'ssy',
    'sakha'                         => 'sah',
    'salishanlanguage'              => 'sal',
    'samaritanaramaic'              => 'sam',
    'samburu'                       => 'saq',
    'samilanguage'                  => 'smi',
    'sandawe'                       => 'sad',
    'sangu'                         => 'sbp',
    'santali'                       => 'sat',
    'sardinian'                     => 'sc',
    'sasak'                         => 'sas',
    'scots'                         => 'sco',
    'selkup'                        => 'sel',
    'semiticlanguage'               => 'sem',
    'sena'                          => 'seh',
    'seneca'                        => 'see',
    'serbocroatian'                 => 'sh',
    'serer'                         => 'srr',
    'shambala'                      => 'ksb',
    'shan'                          => 'shn',
    'sichuanyi'                     => 'ii',
    'sicilian'                      => 'scn',
    'sidamo'                        => 'sid',
    'signlanguage'                  => 'sgn',
    'siksika'                       => 'bla',
    'sinotibetanlanguage'           => 'sit',
    'siouanlanguage'                => 'sio',
    'skoltsami'                     => 'sms',
    'slave'                         => 'den',
    'slaviclanguage'                => 'sla',
    'soga'                          => 'xog',
    'sogdien'                       => 'sog',
    'songhai'                       => 'son',
    'soninke'                       => 'snk',
    'sorbianlanguage'               => 'wen',
    'southamericanindianlanguage'   => 'sai',
    'southernaltai'                 => 'alt',
    'southernsami'                  => 'sma',
    'southndebele'                  => 'nr',
    'sranantongo'                   => 'srn',
    'sukuma'                        => 'suk',
    'sumerian'                      => 'sux',
    'susu'                          => 'sus',
    'syriac'                        => 'syr',
    'tachelhit'                     => 'shi',
    'tagalog'                       => 'tl',
    'tailanguage'                   => 'tai',
    'taita'                         => 'dav',
    'tamashek'                      => 'tmh',
    'taroko'                        => 'trv',
    'tasawaq'                       => 'twq',
    'tereno'                        => 'ter',
    'teso'                          => 'teo',
    'tigre'                         => 'tig',
    'timne'                         => 'tem',
    'tiv'                           => 'tiv',
    'tlingit'                       => 'tli',
    'tokelau'                       => 'tkl',
    'tsimshian'                     => 'tsi',
    'tumbuka'                       => 'tum',
    'tupilanguage'                  => 'tup',
    'tuvalu'                        => 'tvl',
    'tuvinian'                      => 'tyv',
    'twi'                           => 'tw',
    'tyap'                          => 'kcg',
    'udmurt'                        => 'udm',
    'ugaritic'                      => 'uga',
    'ulimiolungaziwa'               => 'und',
    'ulimuolwiyidish'               => 'yi',
    'umbundu'                       => 'umb',
    'uppersorbian'                  => 'hsb',
    'vai'                           => 'vai',
    "volap\Ã\¼k"                  => 'vo',
    'votic'                         => 'vot',
    'vunjo'                         => 'vun',
    'wakashanlanguage'              => 'wak',
    'walamo'                        => 'wal',
    'walloon'                       => 'wa',
    'walser'                        => 'wae',
    'waray'                         => 'war',
    'washo'                         => 'was',
    'yangben'                       => 'yav',
    'yao'                           => 'yao',
    'yapese'                        => 'yap',
    'yupiklanguage'                 => 'ypk',
    'zande'                         => 'znd',
    'zapotec'                       => 'zap',
    'zarma'                         => 'dje',
    'zaza'                          => 'zza',
    'zenaga'                        => 'zen',
    'zhuang'                        => 'za',
    'zuni'                          => 'zun',
);

1;
