#!/usr/bin/perl

package eBay::API::XML::Call::GetPopularKeywords::GetPopularKeywordsRequestType;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. GetPopularKeywordsRequestType.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::Call::GetPopularKeywords::GetPopularKeywordsRequestType

=head1 DESCRIPTION

Retrieves the words more frequently used by eBay users when
searching for listings. These keywords are generated weekly by
eBay. Thus, calls retrieve static data. GetPopularKeywords is not
available for the following sites:  FR, HK, MY, PH, PL, SG, SE.



=head1 SYNOPSIS

=cut


=head1 INHERITANCE

eBay::API::XML::Call::GetPopularKeywords::GetPopularKeywordsRequestType inherits from the L<eBay::API::XML::RequestDataType> class

=cut

use eBay::API::XML::RequestDataType;
our @ISA = ("eBay::API::XML::RequestDataType");

use eBay::API::XML::DataType::PaginationType;


my @gaProperties = ( [ 'CategoryID', 'xs:string', '1', '', '' ]
	, [ 'IncludeChildCategories', 'xs:boolean', '', '', '' ]
	, [ 'MaxKeywordsRetrieved', 'xs:int', '', '', '' ]
	, [ 'Pagination', 'ns:PaginationType', ''
	     ,'eBay::API::XML::DataType::PaginationType', '1' ]
                    );
push @gaProperties, @{eBay::API::XML::RequestDataType::getPropertiesList()};

my @gaAttributes = ( 
                    );
push @gaAttributes, @{eBay::API::XML::RequestDataType::getAttributesList()};

=head1 Subroutines:

=cut

sub new {
  my $classname = shift;
  my %args = @_;
  my $self = $classname->SUPER::new(%args);
  return $self;
}

sub isScalar {
   return 0; 
}



=head2 setCategoryID()

A category ID for which you want keywords returned.
When IncludeChildCategories is true, one and only one
CategoryID is allowed. Otherwise, up
to 100 CategoryIds are allowed.
To retrieve the keywords for root category, set one of
the CategoryIDs to -1 or submit no CategoryIDs at all.

MaxLength: 10

  RequiredInput: No
#    Argument: reference to an array  
                      of 'xs:string'

=cut

sub setCategoryID {
  my $self = shift;
  $self->{'CategoryID'} = 
		$self->convertArray_To_RefToArrayIfNeeded(@_);
}

=head2 getCategoryID()

#    Returns: reference to an array  
                      of 'xs:string'

=cut

sub getCategoryID {
  my $self = shift;
  return $self->_getDataTypeArray('CategoryID');
}


=head2 setIncludeChildCategories()

If true, only one CategoryID can be specified, and keywords
are returned for that category and its subcategories.
If false, keywords are returned only for the categories
identified by CategoryID. Default is false.

  RequiredInput: No
#    Argument: 'xs:boolean'

=cut

sub setIncludeChildCategories {
  my $self = shift;
  $self->{'IncludeChildCategories'} = shift
}

=head2 isIncludeChildCategories()

#    Returns: 'xs:boolean'

=cut

sub isIncludeChildCategories {
  my $self = shift;
  return $self->{'IncludeChildCategories'};
}


=head2 setMaxKeywordsRetrieved()

The maximum number of keywords to be retrieved per category
for this call.

Max: 1000
Default: 20
Min: 1

  RequiredInput: No
#    Argument: 'xs:int'

=cut

sub setMaxKeywordsRetrieved {
  my $self = shift;
  $self->{'MaxKeywordsRetrieved'} = shift
}

=head2 getMaxKeywordsRetrieved()

#    Returns: 'xs:int'

=cut

sub getMaxKeywordsRetrieved {
  my $self = shift;
  return $self->{'MaxKeywordsRetrieved'};
}


=head2 setPagination()

Details about how many categories to return per
page and which page to view.

  RequiredInput: No
#    Argument: 'ns:PaginationType'

=cut

sub setPagination {
  my $self = shift;
  $self->{'Pagination'} = shift
}

=head2 getPagination()

#    Returns: 'ns:PaginationType'

=cut

sub getPagination {
  my $self = shift;
  return $self->_getDataTypeInstance( 'Pagination'
		,'eBay::API::XML::DataType::PaginationType');
}





##  Attribute and Property lists
sub getPropertiesList {
   my $self = shift;
   return \@gaProperties;
}

sub getAttributesList {
   my $self = shift;
   return \@gaAttributes;
}



1;   
