#!/usr/bin/perl

package eBay::API::XML::DataType::BidGroupType;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. BidGroupType.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::DataType::BidGroupType

=head1 DESCRIPTION

Contains a paginated list of items in a bid group.



=head1 SYNOPSIS

=cut


=head1 INHERITANCE

eBay::API::XML::DataType::BidGroupType inherits from the L<eBay::API::XML::BaseDataType> class

=cut

use eBay::API::XML::BaseDataType;
our @ISA = ("eBay::API::XML::BaseDataType");

use eBay::API::XML::DataType::BidGroupItemType;
use eBay::API::XML::DataType::Enum::BidGroupStatusCodeType;


my @gaProperties = ( [ 'BidGroupID', 'xs:long', '', '', '' ]
	, [ 'BidGroupItem', 'ns:BidGroupItemType', '1'
	     ,'eBay::API::XML::DataType::BidGroupItemType', '1' ]
	, [ 'BidGroupName', 'xs:string', '', '', '' ]
	, [ 'BidGroupStatus', 'ns:BidGroupStatusCodeType', ''
	     ,'eBay::API::XML::DataType::Enum::BidGroupStatusCodeType', '' ]
                    );
push @gaProperties, @{eBay::API::XML::BaseDataType::getPropertiesList()};

my @gaAttributes = ( 
                    );
push @gaAttributes, @{eBay::API::XML::BaseDataType::getAttributesList()};

=head1 Subroutines:

=cut

sub new {
  my $classname = shift;
  my %args = @_;
  my $self = $classname->SUPER::new(%args);
  return $self;
}

sub isScalar {
   return 0; 
}



=head2 setBidGroupID()

Contains the bid group ID.

  Calls: GetMyeBayBuying
  RequiredInput: No
  Context: BidAssistantList

#    Argument: 'xs:long'

=cut

sub setBidGroupID {
  my $self = shift;
  $self->{'BidGroupID'} = shift
}

=head2 getBidGroupID()

#    Returns: 'xs:long'

=cut

sub getBidGroupID {
  my $self = shift;
  return $self->{'BidGroupID'};
}


=head2 setBidGroupItem()

Contains a list of bid group item types.

#    Argument: reference to an array  
                      of 'ns:BidGroupItemType'

=cut

sub setBidGroupItem {
  my $self = shift;
  $self->{'BidGroupItem'} = 
		$self->convertArray_To_RefToArrayIfNeeded(@_);
}

=head2 getBidGroupItem()

  Calls: GetMyeBayBuying
  Returned: Conditionally
  Details: DetailLevel: none, ReturnSummary, ReturnAll
  Context: BidAssistantList

#    Returns: reference to an array  
                      of 'ns:BidGroupItemType'

=cut

sub getBidGroupItem {
  my $self = shift;
  return $self->_getDataTypeArray('BidGroupItem');
}


=head2 setBidGroupName()

Contains the bid group name.

#    Argument: 'xs:string'

=cut

sub setBidGroupName {
  my $self = shift;
  $self->{'BidGroupName'} = shift
}

=head2 getBidGroupName()

  Calls: GetMyeBayBuying
  Returned: Conditionally
  Details: DetailLevel: none, ReturnSummary, ReturnAll
  Context: BidAssistantList

#    Returns: 'xs:string'

=cut

sub getBidGroupName {
  my $self = shift;
  return $self->{'BidGroupName'};
}


=head2 setBidGroupStatus()

Contains the bid group status.

#    Argument: 'ns:BidGroupStatusCodeType'

=cut

sub setBidGroupStatus {
  my $self = shift;
  $self->{'BidGroupStatus'} = shift
}

=head2 getBidGroupStatus()

  Calls: GetMyeBayBuying
  Returned: Conditionally
  Details: DetailLevel: none, ReturnSummary, ReturnAll
  Context: BidAssistantList

#    Returns: 'ns:BidGroupStatusCodeType'

=cut

sub getBidGroupStatus {
  my $self = shift;
  return $self->{'BidGroupStatus'};
}





##  Attribute and Property lists
sub getPropertiesList {
   my $self = shift;
   return \@gaProperties;
}

sub getAttributesList {
   my $self = shift;
   return \@gaAttributes;
}



1;   
